const pg = require('pg');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const formidable = require('formidable');
const crypto = require("crypto");

function isNull(item) {
  if (item) {
    return item;
  } else {
    return "";
  }
}

function isNullnumber(item) {
  if (item) {
    return item;
  } else {
    return "0";
  }
}

const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

const mailconfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailconfig);


module.exports = {

  update_deposit_address_API: (request, response) => {

    const form = formidable({ multiples: true });

    form.parse(request, (err, fields, files) => {
      if (err) { 
        return response.status(403).json({ status: false, message: err, })
      }

      if (fields.tbl_deposit_address_id == '' || fields.tbl_deposit_address_id == null || fields.tbl_deposit_address_id == undefined) {
        return response.status(400).json({ status: false, message: 'tbl_deposit_address_id is required', })
      }

      if (fields.deposit_address == '' || fields.deposit_address == null || fields.deposit_address == undefined) {
        return response.status(400).json({ status: false, message: 'deposit_address is required', })
      }

      if (fields.status == '' || fields.status == null || fields.status == undefined) {
        return response.status(400).json({ status: false, message: 'status is required', });
      }

      pool.query(`SELECT tbl_deposit_address_id FROM tbl_deposit_address WHERE tbl_deposit_address_id = '${fields.tbl_deposit_address_id}'`, async (error, result) => {

        if (error) {
          return response.status(403).json({ status: false, message: error, });
        }
        var count = result.rowCount;
        if (count > 0) {

          if (files.deposit_qr != undefined) {

            const fileName = files.deposit_qr.path;
            const typefile = files.deposit_qr.type
            const fileContent = fs.readFileSync(fileName)
            var type = typefile.split("/");
            var imagename = Math.floor(10000000 + Math.random() * 90000000);
            const qrfilenames = imagename + '.' + type[1];

            fs.writeFile(`.././user/views/files/upload/qr/${qrfilenames}`, fileContent, (err) => {
              if (err) {
                console.error(err);
              }
            });

            const Update_pandit_info = await pool.query(`UPDATE tbl_deposit_address SET deposit_address = '${fields.deposit_address}', deposit_qr = '${qrfilenames}', status = '${fields.status}' WHERE tbl_deposit_address_id = '${fields.tbl_deposit_address_id}'`);

            if (Update_pandit_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Your Deposit Address QR is  updated successfully' });
            } else {
              response.status(201).json({ status: false, message: 'Your Deposit Address QR is not updated successfully' });
            }
          } else {
           
            const Update_pandit_info = await pool.query(`UPDATE tbl_deposit_address SET deposit_address = '${fields.deposit_address}', status = '${fields.status}' WHERE tbl_deposit_address_id = '${fields.tbl_deposit_address_id}'`);

            if (Update_pandit_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Your Deposit Address is updated successfully' });
            } else {
              response.status(201).json({ status: false, message: 'Your Deposit Address is not updated successfully' });
            }
          }
        } else {
          response.status(201).json({ status: false, message: 'Something went wrong!.' })
        }
      })
    });
  },
};