var { 
    failure_callback,
    checkVar,
    isValidEmail
} = require('../middleware/common');


module.exports = {

    Admin_login_API: function (req, res, next) {

        try {
            const {  user_name,password } = req.body;

            if (checkVar(user_name)) {
                return failure_callback(res, ['user_name is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    tbl_admin_id_validation: function (req, res, next) {
        try {
            const {  tbl_admin_id } = req.body;

            if(checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    pagesize_validation: function (req, res, next) {

        try {
            const {  pagesize, pagenumber,tbl_admin_id } = req.body

            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400])
            }
            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400])
            }
            if (checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    admin_notification : function (req, res, next) {
        try {
            
            const { tbl_admin_id, title, user_type, message_txt   } = req.body;

            if (checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400]);
            }
            if (checkVar(title)) {
                return failure_callback(res, ['title is required', 400]);
            }
            if (checkVar(user_type)) {
                return failure_callback(res, ['user_type is required', 400]);
            }
            if (checkVar(message_txt)) {
                return failure_callback(res, ['message_txt is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    }, 



    total_trasaction_by_user_account_id : function (req, res, next) {
        try {
            const { tbl_admin_id, account_id } = req.body;

            if (checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400]);
            }
            if (checkVar(account_id)) {
                return failure_callback(res, ['account_id is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    }, 
    
    check_login_id_val : function (req, res, next) {
        try {
            const { tbl_admin_id, login_id } = req.body;

            if (checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400]);
            }

            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    }, 
    
    add_balance_to_mt5_login_id_val : function (req, res, next) {
        try {
            const { tbl_admin_id, login_id, amount } = req.body;

            if (checkVar(tbl_admin_id)) {
                return failure_callback(res, ['tbl_admin_id is required', 400]);
            }

            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400]);
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400]);
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    }, 
    

}