const pg = require('pg');
const fs = require('fs');
const jwt = require('jsonwebtoken');
const AWS = require('aws-sdk');
const crypto = require("crypto");


function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}
const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);


module.exports = {

    total_trasaction_by_user_account_id_API : (request, response) => {

        const { tbl_admin_id, account_id } = request.body;

        const count_query = `SELECT 
            COALESCE((SELECT SUM(amount) FROM tbl_deposit WHERE mt5_number = '${account_id}'),0) AS total_deposit,
            COALESCE((SELECT SUM(amount) FROM tbl_deposit WHERE status='1' AND mt5_number ='${account_id}'),0) AS total_deposit_pending,
            COALESCE((SELECT SUM(amount) FROM tbl_deposit WHERE status='2' AND mt5_number = '${account_id}'), 0) AS total_deposit_approved,
            COALESCE((SELECT SUM(amount) FROM tbl_deposit WHERE status='3' AND mt5_number = '${account_id}'), 0) AS total_deposit_rejected,
            COALESCE((SELECT SUM(amount) FROM tbl_wallet_to_wallet_transection WHERE from_user_account_id = '${account_id}'),0) AS total_wallet_to_wallet_transfer,
            COALESCE((SELECT SUM(main_amount) FROM tbl_wallet_to_wallet_transection WHERE to_user_account_id = '${account_id}'),0) AS total_wallet_to_wallet_recieved,
            COALESCE((SELECT SUM(amount) FROM tbl_withdrawal_amount WHERE account_id = '${account_id}'),0) AS total_withdrawal_amount
        `;

        pool.query(count_query,(error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        account_id: account_id,
                        total_deposit: table.total_deposit.toFixed(2),
                        total_deposit_pending: table.total_deposit_pending.toFixed(2),
                        total_deposit_approved: table.total_deposit_approved.toFixed(2),
                        total_deposit_rejected: table.total_deposit_rejected.toFixed(2),
                        total_wallet_to_wallet_transfer: table.total_wallet_to_wallet_transfer.toFixed(2),
                        total_wallet_to_wallet_recieved: table.total_wallet_to_wallet_recieved.toFixed(2),
                        total_withdrawal_amount: table.total_withdrawal_amount.toFixed(2),
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Total trasaction by user account id',  data: data })

            }else{
                response.status(201).json({ status: false, message: 'No data', data: [] })

            }

        })
    },


    dashboard_Valet_user_list_API:(request, response) => {

        const { tbl_admin_id } = request.body
    
        pool.query(`SELECT tbl_valet_user_id,user_name,mobile,name,status,duty_status,user_status,driver_image,(SELECT COUNT(tbl_valet_user_id) AS All_data FROM tbl_valet_user) FROM tbl_valet_user  where status = '0' ORDER BY created_date DESC Limit 5`,(error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_valet_user_id: isNull(table.tbl_valet_user_id),
                        user_name: isNull(table.user_name),
                        mobile: isNull(table.mobile),
                        name: isNull(table.name),
                        status: table.status,
                        duty_status: isNull(table.duty_status),
                        user_status: table.user_status,
                        driver_image: isNull("https://spaceherobucket.s3.ap-south-1.amazonaws.com/driver_image/"+table.driver_image)
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Dashboard Valet User List Data',  data: data,  })
    
            }else{
                response.status(201).json({ status: false, message: 'No Dashboard Valet User Register', data: [] })
    
            }
    
        })
    },

};