const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
const formidable = require('formidable');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const AWS = require('aws-sdk');
const crypto = require("crypto");
const { log } = require('console');
const moment = require('moment');

// AWS.config.update({
//     accessKeyId: 'AKIAROCJGPTUB7ZDTLV3',
//     secretAccessKey: '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'
// });

// const s3 = new AWS.S3({
//     accessKeyId: process.env.accessKeyId,
//     secretAccessKey: process.env.secretAccessKey,
//     region: 'ap-south-1'
// })

const upload = multer({ dest: '../views/files/upload/user_image/' });

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);

const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}


// function encrypt(password) {
//     var key = "123|a123123123123123@&";
//     var cipher = crypto.createCipher('aes-256-cbc', key);
//     var crypted = cipher.update(password, 'utf-8', 'hex');
//     crypted += cipher.final('hex');
//     return crypted;
// }

// function decrypt(password) {
//     var key = "123|a123123123123123@&";
//     var decipher = crypto.createDecipher('aes-256-cbc', key);
//     var decrypted = decipher.update(password, 'hex', 'utf-8');
//     decrypted += decipher.final('utf-8');
//     return decrypted;
// }


const mailConfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailConfig);

module.exports = {

    leverage_API: (request, response) => {

        const { tbl_leverage } = request.body;

        pool.query(`SELECT * FROM tbl_leverage WHERE status = '1' order by leverage ASC`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_leverage_id: isNull(table.tbl_leverage_id),
                        leverage: table.leverage,
                    };
                    data.push(cat);
                });
                response.status(201).json({ status: true, message: 'Leverage List', data: data });
            } else {
                response.status(201).json({ status: false, message: 'Leverage Created', data: [] })
            }
        })
    },

    /// this api create for trande munda on 22-04-2024 

    mt5_new_add_user_API: (request, response) => {

        const { tbl_user_id, name, leverage, email, password_main, phone, agent, country, group_id } = request.body;
    
        console.log('mt5_new_add_user_API', request.body);
    
        pool.query(`SELECT tbl_user_id FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error });
            }
    
            var count = result.rowCount;
            if (count > 0) {
                // Add API code here

                /// generate 6 digit random login id for user
                
                    const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                    const random_with_id = random.toString() + tbl_user_id; // Combine random number and user ID
                    const sixDigitRandomWithId = random_with_id.slice(-6); // Take the last 6 digits
                    const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                    const Login_id = zeroPad(sixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                
                /// generate 6 digit random login id for user
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");
                
                pool.query(`INSERT INTO tbl_mt5_user (tbl_user_id,login_id,group_id,balance,registration,name,leverage,email,password_main,phone,agent,country,joining_time,joining_date) VALUES ('${tbl_user_id}','${Login_id}',$$${group_id}$$,'0','0','${name}','${leverage}','${email}','${password_main}','${phone}','${agent}','${country}','${joining_time}','${joining_date}')`,
                    async (error, mt5user_user) => {
                    if (error) {
                        return response.status(403).json({ status: false, message: error });
                    }

                    if (mt5user_user.rowCount > 0) {
                        response.status(201).json({ status: true, message: 'User is now registered on MT5', login_id: Login_id, group: group_id, password_main: password_main });
                    } else {
                        response.status(201).json({ status: false, message: 'Something Error',});
                    }
                });    
            } else {
                response.status(201).json({ status: false, message: 'This user is not registered with us. Please check your user ID.' });
            }
        });
    },


    // mt5_add_user_API: (request, response) => {
    //     const { tbl_user_id, name, leverage, email, password_main, phone, agent, country } = request.body;
    
    //     console.log('mt5_add_user_API', request.body);
    
    //     pool.query(`SELECT tbl_user_id FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
    //         if (error) {
    //             return response.status(403).json({ status: false, message: error });
    //         }
    
    //         var count = result.rowCount;
    
    //         if (count > 0) {
    //             // Add API code here
    
    //             const axios = require('axios');
    //             const FormData = require('form-data');
    //             let data = new FormData();
    //             data.append('name', name);
    //             data.append('leverage', leverage);
    //             data.append('email', email);
    //             data.append('password_main', password_main);
    //             data.append('phone', phone);
    //             data.append('agent', agent);
    //             data.append('country', country);
    
    //             let config = {
    //                 method: 'post',
    //                 maxBodyLength: Infinity,
    //                 url: 'https://aiboxstudios.com/mt5_api/add_user.php',
    //                 headers: { 
    //                     ...data.getHeaders()
    //                 },
    //                 data: data
    //             };
    
    //             axios.request(config)
    //                 .then((apiResponse) => {
    //                     var allapi_data = apiResponse.data;
    
    //                     //console.log(allapi_data);
    
    //                     if (allapi_data.retcode === '0 Done') {
    //                         var joining_time = moment().utcOffset("+05:30").format('LT');
    //                         var joining_date = moment(date).format("DD MMM YYYY");
                            
    //                         pool.query(`INSERT INTO tbl_mt5_user (tbl_user_id,login_id,group_id,balance,registration,name,leverage,email,password_main,phone,agent,country,joining_time,joining_date) VALUES ('${tbl_user_id}','${allapi_data.answer.Login}','${allapi_data.answer.Group}','${allapi_data.answer.Balance}','${allapi_data.answer.Registration}','${name}','${leverage}','${email}','${password_main}','${phone}','${agent}','${country}','${joining_time}','${joining_date}')`,
    //                             async (error, mt5user_user) => {
    //                                 if (error) {
    //                                     return response.status(403).json({ status: false, message: error });
    //                                 }
    
    //                                 if (mt5user_user.rowCount > 0) {
    //                                     response.status(201).json({ status: true, message: 'User is now registered on MT5', login_id: allapi_data.answer.Login, group: allapi_data.answer.Group, password_main: password_main });
    //                                 } else {
    //                                     response.status(201).json({ status: false, message: 'Something Error' });
    //                                 }
    //                             });
    //                     }
    //                 })
    //                 .catch((error) => {
    //                     console.log(error);
    //                     response.status(500).json({ status: false, message: 'Internal Server Error' });
    //                 });
    //         } else {
    //             response.status(201).json({ status: false, message: 'This user is not registered with us. Please check your user ID.' });
    //         }
    //     });
    // },


  mlm_update_amount_API: async (request, response) => {
  const { mlm_login_id, updated_bal } = request.body;

  console.log('mlm_update_amount_API Request:', request.body);

  const parsedAmount = Number(updated_bal);

  if (!mlm_login_id || isNaN(parsedAmount)) {
    return response.status(400).json({
      status: false,
      message: "Valid mlm_login_id and numeric updated_bal are required.",
    });
  }

  const client = await pool.connect();

  try {
    const findUser = await client.query(
      `SELECT 1 FROM tbl_mt5_user WHERE mlm_login_id = $1`,
      [mlm_login_id]
    );

    if (findUser.rowCount === 0) {
      return response.status(403).json({
        status: false,
        message: "This user is not registered with us. Please check your user ID.",
      });
    }

    await client.query('BEGIN');

    await client.query(
      `UPDATE tbl_mt5_user SET balance = $1::double precision,  mlm_wallet = $1::character varying WHERE mlm_login_id = $2`,
      [parsedAmount, mlm_login_id]
    );

    await client.query(
      `UPDATE tbl_user SET wallet_amount = $1::double precision, mlm_wallet = $1::character varying WHERE mlm_login_id = $2`,
      [parsedAmount, mlm_login_id]
    );

    await client.query('COMMIT');

    return response.status(200).json({
      status: true,
      message: "Wallet and balance successfully updated.",
    });

  } catch (error) {
    await client.query('ROLLBACK');
    console.error('Error in mlm_update_amount_API:', error);
    return response.status(500).json({
      status: false,
      message: "Something went wrong during update.",
      error: error.message,
    });

  } finally {
    client.release();
  }
    },
    
    mt5_account_list_API: (request, response) => {

        const { tbl_user_id } = request.body;

        pool.query(`SELECT * FROM tbl_mt5_user WHERE tbl_user_id = '${tbl_user_id}' order by balance desc`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_mt5_user_id: isNull(table.tbl_mt5_user_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        group_id: isNull(table.group_id),
                        balance: table.balance.toFixed(2),
                        registration: isNull(table.registration),
                        name: isNull(table.name),
                        leverage: isNull(table.leverage),
                        email: isNull(table.email),
                        password_main: isNull(table.password_main),
                        phone: isNull(table.phone),
                        agent: isNull(table.agent),
                        country: isNull(table.country),
                        joining_time: isNull(table.joining_time),
                        joining_date: isNull(table.joining_date),
                    };
                    data.push(cat);
                });
              response.status(201).json({ status: true, message: 'MT5 Account List', data: data });
            } else {
                response.status(201).json({ status: false, message: 'No Account Created', data: [] })
            }
        })
    },


    info_account_details_API: (request, response) => {

        const { tbl_user_id } = request.body;

        pool.query(`SELECT * FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_user_id: isNull(table.tbl_user_id),
                        balance: "10000",
                        currency : "USD",
                        leverage: "500",
                        lots : "1",
                        commission : "16",
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, message: 'Info view account details ', data: data });
            } else {
                return response.status(201).json({ status: false, message: 'tbl_user_id is not exist', data: [] })
            }
        })

    },

    add_market_data_via_mt5_API: (request, response) => {
    
        console.log('add_market_data_via_mt5_API');
    
                // Add API code here

                const axios = require('axios');

                    let config = {
                    method: 'get',
                    maxBodyLength: Infinity,
                    url: 'https://aiboxstudios.com/mt5_api/market_price_api.php',
                    headers: { }
                    };

    
                axios.request(config)
                    .then((apiResponse) => {
                        var allapi_data = apiResponse.data;
    
                        //console.log("allapi_data",allapi_data);
    
                        if (allapi_data.retcode === '0 Done') {
                            var joining_time = moment().utcOffset("+05:30").format('LT');
                            var joining_date = moment(date).format("DD MMM YYYY");

                            var size = allapi_data.answer.length;

                            for(var i=0; i<size;i++)

                            {

                               // console.log(`UPDATE tbl_market_data SET datetime='${allapi_data.answer[i].Datetime}',datetimemsc='${allapi_data.answer[i].DatetimeMsc}',bid='${allapi_data.answer[i].Bid}',ask='${allapi_data.answer[i].Ask}',last='${allapi_data.answer[i].Last}',volume='${allapi_data.answer[i].Volume}',volumereal='${allapi_data.answer[i].VolumeReal}' where symbol ='${allapi_data.answer[i].Symbol}'`);

                                // console.log(`INSERT INTO tbl_market_data (symbol,digits,datetime,datetimemsc,bid,ask,last,volume,volumereal) VALUES ('${allapi_data.answer[i].Symbol}','${allapi_data.answer[i].Digits}','${allapi_data.answer[i].Datetime}','${allapi_data.answer[i].DatetimeMsc}','${allapi_data.answer[i].Bid}','${allapi_data.answer[i].Ask}','${allapi_data.answer[i].Last}','${allapi_data.answer[i].Volume}','${allapi_data.answer[i].VolumeReal}')`);


                            pool.query(`UPDATE tbl_market_data SET bidlow='${allapi_data.answer[i].BidLow}',bidhigh='${allapi_data.answer[i].BidHigh}',datetime='${allapi_data.answer[i].Datetime}',datetimemsc='${allapi_data.answer[i].DatetimeMsc}',bid='${allapi_data.answer[i].Bid}',ask='${allapi_data.answer[i].Ask}',last='${allapi_data.answer[i].Last}',volume='${allapi_data.answer[i].Volume}',volumereal='${allapi_data.answer[i].VolumeReal}' where symbol ='${allapi_data.answer[i].Symbol}'`,
                                async (error, mt5user_user) => {
                                    if (error) {
                                        return response.status(403).json({ status: false, message: error });
                                    }
    
                                });

                            }

                            response.status(201).json({ status: true, message: 'Data Updated' });

                        }
                    })
                    .catch((error) => {
                        console.log(error);
                        response.status(500).json({ status: false, message: 'Internal Server Error' });
                    });
       
    },

    Market_data_API: (request, response) => {

       // const { tbl_user_id } = request.body;

        pool.query(`SELECT * FROM tbl_market_data WHERE status = '1' order by tbl_market_data_id desc`, async (error, result) => {

            if (error) {
                throw error
            }
            var count = result.rowCount;

            if (count > 0) {

                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {

                        let cat = {
                            tbl_market_data_id: isNull(table.tbl_market_data_id),
                            symbol: isNull(table.symbol),
                            digits: isNull(table.digits),
                            datetime: isNull(table.datetime),
                            datetimemsc: isNull(table.datetimemsc),
                            bid: isNull(table.bid),
                            ask: isNull(table.ask),
                            bidlow: isNull(table.bidlow),
                            bidhigh: isNull(table.bidhigh),
                            last: isNull(table.last),
                            volume: isNull(table.volume),
                            volumereal: isNull(table.volumereal)
                        };
                        data.push(cat);

                    });
                    response.status(201).json({ status: true, message: 'Market Data List', data: data })

                

            } else {
                response.status(201).json({ status: false, message: 'No Data Found', data: [] })
            }
        })

    },

    updated_wallet_balace_api: (request, response) => {

        const { login_id,balance } = request.body;

        console.log('updated_wallet_balace_api', request.body);

        pool.query(`SELECT balance FROM tbl_mt5_user WHERE login_id = '${login_id}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            console.log("count", count);
            if (count > 0) {

                pool.query(`UPDATE tbl_mt5_user SET balance = '${balance}' WHERE login_id = '${login_id}'`,
                    async (error, result_user) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error })
                        }
                       if(result_user.rowCount > 0)
                       {
                        response.status(201).json({ status: true, message: 'amount updated'})
                       }
                    },
                )
            } else {
                response.status(201).json({ status: false, message: 'This tbl_user_id is not exist' })
            }
        })
    },


    
};