const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
const formidable = require('formidable');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const AWS = require('aws-sdk');
const crypto = require("crypto");
const { log } = require('console');
const moment = require('moment');

const notification_function = require('./notification_function');
//notification_function.send_notification(tbl_user_id, title, message, message_type);
//notification_function.send_notification(119, 'wallet transfer', 'wallet_transfer', 'You have transferred an amount of 300 to 632838 in 246138');


const upload = multer({ dest: '../views/files/upload/user_image/' });

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);

const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}



const mailConfig = require('../../mail');
const { request } = require('http');
const transporter = nodeMailer.createTransport(mailConfig);

module.exports = {

    mlm_deposit_amount_API: (request, response) => {
        const { mlm_login_id, deposit_type, amount, user_transection_address } = request.body;
      
        console.log('deposit_amount_API', request.body);
      
        pool.query(
          `SELECT wallet_amount, mlm_wallet, tbl_user_id,
            (SELECT login_id FROM tbl_mt5_user WHERE tbl_user_id = tbl_user.tbl_user_id LIMIT 1) AS mt5_number
           FROM tbl_user
        WHERE LOWER(mlm_login_id) = LOWER($1)`,
          [mlm_login_id],
          (error, result) => {
            if (error) {
              return response.status(403).json({ status: false, message: error.message || error });
            }
      
            if (result.rowCount > 0) {
              const { tbl_user_id, mt5_number, wallet_amount, mlm_wallet } = result.rows[0];
      
              const joining_time = moment().utcOffset("+05:30").format('LT');
              const joining_date = moment().format("DD MMM YYYY");
              const currency_type = 'USD';
      
              pool.query(
                `INSERT INTO tbl_deposit 
                  (tbl_user_id, deposit_type, currency_type, amount, mt5_number, user_transection_address, created_date, created_time, mlm_login_id,status) 
                 VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, 2) RETURNING tbl_deposit_id`,
                [tbl_user_id, deposit_type, currency_type, amount, mt5_number, user_transection_address, joining_date, joining_time, mlm_login_id],
                (insertError, insertResult) => {
                  if (insertError) {
                    return response.status(403).json({ status: false, message: insertError.message || insertError });
                  }
      
                  if (insertResult.rowCount > 0) {
                    const new_wallet_amount = parseFloat(wallet_amount) + parseFloat(amount);
                    const mlmnew_wallet_amount = parseFloat(mlm_wallet) + parseFloat(amount);
      
                    pool.query(
                      `UPDATE tbl_user SET wallet_amount = $1, mlm_wallet = $2 WHERE tbl_user_id = $3`,
                      [new_wallet_amount, mlmnew_wallet_amount, tbl_user_id],
                      (updateUserError, updateUserResult) => {
                        if (updateUserError) {
                          return response.status(403).json({ status: false, message: updateUserError.message || updateUserError });
                        }
      
                        pool.query(
                          `UPDATE tbl_mt5_user SET balance = balance + $1, mlm_wallet = $2 WHERE login_id = $3`,
                          [amount, mlmnew_wallet_amount, mt5_number],
                          (updateMt5Error, updateMt5Result) => {
                            if (updateMt5Error) {
                              return response.status(403).json({ status: false, message: updateMt5Error.message || updateMt5Error });
                            }
      
                            return response.status(201).json({
                              status: true,
                              message: 'Your deposit request has been submitted successfully and balances updated.'
                            });
                          }
                        );
                      }
                    );
                  } else {
                    return response.status(201).json({ status: false, message: 'Something error.' });
                  }
                }
              );
            } else {
              return response.status(201).json({ status: false, message: 'This user id is not registered with us.' });
            }
          }
        );
    },

    // mlm_withdrawal_amount_API: (request, response) => {
    //     const { mlm_login_id, amount, wallet_address } = request.body;
    //     const joining_time = moment().utcOffset("+05:30").format('LT');
    //     const joining_date = moment().format("YYYY-MM-DD");
    // pool.query(
    //     `SELECT * FROM tbl_mt5_user WHERE mlm_login_id = $1`,
    //     [mlm_login_id],
    //     (error, result) => {
    //         if (error) {
    //             return response.status(500).json({ status: false, message: error.message });
    //         }
    //         if (result.rowCount === 0) {
    //             return response.status(404).json({
    //                 status: false,
    //                 message: 'This user ID is not registered with us.'
    //             });
    //         }
    //         const userData = result.rows[0];
    //         const currentWallet = parseFloat(userData.mlm_wallet);
    //         const withdrawAmount = parseFloat(amount);
    //         if (currentWallet < withdrawAmount) {
    //             return response.status(400).json({
    //                 status: false,
    //                 message: 'Not enough money to withdraw.'
    //             });
    //         }
    //         pool.query('BEGIN', async (beginErr) => {
    //             if (beginErr) {
    //                 return response.status(500).json({ status: false, message: beginErr.message });
    //             }
    //             try {
    //                 const { tbl_user_id, login_id, name, } = userData; 
    //                 const account_id = login_id;
    //                 const mt5_number = login_id;
    //                 const insertQuery = `
    //                     INSERT INTO tbl_withdrawal_amount (
    //                         tbl_user_id, account_id, amount, mt5_number, wallet_address, name, created_date, created_time, mlm_login_id
    //                     ) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9)
    //                 `;
    //                 await pool.query(insertQuery, [
    //                     tbl_user_id, account_id, withdrawAmount, mt5_number, wallet_address, name, joining_date, joining_time,mlm_login_id
    //                 ]);
    //                 await pool.query(
    //                     `UPDATE tbl_user
    //                      SET mlm_wallet = (mlm_wallet::numeric - $1)::varchar
    //                      WHERE tbl_user_id = $2`,
    //                     [withdrawAmount, tbl_user_id]
    //                 );
    //                 await pool.query(
    //                     `UPDATE tbl_mt5_user
    //                      SET mlm_wallet = (mlm_wallet::numeric - $1)::varchar
    //                      WHERE mlm_login_id = $2 AND login_id = $3`,
    //                     [withdrawAmount, mlm_login_id, mt5_number]
    //                 );
    //                 await pool.query('COMMIT');
    //                 return response.status(201).json({
    //                     status: true,
    //                     message: 'Your withdrawal request has been submitted successfully.'
    //                 });
    //             } catch (transactionError) {
    //                 await pool.query('ROLLBACK');
    //                 return response.status(500).json({ status: false, message: transactionError.message });
    //             }
    //         });
    //     }
    // );
    // },

    mlm_withdrawal_amount_API: (request, response) => {
    const { mlm_login_id, amount, wallet_address } = request.body;

    const joining_time = moment().utcOffset("+05:30").format('LT');
    const joining_date = moment().format("YYYY-MM-DD");
    withdrawal_type = "USDT";
    currency_type = "USD";

    if (!mlm_login_id || !amount || !wallet_address) {
        return response.status(400).json({
            status: false,
            message: 'mlm_login_id, amount, and wallet_address are required.'
        });
    }

    pool.query(
        `SELECT * FROM tbl_mt5_user WHERE mlm_login_id = $1`,
        [mlm_login_id],
        (error, result) => {
            if (error) {
                return response.status(500).json({ status: false, message: error.message });
            }

            if (result.rowCount === 0) {
                return response.status(404).json({
                    status: false,
                    message: 'This user ID is not registered with us.'
                });
            }

            const userData = result.rows[0];
            // const currentWallet = parseFloat(userData.mlm_wallet);
            // const withdrawAmount = parseFloat(amount);


            // if (isNaN(currentWallet) || isNaN(withdrawAmount) || currentWallet < withdrawAmount) {
            //     return response.status(400).json({
            //         status: false,
            //         message: 'Not enough money to withdraw.'
            //     });
            // }

            pool.query('BEGIN', async (beginErr) => {
                if (beginErr) {
                    return response.status(500).json({ status: false, message: beginErr.message });
                }

                try {
                    const {
                        tbl_user_id,
                        login_id,
                        name,
                    } = userData;

                    const account_id = login_id;
                    const mt5_number = login_id;

                    const insertQuery = `
                        INSERT INTO tbl_withdrawal_amount (
                            tbl_user_id, account_id, amount,withdrawal_type,currency_type, mt5_number, wallet_address, name, created_date, created_time,mlm_login_id
                        ) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, $9, $10, $11)
                    `;

                    await pool.query(insertQuery, [
                        tbl_user_id,
                        account_id,
                        amount,
                        withdrawal_type,
                        currency_type,
                        mt5_number,
                        wallet_address,
                        name,
                        joining_date,
                        joining_time,
                        mlm_login_id
                    ]);

                    // await pool.query(
                    //     `UPDATE tbl_user 
                    //      SET mlm_wallet = (mlm_wallet::numeric - $1)::varchar 
                    //      WHERE tbl_user_id = $2`,
                    //     [withdrawAmount, tbl_user_id]
                    // );

                    // await pool.query(
                    //     `UPDATE tbl_mt5_user 
                    //      SET mlm_wallet = (mlm_wallet::numeric - $1)::varchar 
                    //      WHERE mlm_login_id = $2 AND login_id = $3`,
                    //     [withdrawAmount, mlm_login_id, mt5_number]
                    // );

                    await pool.query('COMMIT');

                    return response.status(201).json({
                        status: true,
                        message: 'Your withdrawal request has been submitted successfully.'
                    });

                } catch (transactionError) {
                    await pool.query('ROLLBACK');
                    return response.status(500).json({ status: false, message: transactionError.message });
                }
            });
        }
    );
    },

    deposit_address_API: (request, response) => {

        // const { tbl_user_id } = request.body
 
         pool.query(`SELECT * FROM tbl_deposit_address WHERE  status = '1'`, async (error, result) => {
             if (error) {
                 return response.status(403).json({ status: false, message: error })
             }
             var count = result.rowCount;
             if (count > 0) {
 
                 var res = result.rows;
                 var data = [];
                 res.forEach(function (table) {
 
                     let cat = {
                         deposit_address: isNull(table.deposit_address),
                         deposit_qr: isNull(base_img_url + "/qr/" + table.deposit_qr),
                     };
                     data.push(cat);
                 });
                 response.status(201).json({ status: true, message: 'Depost Details', data: data })
             } else {
                 response.status(201).json({ status: false, message: 'Details not found', data: [] })
             }
         })
    },



    deposit_amount_API: (request, response) => {

        const { tbl_user_id, deposit_type, currency_type, amount, mt5_number, user_transection_address } = request.body;

        console.log('deposit_amount_API', request.body);

        pool.query(`SELECT wallet_amount,tbl_user_id FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            console.log("count", count);

            if (count > 0) {

                    const joining_time = moment().utcOffset("+05:30").format('LT');
                    const joining_date = moment(date).format("DD MMM YYYY");

                   

                    pool.query(`INSERT INTO tbl_deposit (tbl_user_id,deposit_type,currency_type,amount,mt5_number,user_transection_address,created_date,created_time) VALUES ('${tbl_user_id}','${deposit_type}','${currency_type}','${amount}','${mt5_number}','${user_transection_address}','${joining_date}','${joining_time}') RETURNING tbl_deposit_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error })
                        }

                        if(result_user.rowCount > 0)
                        {
                            response.status(201).json({ status: true, message: 'Your deposit request has been submitted successfully.' })
                        }else{
                            response.status(201).json({ status: false, message: 'Something error.' })
                        }
                    },
                )
            } else {
                response.status(201).json({ status: false, message: 'This user id is not register with us.'})
            }
        })
    },



    withdrawal_amount_API: (request, response) => {

        const { tbl_user_id, account_id, withdrawal_type, currency_type, amount, mt5_number, wallet_address, name } = request.body;

        console.log('withdrawal_amount_API', request.body);

        pool.query(`SELECT balance, tbl_user_id FROM tbl_mt5_user WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${mt5_number}'`, async (error, result) => {

            if (error) { return response.status(403).json({ status: false, message: error }) }
            var count = result.rowCount;

            console.log("count", count);

            if (count > 0) {

                if(result.rows[0].balance >= amount)
                {

                    /// check free margin for withdrawn balance
                    const check_freemargn = await pool.query(`SELECT sum(margin) as total_used_margin FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${account_id}' AND order_status = 'open' AND order_status = 'pending'`);
                    const total_used_margin = check_freemargn.rows[0].total_used_margin;

                    if(total_used_margin >= amount){

                        console.log('total_used_margin', total_used_margin);
                        console.log('amount', amount);

                        const joining_time = moment().utcOffset("+05:30").format('LT');
                        const joining_date = moment(date).format("DD MMM YYYY");
    
                        pool.query(`INSERT INTO tbl_withdrawal_amount (tbl_user_id,account_id,withdrawal_type,currency_type,amount,mt5_number,wallet_address,name,created_date,created_time) VALUES ('${tbl_user_id}','${account_id}','${withdrawal_type}','${currency_type}','${amount}','${mt5_number}','${wallet_address}','${name}','${joining_date}','${joining_time}'); 
                        UPDATE tbl_user SET wallet_amount = wallet_amount - '${amount}' where tbl_user_id = '${tbl_user_id}';
                        UPDATE tbl_mt5_user SET balance = balance - '${amount}' where tbl_user_id = '${tbl_user_id}' AND login_id = '${mt5_number}';
                        `,
                        async (error, result_user) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            if(result_user[0].rowCount > 0)
                            {
                                response.status(201).json({ status: true, message: 'Your withdrawal request has been submitted successfully.' })
                            }else{
                                response.status(201).json({ status: false, message: 'Something error.' })
                            }
                        })
                    }else{
                       return response.status(201).json({ status: false, message: 'Not enough money to withdraw.'})
                    }
                }else{
                    return response.status(201).json({ status: false, message: 'Your login Wallet amount is low for this request.'})
                }

            } else {

                response.status(201).json({ status: false, message: 'This user id is not register with us.'})
            }
        })
    },
    

    All_deposit_list_API: (request, response) => {

        const {tbl_user_id } = request.body;

        pool.query(`select * FROM tbl_deposit where tbl_user_id = '${tbl_user_id}' order by tbl_deposit_id DESC`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Pending';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }

                    let cat = {
                        tbl_deposit_id: isNull(table.tbl_deposit_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        deposit_type: isNull(table.deposit_type),
                        currency_type: isNull(table.currency_type),
                        amount: isNull(table.amount.toFixed(2)),
                        mt5_number: isNull(table.mt5_number),
                        trasaction_id: isNull(table.trasaction_id),
                        user_transection_address: isNull(table.user_transection_address),
                        status: isNull(status_show),
                        created_date : isNull(moment(table.created_date).format("DD MMM YYYY")),
                        created_time: isNull(table.created_time),
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Depost List APi', data: data })
            } else {
                response.status(201).json({ status: false, message: 'No Recored Found', data: [] })
            }

        })
    },



    All_deposit_list_by_mt5_account_API: (request, response) => {

        const {tbl_user_id,login_id } = request.body;

        pool.query(`select * FROM tbl_deposit where tbl_user_id = '${tbl_user_id}' AND mt5_number ='${login_id}' order by tbl_deposit_id DESC`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Pending';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }
                    let cat = {
                        tbl_deposit_id: isNull(table.tbl_deposit_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        deposit_type: isNull(table.deposit_type),
                        currency_type: isNull(table.currency_type),
                        amount: isNull(table.amount.toFixed(2)),
                        mt5_number: isNull(table.mt5_number),
                        user_transection_address: isNull(table.user_transection_address),
                        status: isNull(status_show),
                        trasaction_id: isNull(table.trasaction_id),
                        created_date : isNull(moment(table.created_date).format("DD MMM YYYY")),
                        created_time: isNull(table.created_time),
                    };
                    data.push(cat);
                });

                response.status(201).json({ status: true, message: 'Depost List APi', data: data })
            } else {
                response.status(201).json({ status: false, message: 'No Recored Found', data: [] })
            }

        })
    },

    All_withdrawal_list_API : (request, response) => {
         
        const { tbl_user_id } = request.body;

        pool.query(`SELECT * FROM tbl_withdrawal_amount where tbl_user_id = '${tbl_user_id}' order by tbl_withdrawal_amount_id DESC`, (err, result)=>{

            if(err) {
                return response.status(403).json({ status : false, message : err.message});
            }

            var count = result.rowCount;

            if(count > 0){
                var res = result.rows;
                var data = []; 

                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Pending';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }

                    let widdata = {
                        tbl_withdrawal_amount_id : isNull(table.tbl_withdrawal_amount_id),
                        tbl_user_id : isNull(table.tbl_user_id),
                        account_id : isNull(table.account_id),
                        withdrawal_type : isNull(table.withdrawal_type),
                        currency_type : isNull(table.currency_type),
                        amount : isNull(table.amount),
                        mt5_number : isNull(table.mt5_number),
                        wallet_address : isNull(table.wallet_address),
                        name : isNull(table.name),
                        status : isNull(status_show),
                        created_date : isNull(moment(table.created_date).format("DD MMM YYYY")),
                        created_time : isNull(table.created_time),
                    };
                    data.push(widdata);                   
                });
                response.status(201).json({ status : true, message : 'All withdrawa list', data : data});
            }else{
                response.status(201).json({ status : false, message : 'No Record found', data : []});
            }

        })
    },

    All_withdrawal_list_by_mt5_account_API : (request, response) => {
         
        const { tbl_user_id, login_id } = request.body;

        pool.query(`SELECT * FROM tbl_withdrawal_amount where tbl_user_id = '${tbl_user_id}' and mt5_number = '${login_id}' order by tbl_withdrawal_amount_id DESC`, (err, result)=>{

            if(err) {
                return response.status(403).json({ status : false, message : err.message});
            }

            var count = result.rowCount;

            if(count > 0){
                var res = result.rows;
                var data = []; 

                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Pending';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }

                    let widdata = {
                        tbl_withdrawal_amount_id : isNull(table.tbl_withdrawal_amount_id),
                        tbl_user_id : isNull(table.tbl_user_id),
                        account_id : isNull(table.account_id),
                        withdrawal_type : isNull(table.withdrawal_type),
                        currency_type : isNull(table.currency_type),
                        amount : isNull(table.amount),
                        mt5_number : isNull(table.mt5_number),
                        wallet_address : isNull(table.wallet_address),
                        name : isNull(table.name),
                        status : isNull(status_show),
                        created_date : isNull(moment(table.created_date).format("DD MMM YYYY")),
                        created_time : isNull(table.created_time),
                    };
                    data.push(widdata);                   
                });
                response.status(201).json({ status : true, message : 'Withdrawa list by mt5 account', data : data});
            }else{
                response.status(201).json({ status : false, message : 'No Record found', data : []});
            }

        })
    },

    Wallet_to_wallet_amount_transfer_api: async(request, response) => {

        const { tbl_user_id, from_user_name, from_user_account_id, to_user_name, to_user_account_id, amount, deduction_percentage,fee,main_amount,transfer_pin } = request.body;

        const joining_time = moment().utcOffset("+05:30").format('LT');
        const joining_date = moment(date).format("DD MMM YYYY");

        console.log('Wallet_to_wallet_amount_transfer_api', request.body);

        const to_user_name_inuppercase = to_user_name.toUpperCase();

        const after_deduction_mainamount = main_amount - fee;

        pool.query(`SELECT (SELECT tbl_user_id from tbl_user where user_name = '${to_user_name_inuppercase}') AS to_user_id, tbl_user_id,user_name,wallet_amount,transfer_pin FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}' AND transfer_pin ='${transfer_pin}'`, async(error, result) => {
            if(error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var to_user_wallet_amount = result.rows[0].wallet_amount;
                var to_user_id = result.rows[0].to_user_id;

                const ck_amt_via_acnt_id = await pool.query(`SELECT tbl_user_id, balance, login_id FROM tbl_mt5_user WHERE  login_id = '${from_user_account_id}'`)

                const ck_amd_res = ck_amt_via_acnt_id.rows[0];
                const from_loginid_balance = ck_amd_res.balance;

                if(amount <= from_loginid_balance)
                {

                    const Update_wallet_query = await pool.query(`
                    UPDATE tbl_user SET wallet_amount = wallet_amount - '${amount}'  WHERE tbl_user_id = '${tbl_user_id}';
                    UPDATE tbl_mt5_user SET balance = balance - '${amount}'  WHERE login_id = '${from_user_account_id}';
                    UPDATE tbl_user SET wallet_amount = wallet_amount + '${after_deduction_mainamount}'  WHERE user_name = '${to_user_name_inuppercase}';
                    UPDATE tbl_mt5_user SET balance = balance + '${after_deduction_mainamount}'  WHERE login_id = '${to_user_account_id}'
                    `);

                    if(Update_wallet_query[0].rowCount > 0 )
                    {
                        var trasection_id = Math.floor(100000 + Math.random() * 900000);

                        const insert_query = await pool.query(`INSERT INTO tbl_wallet_to_wallet_transection(tbl_user_id,from_user_name,to_user_name,amount,deduction_percentage,fee,main_amount,transfer_pin,trasection_id,created_date,created_time, from_user_account_id,to_user_account_id) VALUES ('${tbl_user_id}','${from_user_name}','${to_user_name_inuppercase}','${amount}','${deduction_percentage}','${fee}','${after_deduction_mainamount}','${transfer_pin}','${trasection_id}','${joining_date}','${joining_time}','${from_user_account_id}','${to_user_account_id}')`);

                        var title = 'Wallet Transfer';
                        var notification_type = 'Wallet_transfer';
                        var msg_from_user = `You have transferred an amount of ${amount} to ${to_user_account_id} in ${from_user_account_id}`; // of ${to_user_name_inuppercase}
                        var msg_to_user = `You have recived an amount of ${after_deduction_mainamount} from ${from_user_account_id} in ${to_user_account_id}`; //of ${from_user_name}

                        notification_function.send_notification(tbl_user_id, title, notification_type, msg_from_user);
                        notification_function.send_notification(to_user_id, title, notification_type, msg_to_user);

                        // const from_user_query = await pool.query(`INSERT INTO tbl_user_notification(title,notification_type,tbl_user_id,notification_msg,created_date,created_time) VALUES ('Wallet Transfer','Wallet_transfer','${tbl_user_id}','${msg_from_user}','${joining_date}','${joining_time}')`);

                        // const to_user_query = await pool.query(`INSERT INTO tbl_user_notification(title,notification_type,tbl_user_id,notification_msg,created_date,created_time) VALUES ('Wallet Transfer','Wallet_transfer','${to_user_id}','${msg_to_user}','${joining_date}','${joining_time}')`);

                        if(insert_query.rowCount > 0)
                        {
                            response.status(201).json({ status: true, message: 'Your amount has been successfully transferred', trasection_id : trasection_id })
                        }else{
                            response.status(201).json({ status: false, message: 'Your request could not be processed due to an error' })
                        }
                    }
                }else{
                    response.status(201).json({ status: false, message: 'Your account balance is insufficient for this transaction' })
                }                
            } else {
                response.status(201).json({ status: false, message: 'You have entered the incorrect PIN' })
            }
        })
    },

    Wallet_to_wallet_transfer_history_api : (request, response) => {
         
        const { user_name, user_account_id } = request.body;

        pool.query(`SELECT * FROM tbl_wallet_to_wallet_transection where from_user_name = '${user_name}' AND from_user_account_id = '${user_account_id}' order by tbl_wallet_to_wallet_transection_id DESC`, (err, result)=>{

            if(err) {
                return response.status(403).json({ status : false, message : err.message});
            }

            var count = result.rowCount;

            if(count > 0){
                var res = result.rows;
                var data = [];

                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Success';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }

                    let widdata = {
                        tbl_wallet_to_wallet_transection_id : isNull(table.tbl_wallet_to_wallet_transection_id),
                        trasection_id : isNull(table.trasection_id),
                        to_user_name : isNull(table.to_user_name),
                        to_user_account_id : isNull(table.to_user_account_id),
                        amount : isNull(table.amount),
                        deduction_percentage : isNull(table.deduction_percentage),
                        fee : isNull(table.fee),
                        main_amount : isNull(table.main_amount),
                        created_date : isNull(table.created_date),
                        created_time : isNull(table.created_time),
                        status : isNull(status_show),
                    };
                    data.push(widdata);                   
                });
                response.status(201).json({ status : true, message : 'Wallet Transfer amount list', data : data});
            }else{
                response.status(201).json({ status : false, message : 'No Record found', data : []});
            }
        })
    },


    Wallet_to_wallet_recived_history_api : (request, response) => {
         
        const { user_name, user_account_id } = request.body;

        console.log('Wallet_to_wallet_recived_history_api', request.body);

        pool.query(`SELECT * FROM tbl_wallet_to_wallet_transection where to_user_name = '${user_name}' AND to_user_account_id = '${user_account_id}' order by tbl_wallet_to_wallet_transection_id DESC`, (err, result)=>{

            if(err) {
                return response.status(403).json({ status : false, message : err.message});
            }

            var count = result.rowCount;

            if(count > 0){
                var res = result.rows;
                var data = []; 

                res.forEach(function (table) {

                    if(table.status=='1')
                    {
                        var status_show ='Success';
                    }else if(table.status=='2'){
                        var status_show ='Approved';
                    }else{
                        var status_show ='Rejected';
                    }

                    let widdata = {
                        tbl_wallet_to_wallet_transection_id : isNull(table.tbl_wallet_to_wallet_transection_id),
                        trasection_id : isNull(table.trasection_id),
                        from_user_name : isNull(table.from_user_name),
                        from_user_account_id : isNull(table.from_user_account_id),
                        amount : isNull(table.amount),
                        deduction_percentage : isNull(table.deduction_percentage),
                        fee : isNull(table.fee),
                        main_amount : isNull(table.main_amount),
                        created_date : isNull(table.created_date),
                        created_time : isNull(table.created_time),
                        status : isNull(status_show),
                    };
                    data.push(widdata);                   
                });
                response.status(201).json({ status : true, message : 'Wallet Recived amount list', data : data});
            }else{
                response.status(201).json({ status : false, message : 'No Record found', data : []});
            }
        })
    },




};