/*! firebase-admin v12.0.0 */
/*!
 * @license
 * Copyright 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/**
 * Creates a new `FirebaseAppCheckError` by extracting the error code, message and other relevant
 * details from a `CryptoSignerError`.
 *
 * @param err - The Error to convert into a `FirebaseAppCheckError` error
 * @returns A Firebase App Check error that can be returned to the user.
 */
export declare function appCheckErrorFromCryptoSignerError(err: Error): Error;
