export declare namespace MT {
    export interface Deal {
    }
    export interface ServerTime {
        time: string;
    }
    export interface Order {
        Order: string;
        ExternalID: string;
        Login: string;
        Dealer: string;
        Symbol: string;
        Digits: string;
        DigitsCurrency: string;
        ContractSize: string;
        State: string;
        Reason: string;
        TimeSetup: string;
        TimeExpiration: string;
        TimeDone: string;
        TimeSetupMsc: string;
        TimeDoneMsc: string;
        ModifyFlags: string;
        Type: string;
        TypeFill: string;
        TypeTime: string;
        PriceOrder: string;
        PriceTrigger: string;
        PriceCurrent: string;
        PriceSL: string;
        PriceTP: string;
        VolumeInitial: string;
        VolumeInitialExt: string;
        VolumeCurrent: string;
        VolumeCurrentExt: string;
        ExpertID: string;
        PositionID: string;
        PositionByID: string;
        Comment: string;
        RateMargin: string;
        ActivationMode: string;
        ActivationTime: string;
        ActivationPrice: string;
        ActivationFlags: string;
        ApiData: ApiData[];
    }
    export interface Postion {
        Position: string;
        ExternalID: string;
        Login: string;
        Dealer: string;
        Symbol: string;
        Action: string;
        Digits: string;
        DigitsCurrency: string;
        Reason: string;
        ContractSize: string;
        TimeCreate: string;
        TimeUpdate: string;
        TimeCreateMsc: string;
        TimeUpdateMsc: string;
        ModifyFlags: string;
        PriceOpen: string;
        PriceCurrent: string;
        PriceSL: string;
        PriceTP: string;
        Volume: string;
        VolumeExt: string;
        Profit: string;
        Storage: string;
        RateProfit: string;
        RateMargin: string;
        ExpertID: string;
        ExpertPositionID: string;
        Comment: string;
        ActivationMode: string;
        ActivationTime: string;
        ActivationPrice: string;
        ActivationFlags: string;
        ApiData: ApiData[];
    }
    export interface Account {
        Login: string;
        CurrencyDigits: string;
        Balance: string;
        Credit: string;
        Margin: string;
        MarginFree: string;
        MarginLevel: string;
        MarginLeverage: string;
        Profit: string;
        Storage: string;
        Commission: string;
        Floating: string;
        Equity: string;
        SOActivation: string;
        SOTime: string;
        SOLevel: string;
        SOEquity: string;
        SOMargin: string;
        Assets: string;
        Liabilities: string;
        BlockedCommission: string;
        BlockedProfit: string;
        MarginInitial: string;
        MarginMaintenance: string;
    }
    interface ApiData {
        AppID: string;
        ID: string;
        ValueInt: string;
        ValueUInt: string;
        ValueDouble: string;
    }
    type WorkHours = {
        Open: number;
        Close: number;
    } | undefined;
    export interface SymbolInfo {
        Symbol: string;
        Path: string;
        ISIN: string;
        CFI: string;
        Category: string;
        Exchange: string;
        Description: string;
        International: string;
        Sector: string;
        Industry: string;
        Country: string;
        Basis: string;
        Source: string;
        Page: string;
        CurrencyBase: string;
        CurrencyBaseDigits: string;
        CurrencyProfit: string;
        CurrencyProfitDigits: string;
        CurrencyMargin: string;
        CurrencyMarginDigits: string;
        Color: string;
        ColorBackground: string;
        Digits: string;
        Point: string;
        Multiply: string;
        TickFlags: string;
        TickBookDepth: string;
        TickChartMode: string;
        SubscriptionsDelay: string;
        FilterSoft: string;
        FilterSoftTicks: string;
        FilterHard: string;
        FilterHardTicks: string;
        FilterDiscard: string;
        FilterSpreadMax: string;
        FilterSpreadMin: string;
        FilterGap: string;
        FilterGapTicks: string;
        TradeMode: string;
        TradeFlags: string;
        CalcMode: string;
        ExecMode: string;
        GTCMode: string;
        FillFlags: string;
        ExpirFlags: string;
        OrderFlags: string;
        Spread: string;
        SpreadBalance: string;
        SpreadDiff: string;
        SpreadDiffBalance: string;
        TickValue: string;
        TickSize: string;
        ContractSize: string;
        StopsLevel: string;
        FreezeLevel: string;
        QuotesTimeout: string;
        VolumeMin: string;
        VolumeMinExt: string;
        VolumeMax: string;
        VolumeMaxExt: string;
        VolumeStep: string;
        VolumeStepExt: string;
        VolumeLimit: string;
        VolumeLimitExt: string;
        MarginFlags: string;
        MarginInitial: string;
        MarginMaintenance: string;
        MarginInitialBuy: string;
        MarginInitialSell: string;
        MarginInitialBuyLimit: string;
        MarginInitialSellLimit: string;
        MarginInitialBuyStop: string;
        MarginInitialSellStop: string;
        MarginInitialBuyStopLimit: string;
        MarginInitialSellStopLimit: string;
        MarginMaintenanceBuy: string;
        MarginMaintenanceSell: string;
        MarginMaintenanceBuyLimit: string;
        MarginMaintenanceSellLimit: string;
        MarginMaintenanceBuyStop: string;
        MarginMaintenanceSellStop: string;
        MarginMaintenanceBuyStopLimit: string;
        MarginMaintenanceSellStopLimit: string;
        MarginLiquidity: string;
        MarginHedged: string;
        MarginCurrency: string;
        SwapMode: string;
        SwapLong: string;
        SwapShort: string;
        Swap3Day: string;
        TimeStart: string;
        TimeExpiration: string;
        SessionsQuotes: [[WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours]];
        SessionsTrades: [[WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours], [WorkHours]];
        REFlags: string;
        RETimeout: string;
        IECheckMode: string;
        IETimeout: string;
        IESlipProfit: string;
        IESlipLosing: string;
        IEVolumeMax: string;
        IEVolumeMaxExt: string;
        PriceSettle: string;
        PriceLimitMax: string;
        PriceLimitMin: string;
        PriceStrike: string;
        OptionMode: string;
        FaceValue: string;
        AccruedInterest: string;
        SpliceType: string;
        SpliceTimeType: string;
        SpliceTimeDays: string;
    }
    export interface Tick {
        Symbol: string;
        Digits: string;
        Datetime: string;
        DatetimeMsc: string;
        Bid: string;
        Ask: string;
        Last: string;
        Volume: string;
        VolumeReal: string;
    }
    export interface SymbolStat {
        Symbol: string;
        Digits: string;
        Datetime: string;
        DatetimeMsc: string;
        Bid: string;
        BidLow: string;
        BidHigh: string;
        BidDir: string;
        Ask: string;
        AskLow: string;
        AskHigh: string;
        AskDir: string;
        Last: string;
        LastLow: string;
        LastHigh: string;
        LastDir: string;
        Volume: string;
        VolumeReal: string;
        VolumeLow: string;
        VolumeLowReal: string;
        VolumeHigh: string;
        VolumeHighReal: string;
        VolumeDir: string;
        TradeDeals: string;
        TradeVolume: string;
        TradeVolumeReal: string;
        TradeTurnover: string;
        TradeInterest: string;
        TradeBuyOrders: string;
        TradeBuyVolume: string;
        TradeBuyVolumeReal: string;
        TradeSellOrders: string;
        TradeSellVolume: string;
        TradeSellVolumeReal: string;
        PriceAw: string;
        PriceOpen: string;
        PriceClose: string;
        PriceChange: string;
        PriceVolatility: string;
        PriceTheoretical: string;
        PriceGreeksDelta: string;
        PriceGreeksTheta: string;
        PriceGreeksGamma: string;
        PriceGreeksVega: string;
        PriceGreeksRho: string;
        PriceGreeksOmega: string;
        PriceSensitivity: string;
    }
    export interface Group {
        Group: string;
        Server: string;
        PermissionsFlags: string;
        AuthMode: string;
        AuthPasswordMin: string;
        AuthOTPMode: string;
        Company: string;
        CompanyPage: string;
        CompanyEmail: string;
        CompanySupportPage: string;
        CompanySupportEmail: string;
        CompanyCatalog: string;
        CompanyDepositURL: string;
        CompanyWithdrawalURL: string;
        Currency: string;
        CurrencyDigits: string;
        ReportsMode: string;
        ReportsFlags: string;
        ReportsEmail: string;
        NewsMode: string;
        NewsCategory: string;
        NewsLangs: any[];
        MailMode: string;
        TradeFlags: string;
        TradeTransferMode: string;
        TradeInterestrate: string;
        TradeVirtualCredit: string;
        MarginMode: string;
        MarginFlags: string;
        MarginSOMode: string;
        MarginFreeMode: string;
        MarginCall: string;
        MarginStopOut: string;
        MarginFreeProfitMode: string;
        DemoLeverage: string;
        DemoDeposit: string;
        DemoTradesClean: string;
        LimitHistory: string;
        LimitOrders: string;
        LimitSymbols: string;
        LimitPositions: string;
        Commissions: any[];
        Symbols: {
            Path: string;
            TradeMode: string;
            ExecMode: string;
            FillFlags: string;
            ExpirFlags: string;
            OrderFlags: string;
            SpreadDiff: string;
            SpreadDiffBalance: string;
            StopsLevel: string;
            FreezeLevel: string;
            VolumeMin: string;
            VolumeMinExt: string;
            VolumeMax: string;
            VolumeMaxExt: string;
            VolumeStep: string;
            VolumeStepExt: string;
            VolumeLimit: string;
            VolumeLimitExt: string;
            MarginFlags: string;
            MarginInitial: string;
            MarginMaintenance: string;
            MarginInitialBuy: string;
            MarginInitialSell: string;
            MarginInitialBuyLimit: string;
            MarginInitialSellLimit: string;
            MarginInitialBuyStop: string;
            MarginInitialSellStop: string;
            MarginInitialBuyStopLimit: string;
            MarginInitialSellStopLimit: string;
            MarginMaintenanceBuy: string;
            MarginMaintenanceSell: string;
            MarginMaintenanceBuyLimit: string;
            MarginMaintenanceSellLimit: string;
            MarginMaintenanceBuyStop: string;
            MarginMaintenanceSellStop: string;
            MarginMaintenanceBuyStopLimit: string;
            MarginMaintenanceSellStopLimit: string;
            MarginLiquidity: string;
            MarginHedged: string;
            MarginCurrency: string;
            SwapMode: string;
            SwapLong: string;
            SwapShort: string;
            Swap3Day: string;
            REFlags: string;
            RETimeout: string;
            IEFlags: string;
            IECheckMode: string;
            IETimeout: string;
            IESlipProfit: string;
            IESlipLosing: string;
            IEVolumeMax: string;
            IEVolumeMaxExt: string;
            PermissionsFlags: string;
            PermissionsBookdepth: string;
        }[];
    }
    export interface DailyReport {
        Timestamp: string;
        DatetimePrev: string;
        Login: string;
        Name: string;
        Group: string;
        Currency: string;
        CurrencyDigits: string;
        Company: string;
        EMail: string;
        Balance: string;
        Credit: string;
        InterestRate: string;
        CommissionDaily: string;
        CommissionMonthly: string;
        AgentDaily: string;
        AgentMonthly: string;
        BalancePrevDay: string;
        BalancePrevMonth: string;
        EquityPrevDay: string;
        EquityPrevMonth: string;
        Margin: string;
        MarginFree: string;
        MarginLevel: string;
        MarginLeverage: string;
        Profit: string;
        ProfitStorage: string;
        ProfitCommission: string;
        ProfitEquity: string;
        ProfitAssets: string;
        ProfitLiabilities: string;
        DailyProfit: string;
        DailyBalance: string;
        DailyCredit: string;
        DailyCharge: string;
        DailyCorrection: string;
        DailyBonus: string;
        DailyStorage: string;
        DailyCommInstant: string;
        DailyCommFee: string;
        DailyCommRound: string;
        DailyAgent: string;
        DailyInterest: string;
        DailyDividend: string;
        DailyTaxes: string;
        DailySOCompensation: string;
        Positions: {
            Position: string;
            ExternalID: string;
            Login: string;
            Dealer: string;
            Symbol: string;
            Action: string;
            Digits: string;
            DigitsCurrency: string;
            Reason: string;
            ContractSize: string;
            TimeCreate: string;
            TimeUpdate: string;
            TimeCreateMsc: string;
            TimeUpdateMsc: string;
            ModifyFlags: string;
            PriceOpen: string;
            PriceCurrent: string;
            PriceSL: string;
            PriceTP: string;
            Volume: string;
            VolumeExt: string;
            Profit: string;
            Storage: string;
            RateProfit: string;
            RateMargin: string;
            ExpertID: string;
            ExpertPositionID: string;
            Comment: string;
            ActivationMode: string;
            ActivationTime: string;
            ActivationPrice: string;
            ActivationFlags: string;
            ApiData: ApiData[];
        }[];
        Orders: {
            Order: string;
            ExternalID: string;
            Login: string;
            Dealer: string;
            Symbol: string;
            Digits: string;
            DigitsCurrency: string;
            ContractSize: string;
            State: string;
            Reason: string;
            TimeSetup: string;
            TimeExpiration: string;
            TimeDone: string;
            TimeSetupMsc: string;
            TimeDoneMsc: string;
            ModifyFlags: string;
            Type: string;
            TypeFill: string;
            TypeTime: string;
            PriceOrder: string;
            PriceTrigger: string;
            PriceCurrent: string;
            PriceSL: string;
            PriceTP: string;
            VolumeInitial: string;
            VolumeInitialExt: string;
            VolumeCurrent: string;
            VolumeCurrentExt: string;
            ExpertID: string;
            PositionID: string;
            PositionByID: string;
            Comment: string;
            RateMargin: string;
            ActivationMode: string;
            ActivationTime: string;
            ActivationPrice: string;
            ActivationFlags: string;
            ApiData: ApiData[];
        }[];
    }
    export interface HistoryBar {
        dt: number;
        open: number;
        high: number;
        low: number;
        close: number;
        tick: number;
        volume: number;
    }
    export {};
}
