const pg = require('pg');
const moment = require('moment');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const requests = require('request');
const admin = require('firebase-admin');
const serviceAccount = require("../../user/api/trade-munda-firebase-adminsdk-fd44z-98b41324e7.json");

// Initialize the Firebase Admin SDK
admin.initializeApp({
    credential: admin.credential.cert(serviceAccount)
});

const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);




module.exports = {

    send_notification_to_all_user :  async(title,  notification_message)=> {

        console.log('title', title);
        console.log('notification_message', notification_message);            
    
        const topic = 'all_user'; // Topic name
        
        // Function to send a push notification

        const message = {
            topic: topic, // Use topic instead of to
            notification: {
                title: title,
                body: notification_message,                
            }
        };
    
        admin.messaging().send(message)
        .then((response) => {
            console.log('Successfully sent message:', response);
        })
        .catch((error) => {
            console.error('Error sending message:', error);
        });
   
    },
};