const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
const formidable = require('formidable');
const date = require('date-and-time');
const AWS = require('aws-sdk');
const crypto = require("crypto");
const base_url = 'http://zerogravity.ojpasoftware.com:8152/files/upload'

AWS.config.update({
    accessKeyId: 'AKIAR3PYHLJ2HJHWOXWQ',
    secretAccessKey: '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'
});

const s3 = new AWS.S3({
    accessKeyId: process.env.accessKeyId,
    secretAccessKey: process.env.secretAccessKey,
    region: 'ap-south-1'
})



function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

const mailconfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailconfig);




module.exports = {
   
    Add_category_api: (request, response) => {

        const form = formidable({ multiples: true });
        form.parse(request, (err, fields, files) => {

            if (err) {
                return response.status(403).json({ status: false, message: err, })
            }

            if (fields.category_name == '' || fields.category_name == null || fields.category_name == undefined) {
                return response.status(400).json({ status: false, message: 'category_name is required', })
            }
            if (fields.position == '' || fields.position == null || fields.position == undefined) {
                return response.status(400).json({ status: false, message: 'position is required', })
            }
            if (files.category_image == '' || files.category_image == null || files.category_image == undefined) {
                return response.status(400).json({ status: false, message: 'category_image is required', })
            }
            if (files.category_icon == '' || files.category_icon == null || files.category_icon == undefined) {
                return response.status(400).json({ status: false, message: 'category_icon is required', })
            }
           

        
            pool.query(`SELECT category_name FROM tbl_category WHERE category_name = $$${fields.category_name}$$`, async(error, result) => {

                if (error) {
                    return response.status(403).json({ status: false, message: error, })
                }
                var count = result.rowCount;
                if (count > 0) {

                    response.status(201).json({ status: false, message: 'Same name category is already added on your list' })

                } else {

                    const fileName = files.category_image.path;
                    const typefile = files.category_image.type
                    const fileContent = fs.readFileSync(fileName)
                    var type = typefile.split("/");
                    var imagename = Math.floor(10000000 + Math.random() * 90000000);
                    const addones_image = imagename + '.' + type[1];

                    fs.writeFile(`./views/files/upload/category_image/${addones_image}`, fileContent, (err) => {
                        if (err) {
                          console.error(err);
                        }
                    });

                    const fileName_icn = files.category_icon.path;
                    const typefile_icn = files.category_icon.type
                    const fileContent_icn = fs.readFileSync(fileName_icn)
                    var type = typefile_icn.split("/");
                    var iconname = Math.floor(10000000 + Math.random() * 90000000);
                    const cat_icon =  'icon_'+iconname + '.' + type[1];

                    fs.writeFile(`./views/files/upload/category_image/${cat_icon}`, fileContent_icn, (err) => {
                        if (err) {
                          console.error(err);
                        }
                    });
                   
                    const added_category = await pool.query(`INSERT INTO tbl_category (category_name,category_image, position, category_icon) VALUES ($$${fields.category_name}$$,'${addones_image}', '${fields.position}','${cat_icon}')`);

                    if(added_category.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category added succesfully .' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }
                }
            })
        });
    },

    Category_list_api: (request, response) => {

        const { tbl_admin_id } = request.body

        pool.query('SELECT * FROM tbl_category ORDER BY tbl_category_id DESC', (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
    
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
    
                    let cat = {
                        tbl_category_id: isNull(table.tbl_category_id),
                        category_name: isNull(table.category_name),
                        category_image: base_url+"/category_image/"+isNull(table.category_image),
                        position: isNull(table.position),
                        category_icon: base_url+"/category_image/"+isNull(table.category_icon),
                        status: table.cat_status,
                        
                    };
                    data.push(cat);
    
                });
    
                response.status(201).json({ status: true, message: 'Category List', data: data })
            } else {
                response.status(201).json({ status: false, message: 'Category List Not Found', data: [] })
            }
    
        })
    },

    
    select_category_for_puja_api: (request, response) => {

        const { tbl_admin_id } = request.body

        pool.query('SELECT * FROM tbl_category where cat_status = 1 ORDER BY tbl_category_id DESC', (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
    
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
    
                    let cat = {
                        tbl_category_id: isNull(table.tbl_category_id),
                        category_name: isNull(table.category_name),
                        status: table.cat_status,
                    };
                    data.push(cat);
    
                });
    
                response.status(201).json({ status: true, message: 'Category List', data: data })
            } else {
                response.status(201).json({ status: false, message: 'Category List Not Found', data: [] })
            }
    
        })
    },


    Category_detail_api: (request, response) => {

        const { tbl_admin_id,tbl_category_id } = request.body

        pool.query(`SELECT * FROM tbl_category where tbl_category_id = '${tbl_category_id}'`, (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
    
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
    
                    let cat = {
                        tbl_category_id: isNull(table.tbl_category_id),
                        category_name: isNull(table.category_name),
                        category_image: base_url+"/category_image/"+isNull(table.category_image),
                        position: isNull(table.position),
                        category_icon: base_url+"/category_image/"+isNull(table.category_icon),
                        status: table.cat_status,
                    };
                    data.push(cat);
    
                });
    
                response.status(201).json({ status: true, message: 'Category Data Details', data: data })
            } else {
                response.status(201).json({ status: true, message: 'Category List Not Found', data: [] })
            }
    
        })
    },


    update_category_api:(request, response) => {

        const form = formidable({ multiples: true });
        form.parse(request, (err, fields, files) => {
            if (err) {
                return response.status(403).json({ status: false, message: err, })
            }
            if (fields.tbl_category_id == '' || fields.tbl_category_id == null || fields.tbl_category_id == undefined) {
                return response.status(400).json({ status: false, message: 'tbl_category_id is required', });
            }

            if (fields.category_name == '' || fields.category_name == null || fields.category_name == undefined) {
                return response.status(400).json({ status: false, message: 'category_name is required', })
            }

            if (fields.status == '' || fields.status == null || fields.status == undefined) {
                return response.status(400).json({ status: false, message: 'status is required', })
            }

            if (fields.position == '' || fields.position == null || fields.position == undefined) {
                return response.status(400).json({ status: false, message: 'position is required', })
            }
        
            if (files.cat_image != undefined &&  files.category_icon != undefined) {

               

                const fileName = files.cat_image.path;
                const typefile = files.cat_image.type
                const fileContent = fs.readFileSync(fileName)
                var type = typefile.split("/");
                var imagename = Math.floor(10000000 + Math.random() * 90000000);
                const category_img = imagename + '.' + type[1];

                fs.writeFile(`./views/files/upload/category_image/${category_img}`, fileContent, (err) => {
                    if (err) {
                      console.error(err);
                    }
                });
            



                /////////  upload category icon  ////// 

                    const fileName_icn = files.category_icon.path;
                    const typefile_icn = files.category_icon.type
                    const fileContent_icn = fs.readFileSync(fileName_icn)
                    var type = typefile_icn.split("/");
                    var iconname = Math.floor(10000000 + Math.random() * 90000000);
                    const cat_icon =  'icon_'+iconname + '.' + type[1];

                    fs.writeFile(`./views/files/upload/category_image/${cat_icon}`, fileContent_icn, (err) => {
                        if (err) {
                          console.error(err);
                        }
                    });
                  
                /////////  upload category icon  ////// 

                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$, cat_status = '${fields.status}', position = '${fields.position}',category_icon = '${cat_icon}',category_image = '${category_img}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {

                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully.' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }
                })

            }else if(files.cat_image != undefined) {

             
                
                const fileName = files.cat_image.path;
                const typefile = files.cat_image.type
                const fileContent = fs.readFileSync(fileName)
                var type = typefile.split("/");
                var imagename = Math.floor(10000000 + Math.random() * 90000000);
                const category_img = imagename + '.' + type[1];

                fs.writeFile(`./views/files/upload/category_image/${category_img}`, fileContent, (err) => {
                    if (err) {
                      console.error(err);
                    }
                });

                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$, cat_status = '${fields.status}', position = '${fields.position}',category_image = '${category_img}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {

                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully.' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }
                })

            }else if(files.category_icon != undefined) {

               


                /////////  upload category icon  ////// 

                    const fileName_icn = files.category_icon.path;
                    const typefile_icn = files.category_icon.type
                    const fileContent_icn = fs.readFileSync(fileName_icn)
                    var type = typefile_icn.split("/");
                    var iconname = Math.floor(10000000 + Math.random() * 90000000);
                    const cat_icon =  'icon_'+iconname + '.' + type[1];

                    fs.writeFile(`./views/files/upload/category_image/${cat_icon}`, fileContent_icn, (err) => {
                        if (err) {
                          console.error(err);
                        }
                    });
                /////////  upload category icon  ////// 

                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$, cat_status = '${fields.status}', position = '${fields.position}',category_icon = '${cat_icon}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {

                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully.' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }
                })

            } else {


                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$, position = '${fields.position}', cat_status = '${fields.status}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {


                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully .' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }

                })
            }
        });
    },


    back_up_update_category_api:(request, response) => {

        const form = formidable({ multiples: true });
        form.parse(request, (err, fields, files) => {
            if (err) {
                return response.status(403).json({ status: false, message: err, })
            }
            if (fields.tbl_category_id == '' || fields.tbl_category_id == null || fields.tbl_category_id == undefined) {
                return response.status(400).json({ status: false, message: 'tbl_category_id is required', });
            }

            if (fields.category_name == '' || fields.category_name == null || fields.category_name == undefined) {
                return response.status(400).json({ status: false, message: 'category_name is required', })
            }

            if (fields.status == '' || fields.status == null || fields.status == undefined) {
                return response.status(400).json({ status: false, message: 'status is required', })
            }

            
        
            if (files.cat_image != undefined ) {

                const fileName = files.cat_image.path;
                const typefile = files.cat_image.type
                const fileContent = fs.readFileSync(fileName)
                var type = typefile.split("/");
                var imagename = Math.floor(10000000 + Math.random() * 90000000);
                const category_img = imagename + '.' + type[1];
              
                const params = {
                    Bucket: 'easemypuja',
                    Key: `easemypuja/category_image/${category_img}`,
                    'ContentType': 'image/png',
                    Body: fileContent
                }

                s3.upload(params, (err, data) => {
                    if (err) {
                        //reject(err)
                        console.log(err)
                    }
                })
            

                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$,cat_status = '${fields.status}',category_image = '${category_img}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {


                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully.' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }
                })

            } else {

                pool.query(`UPDATE tbl_category SET category_name = $$${fields.category_name}$$,cat_status = '${fields.status}' WHERE tbl_category_id =${fields.tbl_category_id}`, (error, result) => {


                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your category updated succesfully .' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }

                })
            }
        });
    },


    ///////////////////////   specialization for astrologer code start from here      /////////////////////

    specialization_list_api: (request, response) => {

        const { tbl_admin_id } = request.body

        pool.query('SELECT * FROM tbl_specialization_astro ORDER BY tbl_specialization_astro_id DESC', (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
    
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
    
                    let spe = {
                        tbl_specialization_astro_id: isNull(table.tbl_specialization_astro_id),
                        astro_specialization_name: isNull(table.astro_specialization_name),
                        status: table.status
                    };
                    data.push(spe);
    
                });
    
                response.status(201).json({ status: true, message: 'Specialization List', data: data })
            } else {
                response.status(404).json({ status: false, message: 'Specialization List Not Found', data: [] });
            }
    
        })
    },

    specialization_details_api: (request, response) => {

        const { tbl_admin_id, tbl_specialization_id } = request.body

        pool.query(`SELECT * FROM tbl_specialization_astro where tbl_specialization_astro_id = ${tbl_specialization_id}`, (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
    
                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
    
                    let spe = {
                        tbl_specialization_astro_id: isNull(table.tbl_specialization_astro_id),
                        astro_specialization_name: isNull(table.astro_specialization_name),
                        status: table.status
                    };
                    data.push(spe);
    
                });
    
                response.status(201).json({ status: true, message: 'Specialization details', data: data })
            } else {
                response.status(404).json({ status: false, message: 'Specialization details Not Found', data: [] });
            }
    
        })
    },

    add_specialization_api: (request, response) => {

        const { tbl_admin_id, specialization_name  } = request.body

       
        pool.query(`SELECT tbl_specialization_astro_id FROM tbl_specialization_astro where  astro_specialization_name =  $$${specialization_name}$$`,async (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            if (count > 0) {
                response.status(201).json({ status: false, message: 'This Specialization name is already added on your list.' });
            } else {
                const added_speci = await pool.query(`INSERT INTO tbl_specialization_astro (astro_specialization_name) VALUES ($$${specialization_name}$$)`); 

                if(added_speci.rowCount > 0)
                {
                    response.status(201).json({ status: true, message: 'Your Specialization added succesfully .' })
                }else{
                    response.status(201).json({ status: false, message: 'something error' })
                }
                
            }
    
        })
    },


    update_specialization_api: (request, response) => {

        const { tbl_admin_id, tbl_specialization_id, specialization_name, status } = request.body;

        console.log('update_specialization_api', request.body);



        pool.query(`SELECT tbl_specialization_astro_id FROM tbl_specialization_astro where astro_specialization_name = $$${specialization_name}$$ and tbl_specialization_astro_id != ${tbl_specialization_id}`, (error, result) => {
    
            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                response.status(201).json({ status: false, message: 'This Specialization name is already added on your list.'});
            } else {
                pool.query(`UPDATE tbl_specialization_astro  SET astro_specialization_name = $$${specialization_name}$$,status = '${status}' WHERE tbl_specialization_astro_id = ${tbl_specialization_id}`, (error, result) => {


                    if(result.rowCount > 0)
                    {
                        response.status(201).json({ status: true, message: 'Your Specialization updated succesfully.' })
                    }else{
                        response.status(201).json({ status: false, message: 'something error' })
                    }

                });
            }
    
        })
    },
    
    ///////////////////////   specialization for astrologer code end from here       /////////////////////






};