# Contributing to error-handler-module

Thanks for your interest in error-handler-module. Our goal is to provide some easy way to handle errors across node applications, and we are focused on Express.js applications.

## Contributions

error-handler-module welcomes contributions from everyone.

Contributions to error-handler-module should be made in the form of GitHub pull requests. Each pull request will
be reviewed by a core contributor ([@inigomarquinez](https://github.com/inigomarquinez) or [@kevinccbsg](https://github.com/kevinccbsg)) and either landed in the
main tree or given feedback for changes that would be required.

## Getting Started

error-handler-module's [open issues are here](https://github.com/guidesmiths/error-handler-module/issues).

error-handler-module's [docs are here](https://github.com/guidesmiths/error-handler-module/blob/main/README.md).

You can clone this repository and run this command to start using developing this package.

```
npm install
```

If you want to test it you can add a new test in [this folder](https://github.com/guidesmiths/error-handler-module/tree/master/test).

To execute package's tests you have run this command:

```
npm test
```

Please also ensure linting is correct while you're developing by running this command:

```
npm run lint
```

## Pull Request Checklist

- [Check validations](https://app.circleci.com/pipelines/github/guidesmiths/error-handler-module) should pass. This one includes linting and testing.

- Commits should be as small as possible, while ensuring that each commit is
  correct independently (i.e., each commit should compile and pass tests). 

- If your patch is not getting reviewed or you need a specific person to review
  it, you can @-reply a reviewer asking for a review in the pull request or a
  comment.


## Conduct

We follow the [error-handler-module Code of Conduct](https://github.com/guidesmiths/error-handler-module/blob/master/CODE_OF_CONDUCT.md).

All code in this repository is under [MIT License](https://github.com/guidesmiths/error-handler-module/blob/master/LICENSE.md).
