/*! firebase-admin v12.1.1 */
"use strict";
/*!
 * Copyright 2021 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.PercentConditionOperator = void 0;
/**
 * Defines supported operators for percent conditions.
 */
var PercentConditionOperator;
(function (PercentConditionOperator) {
    /**
     * A catchall error case.
     */
    PercentConditionOperator["UNKNOWN"] = "UNKNOWN";
    /**
     * Target percentiles less than or equal to the target percent.
     * A condition using this operator must specify microPercent.
     */
    PercentConditionOperator["LESS_OR_EQUAL"] = "LESS_OR_EQUAL";
    /**
     * Target percentiles greater than the target percent.
     * A condition using this operator must specify microPercent.
     */
    PercentConditionOperator["GREATER_THAN"] = "GREATER_THAN";
    /**
     * Target percentiles within an interval defined by a lower bound and an
     * upper bound. The lower bound is an exclusive (open) bound and the
     * micro_percent_range_upper_bound is an inclusive (closed) bound.
     * A condition using this operator must specify microPercentRange.
     */
    PercentConditionOperator["BETWEEN"] = "BETWEEN";
})(PercentConditionOperator || (exports.PercentConditionOperator = PercentConditionOperator = {}));
