const http = require('http');
const WebSocket = require('ws');
const pg = require('pg');
const dbconfig = require('../db');
const moment = require('moment');
const pool = new pg.Pool(dbconfig);
const server = http.createServer();
const wss = new WebSocket.Server({ server, path: '/websocket_admin_order_detail_list_API' });

function isNull(item) {
  return item || "";
}

const clients = new Set(); 
async function fetchAndSendData() {
  try {
    const select_Query = await pool.query(`
      SELECT (
        SELECT currencypair_image 
        FROM tbl_currencypair_logo 
        WHERE status = '1' AND currencypair = tbl_order.currency_pair
      ) AS currencypair_image,
      tbl_market_live_rate.currency_pair AS marker_pair, 
      tbl_market_live_rate.sell_bidprice, 
      tbl_market_live_rate.buy_askprice,
      tbl_market_live_rate.market_status, 
      tbl_order.* 
      FROM tbl_order  
      INNER JOIN tbl_market_live_rate  
      ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
      WHERE tbl_order.order_status = 'open' 
      ORDER BY tbl_order.tbl_order_id DESC
    `);

    const count = select_Query.rowCount;

    if (count > 0) {
      const resdata = select_Query.rows;
      let total_profitloss_value = 0;

      const data = resdata.map((table) => {
        const currencypair_image = table.currencypair_image 
          ? 'http://metarg.ojpasoftware.com:8126/files/upload/currencypair_image/' + table.currencypair_image 
          : "";

        let profitloss = table.type === 'sell' 
          ? table.exchange_rate - table.sell_bidprice 
          : table.buy_askprice - table.exchange_rate;

        const profitloss_value = Number(
          ((profitloss.toFixed(5)) * table.lotsize_in_lak * table.tradesize_lots.toFixed(2)).toFixed(2) * 
          (table.quote_currency_amount_in_usd.toFixed(5))
        );

        total_profitloss_value += profitloss_value;

        const profitloss_type = profitloss_value >= 0 ? 'profit' : 'loss';
        const claculation_value = table.tradesize_lots * table.lotsize_in_lak;

        const stop_los_val = table.stop_loss_status === 'yes' ? table.stop_loss.toFixed(2) : "";
        const take_profit_val = table.take_profit_status === 'yes' ? table.take_profit.toFixed(2) : "";

        return {
          tbl_user_id: isNull(table.tbl_user_id),
          login_id: isNull(table.login_id),
          order_status: isNull(table.order_status),
          tbl_order_id: isNull(table.tbl_order_id),
          order_id: isNull(table.order_id),
          type: isNull(table.type),
          market_status: isNull(table.market_status),
          market_order_type: isNull(table.market_order_type),
          currency_pair: isNull(table.currency_pair),
          currencypair_image: currencypair_image,
          currency_type: isNull(table.currency_type),
          margin: table.margin.toFixed(2),
          leverage_ratio: table.leverage_ratio,
          exchange_rate: table.exchange_rate,
          market_sell_bidPrice: table.sell_bidprice,
          market_buy_askPrice: table.buy_askprice,
          quote_currency_amount_in_usd: table.quote_currency_amount_in_usd.toFixed(5),
          profitloss_value: profitloss_value,
          profitloss_type: profitloss_type,
          tradesize_lots: table.tradesize_lots.toFixed(2),
          multiply_profit_loss: claculation_value,
          isupdater: "0.00",
          stop_loss: stop_los_val,
          take_profit: take_profit_val,
          take_profit_price: table.take_profit_price,
          stop_loss_price: table.stop_loss_price,
          open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a')
        };
      });

      for (const client of clients) {
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify({
            event: 'Open order data',
            total_profitloss_value: total_profitloss_value.toFixed(2),
            data
          }));
        }
      }

    } else {
      for (const client of clients) {
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify({
            event: 'No open orders found',
            total_profitloss_value: "",
            data: []
          }));
        }
      }
    }

  } catch (err) {
    console.error('Error fetching open orders:', err);
  }
}

wss.on('connection', function connection(ws) {
  clients.add(ws);

  ws.on('close', () => {
    clients.delete(ws);
  });

  console.log('Client connected');
});

setInterval(fetchAndSendData, 3000);

server.listen(8173, function listening() {
  console.log('Server is listening on port 8173');
});
