const http = require('http');
const WebSocket = require('ws');
const pg = require('pg');
const dbconfig = require('../db');
const moment = require('moment');
const pool = new pg.Pool(dbconfig);
const server = http.createServer();
const wss = new WebSocket.Server({ server, path: '/pending_order_api' });

const clientsData = new Map(); // To store parameters for each client

function isNull(item) {
  return item || "";
}

async function fetchAndSendData() {
  for (const [client, params] of clientsData.entries()) {
    if (params && params.tbl_user_id && params.login_id) {
      const { tbl_user_id, login_id } = params;
      try {

        const select_Query = await pool.query(
          `SELECT (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair),
             tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
             tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.order_status = 'pending' AND tbl_order.tbl_user_id = '${tbl_user_id}' AND tbl_order.login_id = '${login_id}' order by tbl_order.tbl_order_id DESC`
        );

        const count = select_Query.rowCount;

        if (count > 0) {
          const resdata = select_Query.rows;
          const data = resdata.map((table) => {
            const currencypair_image = table.currencypair_image ? 
              'http://35.154.239.62:8126/files/upload/currencypair_image/' + table.currencypair_image : "";

            let profitloss;
            if (table.type === 'sell') {
              profitloss = table.exchange_rate - table.sell_bidprice;
            } else {
              profitloss = table.buy_askprice - table.exchange_rate;
            }
            const profitloss_value = Number(((profitloss.toFixed(5)) * table.lotsize_in_lak * table.tradesize_lots.toFixed(2)).toFixed(2) * (table.quote_currency_amount_in_usd.toFixed(5)));
            const profitloss_type = profitloss_value >= 0 ? 'profit' : 'loss';
            const claculation_value = table.tradesize_lots * table.lotsize_in_lak;

            return {
              tbl_user_id: isNull(table.tbl_user_id),
              login_id: isNull(table.login_id),
              order_status: isNull(table.order_status),
              tbl_order_id: isNull(table.tbl_order_id),
              order_id: isNull(table.order_id),
              type: isNull(table.type),
              market_status: isNull(table.market_status),
              market_order_type: isNull(table.market_order_type),
              currency_pair: isNull(table.currency_pair),
              currencypair_image: currencypair_image,
              currency_type: isNull(table.currency_type),
              margin: table.margin.toFixed(2),
              leverage_ratio: table.leverage_ratio,
              exchange_rate: table.exchange_rate,
              market_sell_bidPrice: table.sell_bidprice,
              market_buy_askPrice: table.buy_askprice,
              profitloss_value: profitloss_value,
              profitloss_type: profitloss_type,
              tradesize_lots: table.tradesize_lots.toFixed(2),
              multiply_profit_loss: claculation_value,
              isupdater: "0.00",
              stop_loss: table.stop_loss.toFixed(2),
              take_profit: table.take_profit.toFixed(2),
              open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a')
            };
          });

          if (client.readyState === WebSocket.OPEN) {
            client.send(JSON.stringify({ event: 'Pending order data', data: data }));
          }
        } else {
          if (client.readyState === WebSocket.OPEN) {
            client.send(JSON.stringify({ event: 'No pending orders found', data: [] }));
          }
        }
      } catch (err) {
        console.error('Error updating tbl_order:', err);
      }
    }
  }
}

wss.on('connection', function connection(ws) {
  ws.on('message', function incoming(message) {
    try {
      const receivedData = JSON.parse(message);
      const { tbl_user_id, login_id } = receivedData;

      if (tbl_user_id && login_id) {
        // Check if a client with the same user ID already exists
        let existingClient = null;
        for (const [client, params] of clientsData.entries()) {
          if (params && params.tbl_user_id === tbl_user_id && params.login_id === login_id) {
            existingClient = client;
            break;
          }
        }

        if (existingClient) {
          existingClient.close(); // Close the existing connection
          clientsData.delete(existingClient); // Remove the old client's data
        }

        // Store the new connection
        clientsData.set(ws, { tbl_user_id, login_id });

        // console.log('Updated client data:', clientsData);
      }
    } catch (error) {
      console.error('Error parsing JSON message:', error);
    }
  });

  ws.on('close', function close() {
    // Remove client data on disconnect
    clientsData.delete(ws);
    // console.log('Client disconnected, updated client data:', clientsData);
  });

  console.log('Client connected');
});

// Periodically fetch and send data to all clients every 3 seconds
setInterval(fetchAndSendData, 3000);

server.listen(8155, function listening() {
  console.log('Server is listening on port 8155');
});
