const pg = require('pg');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const moment = require('moment');
const notification_function = require('./notification_function');
//notification_function.send_notification(tbl_user_id, title, message_type, message);

const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);


function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

module.exports = {

    auto_update_pending_to_open_order_api : async(request, response) => {

        const select_Query = await pool.query( `SELECT tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice, tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order INNER JOIN tbl_market_live_rate ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.order_status = 'pending'`
        );
        const count = select_Query.rowCount;

        // console.log('auto_update_pending_to_open_order_api');
    
        if (count > 0) {
            const resdata = select_Query.rows;
        
            resdata.forEach(async (table) =>{
                const tbl_user_id = table.tbl_user_id;
                const tbl_order_id = table.tbl_order_id;
                const sell_bidprice = table.sell_bidprice;
                const buy_askprice = table.buy_askprice;

                if (table.type === 'sell'){
                    // sell limit 1.00 lot at 1.08661 and sell market price 1.08650 in pending
                    // execute sell_limit condition exchange_rate = 1.08650 then market_sell_bidprice = 1.08655 is true
                    if (table.market_order_type === 'sell_limit') {
                        if (sell_bidprice >= table.exchange_rate) {
                        const updateQuery = await pool.query(`UPDATE tbl_order SET order_status = 'open' WHERE order_status = 'pending' AND tbl_order_id = '${tbl_order_id}' AND type = 'sell' AND market_order_type = 'sell_limit'`);
            
                        if (updateQuery.rowCount > 0) {
                            const title = `Order executed`;
                            const message_type = `order_executed`;
                            const message = `Your ${table.type} Order #${table.order_id} for ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} is executed at ${table.exchange_rate}`;
            
                            notification_function.send_notification(tbl_user_id, title, message_type, message);
                        }
                        }
                    } else {
                        // sell limit 1.00 lot at 1.08630 and sell market price 1.08650 in pending
                        // execute sell_stop condition exchange_rate = 1.08630 then market_sell_bidprice = 1.08625 is true
                        if (table.exchange_rate >= sell_bidprice) {
                        const updateQuery = await pool.query(`UPDATE tbl_order SET order_status = 'open' WHERE order_status = 'pending' AND tbl_order_id = '${tbl_order_id}' AND type = 'sell' AND market_order_type = 'sell_stop'`);
            
                        if (updateQuery.rowCount > 0) {
                            const title = `Order executed`;
                            const message_type = `order_executed`;
                            const message = `Your ${table.type} Order #${table.order_id} for ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} is executed at ${table.exchange_rate}`;
            
                            notification_function.send_notification(tbl_user_id, title, message_type, message);
                        }
                        }
                    }
                } else {
                    if (table.market_order_type === 'buy_limit') {
                           // buy limit 1.00 lot at 1.08671 and buy market price 1.08692 in pending
                          // buy_limit condition exchange_rate = 1.08671 then market_buy_askprice = 1.08655 is true
                        if (table.exchange_rate >= buy_askprice) {
                        const updateQuery = await pool.query(`UPDATE tbl_order SET order_status = 'open' WHERE order_status = 'pending' AND tbl_order_id = '${tbl_order_id}' AND type = 'buy' AND market_order_type = 'buy_limit'`);
            
                        if (updateQuery.rowCount > 0) {
                            const title = `Order executed`;
                            const message_type = `order_executed`;
                            const message = `Your ${table.type} Order #${table.order_id} for ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} is executed at ${table.exchange_rate}`;
            
                            notification_function.send_notification(tbl_user_id, title, message_type, message);
                        }
                        }
                    } else {
                        // buy stop 1.00 lot at 1.08721 and buy market price 1.08704 in pending
                        // buy_stop condition exchange_rate = 1.08721 then market_buy_askprice = 1.08725 is true
                        if (buy_askprice >= table.exchange_rate) {
                        const updateQuery = await pool.query(`UPDATE tbl_order SET order_status = 'open' WHERE order_status = 'pending' AND tbl_order_id = '${tbl_order_id}' AND type = 'buy' AND market_order_type = 'buy_stop'`);
            
                        if (updateQuery.rowCount > 0) {
                            const title = `Order executed`;
                            const message_type = `order_executed`;
                            const message = `Your ${table.type} Order #${table.order_id} for ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} is executed at ${table.exchange_rate}`;
            
                            notification_function.send_notification(tbl_user_id, title, message_type, message);
                        }
                        }
                    }
                }
            });
            return response.status(201).json({ status: true, count : count, message: 'Pending order list', });
        }else{
            return response.status(201).json({ status: true, count : 0, message: 'No pending order found', });
        }
    },

    auto_update_tp_sl_order_api : async(request, response) => {

        const ck_markt_open_query = await pool.query( `SELECT currency_pair FROM tbl_market_live_rate WHERE market_status = 'open'`);

        // console.log('auto_update_tp_sl_order_api');
        if(ck_markt_open_query.rowCount > 0){

            const select_Query = await pool.query( `SELECT tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, 
            tbl_market_live_rate.buy_askprice, tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order INNER JOIN tbl_market_live_rate ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.order_status = 'open' AND (tbl_order.take_profit_status = 'yes' OR tbl_order.stop_loss_status = 'yes')`
            );
            const count = select_Query.rowCount;

           
        
            if (count > 0) {
                const resdata = select_Query.rows;
            
                resdata.forEach(async (table) =>{
                    const tbl_user_id = table.tbl_user_id;
                    const login_id = table.login_id;
                    const tbl_order_id = table.tbl_order_id;
                    const sell_bidprice = table.sell_bidprice;
                    const buy_askprice = table.buy_askprice;
                    const exchange_rate = table.exchange_rate;
                    const take_profit_price = table.take_profit_price;
                    const stop_loss_price = table.stop_loss_price;
                    const take_profit_dollar = table.take_profit;
                    const stop_loss_dollar = table.stop_loss;

                    let profitloss;
                    if (table.type === 'sell') {
                       profitloss = table.exchange_rate - table.sell_bidprice;
                    } else {
                      profitloss = table.buy_askprice - table.exchange_rate;
                    }
                    const profitloss_value = (profitloss.toFixed(5)) * table.lotsize_in_lak;
                    const profitloss_type = profitloss_value >= 0 ? 'profit' : 'loss';

                    // console.log('profitloss_type', profitloss_type);
                    // console.log('profitloss_value', profitloss_value);
                   
                    // console.log('table.tradesize_lots', table.tradesize_lots);
                    const admin_commission = table.tradesize_lots * 16;
                     // closed by = user/stop_loss/take_profit
                    if (table.type === 'sell'){
                        // console.log('table.type', table.type);

                        if(table.take_profit_status == 'yes'  && profitloss_type ==  'profit'){   
                         
                            // sell limit 1.00 lot at 1.08792 and take profit = 10 dollar and take profit price = 1.08782 (take_profit_price)
                            // Take profit execute if the take profit price =  1.08782 is greater than or equal to sell_bidprice = 1.08775 or 1.08782 is true;

                            if(take_profit_price >= sell_bidprice){
                                console.log('take profit is done', take_profit_dollar);
                                var updt_blance = `balance = balance + ${take_profit_dollar} - ${admin_commission}`;
                                var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${take_profit_dollar} - ${admin_commission}`;
            
                                const updateQuery = await pool.query(`UPDATE tbl_order SET  closed_price = '${take_profit_price}', profit_type = '${profitloss_type}', profit_loss_value = '${take_profit_dollar}', closed_by = 'take_profit', admin_commission = '${admin_commission}', order_status = 'closed', closed_order_datetime = now() WHERE login_id = '${login_id}' AND tbl_order_id = '${tbl_order_id}';
                                UPDATE tbl_mt5_user SET ${updt_blance} WHERE login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}';
                                UPDATE tbl_user SET ${user_wlt_updt_blance} WHERE tbl_user_id = '${tbl_user_id}';
                                `);
                
                                if (updateQuery[0].rowCount > 0) {
                                    const title = `Order closed by limit`;
                                    const message_type = `take_profit`;
                                    const message = `Order #${table.order_id} ${table.type}  ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} has been closed at the Take Profit price  at ${take_profit_price}. Your profit is ${take_profit_dollar} USD`;
                                    notification_function.send_notification(tbl_user_id, title, message_type, message);
                                    console.log('sell take_profit message', message);
                                }
                            }
                        }


                        if(table.stop_loss_status == 'yes'  && profitloss_type ==  'loss'){
                            console.log('table.take_profit_status', table.take_profit_status);
                          
                            
                            // sell limit 1.00 lot at 1.08792 and stop profit = -20 dollar and stop loss price = 1.08812 (stop_loss_price)
                            // Stop loss execute if the sell_bidprice = 1.08818 or 1.08812 is greater than or equal to stop loss price =  1.08812 is true;

                            if(sell_bidprice >= stop_loss_price){

                                // console.log('sell_bidprice >= stop_loss_price');
                                // console.log('buy take profit is done', stop_loss_price);

                                var updt_blance = `balance = balance + ${stop_loss_dollar} - ${admin_commission}`;
                                var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${stop_loss_dollar} - ${admin_commission}`;
        
                                const updateQuery = await pool.query(`UPDATE tbl_order SET  closed_price = '${stop_loss_price}', profit_type = '${profitloss_type}', profit_loss_value = '${stop_loss_dollar}', closed_by = 'stop_loss', admin_commission = '${admin_commission}', order_status = 'closed', closed_order_datetime = now() WHERE login_id = '${login_id}' AND tbl_order_id = '${tbl_order_id}';
                                UPDATE tbl_mt5_user SET ${updt_blance} WHERE login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}';
                                UPDATE tbl_user SET ${user_wlt_updt_blance} WHERE tbl_user_id = '${tbl_user_id}';
                                `);
                
                                if (updateQuery[0].rowCount > 0) {
                                    const title = `Order closed by stop`;
                                    const message_type = `stop_loss`;
                                    const message = `Order #${table.order_id} ${table.type}  ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} has been closed at the Stop Loss price  at ${stop_loss_price}. Your profit is ${stop_loss_dollar} USD`;
                                    notification_function.send_notification(tbl_user_id, title, message_type, message);
                                    console.log('sell stop_loss message', message);
                                }                               

                            }
                        }

                    } else if(table.type === 'buy') {  //// table.type === 'buy'
                        // console.log('table.type === buy', table.type);
                        // console.log('buy_askprice', buy_askprice);
                        // console.log('take_profit_price', take_profit_price);

                        if(table.take_profit_status == 'yes'  && profitloss_type ==  'profit'){   
                         
                            // buy limit 1.00 lot at 1.08759 and take profit = 10 dollar and take profit price = 1.08769 (take_profit_price)
                            // Take profit execute if the buy_askprice = 1.08769 or 1.08785 is greater than or equal to take profit price = 1.08769  is true;

                            if(buy_askprice  >= take_profit_price){

                                // console.log('buy take profit is done', take_profit_dollar);
                                var updt_blance = `balance = balance + ${take_profit_dollar} - ${admin_commission}`;
                                var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${take_profit_dollar} - ${admin_commission}`;
            
                                const updateQuery = await pool.query(`UPDATE tbl_order SET  closed_price = '${take_profit_price}', profit_type = '${profitloss_type}', profit_loss_value = '${take_profit_dollar}', closed_by = 'take_profit', admin_commission = '${admin_commission}', order_status = 'closed', closed_order_datetime = now() WHERE login_id = '${login_id}' AND tbl_order_id = '${tbl_order_id}';
                                UPDATE tbl_mt5_user SET ${updt_blance} WHERE login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}';
                                UPDATE tbl_user SET ${user_wlt_updt_blance} WHERE tbl_user_id = '${tbl_user_id}';
                                `);
                
                                if (updateQuery[0].rowCount > 0) {
                                    const title = `Order closed by limit`;
                                    const message_type = `take_profit`;
                                    const message = `Order #${table.order_id} ${table.type}  ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} has been closed at the Take Profit price  at ${take_profit_price}. Your profit is ${take_profit_dollar} USD`;
                                    notification_function.send_notification(tbl_user_id, title, message_type, message);
                                    console.log('buy take_profit message', message);
                                }
                            }
                        }


                        if(table.stop_loss_status == 'yes'  && profitloss_type ==  'loss'){
                            // console.log('table.take_profit_status', table.take_profit_status);
                          
                            
                            // buy limit 1.00 lot at 1.08859 and stop profit = -20 dollar and stop loss price = 1.08839 (stop_loss_price)
                            // Stop loss execute if the stop loss price =  1.08839 is greater than or equal to buy_askprice = 1.08829 or 1.08839 is true;

                            if(stop_loss_price >= buy_askprice){

                                // console.log('stop_loss_price  >= buy_askprice');

                                var updt_blance = `balance = balance + ${stop_loss_dollar} - ${admin_commission}`;
                                var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${stop_loss_dollar} - ${admin_commission}`;
        
                                const updateQuery = await pool.query(`UPDATE tbl_order SET  closed_price = '${stop_loss_price}', profit_type = '${profitloss_type}', profit_loss_value = '${stop_loss_dollar}', closed_by = 'stop_loss', admin_commission = '${admin_commission}', order_status = 'closed', closed_order_datetime = now() WHERE login_id = '${login_id}' AND tbl_order_id = '${tbl_order_id}';
                                UPDATE tbl_mt5_user SET ${updt_blance} WHERE login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}';
                                UPDATE tbl_user SET ${user_wlt_updt_blance} WHERE tbl_user_id = '${tbl_user_id}';
                                `);
                
                                if (updateQuery[0].rowCount > 0) {
                                    const title = `Order closed by stop`;
                                    const message_type = `stop_loss`;
                                    const message = `Order #${table.order_id} ${table.type}  ${table.tradesize_lots.toFixed(2)} lot of ${table.currency_pair} has been closed at the Stop Loss price  at ${stop_loss_price}. Your profit is ${stop_loss_dollar} USD`;
                                    notification_function.send_notification(tbl_user_id, title, message_type, message);
                                    console.log('buy stop_loss message', message);
                                }                               
                            }
                        }
                    }else{
                        console.log('sell/buy type is not matched');
                    }
                });
                return response.status(201).json({ status: true, count : count, message: 'Take profit stop loss order list', });
            }else{
                return response.status(201).json({ status: false, count : 0, message: 'No Take profit stop loss order found', });
            }
        }else{
            return response.status(201).json({ status: false, message: 'Market is Closed', });
        }
    },

};