const pg = require('pg');
const moment = require('moment');

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);


module.exports = {

    notification_list: (req, res) => {
        try {

            const {tbl_user_id, pagesize, pagenumber } = req.body

            pool.query(`SELECT * FROM tbl_user_notification Where tbl_user_id = '${tbl_user_id}' order by tbl_user_notification_id DESC LIMIT ${pagesize} OFFSET (${pagenumber} - 1) * ${pagesize}`, (error, result) => {

                if (error) { return res.status(403).json({ status: false, message: error.message }); }

                if (result.rowCount > 0) {
                    let res_data = result.rows;
                    let dat = [];

                    res_data.forEach(async (table) => {

                        let noti = {
                            tbl_user_notification_id: table.tbl_user_notification_id,                        
                            tbl_user_id: isNull(table.tbl_user_id),
                            title: isNull(table.title),
                            notification_type: isNull(table.notification_type),
                            notification_msg: isNull(table.notification_msg),
                            created_date: table.created_date + ' '+ table.created_time,
                            status: table.status,
                        };
                        dat.push(noti);
                    });

                    // pool.query(`UPDATE tbl_notification_candidate SET status = '0' where tbl_candidate_id = '${tbl_candidate_id}'`);
                    // setTimeout(() => {
                    // }, 30);
                   return res.status(201).json({ status: true, message: 'Notification List', data: dat });

                } else {
                    return res.status(201).json({ status: false, message: 'No Notification Data.' });
                }

            });

        } catch (error) {
            console.log(error);
        }
    },


    Notification_count_for_candidate: (req, res) => {

        try {

            const { tbl_candidate_id } = req.body;

            pool.query(`SELECT * FROM tbl_notification_candidate where tbl_candidate_id = '${tbl_candidate_id}' AND status = 1`, (error, result) => {

                if (error) {
                    return res.status(403).json({ status: false, message: error });
                }
                if (result.rowCount > 0) {

                    res.status(201).json({ status: true, message: 'Notification count', data: result.rowCount })

                } else {
                    res.status(201).json({ status: false, message: 'No Notification Data.' });
                }
            });


        } catch (error) {
            console.log(error);
        }
    },





    Notification_Delete: (req, res) => {
        try {
            const { tbl_notification_id } = req.body;

            pool.query(`DELETE FROM tbl_notification_candidate where tbl_notification_id = '${tbl_notification_id}'`, (error, result) => {

                if (error) {
                    return res.status(403).json({ status: false, message: error });
                }

                if (result.rowCount > 0) {

                    res.status(201).json({ status: true, message: 'Notification Deleted' })
                } else {
                    res.status(201).json({ status: false, message: 'No Notification Data.' });
                }

            });

        } catch (error) {
            console.log(error);
        }
    },




    



};