const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const { log, table } = require('console');
const moment = require('moment');
const notification_function = require('./notification_function');
//notification_function.send_notification(tbl_user_id, title, message_type, message);

const upload = multer({ dest: '../views/files/upload/user_image/' });
function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);

const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}

const mailConfig = require('../../mail');
const { request } = require('https');
const { format } = require('path');
const transporter = nodeMailer.createTransport(mailConfig);


// var joining_time = moment().utcOffset("+05:30").format('LT');
// var joining_date = moment(date).format("DD MMM YYYY");

module.exports = {


    check_order_type_API: async (request, response) => {

        const {
            tbl_user_id, login_id, exchange_rate, currency_pair,
            take_profit_price, stop_loss_price,
            take_profit_status, stop_loss_status
        } = request.body;

        try {
            const exchangeRate = parseFloat(exchange_rate);
            const takeProfit = parseFloat(take_profit_price);
            const stopLoss = parseFloat(stop_loss_price);

            if (isNaN(exchangeRate)) {
                return response.status(400).json({
                    status: false,
                    message: 'Invalid exchange_rate.'
                });
            }

            let type = '';

            // Case 1: Both TP and SL active
            if (take_profit_status === 'yes' && stop_loss_status === 'yes') {
                if (takeProfit > exchangeRate && stopLoss < exchangeRate) {
                    type = 'buy';
                } else if (takeProfit < exchangeRate && stopLoss > exchangeRate) {
                    type = 'sell';
                }
            }
            // Case 2: Only TP active
            else if (take_profit_status === 'yes') {
                if (takeProfit > exchangeRate) {
                    type = 'buy';
                } else if (takeProfit < exchangeRate) {
                    type = 'sell';
                }
            }
            // Case 3: Only SL active
            else if (stop_loss_status === 'yes') {
                if (stopLoss < exchangeRate) {
                    type = 'buy';
                } else if (stopLoss > exchangeRate) {
                    type = 'sell';
                }
            }

            // If no valid type detected
            if (!type) {
                return response.status(200).json({
                    status: false,
                    message: 'Unable to detect order type from given values.'
                });
            }

            return response.status(200).json({
                status: true,
                message: `Detected order type: ${type.toUpperCase()}`,
                type: type,
                data: {
                    tbl_user_id,
                    login_id,
                    currency_pair,
                    exchange_rate: exchangeRate,
                    take_profit_price: takeProfit,
                    stop_loss_price: stopLoss,                    
                }
            });

        } catch (error) {
            console.error('Error detecting order type:', error);
            return response.status(500).json({
                status: false,
                message: 'Internal server error while detecting order type.'
            });
        }
    },

    calculate_sell_buy_market_order_preview_API: async (request, response) => {
        
        const {
            tbl_user_id, login_id, type, tradesize, exchange_rate, leverage_ratio,
            currency_pair, currency_type, take_profit, stop_loss,
            take_profit_status, stop_loss_status, sltp_currency_type
        } = request.body;

        const sltp_currency_typ = sltp_currency_type == 'price' ? sltp_currency_type : 'USD';
        
    
        console.log('calculate_sell_buy_market_order_preview_API', request.body);
    
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
    
        if (lots_size_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist` });
        }
    
        const res = lots_size_query.rows[0];
        const lots_unitsize = Number(res.one_lots_unitsize);
        const calculate_pip_value = Number(res.calculate_sell_buy_market_order_pip_val);
        const chk_limit_stoploss = Number(res.calculate_market_order_chk_limit_stoploss); // USD
        const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);
    
        const lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;
        const exchange_rate_num = Number(exchange_rate);
        const take_profit_num = Number(take_profit);
        const stop_loss_num = Number(stop_loss);
    
        let final_rate, pip_profit;
    
        if (type === 'sell' || type === 'buy') {
            const isSell = type === 'sell';
         
            
    
            if (take_profit_status === 'yes') {

                if (take_profit_num >= 0) {
                    if (sltp_currency_typ === 'price') {
                        final_rate = take_profit_num;
                        const usd_profit = isSell 
                            ? (exchange_rate_num - final_rate) * lots_in_lac
                            : (final_rate - exchange_rate_num) * lots_in_lac;

                            
                            
                        if (parseFloat(usd_profit.toFixed(2)) < 0) {
                            return response.status(201).json({ status: false, message: `Min ${exchange_rate_num}` });
                        }
    
                        pip_profit = (usd_profit) / (lots_in_lac / calculate_pip_value);
                        final_rate = usd_profit;
                    } else {
                        final_rate = isSell
                            ? exchange_rate_num - (take_profit_num / lots_in_lac)
                            : exchange_rate_num + (take_profit_num / lots_in_lac);
    
                        pip_profit = (take_profit_num * calculate_pip_value) / lots_in_lac;
                    }
                } else {
                    return response.status(201).json({ status: false, message: `Min +0.00` });
                }
            } else if (stop_loss_status === 'yes') {
                if (sltp_currency_typ === 'price') {
                    const stop_loss_price = stop_loss_num;
    
                    const usd_loss = isSell 
                        ? (stop_loss_price - exchange_rate_num) * lots_in_lac
                        : (exchange_rate_num - stop_loss_price) * lots_in_lac;    
                    
                    const chk_limit_stoploss_inprice  = Number(exchange_rate_num +(chk_limit_stoploss / lots_in_lac))
                    
                    if (Math.round(usd_loss) > chk_limit_stoploss) {
                        return response.status(201).json({ status: false, message: `Max ${chk_limit_stoploss_inprice}`});
                    }
    
                    final_rate = stop_loss_price;
                     pip_profit = (usd_loss) / (lots_in_lac / calculate_pip_value);
                    final_rate = usd_loss;
    
                } else if (sltp_currency_typ === 'USD') {
                    const abs_usd_loss = stop_loss_num;                   
                    
                    if (abs_usd_loss > chk_limit_stoploss) {

                        return response.status(201).json({
                            status: false,
                            message: `Max ${chk_limit_stoploss.toFixed(2)}`
                        });
                    }
    
                    final_rate = isSell
                        ? exchange_rate_num + (abs_usd_loss / lots_in_lac)
                        : exchange_rate_num - (abs_usd_loss / lots_in_lac);
    
                    pip_profit = (abs_usd_loss * calculate_pip_value) / lots_in_lac;
                } else {
                    return response.status(201).json({ status: false, message: 'Invalid sltp_currency_typ' });
                }
            } else {
                return response.status(201).json({ status: false, message: 'Something went wrong' });
            }
    
            return response.status(201).json({
                status: true,
                message: `Calculation ${type.charAt(0).toUpperCase() + type.slice(1)} market order preview API`,
                final_rate: final_rate.toFixed(5),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type: currency_type,
                sltp_currency_type: sltp_currency_type,
            });
        } else {
            return response.status(201).json({ status: false, message: 'Type went wrong' });
        }
    },

    //////////////////////  New api code start from here on 26-05-2025 //////////////////////

    calculate_sell_buy_without_type_market_order_preview_API: async (request, response) => {
    const {
            tbl_user_id, login_id, tradesize, exchange_rate, leverage_ratio,
            currency_pair, currency_type, take_profit, stop_loss,
            take_profit_status, stop_loss_status, sltp_currency_type
        } = request.body;

    const exchangeRate = parseFloat(exchange_rate);
    const takeProfit = parseFloat(take_profit);
    const stopLoss = parseFloat(stop_loss);

    // Step 1: Detect type (buy/sell)
    let type = '';
    if (take_profit_status === 'yes' && stop_loss_status === 'yes') {
        if (takeProfit > exchangeRate && stopLoss < exchangeRate) {
            type = 'buy';
        } else if (takeProfit < exchangeRate && stopLoss > exchangeRate) {
            type = 'sell';
        }
    } else if (take_profit_status === 'yes') {
        if (takeProfit > exchangeRate) {
            type = 'buy';
        } else if (takeProfit < exchangeRate) {
            type = 'sell';
        }
    } else if (stop_loss_status === 'yes') {
        if (stopLoss < exchangeRate) {
            type = 'buy';
        } else if (stopLoss > exchangeRate) {
            type = 'sell';
        }
    }

    if (!type) {
        return response.status(200).json({
            status: false,
            message: 'Unable to detect order type from given values.'
        });
    }

    const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';

    try {
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);

        if (lots_size_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair does not exist` });
        }

        const res = lots_size_query.rows[0];
        const lots_unitsize = Number(res.one_lots_unitsize);
        const calculate_pip_value = Number(res.calculate_sell_buy_market_order_pip_val);
        const chk_limit_stoploss = Number(res.calculate_market_order_chk_limit_stoploss); // USD
        const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);

        const lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;
        const exchange_rate_num = Number(exchange_rate);
        const take_profit_num = Number(take_profit);
        const stop_loss_num = Number(stop_loss);

        let final_rate, pip_profit;
        const isSell = type === 'sell';

        if (take_profit_status === 'yes') {
            if (take_profit_num >= 0) {
                if (sltp_currency_typ === 'price') {
                    final_rate = take_profit_num;
                    const usd_profit = isSell
                        ? (exchange_rate_num - final_rate) * lots_in_lac
                        : (final_rate - exchange_rate_num) * lots_in_lac;

                    if (parseFloat(usd_profit.toFixed(2)) < 0) {
                        return response.status(201).json({ status: false, message: `Min ${exchange_rate_num}` });
                    }

                    pip_profit = usd_profit / (lots_in_lac / calculate_pip_value);
                    final_rate = usd_profit;
                } else {
                    final_rate = isSell
                        ? exchange_rate_num - (take_profit_num / lots_in_lac)
                        : exchange_rate_num + (take_profit_num / lots_in_lac);

                    pip_profit = (take_profit_num * calculate_pip_value) / lots_in_lac;
                }
            } else {
                return response.status(201).json({ status: false, message: `Min +0.00` });
            }
        } else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                const stop_loss_price = stop_loss_num;

                const usd_loss = isSell
                    ? (stop_loss_price - exchange_rate_num) * lots_in_lac
                    : (exchange_rate_num - stop_loss_price) * lots_in_lac;

                const chk_limit_stoploss_inprice = Number(exchange_rate_num + (chk_limit_stoploss / lots_in_lac));

                if (Math.round(usd_loss) > chk_limit_stoploss) {
                    return response.status(201).json({ status: false, message: `Max ${chk_limit_stoploss_inprice}` });
                }

                final_rate = stop_loss_price;
                pip_profit = usd_loss / (lots_in_lac / calculate_pip_value);
                final_rate = usd_loss;
            } else if (sltp_currency_typ === 'USD') {
                const abs_usd_loss = stop_loss_num;

                if (abs_usd_loss > chk_limit_stoploss) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${chk_limit_stoploss.toFixed(2)}`
                    });
                }

                final_rate = isSell
                    ? exchange_rate_num + (abs_usd_loss / lots_in_lac)
                    : exchange_rate_num - (abs_usd_loss / lots_in_lac);

                pip_profit = (abs_usd_loss * calculate_pip_value) / lots_in_lac;
            } else {
                return response.status(201).json({ status: false, message: 'Invalid sltp_currency_typ' });
            }
        } else {
            return response.status(201).json({ status: false, message: 'Something went wrong' });
        }

        return response.status(201).json({
            status: true,
            message: `Calculation ${type.toUpperCase()} market order preview API`,
            final_rate: final_rate.toFixed(5),
            pip_profit: pip_profit.toFixed(1) + ' pips',
            currency_type: currency_type,
            sltp_currency_type: sltp_currency_type,
            type: type
        });

    } catch (error) {
        console.error('Error in calculate_sell_buy_market_order_preview_without_type_API:', error);
        return response.status(500).json({
            status: false,
            message: 'Internal server error.'
        });
    }
    },


    //////////////////////  New api code end here 26-05-2025  //////////////////////

    // bidding code start from here 
    claculate_order_preview_API: async (request, response) => {

        const { tbl_user_id, login_id, category, tradesize, exchange_rate, leverage_ratio, currency_pair, currency_type } = request.body;

        const baseCurrency = currency_pair.substring(0, 3); // Extracts the first three characters
        const lastCurrency = currency_pair.substring(3, 6); // Extracts the first three characters

        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size where currency_pair = '${currency_pair}'`);

        if (lots_size_query.rowCount > 0) { 
            const res = lots_size_query.rows[0];

            const ck_cruncy_pair = res.currency_pair;
            const lots_unitsize = res.one_lots_unitsize;
            const calculate_pip = res.pip_profit_calculate;
            const quote_currency_amount_in_usd = res.quote_currency_amount_in_usd;

            if (currency_pair == ck_cruncy_pair) {
                // for gold 
                var lots_in_lac = tradesize * lots_unitsize * Number(quote_currency_amount_in_usd);
                var exng_ratewith_lot = lots_in_lac * exchange_rate;
                var margin = (lots_in_lac / leverage_ratio) * exchange_rate;
                var pip_profit = (calculate_pip * tradesize);
            } else {
                var lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;                
                var exng_ratewith_lot = lots_in_lac * exchange_rate;
                var margin = (lots_in_lac / leverage_ratio) * exchange_rate;
                var pip_profit = (10 * tradesize);
            }

            return response.status(201).json({ status: true, message: 'Calculation tbl result', exchange_rate_with_lot: exng_ratewith_lot.toFixed(2) + ' ' + currency_type, tradeSize: lots_in_lac.toFixed(2) + ' ' + baseCurrency, margin: margin.toFixed(2), pip_profit: pip_profit.toFixed(2) + ' ' + currency_type, currency_type: currency_type });

        } else {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist` });
        }
    },
    

    calculate_sell_limit_stop_order_preview_API: async (request, response) => {
        const {
            tbl_user_id, login_id, type, limit_stop_type, tradesize, exchange_rate, order_rate,
            leverage_ratio, currency_pair, currency_type, take_profit, stop_loss,
            take_profit_status, stop_loss_status, sltp_currency_type
        } = request.body;
    
        const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';
        console.log('calculate_sell_limit_stop_order_preview_API', request.body);
    
        const baseCurrency = currency_pair.substring(0, 3);
        const exchange_rate_in_muber = Number(exchange_rate);
        const order_rate_in_muber = Number(order_rate);
    
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
        if (lots_size_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair does not exist` });
        }
    
        const res = lots_size_query.rows[0];
        const lots_unitsize = Number(res.one_lots_unitsize);
        const calculate_pip = Number(res.calculate_sell_buy_market_order_pip_val);
        const sell_limit_stop_order_ck_limit_price = Number(res.sell_limit_stop_order_ck_limit_price);
        const sell_limit_stop_order_check_takepro_min = Number(res.sell_limit_stop_order_check_takepro_min);
        const sell_limit_stop_order_check_stoploss_max = Number(res.sell_limit_stop_order_check_stoploss_max);
        const sell_limit_stop_order_ck_stop_price = Number(res.sell_limit_stop_order_ck_stop_price);
        const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);
    
        let lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;
    
        let ck_limit_price = (exchange_rate_in_muber + sell_limit_stop_order_ck_limit_price);
        let check_takepro_min = tradesize * sell_limit_stop_order_check_takepro_min;
        let check_stoploss_max = tradesize * sell_limit_stop_order_check_stoploss_max;
        let ck_stop_price = (exchange_rate_in_muber - sell_limit_stop_order_ck_stop_price);
    
        if (limit_stop_type === 'sell_limit') {
            if (take_profit_status === 'yes') {
                if (sltp_currency_typ === 'price') {
                    const min_tp_price = order_rate_in_muber - (check_takepro_min / lots_in_lac);                    
                    
                    if (Number(take_profit) > min_tp_price || Number(take_profit) == 0) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min +${min_tp_price.toFixed(5)}`
                        });
                    }
    
                    const tp_price = Number(take_profit);
                    const usd_profit = (order_rate_in_muber - tp_price) * lots_in_lac;   
                    
                    if (usd_profit < 0) {
                        return response.status(201).json({ 
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min ${order_rate_in_muber}` 
                        });
                    }
    
                    const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'take_profit',
                        message: 'Calculation Sell limit order preview API',
                        final_rate: usd_profit.toFixed(2),
                        pip_profit: pip_profit.toFixed(1) + ' pips',
                        currency_type,
                        sltp_currency_type
                    });
                } else {
                    if (Number(take_profit) < check_takepro_min) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min +${check_takepro_min.toFixed(2)}`
                        });
                    }
    
                    const final_rate = order_rate_in_muber - (Number(take_profit) / lots_in_lac);
                    const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'take_profit',
                        message: 'Calculation Sell limit order preview API',
                        final_rate: final_rate.toFixed(5),
                        pip_profit: pip_profit.toFixed(1) + ' pips',
                        currency_type
                    });
                }
            } else if (stop_loss_status === 'yes') {
                if (sltp_currency_typ === 'price') {
                    const max_sl_price = order_rate_in_muber - (check_stoploss_max / lots_in_lac);

                    if (Number(stop_loss) < max_sl_price) {
                        return response.status(201).json({ status: false, 
                            check_profit_loss: 'stop_loss',
                            message: `Max ${max_sl_price.toFixed(5)}`
                        });
                    }
    
                    const sl_price = Number(stop_loss);
                    const usd_loss = (order_rate_in_muber - sl_price) * lots_in_lac;
    
                    const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'stop_loss',
                        message: 'Calculation Sell limit order preview API',
                        final_rate: usd_loss.toFixed(2),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type,
                        sltp_currency_type
                    });
                } else {
                    if (Number(stop_loss) > check_stoploss_max) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'stop_loss',
                            message: `Max ${check_stoploss_max.toFixed(2)}`
                        });
                    }
    
                    const final_rate = order_rate_in_muber - (Number(stop_loss) / lots_in_lac);
                    const pip_loss = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'stop_loss',
                        message: 'Calculation Sell limit order preview API',
                        final_rate: final_rate.toFixed(5),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type
                    });
                }
            } else if (order_rate_in_muber >= ck_limit_price) {
                return response.status(201).json({ status: true, order_rate: 'yes', message: `Min ${ck_limit_price}` });
            } else {
                return response.status(201).json({ status: false, order_rate: 'yes', message: `Min ${ck_limit_price}` });
            }
        } else if (limit_stop_type === 'sell_stop') {
            if (take_profit_status === 'yes') {
                if (sltp_currency_typ === 'price') {
                    const min_tp_price = order_rate_in_muber - (check_takepro_min / lots_in_lac);

                   
                    
                    if (Number(take_profit) > Number(min_tp_price) || Number(take_profit) == 0) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min +${min_tp_price.toFixed(5)}`
                        });
                    }
    
                    const tp_price = Number(take_profit);
                    const usd_profit = (order_rate_in_muber - tp_price) * lots_in_lac;
    
                    if (usd_profit < 0) {
                   
                        return response.status(201).json({ 
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min usd ${order_rate_in_muber}` 
                        });
                    }
    
                    const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
                    
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'take_profit',
                        message: 'Calculation Sell stop order preview API',
                        final_rate: usd_profit.toFixed(2),
                        pip_profit: pip_profit.toFixed(1) + ' pips',
                        currency_type,
                        sltp_currency_type
                    });
                } else {
                    if (Number(take_profit) < check_takepro_min) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'take_profit',
                            message: `Min +${check_takepro_min.toFixed(2)}`
                        });
                    }
    
                    const final_rate = order_rate_in_muber - (Number(take_profit) / lots_in_lac);
                    const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'take_profit',
                        message: 'Calculation Sell stop order preview API',
                        final_rate: final_rate.toFixed(5),
                        pip_profit: pip_profit.toFixed(1) + ' pips',
                        currency_type
                    });
                }
            } else if (stop_loss_status === 'yes') {
                if (sltp_currency_typ === 'price') {
                    const max_sl_price = order_rate_in_muber - (check_stoploss_max / lots_in_lac);

                    if (Number(stop_loss) < max_sl_price) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'stop_loss',
                            message: `Max ${max_sl_price.toFixed(5)}`
                        });
                    }
    
                    const sl_price = Number(stop_loss);
                    const usd_loss = (order_rate_in_muber - sl_price) * lots_in_lac;
    
                    const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'stop_loss',
                        message: 'Calculation Sell stop order preview API',
                        final_rate: usd_loss.toFixed(2),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type,
                        sltp_currency_type
                    });
                } else {
                    if (Number(stop_loss) > check_stoploss_max) {
                        return response.status(201).json({
                            status: false,
                            check_profit_loss: 'stop_loss',
                            message: `Max ${check_stoploss_max.toFixed(2)}`
                        });
                    }
    
                    const final_rate = order_rate_in_muber - (Number(stop_loss) / lots_in_lac);
                    const pip_loss = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: 'stop_loss',
                        message: 'Calculation Sell stop order preview API',
                        final_rate: final_rate.toFixed(5),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type,
                        sltp_currency_type
                    });
                }
            } else if (ck_stop_price >= order_rate_in_muber) {
                return response.status(201).json({ status: true, order_rate: 'yes', message: `Max ${ck_stop_price}` });
            } else {
                return response.status(201).json({ status: false, order_rate: 'yes', message: `Max ${ck_stop_price}` });
            }
        } else {
            return response.status(201).json({ status: false, message: 'limit_stop_type is invalid!' });
        }
    },

    calculate_bck0505_sell_limit_stop_order_preview_API: async(request, response) => {

        const { tbl_user_id, login_id, type, limit_stop_type, tradesize, exchange_rate, order_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = request.body;

        
        const baseCurrency = currency_pair.substring(0, 3); // Extracts the first three characters
        // const lastCurrency = currency_pair.substring(3, 6); // Extracts the first three characters
        const exchange_rate_in_muber = Number(exchange_rate);
        const order_rate_in_muber = Number(order_rate);

        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size where currency_pair = '${currency_pair}'`);

        if (lots_size_query.rowCount > 0) {
            const res = lots_size_query.rows[0];

                const ck_cruncy_pair = res.currency_pair;
                const lots_unitsize = res.one_lots_unitsize;
                const calculate_market_order_pip_val_pip = res.calculate_sell_buy_market_order_pip_val;
                const sell_limit_stop_order_ck_limit_price = res.sell_limit_stop_order_ck_limit_price;
                const sell_limit_stop_order_check_takepro_min = res.sell_limit_stop_order_check_takepro_min;
                const sell_limit_stop_order_check_stoploss_max = res.sell_limit_stop_order_check_stoploss_max;
                const sell_limit_stop_order_ck_stop_price = res.sell_limit_stop_order_ck_stop_price;
                const quote_currency_amount_in_usd = res.quote_currency_amount_in_usd;

                if (currency_pair == ck_cruncy_pair) {  // for gold
                    
                    
                    var lots_in_lac = tradesize * Number(lots_unitsize) * Number(quote_currency_amount_in_usd);
                    var calculate_pip = Number(calculate_market_order_pip_val_pip);  /// calculate pip value for each trade in pi 100

                    var ck_limit_price = (exchange_rate_in_muber + Number(sell_limit_stop_order_ck_limit_price)).toFixed(5);  // sell limit rate is have to more than 400 from the exchange rate
                    // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 2359.004 then order_rate have to 2359.404;
                    var check_takepro_min = tradesize * Number(sell_limit_stop_order_check_takepro_min);
                    var check_stoploss_max = tradesize * (Number(sell_limit_stop_order_check_stoploss_max));
                    // code limit_stop_type == 'sell_stop'
                    var ck_stop_price = (exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price)).toFixed(3);

                } else {
                  
                    var lots_in_lac = tradesize * Number(lots_unitsize) * Number(quote_currency_amount_in_usd); 
                    // for sell limit
                    var calculate_pip = Number(calculate_market_order_pip_val_pip);  /// calculate pip value for each trade in pi 10000
                    var ck_limit_price = exchange_rate_in_muber + Number(sell_limit_stop_order_ck_limit_price);  // sell limit rate is have to more than 20 from the exchange rate
                    // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 1.07555 then order_rate have to 1.07576;
                    var check_takepro_min = tradesize * Number(sell_limit_stop_order_check_takepro_min);
                    var check_stoploss_max = tradesize * (Number(sell_limit_stop_order_check_stoploss_max));
                    // code limit_stop_type == 'sell_stop'
                    var ck_stop_price = (exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price));
                }

                // if (currency_pair == "XAUUSD") {  // for gold
                //     var lots_in_lac = tradesize * 100;
                //     var ck_limit_price = (exchange_rate_in_muber + 0.400).toFixed(3);  // sell limit rate is have to more than 400 from the exchange rate
                //     // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 2359.004 then order_rate have to 2359.404;
                //     var calculate_pip = 100;  /// calculate pip value for each trade in pi
                //     var check_takepro_min = tradesize * 20;
                //     var check_stoploss_max = tradesize * (-20);
                //     // code limit_stop_type == 'sell_stop'
                //     var ck_stop_price = (exchange_rate_in_muber - 0.200).toFixed(3);

                // } else {
                //     var lots_in_lac = tradesize * 100000; 
                //     // for sell limit
                //     var ck_limit_price = exchange_rate_in_muber + 0.00020;  // sell limit rate is have to more than 20 from the exchange rate
                //     // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 1.07555 then order_rate have to 1.07576;
                //     var calculate_pip = 10000;  /// calculate pip value for each trade in pi 10000
                //     var check_takepro_min = tradesize * 10;
                //     var check_stoploss_max = tradesize * (-10);
                //     // code limit_stop_type == 'sell_stop'
                //     var ck_stop_price = (exchange_rate_in_muber - 0.00010);
                // }

                const take_profite_val = (take_profit / lots_in_lac);
                const stop_loss_val = (stop_loss / lots_in_lac);

            if (limit_stop_type == 'sell_limit') {
                // const ck_limit_price = exchange_rate_in_muber + 0.00020;
                if (take_profit_status == 'yes') {
                    //const check_takepro_min = tradesize * 10;
                    /// this condition is used to set min take profit value is 10 as a amount of order_rate
                    if (take_profit >= check_takepro_min) {
                        var final_rate = order_rate_in_muber - take_profite_val;
                        var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "take_profit";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation Sell limit order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: 'take_profit', message: `Min +${check_takepro_min.toFixed(2)}` });
                    }
                } else if (stop_loss_status == 'yes') {
                    // const check_stoploss_max = tradesize * (-10);
                    if (check_stoploss_max >= stop_loss) {
                        var final_rate = order_rate_in_muber - stop_loss_val;
                        var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "stop_loss";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation Sell limit order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: 'stop_loss', message: `Max ${check_stoploss_max.toFixed(2)}` });
                    }
                } else if (order_rate_in_muber >= ck_limit_price) {
                    return response.status(201).json({ status: true, order_rate: "yes", message: `Min ${ck_limit_price}` });
                } else {
                    return response.status(201).json({ status: false, order_rate: "yes", message: `Min ${ck_limit_price}` });
                }

            } else if (limit_stop_type == 'sell_stop') {

                // const ck_stop_price = exchange_rate_in_muber - 0.00010;  // sell stop rate is more than 20 from the exchange rate
                if (take_profit_status == 'yes') {
                    //const check_takepro_min = tradesize * 10;   
                    /// this condition is used to set min take profit value is 10 as a amount of order_rate
                    if (take_profit >= check_takepro_min) {
                        var final_rate = order_rate_in_muber - take_profite_val;
                        var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "take_profit";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation Sell stop order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: "take_profit", message: `Min +${check_takepro_min.toFixed(2)}` });
                    }
                } else if (stop_loss_status == 'yes') {
                    // const check_stoploss_max = tradesize * (-10);
                    if (check_stoploss_max >= stop_loss) {
                        var final_rate = order_rate_in_muber - stop_loss_val;
                        var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "stop_loss";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation Sell stop order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: "stop_loss", message: `Max ${check_stoploss_max.toFixed(2)}` });
                    }
                } else if (ck_stop_price >= order_rate_in_muber) {
                    // here final rate is set by the use of order_rate  in loss and profit calculation if exchange_rate_in_muber is 1.07555 then order_rate  is 1.07576;
                    return response.status(201).json({ status: true, order_rate: "yes", message: `Max ${ck_stop_price}` });
                } else {
                    return response.status(201).json({ status: false, order_rate: "yes", message: `Max ${ck_stop_price}` });
                }
            } else {
                return response.status(201).json({ status: false, message: 'limit_stop_type is wrong!' });
            }
        } else {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist` });
        }

    },

    calculate_test_buy_limit_stop_order_preview_API: async (request, response) => {

        const {
          tbl_user_id, login_id, type, limit_stop_type, tradesize,
          exchange_rate, order_rate, leverage_ratio,
          currency_pair, currency_type,
          take_profit, stop_loss,
          take_profit_status, stop_loss_status,
          sltp_currency_type
        } = request.body;
      
        const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';
      
        const exchange_rate_in_muber = Number(exchange_rate);
        const order_rate_in_muber = Number(order_rate);
      
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
        if (lots_size_query.rowCount === 0) {
          return response.status(201).json({ status: false, message: 'Currency pair does not exist.' });
        }
      
        const res = lots_size_query.rows[0];
        const {
          one_lots_unitsize: lots_unitsize,
          calculate_sell_buy_market_order_pip_val: calculate_market_order_pip_val_pip,
          sell_limit_stop_order_ck_limit_price,
          sell_limit_stop_order_check_takepro_min,
          sell_limit_stop_order_check_stoploss_max,
          sell_limit_stop_order_ck_stop_price,
          quote_currency_amount_in_usd
        } = res;
      
        const lots_in_lac = tradesize * lots_unitsize * Number(quote_currency_amount_in_usd);
        const calculate_pip = Number(calculate_market_order_pip_val_pip);
        const ck_limit_price = exchange_rate_in_muber - Number(sell_limit_stop_order_ck_limit_price);
        const check_takepro_min = tradesize * Number(sell_limit_stop_order_check_takepro_min);
        const check_stoploss_max = tradesize * Number(sell_limit_stop_order_check_stoploss_max);
        const ck_stop_price = exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price);
      
        const take_profit_val = Number(take_profit) / lots_in_lac;
        const stop_loss_val = Number(stop_loss) / lots_in_lac;
      
        const calculateUsdProfit = (tp_price, order_rate) => (tp_price - order_rate) * lots_in_lac;
        const calculateUsdLoss = (sl_price, order_rate) => (sl_price - order_rate) * lots_in_lac;
      
        if (limit_stop_type === 'buy_limit') {
          const min_tp_price = order_rate_in_muber + (check_takepro_min / lots_in_lac);
      
          if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
              const tp_price = Number(take_profit);
      
              if (tp_price < min_tp_price || tp_price === 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${min_tp_price.toFixed(5)}`
                });
              }
      
              const usd_profit = calculateUsdProfit(tp_price, order_rate_in_muber);
              if (usd_profit <= 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Take profit must be greater than order rate (${order_rate_in_muber})`
                });
              }
      
              const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy limit order preview API',
                final_rate: usd_profit.toFixed(2),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type,
                sltp_currency_type
              });
            } else {
              if (Number(take_profit) < check_takepro_min) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${check_takepro_min.toFixed(2)}`
                });
              }
      
              const final_rate = order_rate_in_muber + take_profit_val;
              const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy limit order preview API',
                final_rate: final_rate.toFixed(5),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type
              });
            }
          } else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {

                const min_sl_price = order_rate_in_muber + (check_stoploss_max / lots_in_lac);
                const sl_price = Number(stop_loss);

                if (sl_price == 0) {
                    return response.status(201).json({ status: false, check_profit_loss: "stop_loss", 
                        message: `Max ${min_sl_price.toFixed(5)}`
                    });
                }
      
                if (min_sl_price >= sl_price) {
                    const usd_loss = calculateUsdLoss(sl_price, order_rate_in_muber);       
                    
        
                    const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: "stop_loss",
                        message: 'Calculation buy limit order preview API',
                        final_rate: usd_loss.toFixed(2),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type
                    });
                } else {
                    return response.status(201).json({
                        status: false,
                        check_profit_loss: "stop_loss",
                        message: `Max ${min_sl_price.toFixed(5)}`
                    });
                }
            } else {
              if (check_stoploss_max >= Number(stop_loss)) {
                const final_rate = order_rate_in_muber - stop_loss_val;
                const pip_profit = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                return response.status(201).json({
                  status: true,
                  check_profit_loss: "stop_loss",
                  message: 'Calculation buy limit order preview API',
                  final_rate: final_rate.toFixed(5),
                  pip_profit: pip_profit.toFixed(1) + ' pips',
                  currency_type
                });
              } else {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "stop_loss",
                  message: `Max ${check_stoploss_max.toFixed(2)}`
                });
              }
            }
          } else if (Number(order_rate_in_muber) > ck_limit_price) {
                return response.status(201).json({
                status: false,
                order_rate: "yes",
                message: `Max ${ck_limit_price.toFixed(5)}`
                });
          } else {
            return response.status(201).json({
              status: true,
              order_rate: "yes",
              message: `Max ${ck_limit_price.toFixed(5)}`
            });
          }
        } else if (limit_stop_type === 'buy_stop') {
          if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
              const tp_price = Number(take_profit);
              const min_tp_price = order_rate_in_muber + (check_takepro_min / lots_in_lac);
      
              if (tp_price < min_tp_price || tp_price === 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${min_tp_price.toFixed(5)}`
                });
              }
      
              const usd_profit = calculateUsdProfit(tp_price, order_rate_in_muber);
              const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy stop order preview API',
                final_rate: usd_profit.toFixed(2),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type,
                sltp_currency_type
              });
            } else {
              if (Number(take_profit) < check_takepro_min) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${check_takepro_min.toFixed(2)}`
                });
              }
      
              const final_rate = order_rate_in_muber + take_profit_val;
              const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy stop order preview API',
                final_rate: final_rate.toFixed(5),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type
              });
            }
          } else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                const sl_price = Number(stop_loss);
                // const max_sl_price = check_stoploss_max; // Max allowed stop loss price
                const max_sl_price = order_rate_in_muber + (check_stoploss_max / lots_in_lac);
            
                if (sl_price === 0 || sl_price > max_sl_price) {
                    return response.status(201).json({
                        status: false,
                        check_profit_loss: "stop_loss",
                        message: `Max ${max_sl_price.toFixed(2)}`
                    });
                }
            
                const usd_loss = calculateUsdLoss(sl_price, order_rate_in_muber);
               
                
                const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
            
                return response.status(201).json({
                    status: true,
                    check_profit_loss: "stop_loss",
                    message: 'Calculation buy stop order preview API',
                    final_rate: usd_loss.toFixed(2),
                    pip_profit: pip_loss.toFixed(1) + ' pips',
                    currency_type
                });

            } else {
              if (check_stoploss_max >= Number(stop_loss)) {
                const final_rate = order_rate_in_muber - stop_loss_val;
                const pip_profit = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                return response.status(201).json({
                  status: true,
                  check_profit_loss: "stop_loss",
                  message: 'Calculation buy stop order preview API',
                  final_rate: final_rate.toFixed(5),
                  pip_profit: pip_profit.toFixed(1) + ' pips',
                  currency_type
                });
              } else {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "stop_loss",
                  message: `Max ${check_stoploss_max.toFixed(2)}`
                });
              }
            }
          } else if (order_rate_in_muber < ck_stop_price) {
            return response.status(201).json({
              status: false,
              order_rate: "yes",
              message: `Min ${ck_stop_price.toFixed(5)}`
            });
          } else {
            return response.status(201).json({
              status: true,
              order_rate: "yes",
              message: `Min ${ck_stop_price.toFixed(5)}`
            });
          }
        } else {
          return response.status(201).json({ status: false, message: 'limit_stop_type is invalid!' });
        }
    },

    calculate_buy_limit_stop_order_preview_API: async (request, response) => {

        const {
          tbl_user_id, login_id, type, limit_stop_type, tradesize,
          exchange_rate, order_rate, leverage_ratio,
          currency_pair, currency_type,
          take_profit, stop_loss,
          take_profit_status, stop_loss_status,
          sltp_currency_type
        } = request.body;
      
        const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';
      
        const exchange_rate_in_muber = Number(exchange_rate);
        const order_rate_in_muber = Number(order_rate);
      
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
        if (lots_size_query.rowCount === 0) {
          return response.status(201).json({ status: false, message: 'Currency pair does not exist.' });
        }
      
        const res = lots_size_query.rows[0];
        const {
          one_lots_unitsize: lots_unitsize,
          calculate_sell_buy_market_order_pip_val: calculate_market_order_pip_val_pip,
          sell_limit_stop_order_ck_limit_price,
          sell_limit_stop_order_check_takepro_min,
          sell_limit_stop_order_check_stoploss_max,
          sell_limit_stop_order_ck_stop_price,
          quote_currency_amount_in_usd
        } = res;
      
        const lots_in_lac = tradesize * lots_unitsize * Number(quote_currency_amount_in_usd);
        const calculate_pip = Number(calculate_market_order_pip_val_pip);
        const ck_limit_price = exchange_rate_in_muber - Number(sell_limit_stop_order_ck_limit_price);
        const check_takepro_min = tradesize * Number(sell_limit_stop_order_check_takepro_min);
        const check_stoploss_max = tradesize * Number(sell_limit_stop_order_check_stoploss_max);
        const ck_stop_price = exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price);
      
        const take_profit_val = Number(take_profit) / lots_in_lac;
        const stop_loss_val = Number(stop_loss) / lots_in_lac;
      
        const calculateUsdProfit = (tp_price, order_rate) => (tp_price - order_rate) * lots_in_lac;
        const calculateUsdLoss = (sl_price, order_rate) => (sl_price - order_rate) * lots_in_lac;
      
        if (limit_stop_type === 'buy_limit') {
          const min_tp_price = order_rate_in_muber + (check_takepro_min / lots_in_lac);
      
          if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
              const tp_price = Number(take_profit);
      
              if (tp_price < min_tp_price || tp_price === 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${min_tp_price.toFixed(5)}`
                });
              }
      
              const usd_profit = calculateUsdProfit(tp_price, order_rate_in_muber);
              if (usd_profit <= 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Take profit must be greater than order rate (${order_rate_in_muber})`
                });
              }
      
              const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy limit order preview API',
                final_rate: usd_profit.toFixed(2),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type,
                sltp_currency_type
              });
            } else {
              if (Number(take_profit) < check_takepro_min) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${check_takepro_min.toFixed(2)}`
                });
              }
      
              const final_rate = order_rate_in_muber + take_profit_val;
              const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy limit order preview API',
                final_rate: final_rate.toFixed(5),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type
              });
            }
          } else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {

                const min_sl_price = order_rate_in_muber + (check_stoploss_max / lots_in_lac);
                const sl_price = Number(stop_loss);

                if (sl_price == 0) {
                    return response.status(201).json({ status: false, check_profit_loss: "stop_loss", 
                        message: `Max ${min_sl_price.toFixed(5)}`
                    });
                }
      
                if (min_sl_price >= sl_price) {
                    const usd_loss = calculateUsdLoss(sl_price, order_rate_in_muber);       
                    
        
                    const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
                    return response.status(201).json({
                        status: true,
                        check_profit_loss: "stop_loss",
                        message: 'Calculation buy limit order preview API',
                        final_rate: usd_loss.toFixed(2),
                        pip_profit: pip_loss.toFixed(1) + ' pips',
                        currency_type
                    });
                } else {
                    return response.status(201).json({
                        status: false,
                        check_profit_loss: "stop_loss",
                        message: `Max ${min_sl_price.toFixed(5)}`
                    });
                }
            } else {
              if (check_stoploss_max >= Number(stop_loss)) {
                const final_rate = order_rate_in_muber - stop_loss_val;
                const pip_profit = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                return response.status(201).json({
                  status: true,
                  check_profit_loss: "stop_loss",
                  message: 'Calculation buy limit order preview API',
                  final_rate: final_rate.toFixed(5),
                  pip_profit: pip_profit.toFixed(1) + ' pips',
                  currency_type
                });
              } else {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "stop_loss",
                  message: `Max ${check_stoploss_max.toFixed(2)}`
                });
              }
            }
          } else if (Number(order_rate_in_muber) > ck_limit_price) {
                return response.status(201).json({
                status: false,
                order_rate: "yes",
                message: `Max ${ck_limit_price.toFixed(5)}`
                });
          } else {
            return response.status(201).json({
              status: true,
              order_rate: "yes",
              message: `Max ${ck_limit_price.toFixed(5)}`
            });
          }
        } else if (limit_stop_type === 'buy_stop') {
          if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
              const tp_price = Number(take_profit);
              const min_tp_price = order_rate_in_muber + (check_takepro_min / lots_in_lac);
      
              if (tp_price < min_tp_price || tp_price === 0) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${min_tp_price.toFixed(5)}`
                });
              }
      
              const usd_profit = calculateUsdProfit(tp_price, order_rate_in_muber);
              const pip_profit = usd_profit / (lots_in_lac / calculate_pip);
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy stop order preview API',
                final_rate: usd_profit.toFixed(2),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type,
                sltp_currency_type
              });
            } else {
              if (Number(take_profit) < check_takepro_min) {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "take_profit",
                  message: `Min +${check_takepro_min.toFixed(2)}`
                });
              }
      
              const final_rate = order_rate_in_muber + take_profit_val;
              const pip_profit = (Number(take_profit) * calculate_pip) / lots_in_lac;
              return response.status(201).json({
                status: true,
                check_profit_loss: "take_profit",
                message: 'Calculation buy stop order preview API',
                final_rate: final_rate.toFixed(5),
                pip_profit: pip_profit.toFixed(1) + ' pips',
                currency_type
              });
            }
          } else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                const sl_price = Number(stop_loss);
                // const max_sl_price = check_stoploss_max; // Max allowed stop loss price
                const max_sl_price = order_rate_in_muber + (check_stoploss_max / lots_in_lac);
            
                if (sl_price === 0 || sl_price > max_sl_price) {
                    return response.status(201).json({
                        status: false,
                        check_profit_loss: "stop_loss",
                        message: `Max ${max_sl_price.toFixed(2)}`
                    });
                }
            
                const usd_loss = calculateUsdLoss(sl_price, order_rate_in_muber);
               
                
                const pip_loss = usd_loss / (lots_in_lac / calculate_pip);
            
                return response.status(201).json({
                    status: true,
                    check_profit_loss: "stop_loss",
                    message: 'Calculation buy stop order preview API',
                    final_rate: usd_loss.toFixed(2),
                    pip_profit: pip_loss.toFixed(1) + ' pips',
                    currency_type
                });

            } else {
              if (check_stoploss_max >= Number(stop_loss)) {
                const final_rate = order_rate_in_muber - stop_loss_val;
                const pip_profit = (Number(stop_loss) * calculate_pip) / lots_in_lac;
                return response.status(201).json({
                  status: true,
                  check_profit_loss: "stop_loss",
                  message: 'Calculation buy stop order preview API',
                  final_rate: final_rate.toFixed(5),
                  pip_profit: pip_profit.toFixed(1) + ' pips',
                  currency_type
                });
              } else {
                return response.status(201).json({
                  status: false,
                  check_profit_loss: "stop_loss",
                  message: `Max ${check_stoploss_max.toFixed(2)}`
                });
              }
            }
          } else if (order_rate_in_muber < ck_stop_price) {
            return response.status(201).json({
              status: false,
              order_rate: "yes",
              message: `Min ${ck_stop_price.toFixed(5)}`
            });
          } else {
            return response.status(201).json({
              status: true,
              order_rate: "yes",
              message: `Min ${ck_stop_price.toFixed(5)}`
            });
          }
        } else {
          return response.status(201).json({ status: false, message: 'limit_stop_type is invalid!' });
        }
    },

    /// this code is used to check buy sell limit and sell stop orders  
    calculate_bck0705_buy_limit_stop_order_preview_API: async(request, response) => {

        const { tbl_user_id, login_id, type, limit_stop_type, tradesize, exchange_rate, order_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = request.body;

        // const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';

       
        const baseCurrency = currency_pair.substring(0, 3); // Extracts the first three characters
        // const lastCurrency = currency_pair.substring(3, 6); // Extracts the first three characters

        const exchange_rate_in_muber = Number(exchange_rate);
        const order_rate_in_muber = Number(order_rate);

        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size where currency_pair = '${currency_pair}'`);

        if (lots_size_query.rowCount > 0) {
            const res = lots_size_query.rows[0];

            const ck_cruncy_pair = res.currency_pair;
            const lots_unitsize = res.one_lots_unitsize;
            const calculate_market_order_pip_val_pip = res.calculate_sell_buy_market_order_pip_val;
            const sell_limit_stop_order_ck_limit_price = res.sell_limit_stop_order_ck_limit_price;
            const sell_limit_stop_order_check_takepro_min = res.sell_limit_stop_order_check_takepro_min;
            const sell_limit_stop_order_check_stoploss_max = res.sell_limit_stop_order_check_stoploss_max;
            const sell_limit_stop_order_ck_stop_price = res.sell_limit_stop_order_ck_stop_price;
            const quote_currency_amount_in_usd = res.quote_currency_amount_in_usd;

            if (currency_pair == ck_cruncy_pair) {  // for gold

          
                var lots_in_lac = tradesize * lots_unitsize * Number(quote_currency_amount_in_usd);
                var calculate_pip = Number(calculate_market_order_pip_val_pip);  /// calculate pip value for each trade in pi
                var ck_limit_price = (exchange_rate_in_muber - Number(sell_limit_stop_order_ck_limit_price)).toFixed(5);  // sell limit rate is have to more than 400 from the exchange rate
                // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 2359.004 then order_rate have to 2359.404;
                var check_takepro_min = tradesize *  Number(sell_limit_stop_order_check_takepro_min);
                var check_stoploss_max = tradesize * (Number(sell_limit_stop_order_check_stoploss_max));
                // code limit_stop_type == 'sell_stop'
                var ck_stop_price = (exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price)).toFixed(5);
            } else {

            

                var lots_in_lac =  tradesize * lots_unitsize * Number(quote_currency_amount_in_usd);
                var calculate_pip = Number(calculate_market_order_pip_val_pip);  /// calculate pip value for each trade in pi
                // for sell limit
                // you can set buy limit less than 20 from the exchange rate like 1.07445 then Max order rate is 1.07425
                var ck_limit_price = exchange_rate_in_muber - Number(sell_limit_stop_order_ck_limit_price);  // buy limit rate is have to less than 20 from the exchange rate
                // here final rate is set by the use of order_rate in take profit calculation if order_rate is 1.07425 then take profit take_profite_val min 10 have to 1.07435;
                var check_takepro_min = tradesize * Number(sell_limit_stop_order_check_takepro_min);
                var check_stoploss_max = tradesize * (Number(sell_limit_stop_order_check_stoploss_max));
                // code limit_stop_type == 'sell_stop'
                var ck_stop_price = (exchange_rate_in_muber - Number(sell_limit_stop_order_ck_stop_price));  // buy order_rate is more than 10 from the exchange rate
            }


            const take_profite_val = (take_profit / lots_in_lac);
            const stop_loss_val = (stop_loss / lots_in_lac);

            if (limit_stop_type == 'buy_limit') {
                // you can set buy limit less than 20 from the exchange rate like 1.07445 then Max order rate is 1.07425
                // const ck_limit_price = exchange_rate_in_muber - 0.00020;  // buy limit rate is have to less than 20 from the exchange rate

                // here final rate is set by the use of order_rate in take profit calculation if order_rate is 1.07425 then take profit take_profite_val min 10 have to 1.07435;
                if (take_profit_status == 'yes') {
                    //const check_takepro_min = tradesize * 10;
                    /// this condition is used to set min take profit value is 10 as a amount of order_rate
                    if (take_profit >= check_takepro_min) {
                        var final_rate = order_rate_in_muber + take_profite_val;
                        var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "take_profit";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation buy limit order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: 'take_profit', message: `Min +${check_takepro_min.toFixed(2)}` });
                    }
                } else if (stop_loss_status == 'yes') {
                    // final_rate == calculation is depend on order_rate if order_rate is 1.07435 then stop_loss final_rate is add stop_loss_val from order rate order_rate + stop_loss_val here apply addition beacause stop_loss always in (-) like -10  then final rate is 1.07435
                    //const check_stoploss_max = tradesize * (-10);
                    if (check_stoploss_max >= stop_loss) {
                        var final_rate = order_rate_in_muber + stop_loss_val;
                        var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "stop_loss";
                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation buy limit order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: 'stop_loss', message: `Max ${check_stoploss_max.toFixed(2)}` });
                    }
                } else if (ck_limit_price >= order_rate) {
                    return response.status(201).json({ status: true, order_rate: "yes", message: `Max ${ck_limit_price}` });
                } else {
                    return response.status(201).json({ status: false, order_rate: "yes", message: `Max ${ck_limit_price}` });
                }


            } else if (limit_stop_type == 'buy_stop') {

                //const ck_stop_price = exchange_rate_in_muber + 0.00010;  // buy order_rate is more than 10 from the exchange rate
                if (take_profit_status == 'yes') {
                    // const check_takepro_min = tradesize * 10;   
                    /// this condition is used to set min take profit value is 10 as a amount of order_rate
                    if (take_profit >= check_takepro_min) {
                        var final_rate = order_rate_in_muber + take_profite_val;
                        var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "take_profit";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation buy stop order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: "take_profit", message: `Min +${check_takepro_min.toFixed(2)}` });
                    }
                } else if (stop_loss_status == 'yes') {
                    /// this condition is used to set max take profit value is -10 as a amount of if "stop_loss":  "-10", "order_rate": 1.07465, then  "final_rate": "1.07455 USD",
                    //  const check_stoploss_max = tradesize * (-10);
                    if (check_stoploss_max >= stop_loss) {
                        var final_rate = order_rate_in_muber + stop_loss_val;
                        var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                        var check_profit_loss = "stop_loss";

                        return response.status(201).json({ status: true, check_profit_loss: check_profit_loss, message: 'Calculation buy stop order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type });
                    } else {
                        return response.status(201).json({ status: false, check_profit_loss: "stop_loss", message: `Max ${check_stoploss_max.toFixed(2)}` });
                    }
                } else if (order_rate_in_muber >= ck_stop_price) {
                    // here final rate is set by the use of order_rate in loss and profit calculation if exchange_rate_in_muber is 1.07555 then order_rate  is 1.07576;
                    return response.status(201).json({ status: true, order_rate: "yes", message: `Max ${ck_stop_price}` });
                } else {
                    return response.status(201).json({ status: false, order_rate: "yes", message: `Min ${ck_stop_price}` });
                }
            } else {
                return response.status(201).json({ status: false, message: 'limit_stop_type is wrong!' });
            }

        } else {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist` });
        }

    },

    user_account_details_by_loginid_API: (request, response) => {

        const { tbl_user_id, login_id } = request.body;

        pool.query(`SELECT * FROM tbl_mt5_user WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                /// check free margin for open trade order
                const check_freemargn = await pool.query(`SELECT sum(margin) as total_used_margin FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'open'`);

                if (check_freemargn.rows[0].total_used_margin == null) {
                    var total_used_margin = 0;
                } else {
                    var total_used_margin = check_freemargn.rows[0].total_used_margin;
                }
                const free_mrgn = result.rows[0].balance - total_used_margin;


                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
                    let cat = {
                        tbl_mt5_user_id: isNull(table.tbl_mt5_user_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        balance: table.balance.toFixed(2),

                        ///// update this value

                        equity: table.balance.toFixed(2),   /// equity = accountBalance + floatingProfitsLosses;
                        total_pl: "0.00",
                        free_margin: free_mrgn.toFixed(2),
                        margin: total_used_margin.toFixed(2),  // trade with actual amount of balance

                        ///// update this value


                        margin_level: "0.00",  //marginLevel = (equity / usedMargin) * 100; code is below
                        leverage: isNull(table.leverage),
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, message: 'User account details by loginid', data: data });
            } else {
                return response.status(201).json({ status: false, message: 'No Account Created', data: [] })
            }
        })
    },

    // Let's calculate the margin level using the provided function and example values:
    // const accountBalance = 100.86; // Account balance
    // const floatingProfitsLosses = 0.08; // Floating profits/losses
    // const usedMargin = 53.53; // Used margin

    // const equity = accountBalance + floatingProfitsLosses;
    // const marginLevel = (equity / usedMargin) * 100;

    //Substituting the values:

    // const equity = 100.86 + 0.08; // Equity = Account Balance + Floating Profits/Losses = 100.86 + 0.08 = 100.94
    // const marginLevel = (100.94 / 53.53) * 100; // Margin Level = (Equity / Used Margin) * 100 = (100.94 / 53.53) * 100 ≈ 188.54

    //  So, the margin level would be approximately 188.54%.
    // If you run the code with these values, the output should be:

    //  Margin Level: 188.54%

    confirm_order_API: async (request, response) => {

        const { tbl_user_id, login_id, type, tradesize, exchange_rate, free_margin, margin, leverage_ratio, currency_pair, currency_type, order_setting, market_order_type, market_order_price, take_profit, stop_loss, take_profit_price, stop_loss_price, take_profit_status, stop_loss_status, take_profit_currency_type, stop_loss_currency_type } = request.body;

        console.log('confirm_order_API', request.body);
        

        const tp_currency_typ = take_profit_currency_type == 'price' ? take_profit_currency_type : 'price';
        const sl_currency_typ = stop_loss_currency_type == 'price' ? stop_loss_currency_type : 'price';
        
        /// type is sell or buy in this trade order // market_order_type is normal then not send sell buy stop limit
        // market_order_type means set limit or sell stop if type is sell // market_order_type means buy limit or buy stop if type is buy 

        /* condition for sell or bid limit/stop  buy or ask limit/stop EURUSD   
           we wan't set sell_limit if market sell live rate is 1.07500 then you will have to add min +20 to confirm_order  = 1.07520
           we wan't set sell_stop if market sell live rate is 1.074500 then you will have to subtracted max -10 to confirm_order  = 1.07490
        */
        /* condition for buy or ask limit/stop EURUSD   
           we wan't set buy_limit if market buy live rate is 1.07500 then you will have to subtracted min -20 to confirm_order  = 1.07480
           we wan't set buy_stop if market buy live rate is 1.07500 then you will have to add max +10 to confirm_order  = 1.07510
        */


        const tradesize_num = Number(tradesize);

        if (market_order_type != 'normal') {
            if (market_order_price == null || market_order_price == undefined || market_order_price == '') {
                return response.status(403).json({ status: false, message: "market_order_price is required." });
            } else {
                var order_status = 'pending'
            }
        } else {
            var order_status = 'open'
        }

        if (take_profit_status == 'yes') {
            if (take_profit_price == null || take_profit_price == undefined || take_profit_price == '') {
                return response.status(403).json({ status: false, message: "take_profit_price is required." });
            }
            var takeprofit_price = take_profit_price;
        } else {
            var takeprofit_price = 0;
        }

        if (stop_loss_status == 'yes') {
            if (stop_loss_price == null || stop_loss_price == undefined || stop_loss_price == '') {
                return response.status(403).json({ status: false, message: "stop_loss_price is required." });
            }
            var stoplos_price = stop_loss_price;
        } else {
            var stoplos_price = 0;
        }

        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size where currency_pair = '${currency_pair}'`);

        if (lots_size_query.rowCount > 0) {
            const res = lots_size_query.rows[0];

            const ck_cruncy_pair = res.currency_pair;
            const lots_unitsize_db = res.one_lots_unitsize;
            // udate it on 28-04-2025
                var quote_currency = res.quote_currency;
                var quote_currency_amount = res.quote_currency_amount;
                var quote_currency_amount_in_usd = res.quote_currency_amount_in_usd;
            // udate it on 28-04-2025

            if (currency_pair == ck_cruncy_pair) {
                var lots_unitsize = Number(lots_unitsize_db);
            } else {
                var lots_unitsize = Number(lots_unitsize_db);
            }
        } else {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist` });
        } 

        pool.query(`SELECT balance FROM tbl_mt5_user WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error.message });
            }
            var count = result.rowCount;
            if (count > 0) {
              
                if (result.rows[0].balance > margin) {

                    /// check free margin for open trade order
                    const check_freemargn = await pool.query(`SELECT sum(margin) as total_used_margin FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'open' AND order_status = 'pending'`);

                    const total_used_margin = check_freemargn.rows[0].total_used_margin;
                    const free_mrgn = result.rows[0].balance - margin;

                    if(free_mrgn > margin || free_margin > margin) {

                        /// generate 6 digit random login id for user

                        const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                        const random_with_id = login_id + random.toString(); // Combine random number and user ID
                        const sixDigitRandomWithId = random_with_id.slice(-8); // Take the last 6 digits
                        const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                        const order_id = zeroPad(sixDigitRandomWithId, 8); // Ensure the final ID is 6 digits                    
                  

                        /// generate 6 digit random login id for user 

                        console.log(`INSERT INTO tbl_order(order_id,tbl_user_id,login_id,type,tradesize_lots,exchange_rate,margin,leverage_ratio,currency_pair,currency_type,order_setting,market_order_type,market_order_price,stop_loss,take_profit,stop_loss_price,take_profit_price,open_order_datetime, open_price, order_status, take_profit_status, stop_loss_status, lotsize_in_lak,quote_currency,quote_currency_amount,quote_currency_amount_in_usd, take_profit_currency_type, stop_loss_currency_type)VALUES('${order_id}','${tbl_user_id}','${login_id}','${type}','${tradesize}','${exchange_rate}','${margin}','${leverage_ratio}','${currency_pair}','${currency_type}','${order_setting}','${market_order_type}','${market_order_price}','${stop_loss}','${take_profit}','${stoplos_price}','${takeprofit_price}',now(), '${exchange_rate}', '${order_status}','${take_profit_status}','${stop_loss_status}','${lots_unitsize}','${quote_currency}','${quote_currency_amount}','${quote_currency_amount_in_usd}','${tp_currency_typ}','${sl_currency_typ}') RETURNING tbl_order_id`);
                        

                        pool.query(`INSERT INTO tbl_order(order_id,tbl_user_id,login_id,type,tradesize_lots,exchange_rate,margin,leverage_ratio,currency_pair,currency_type,order_setting,market_order_type,market_order_price,stop_loss,take_profit,stop_loss_price,take_profit_price,open_order_datetime, open_price, order_status, take_profit_status, stop_loss_status, lotsize_in_lak,quote_currency,quote_currency_amount,quote_currency_amount_in_usd, take_profit_currency_type, stop_loss_currency_type)VALUES('${order_id}','${tbl_user_id}','${login_id}','${type}','${tradesize}','${exchange_rate}','${margin}','${leverage_ratio}','${currency_pair}','${currency_type}','${order_setting}','${market_order_type}','${market_order_price}','${stop_loss}','${take_profit}','${stoplos_price}','${takeprofit_price}',now(), '${exchange_rate}', '${order_status}','${take_profit_status}','${stop_loss_status}','${lots_unitsize}','${quote_currency}','${quote_currency_amount}','${quote_currency_amount_in_usd}','${tp_currency_typ}','${sl_currency_typ}') RETURNING tbl_order_id`,
                            async (error, order_res) => {
                                if (error) {
                                    return response.status(403).json({ status: false, message: error });
                                }
                                if (order_res.rowCount > 0) {

                                    if(order_status == 'open' ){

                                        ///////////  this code is updated on 09-12-2024 for MetaFxPro  code start from here

                                        const tblorderid = order_res.rows[0].tbl_order_id;
                                        const deelrandom = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                                        const deelrandom_with_id = tblorderid + deelrandom.toString(); // Combine random number and user ID
                                        const deelsixDigitRandomWithId = deelrandom_with_id.slice(-8); // Take the last 6 digits
                                        const zeroPadd = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                                        const deal_id = zeroPadd(deelsixDigitRandomWithId, 6); // Ensure the final ID is 6 digits
                                  

                                        const duplicate_ordr_query = await pool.query(`INSERT INTO tbl_duplicate_order(tbl_order_id,order_id,deal_id,tbl_user_id,login_id,type,type_inout,tradesize_lots,exchange_rate,order_status,quote_currency,quote_currency_amount,quote_currency_amount_in_usd)VALUES('${tblorderid}','${order_id}','${deal_id}','${tbl_user_id}','${login_id}','${type}','in','${tradesize}','${exchange_rate}','${order_status}','${quote_currency}','${quote_currency_amount}','${quote_currency_amount_in_usd}')`);

                                        ///////////  this code is updated on 09-12-2024 for MetaFxPro code end here 


                                        const title = `Order Opened`;
                                        const message_type = `order_open`;
                                        const message = `Your ${type} Order #${order_id} for ${tradesize} lot of ${currency_pair} is opened at ${exchange_rate}`;
    
                                        notification_function.send_notification(tbl_user_id, title, message_type, message);
                                    }

                                    return response.status(201).json({ status: true, message: 'Order successfully open.', order_id: order_id });
                                } else {
                                    return response.status(201).json({ status: false, message: 'Something Error', });
                                }
                            });
                    } else {
                        return response.status(201).json({ status: false, message: 'Not enough money.', details: `Margin required for the entered order volume (${tradesize_num.toFixed(2)}) exceeds available free margin on your account.` });
                    }
                } else {
                    return response.status(201).json({ status: false, message: 'Not enough money.', details: `Margin required for the entered order volume (${tradesize_num.toFixed(2)}) exceeds available free margin on your account.` });
                }
            } else {
                return response.status(201).json({ status: false, message: 'This user is not registered with us. Please check your user ID.' });
            }
        });
    },

    edit_test_calculate_sell_buy_market_order_preview_API: async (request, response) => {
        const {
            tbl_user_id, tbl_order_id, login_id, ordr_profit_loss_val,
            take_profit, stop_loss, take_profit_status, stop_loss_status,
            sltp_currency_type
        } = request.body;
    
        const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';
        

    
        const ordr_query = await pool.query(`SELECT * FROM tbl_order WHERE tbl_order_id = '${tbl_order_id}'`);
        if (ordr_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `tbl_order_id does not exist`, err_message: '' });
        }
    
        const ordr_reslt = ordr_query.rows[0];
        if (ordr_reslt.order_status === 'closed') {
            return response.status(201).json({ status: false, message: `This order is closed`, err_message: '' });
        }
    
        const type = ordr_reslt.type;
        const tradesize = Number(ordr_reslt.tradesize_lots);
        const exchange_rate = Number(ordr_reslt.exchange_rate);
        const currency_pair = ordr_reslt.currency_pair;
        const currency_type = ordr_reslt.currency_type;
    
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
        if (lots_size_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair does not exist`, err_message: '' });
        }
    
        const res = lots_size_query.rows[0];
        const lots_unitsize = Number(res.one_lots_unitsize);
        const calculate_pip = Number(res.calculate_sell_buy_market_order_pip_val);
        const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);
    
        const lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;
        const ordr_profit_loss = Number(ordr_profit_loss_val);
        const take_profit_num = Number(take_profit);
        const stop_loss_num = Number(stop_loss);
    
        let final_rate, pip_profit;
    
        const isSell = type === 'sell';
        const isBuy = type === 'buy';
    
        if (!isSell && !isBuy) {
            return response.status(201).json({ status: false, message: 'Type went wrong', err_message: '' });
        }
    
        // ==== TAKE PROFIT LOGIC ====
        if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                const min_tp_price = isSell
                    ? exchange_rate - (ordr_profit_loss / lots_in_lac)
                    : exchange_rate + (ordr_profit_loss / lots_in_lac);
    
                if (take_profit_num < min_tp_price) {
                    return response.status(201).json({
                        status: false,
                        message: `Min ${min_tp_price.toFixed(5)}`,
                        err_message: ''
                    });
                }
    
                const final_tp_price = take_profit_num;
                const usd_profit = isSell
                    ? (exchange_rate - final_tp_price) * lots_in_lac
                    : (final_tp_price - exchange_rate) * lots_in_lac;
    
                if (usd_profit < 0) {
                    return response.status(201).json({ status: false, message: 'Min +0.00', err_message: '' });
                }
    
                pip_profit = Math.abs(final_tp_price - exchange_rate) * lots_in_lac / calculate_pip;
                final_rate = usd_profit;
    
            } else {
                if (take_profit_num < ordr_profit_loss) {
                    return response.status(201).json({
                        status: false,
                        message: `Min ${ordr_profit_loss_val}`,
                        err_message: ''
                    });
                }
    
                const profit_in_usd = take_profit_num;
                final_rate = isSell
                    ? exchange_rate - (profit_in_usd / lots_in_lac)
                    : exchange_rate + (profit_in_usd / lots_in_lac);
    
                pip_profit = (profit_in_usd * calculate_pip) / lots_in_lac;
            }
        }
    
        // ==== STOP LOSS LOGIC ====
        else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                const max_sl_price = isSell
                    ? exchange_rate + (ordr_profit_loss / lots_in_lac)
                    : exchange_rate - (ordr_profit_loss / lots_in_lac);
    
                  
                    
                if (stop_loss_num > max_sl_price) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${max_sl_price.toFixed(5)}`,
                        err_message: ''
                    });
                }
    
                const stop_loss_price = stop_loss_num;
                const usd_loss = isSell
                    ? (stop_loss_price - exchange_rate) * lots_in_lac
                    : (exchange_rate - stop_loss_price) * lots_in_lac;
    
               
    
                pip_profit = Math.abs(exchange_rate - stop_loss_price) * lots_in_lac / calculate_pip;
                final_rate = usd_loss;
    
            } else {
                if (stop_loss_num > ordr_profit_loss) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${ordr_profit_loss_val}`,
                        err_message: ''
                    });
                }
    
                const loss_in_usd = stop_loss_num;
                const max_loss_in_usd = ordr_profit_loss;
    
                if (loss_in_usd > max_loss_in_usd) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${max_loss_in_usd.toFixed(2)}`,
                        err_message: ''
                    });
                }
    
                final_rate = isSell
                    ? exchange_rate + (loss_in_usd / lots_in_lac)
                    : exchange_rate - (loss_in_usd / lots_in_lac);
    
                pip_profit = (loss_in_usd * calculate_pip) / lots_in_lac;
            }
        } else {
            return response.status(201).json({ status: false, message: 'Something went wrong', err_message: '' });
        }
    
        return response.status(201).json({
            status: true,
            message: `Edit calculation ${type} market order preview API`,
            final_rate: final_rate.toFixed(5),
            pip_profit: pip_profit.toFixed(1) + ' pips',
            currency_type: currency_type,
            err_message: ''
        });
    },

    edit_calculate_sell_buy_market_order_preview_API: async (request, response) => {
        const {
            tbl_user_id, tbl_order_id, login_id, ordr_profit_loss_val,
            take_profit, stop_loss, take_profit_status, stop_loss_status,
            sltp_currency_type
        } = request.body;
    
        console.log('edit_calculate_sell_buy_market_order_preview_API', request.body);
        const sltp_currency_typ = sltp_currency_type === 'price' ? 'price' : 'USD';
       
        

    
        const ordr_query = await pool.query(`SELECT * FROM tbl_order WHERE tbl_order_id = '${tbl_order_id}'`);
        if (ordr_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `tbl_order_id does not exist`, err_message: '' });
        }
    
        const ordr_reslt = ordr_query.rows[0];
        if (ordr_reslt.order_status === 'closed') {
            return response.status(201).json({ status: false, message: `This order is closed`, err_message: '' });
        }
    
        const type = ordr_reslt.type;
        const tradesize = Number(ordr_reslt.tradesize_lots);
        const exchange_rate = Number(ordr_reslt.exchange_rate);
        const currency_pair = ordr_reslt.currency_pair;
        const currency_type = ordr_reslt.currency_type;
    
        const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size WHERE currency_pair = '${currency_pair}'`);
        if (lots_size_query.rowCount === 0) {
            return response.status(201).json({ status: false, message: `${currency_pair} currency_pair does not exist`, err_message: '' });
        }
    
        const res = lots_size_query.rows[0];
        const lots_unitsize = Number(res.one_lots_unitsize);
        const calculate_pip = Number(res.calculate_sell_buy_market_order_pip_val);
        const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);
    
        const lots_in_lac = tradesize * lots_unitsize * quote_currency_amount_in_usd;
        const ordr_profit_loss = Number(ordr_profit_loss_val);
        const take_profit_num = Number(take_profit);
        const stop_loss_num = Number(stop_loss);
    
        let final_rate, pip_profit;
    
        const isSell = type === 'sell';
        const isBuy = type === 'buy';
    
        if (!isSell && !isBuy) {
            return response.status(201).json({ status: false, message: 'Type went wrong', err_message: 'Type went wrong' });
        }
    
        // ==== TAKE PROFIT LOGIC ====
        if (take_profit_status === 'yes') {
            if (sltp_currency_typ === 'price') {
                
                const min_tp_price = isSell ? exchange_rate - (ordr_profit_loss / lots_in_lac) : exchange_rate + (ordr_profit_loss / lots_in_lac);

                if(isSell === true){
                    console.log('isSell', isSell);
                    if (take_profit_num > min_tp_price) {
                        return response.status(201).json({ status: false, message: `Max ${min_tp_price.toFixed(5)}`,
                            err_message: `Max ${min_tp_price.toFixed(5)}`
                        });
                    }
                }else{
                    console.log('isSell', isSell);
                    if (take_profit_num < min_tp_price) {
                        return response.status(201).json({ status: false, message: `Min ${min_tp_price.toFixed(5)}`,
                            err_message: `Min ${min_tp_price.toFixed(5)}`
                        });
                    }
                }
    
                const final_tp_price = take_profit_num;
                const usd_profit = isSell ? (exchange_rate - final_tp_price) * lots_in_lac : (final_tp_price - exchange_rate) * lots_in_lac;
                              
                // if (usd_profit < 0) {
                //     return response.status(201).json({ status: false, message: 'Min +0.00', err_message: 'usd_profit < 0' });
                // }
                //pip_profit = Math.abs(final_tp_price - exchange_rate) * lots_in_lac / calculate_pip;
                
                pip_profit = (usd_profit) / (lots_in_lac / calculate_pip);
                final_rate = usd_profit;
    
            } else {

                if (take_profit_num < ordr_profit_loss) {
                    return response.status(201).json({
                        status: false,
                        message: `Min ${ordr_profit_loss_val}`,
                        err_message: `Min ${ordr_profit_loss_val}`
                    });
                }
    
                const profit_in_usd = take_profit_num;
                final_rate = isSell
                    ? exchange_rate - (profit_in_usd / lots_in_lac)
                    : exchange_rate + (profit_in_usd / lots_in_lac);
    
                pip_profit = (profit_in_usd * calculate_pip) / lots_in_lac;
            }
        }
    
        // ==== STOP LOSS LOGIC ====
        else if (stop_loss_status === 'yes') {
            if (sltp_currency_typ === 'price') { 

                const max_sl_price = isSell ? exchange_rate - (ordr_profit_loss / lots_in_lac) : exchange_rate + (ordr_profit_loss / lots_in_lac); 
                    
                if(isSell === true){
                    console.log('stop_loss_status', stop_loss_status);
                    console.log('isSell', isSell);
                    if (stop_loss_num < max_sl_price) {
                        return response.status(201).json({  status: false, message: `Min ${max_sl_price.toFixed(5)}`, err_message: `Min ${max_sl_price.toFixed(5)}` });
                    }
                }else{
                    console.log('stop_loss_status', stop_loss_status);
                    console.log('isSell', isSell);
                    if (stop_loss_num > max_sl_price) {
                        return response.status(201).json({  status: false, message: `Max ${max_sl_price.toFixed(5)}`, err_message: `Max ${max_sl_price.toFixed(5)}` });
                    }
                }    
    
                const stop_loss_price = stop_loss_num;
                const usd_loss = isSell ? (exchange_rate - stop_loss_price) * lots_in_lac : (stop_loss_price - exchange_rate) * lots_in_lac;

                //pip_profit = Math.abs(exchange_rate - stop_loss_price) * lots_in_lac / calculate_pip;
                pip_profit = (usd_loss) / (lots_in_lac / calculate_pip);
                final_rate = usd_loss;
    
            } else {
                if (stop_loss_num > ordr_profit_loss) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${ordr_profit_loss_val}`,
                        err_message: `Max ${ordr_profit_loss_val}`
                    });
                }
    
                const loss_in_usd = stop_loss_num;
                const max_loss_in_usd = ordr_profit_loss;
    
                if (loss_in_usd > max_loss_in_usd) {
                    return response.status(201).json({
                        status: false,
                        message: `Max ${max_loss_in_usd.toFixed(2)}`,
                        err_message: `Max ${max_loss_in_usd.toFixed(2)}`
                    });
                }
    
                final_rate = isSell
                    ? exchange_rate + (loss_in_usd / lots_in_lac)
                    : exchange_rate - (loss_in_usd / lots_in_lac);
    
                pip_profit = (loss_in_usd * calculate_pip) / lots_in_lac;
            }
        } else {
            return response.status(201).json({ status: false, message: 'Something went wrong', err_message: 'Something went wrong' });
        }
    
        return response.status(201).json({
            status: true,
            message: `Edit calculation ${type} market order preview API`,
            final_rate: final_rate.toFixed(5),
            pip_profit: pip_profit.toFixed(1) + ' pips',
            currency_type: currency_type,
            err_message: ''
        });
    },

    edit_050525_bck__calculate_sell_buy_market_order_preview_API: async(request, response) => {

        // const {  tbl_user_id, tbl_order_id, login_id, type, tradesize, exchange_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = request.body;
        const {  tbl_user_id, tbl_order_id, login_id, ordr_profit_loss_val, take_profit, stop_loss, take_profit_status, stop_loss_status, sltp_currency_type } = request.body;

      
      

        const ordr_query = await pool.query(`SELECT * FROM tbl_order where tbl_order_id = '${tbl_order_id}'`);

        if (ordr_query.rowCount > 0) {
            const ordr_reslt = ordr_query.rows[0];

            if (ordr_reslt.order_status == 'closed') {
                return response.status(201).json({ status: false, message: `This order is closed`, err_message: '' });
            }else {

                ///////  order details codes start from here
                const type = ordr_reslt.type;
                const tradesize = ordr_reslt.tradesize_lots;
                const exchange_rate = ordr_reslt.exchange_rate;
                const currency_pair = ordr_reslt.currency_pair;
                const currency_type = ordr_reslt.currency_type;
                
                

                ///////  order details codes start from here end 

                const lots_size_query = await pool.query(`SELECT * FROM tbl_lots_size where currency_pair = '${currency_pair}'`);
                if (lots_size_query.rowCount > 0) {
                    const res = lots_size_query.rows[0];

                    const ck_cruncy_pair = res.currency_pair;
                    const lots_unitsize = res.one_lots_unitsize;
                    const calculate_market_order_pip_val_pip = res.calculate_sell_buy_market_order_pip_val;
                    const calculate_market_order_chk_limit_stoploss = res.calculate_market_order_chk_limit_stoploss;
                    const quote_currency_amount_in_usd = Number(res.quote_currency_amount_in_usd);

                   
                    const lots_in_lac = tradesize * Number(lots_unitsize) * quote_currency_amount_in_usd;
                    const calculate_pip = Number(calculate_market_order_pip_val_pip);  /// calculate pip value for each trade in pi
                    const chk_limit_stoploss = Number(calculate_market_order_chk_limit_stoploss); // this is the max limit for stop loss via exchange rate  
                   

                    const take_profite_val = (take_profit / lots_in_lac);
                    const stop_loss_val = (stop_loss / lots_in_lac);
                    const exchange_rate_in_muber = Number(exchange_rate);

                    if (type == 'sell') {
                        if (take_profit_status == 'yes') {
                            if (Number(take_profit) >= Number(ordr_profit_loss_val)) {
                                var final_rate = exchange_rate_in_muber - take_profite_val;
                                var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                            } else {
                                return response.status(201).json({ status: false, message: 'Edit calculation Sell market order preview API', err_message: `Min ${ordr_profit_loss_val}` });
                            }
                        } else if (stop_loss_status == 'yes') {
                            const check_stoploss_max = tradesize * chk_limit_stoploss;
                            // if (check_stoploss_max >= stop_loss) {
                            if (Number(ordr_profit_loss_val) >= Number(stop_loss)) {
                                var final_rate = exchange_rate_in_muber - stop_loss_val;
                                var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                            } else {
                                return response.status(201).json({ status: false, message: 'Edit calculation Sell market order preview API', err_message: `Max ${ordr_profit_loss_val}` });
                            }
                        } else {
                            return response.status(201).json({ status: false, message: 'someting went wrong', err_message: '' });
                        }
                        // final_rate: final_rate,
                        return response.status(201).json({ status: true, message: 'Edit calculation Sell market order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type, err_message: '' });

                    } else if (type == 'buy') {

                        if (take_profit_status == 'yes') {
                            if (Number(take_profit) >= Number(ordr_profit_loss_val)) {
                                // (10/lots_in_lac) this condition is used to add 10 bydefault add take profit at buy price
                                var final_rate = exchange_rate_in_muber + take_profite_val;
                                var pip_profit = (take_profit * calculate_pip) / lots_in_lac;
                            } else {
                                return response.status(201).json({ status: false, message: 'Edit calculation Sell market order preview API', err_message: `Min ${ordr_profit_loss_val}` });
                            }
                        } else if (stop_loss_status == 'yes') {
                            const check_stoploss_max = tradesize * chk_limit_stoploss;
                            // if (check_stoploss_max >= stop_loss) {
                            if (Number(ordr_profit_loss_val) >= Number(stop_loss)) {
                                var final_rate = exchange_rate_in_muber + stop_loss_val;
                                var pip_profit = (stop_loss * calculate_pip) / lots_in_lac;
                            } else {
                                return response.status(201).json({ status: false, message: 'Edit calculation Sell market order preview API', err_message: `Max ${ordr_profit_loss_val}` });
                            }
                        } else {
                            return response.status(201).json({ status: false, message: 'someting went wrong', err_message: ''  });
                        }
                        return response.status(201).json({ status: true, message: 'Edit calculation buy market order preview API', final_rate: final_rate.toFixed(5), pip_profit: pip_profit.toFixed(1) + ' pips', currency_type: currency_type, err_message: '' });

                    } else {
                        return response.status(201).json({ status: false, message: 'type went wrong', err_message: '' });
                    }

                } else {
                    return response.status(201).json({ status: false, message: `${currency_pair} currency_pair is not exist`, err_message: '' });
                }
            }    /// This order is closed
        } else {
            return response.status(201).json({ status: false, message: `tbl_order_id is not exist`, err_message: '' });
        }
    },

    edit_order_API: async (request, response) => {

        // const { tbl_user_id, login_id, type, tradesize, exchange_rate, free_margin, margin, leverage_ratio, currency_pair, currency_type, order_setting, market_order_type, market_order_price, take_profit, stop_loss, take_profit_price, stop_loss_price, take_profit_status, stop_loss_status } = request.body;

        const { tbl_user_id, login_id, tbl_order_id, take_profit, stop_loss, take_profit_price, stop_loss_price, take_profit_status, stop_loss_status } = request.body;


        

        /// type is sell or buy in this trade order // market_order_type is normal then not send sell buy stop limit
        // market_order_type means set limit or sell stop if type is sell // market_order_type means buy limit or buy stop if type is buy 

        /* condition for sell or bid limit/stop  buy or ask limit/stop EURUSD   
           we wan't set sell_limit if market sell live rate is 1.07500 then you will have to add min +20 to confirm_order  = 1.07520
           we wan't set sell_stop if market sell live rate is 1.074500 then you will have to subtracted max -10 to confirm_order  = 1.07490
        */
        /* condition for buy or ask limit/stop EURUSD   
           we wan't set buy_limit if market buy live rate is 1.07500 then you will have to subtracted min -20 to confirm_order  = 1.07480
           we wan't set buy_stop if market buy live rate is 1.07500 then you will have to add max +10 to confirm_order  = 1.07510
        */

        const ordr_query = await pool.query(`SELECT * FROM tbl_order where tbl_order_id = '${tbl_order_id}'`);

        if (ordr_query.rowCount > 0) {
            const ordr_reslt = ordr_query.rows[0];
            const order_id = ordr_reslt.order_id;

            if (ordr_reslt.order_status == 'closed') {
                return response.status(201).json({ status: false, message: `This order is closed` });
            }else {

                if (take_profit_status == 'yes') {
                    if (take_profit == null || take_profit == undefined || take_profit == '') {
                        return response.status(403).json({ status: false, message: "take_profit is required." });
                    }
                    if (take_profit_price == null || take_profit_price == undefined || take_profit_price == '') {
                        return response.status(403).json({ status: false, message: "take_profit_price is required." });
                    }
                    var takeprofit_price = take_profit_price;
                    var takeprofit = take_profit;

                } else {
                    var takeprofit_price = 0;
                    var takeprofit = 0;
                }

                if (stop_loss_status == 'yes') {
                    if (stop_loss == null || stop_loss == undefined || stop_loss == '') {
                        return response.status(403).json({ status: false, message: "stop_loss is required." });
                    }
                    if (stop_loss_price == null || stop_loss_price == undefined || stop_loss_price == '') {
                        return response.status(403).json({ status: false, message: "stop_loss_price is required." });
                    }
                    var stoploss = stop_loss;
                    var stoplos_price = stop_loss_price;
                } else {
                    var stoplos_price = 0;
                    var stoploss = 0;
                }

                pool.query(`SELECT login_id FROM tbl_mt5_user WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}'`, async (error, result) => {
                    if (error) {
                        return response.status(403).json({ status: false, message: error.message });
                    }
                    var count = result.rowCount;
                    if (count > 0) {
                      


                        const update_order_query = await pool.query(`UPDATE tbl_order SET stop_loss = '${stoploss}', stop_loss_price = '${stoplos_price}', take_profit_status = '${take_profit_status}', take_profit = '${takeprofit}', take_profit_price = '${takeprofit_price}', stop_loss_status = '${stop_loss_status}' where tbl_order_id = '${tbl_order_id}' AND login_id = '${login_id}'`);

                        if (update_order_query.rowCount > 0) {                            
                            return response.status(201).json({ status: true, message: 'Order updated successfully.', order_id: order_id });
                        } else {
                            return response.status(201).json({ status: false, message: 'Something Error', });
                        }
                
                    } else {
                        return response.status(201).json({ status: false, message: 'This user is not registered with us. Please check your user ID.' });
                    }
                });
            }    /// This order is closed
        } else {
            return response.status(201).json({ status: false, message: `tbl_order_id is not exist` });
        }
    },

    order_list_by_type_API: (request, response) => {

        const { tbl_user_id, login_id, order_status } = request.body;

        pool.query(`SELECT (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1'
        AND currencypair = tbl_order.currency_pair), * FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = '${order_status}' order by tbl_order_id desc`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    if (table.currencypair_image == null) {
                        var currencypair_image = "";
                    } else {
                        var currencypair_image = base_img_url + '/currencypair_image/' + table.currencypair_image;
                    }

                    const claculation_value = table.tradesize_lots * table.lotsize_in_lak;

                    let cat = {
                        tbl_order_id: isNull(table.tbl_order_id),
                        order_id: isNull(table.order_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        type: isNull(table.type),
                        market_order_type: isNull(table.market_order_type),
                        currency_pair: isNull(table.currency_pair),
                        currencypair_image: currencypair_image,
                        margin: table.margin.toFixed(2),
                        leverage_ratio: table.leverage_ratio,
                        exchange_rate: table.exchange_rate,
                        tradesize_lots: table.tradesize_lots.toFixed(2),
                        multiply_profit_loss: claculation_value,  ///  this value is used to calculate after profit loss like 0.00006 * 0.01 = 0.06;
                        isupdater: "0.00",
                        stop_loss: table.stop_loss.toFixed(2),
                        take_profit: table.take_profit.toFixed(2),
                        type: isNull(table.type),
                        open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, message: 'Order list by status', data: data });
            } else {
                return response.status(201).json({ status: false, message: 'Order not found', data: [] })
            }
        })
    },

    close_order_API: async (request, response) => {

        const { tbl_user_id, login_id, order_id, closed_price, profitloss_type, profit_loss_value, closed_by } = request.body;

        //console.log('close_order_API', request.body);

        pool.query(`SELECT tbl_order_id, order_id, exchange_rate, margin, tradesize_lots, type, currency_pair, quote_currency, quote_currency_amount, quote_currency_amount_in_usd FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_id = '${order_id}' AND order_status = 'open'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error.message });
            }
            var count = result.rowCount;
            if (count > 0) {

         
                const admin_commission = result.rows[0].tradesize_lots * 16;

            

                if (profitloss_type == 'profit') {
                    var updt_blance = `balance = balance + ${profit_loss_value} - ${admin_commission}`;
                    var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${profit_loss_value} - ${admin_commission}`;
                } else {
                    ///   ${profit_loss_value} this value is always in minus (-14)
                    var updt_blance = `balance = balance + ${profit_loss_value} - ${admin_commission}`;
                    var user_wlt_updt_blance = `wallet_amount = wallet_amount + ${profit_loss_value} - ${admin_commission}`;
                }

       
               

                pool.query(`UPDATE tbl_order SET  closed_price = '${closed_price}', profit_type = '${profitloss_type}', profit_loss_value = '${profit_loss_value}', closed_by = '${closed_by}', admin_commission = '${admin_commission}', order_status = 'closed', closed_order_datetime = now() WHERE login_id = '${login_id}' AND order_id = '${order_id}';
                UPDATE tbl_mt5_user SET ${updt_blance} WHERE login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}';
                UPDATE tbl_user SET ${user_wlt_updt_blance} WHERE tbl_user_id = '${tbl_user_id}';
                `,
                    async (error, order_res) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }
                        if (order_res[0].rowCount > 0) {


                            ///////////  this code is updated on 09-12-2024 for MetaFxPro  code start from here

                                if(result.rows[0].type == 'sell'){
                                    var opjt_type = 'buy';
                                }else{
                                    var opjt_type = 'sell';
                                }

                                const tblorderid = result.rows[0].tbl_order_id;
                                const quote_currency = result.rows[0].quote_currency;
                                const quote_currency_amount = result.rows[0].quote_currency_amount;
                                const quote_currency_amount_in_usd = result.rows[0].quote_currency_amount_in_usd;

                                const deelrandom = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                                const deelrandom_with_id = tblorderid + deelrandom.toString(); // Combine random number and user ID
                                const deelsixDigitRandomWithId = deelrandom_with_id.slice(-8); // Take the last 6 digits
                                const zeroPadd = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                                const deal_id = zeroPadd(deelsixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                        
                                

                                const duplicate_ordr_query = await pool.query(`INSERT INTO tbl_duplicate_order(tbl_order_id,order_id,deal_id,tbl_user_id,login_id,type,type_inout,tradesize_lots,exchange_rate,order_status, profit_loss_value, quote_currency, quote_currency_amount, quote_currency_amount_in_usd)VALUES('${tblorderid}','${order_id}','${deal_id}','${tbl_user_id}','${login_id}','${opjt_type}','out','${result.rows[0].tradesize_lots}','${result.rows[0].exchange_rate}','closed', '${profit_loss_value}','${quote_currency}','${quote_currency_amount}','${quote_currency_amount_in_usd}')`);

                            ///////////  this code is updated on 09-12-2024 for MetaFxPro code end here  

                            const title = `Order closed by ${closed_by}`;
                            const message_type = `order_closed`;
                            const message = `Your ${result.rows[0].type} Order #${order_id} for ${result.rows[0].tradesize_lots} lot of ${result.rows[0].currency_pair} has been closed at the closed price of ${closed_price}`;

                            notification_function.send_notification(tbl_user_id, title, message_type, message);
                           
                            return response.status(201).json({ status: true, message: 'Order successfully closed.', order_id: order_id });
                        } else {
                            return response.status(201).json({ status: false, message: 'Something Error', });
                        }
                    });
            } else {
                return response.status(201).json({ status: false, message: 'This order id is invalid. Please check your order id.' });
            }
        });
    },

    closed_order_list_API: (request, response) => {

        const { tbl_user_id, login_id, date, currency_pair } = request.body;

        if (currency_pair == null || currency_pair == undefined || currency_pair == '') {
            var currency_pair_query = ``;
        } else {
            var currency_pair_query = `AND currency_pair = '${currency_pair}'`;
        }

        // AND DATE(closed_order_datetime) = '2024-05-07'

        pool.query(`SELECT (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1'
        AND currencypair = tbl_order.currency_pair),
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'loss' AND DATE(closed_order_datetime) = '${date}' ${currency_pair_query}) as total_loss,
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}'  AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'profit' AND DATE(closed_order_datetime) = '${date}' ${currency_pair_query}) as total_profit,
        tbl_order.*  FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND DATE(closed_order_datetime) = '${date}' ${currency_pair_query} order by tbl_order_id DESC`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                var res = result.rows;
                var data = [];

                const total_profit = res[0].total_profit;
                const total_loss = res[0].total_loss;
                const netprofit_loss = total_profit - total_loss;
                const net_profit_loss = netprofit_loss > 0 ? `+${netprofit_loss.toFixed(2)}` : `${netprofit_loss.toFixed(2)}`;
                const profit_loss_type = total_profit > total_loss ? `profit` : `loss`;
                const top_date = moment(res[0].closed_order_datetime).utcOffset("+05:30").format('YYYY/MM/DD')

                // if(total_profit > total_loss){
                //     var profit_loss_type = "profit";
                // }else{
                //     var profit_loss_type = "loss";
                // }
               
                res.forEach((table) => {

                    if (table.currencypair_image == null) {
                        var currencypair_image = "";
                    } else {
                        var currencypair_image = base_img_url + '/currencypair_image/' + table.currencypair_image;
                    }
                    if (table.take_profit_status == 'yes') {
                        var takeprofit_val = table.take_profit.toFixed(2);
                        var takeprofit_price = table.take_profit_price.toString();
                    } else {
                        var takeprofit_val = "-";
                        var takeprofit_price = "-";
                    }
                    if (table.stop_loss_status == 'yes') {
                        var stoploss_val = table.stop_loss.toFixed(2);
                        var stoploss_price = table.stop_loss_price.toString();
                    } else {
                        var stoploss_val = "-";
                        var stoploss_price = "-";
                    }
                    let cat = {
                        tbl_order_id: isNull(table.tbl_order_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        order_id: isNull(table.order_id),
                        type: isNull(table.type),
                        currency_pair: isNull(table.currency_pair),
                        currencypair_image: currencypair_image,
                        currency_type: isNull(table.currency_type),
                        margin: table.margin.toFixed(2),
                        leverage_ratio: table.leverage_ratio,
                        exchange_rate: table.exchange_rate,
                        open_price: table.open_price,
                        profit_type: isNull(table.profit_type),
                        profit_loss_value: table.profit_loss_value,
                        closed_price: table.closed_price,
                        tradesize_lots: table.tradesize_lots.toFixed(2),
                        commission: table.admin_commission.toFixed(2),
                        take_profit_status: isNull(table.take_profit_status),
                        stop_loss_status: isNull(table.stop_loss_status),
                        stop_loss_price: stoploss_price,
                        stop_loss: stoploss_val,
                        take_profit_price: takeprofit_price,
                        take_profit: takeprofit_val,
                        closed_by: isNull(table.closed_by),
                        open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                        closed_date_time: moment(table.closed_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a')
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, total_profit: total_profit.toFixed(2), total_loss: total_loss.toFixed(2), net_profit_loss: net_profit_loss, profit_loss_type: profit_loss_type, date: top_date, message: 'Closed order list API', data: data, });
            } else {
                return response.status(201).json({ status: false, total_profit: "0.00", total_loss: "0.00", net_profit_loss: "0.00", message: 'Order not found', data: [], })
            }
        })
    },

    closed_order_list_new_API: async (req, res) => {

        try {
            const { tbl_user_id, login_id, pagesize, pagenumber, currency_pair } = req.body;

            if (currency_pair == null || currency_pair == undefined || currency_pair == '') {
                var currency_pair_query = ``;
            } else {
                var currency_pair_query = `AND currency_pair = '${currency_pair}'`;
            }

            pool.query(`SELECT DATE(closed_order_datetime) FROM tbl_order where tbl_user_id = '${tbl_user_id}' ${currency_pair_query} AND login_id = '${login_id}' AND order_status = 'closed' GROUP BY DATE(closed_order_datetime) ORDER BY DATE(closed_order_datetime) DESC LIMIT ${pagesize} OFFSET (${pagenumber} - 1) * ${pagesize}`,  async (error, result) => {

                if (error) {
                    return res.status(403).json({ status: false, message: error });
                }
            
                const count = result.rowCount;
                if (count > 0) {
                    let res_data = result.rows;
                    let dat = [];
                    let sno = 0;
            
                    for (const table1 of res_data) {
                        const today_date = moment(table1.date).format('YYYY-MM-DD');
                        
                        try {

                            // const notifi_data = await datewise_order(today_date);
                            const { notifi_data, total_profit, total_loss, net_profit_loss, profit_loss_type } = await datewise_order(today_date);
                            
                            let notifi = {
                                close_order_date_time: moment(today_date).format('DD MMM YYYY'),
                                total_profit,
                                total_loss,
                                net_profit_loss,
                                profit_loss_type,
                                close_list_by_date: notifi_data,
                            };
                            dat.push(notifi);
                            
                            // Perform other actions here
                            
                            if (sno === count - 1) {
                                return res.status(201).json({ status: true, message: 'Closed Order List', data: dat })
                            }
                            sno++;
                        } catch (error) {
                            res.status(401).json({ status: false, error: error, message: "Error in datewise_order" });
                        }
                    }
                } else {
                    res.status(201).json({ status: false, message: 'No Order Data.' });
                }
            });
            
            async function datewise_order(today_date) {

                return new Promise((resolve, reject) => {
                    // Your existing code for querying the database
                    let dat1 = [];
            
                    const closeorder_by_date_query1 =  `SELECT (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1'
                    AND currencypair = tbl_order.currency_pair),
                    (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'loss' AND DATE(closed_order_datetime) = '${today_date}' ${currency_pair_query}) as total_loss,
                    (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}'  AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'profit' AND DATE(closed_order_datetime) = '${today_date}' ${currency_pair_query} ) as total_profit,
                    tbl_order.*  FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND DATE(closed_order_datetime) = '${today_date}' ${currency_pair_query}  order by closed_order_datetime DESC`;

                        pool.query(closeorder_by_date_query1, (err_attr, sub_noti_result) => {

                            if (err_attr) {
                                res.status(401).json({ status: false, error: err_attr, message: "attr error" });
                            }
                            const sub_noti_result1 = sub_noti_result.rows;

                            const total_profit = sub_noti_result1[0].total_profit.toFixed(2);
                            const total_loss = sub_noti_result1[0].total_loss.toFixed(2);
                            const netprofit_loss = +total_profit + +total_loss;
                            // const netprofit_loss = parseFloat(total_profit) + parseFloat(total_loss);
                            
                            const net_profit_loss = netprofit_loss > 0 ? `+${netprofit_loss.toFixed(2)}` : `${netprofit_loss.toFixed(2)}`;
                            const profit_loss_type = netprofit_loss > 0 ? `profit` : `loss`;
                            const top_date = moment(sub_noti_result1[0].closed_order_datetime).utcOffset("+05:30").format('YYYY/MM/DD');


                            sub_noti_result1.forEach((table) => {

                                if (table.currencypair_image == null) {
                                    var currencypair_image = "";
                                } else {
                                    var currencypair_image = base_img_url + '/currencypair_image/' + table.currencypair_image;
                                }
                                if (table.take_profit_status == 'yes') {
                                    var takeprofit_val = table.take_profit.toFixed(2);
                                    var takeprofit_price = table.take_profit_price.toString();
                                } else {
                                    var takeprofit_val = "-";
                                    var takeprofit_price = "-";
                                }
                                if (table.stop_loss_status == 'yes') {
                                    var stoploss_val = table.stop_loss.toFixed(2);
                                    var stoploss_price = table.stop_loss_price.toString();
                                } else {
                                    var stoploss_val = "-";
                                    var stoploss_price = "-";
                                } 

                                let orderdat = {
                                    tbl_order_id: isNull(table.tbl_order_id),
                                    tbl_user_id: isNull(table.tbl_user_id),
                                    login_id: isNull(table.login_id),
                                    order_id: isNull(table.order_id),
                                    type: isNull(table.type),
                                    currency_pair: isNull(table.currency_pair),
                                    currencypair_image: currencypair_image,
                                    currency_type: isNull(table.currency_type),
                                    margin: table.margin.toFixed(2),
                                    leverage_ratio: table.leverage_ratio,
                                    exchange_rate: table.exchange_rate,
                                    open_price: table.open_price,
                                    profit_type: isNull(table.profit_type),
                                    profit_loss_value: table.profit_loss_value,
                                    closed_price: table.closed_price,
                                    tradesize_lots: table.tradesize_lots.toFixed(2),
                                    commission: table.admin_commission.toFixed(2),
                                    take_profit_status: isNull(table.take_profit_status),
                                    stop_loss_status: isNull(table.stop_loss_status),
                                    stop_loss_price: stoploss_price,
                                    stop_loss: stoploss_val,
                                    take_profit_price: takeprofit_price,
                                    take_profit: takeprofit_val,
                                    closed_by: isNull(table.closed_by),
                                    open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                                    closed_date_time: moment(table.closed_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a')
                                };
                                dat1.push(orderdat);
                            })
                            // callback(null, dat1);
                            // resolve(dat1);
                            resolve({ notifi_data: dat1, total_profit, total_loss, net_profit_loss, profit_loss_type });
                        })
                    
                    // Once you have the notification data, resolve the promise
                    
                    // If there's an error, reject the promise
                    // reject(error);
                });
            }
            
        } catch (error) {
            console.log(error);
        }
    },

    metarg_closed_order_list_API: (request, response) => {

        const { tbl_user_id, login_id, from_date, to_date, currency_pair, show_order_type } = request.body;

        if(currency_pair == null || currency_pair == undefined || currency_pair == '') {
            var currency_pair_query = ``;
        } else {
            var currency_pair_query = `AND currency_pair = '${currency_pair}'`;
        }

       
        

        // AND DATE(closed_order_datetime) = '2024-05-07' 

        if(show_order_type == 'position'){
          var order_typ_query = `SELECT (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1' AND currencypair = tbl_order.currency_pair),
            (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'loss' AND DATE(closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}' ${currency_pair_query}) as total_loss,
            (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}'  AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'profit' AND DATE(closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}' ${currency_pair_query}) as total_profit,
            (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id = '${tbl_user_id}' AND mt5_number = '${login_id}' AND status = '2') as total_deposit,
            (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE tbl_user_id = '${tbl_user_id}' AND mt5_number = '${login_id}' AND status = '2') as total_withdrawal,
            tbl_order.*  FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'closed' AND DATE(closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}' ${currency_pair_query} order by tbl_order_id DESC`

        }else if(show_order_type == 'orders' || show_order_type ==  'deals'){

            var order_typ_query = `SELECT dp_odr.tbl_duplicate_order_id, dp_odr.deal_id, dp_odr.type as dp_type, dp_odr.type_inout, 
            (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1' AND currencypair = ordr.currency_pair), 
            (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND  order_status = 'closed' AND profit_type = 'loss' AND DATE(closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}'  ${currency_pair_query} ) as total_loss,
            (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order  WHERE tbl_user_id = '${tbl_user_id}'  AND login_id = '${login_id}' AND order_status = 'closed' AND profit_type = 'profit' AND DATE(closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}'  ${currency_pair_query} ) as total_profit,
            (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id = '${tbl_user_id}' AND mt5_number = '${login_id}' AND status = '2') as total_deposit,
            (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE tbl_user_id = '${tbl_user_id}' AND mt5_number = '${login_id}' AND status = '2') as total_withdrawal,
            ordr.* FROM tbl_duplicate_order dp_odr INNER JOIN tbl_order ordr ON dp_odr.order_id = ordr.order_id   WHERE ordr.tbl_user_id = '${tbl_user_id}' AND ordr.login_id = '${login_id}' AND ordr.order_status != 'pending' AND ( DATE(ordr.closed_order_datetime) BETWEEN '${from_date}' AND '${to_date}'  OR DATE(ordr.open_order_datetime) BETWEEN '${from_date}' AND '${to_date}' )  ${currency_pair_query} order by ordr.tbl_order_id DESC`

        }else{
            return response.status(201).json({ status: false,  message: 'show_order_type is wrong.',  })
        }  
        

        pool.query(order_typ_query, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;           

            if (count > 0) {
                
                var res = result.rows;
                var data = [];
                
                const total_profit = res[0].total_profit;
                const total_deposit = res[0].total_deposit;
                const total_withdrawal = res[0].total_withdrawal;
                const total_loss = res[0].total_loss;
                const netprofit_loss = Number(total_profit) + Number(total_loss);
                const net_profit_loss = netprofit_loss > 0 ? `+${netprofit_loss.toFixed(2)}` : `${netprofit_loss.toFixed(2)}`;
                const profit_loss_type = total_profit > total_loss ? `profit` : `loss`;
                const top_date = moment(res[0].closed_order_datetime != null ? res[0].closed_order_datetime : res[0].open_order_datetime ).utcOffset("+05:30").format('YYYY/MM/DD')

                res.forEach((table) => {

                    if (table.currencypair_image == null) {
                        var currencypair_image = "";
                    } else {
                        var currencypair_image = base_img_url + '/currencypair_image/' + table.currencypair_image;
                    }
                    if (table.take_profit_status == 'yes') {
                        var takeprofit_val = table.take_profit.toFixed(2);
                        var takeprofit_price = table.take_profit_price.toString();
                    } else {
                        var takeprofit_val = "-";
                        var takeprofit_price = "-";
                    }
                    if (table.stop_loss_status == 'yes') {
                        var stoploss_val = table.stop_loss.toFixed(2);
                        var stoploss_price = table.stop_loss_price.toString();
                    } else {
                        var stoploss_val = "-";
                        var stoploss_price = "-";
                    }

                    if (show_order_type != 'position') {
                        var duplicate_order_id = table.tbl_duplicate_order_id;
                        var dealid = table.deal_id;
                        var typ = table.dp_type;
                        var typ_inout = table.type_inout;
                        
                    } else {
                        var duplicate_order_id = "0";
                        var dealid = "0";
                        var typ = table.type;
                        var typ_inout = "";
                    }

                    

                    let cat = {
                        tbl_duplicate_order_id: isNull(duplicate_order_id),
                        deal_id: isNull(dealid),
                        type_inout: isNull(typ_inout),
                        type: isNull(typ),
                        tbl_order_id: isNull(table.tbl_order_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        order_id: isNull(table.order_id),
                        currency_pair: isNull(table.currency_pair),
                        currencypair_image: currencypair_image,
                        currency_type: isNull(table.currency_type),
                        margin: table.margin.toFixed(2),
                        leverage_ratio: table.leverage_ratio,
                        exchange_rate: table.exchange_rate,
                        open_price: table.open_price,
                        quote_currency: isNull(table.quote_currency),
                        quote_currency_amount: table.quote_currency_amount,
                        quote_currency_amount_in_usd: table.quote_currency_amount_in_usd,
                        profit_type: isNull(table.profit_type),
                        profit_loss_value: table.profit_loss_value,
                        closed_price: table.closed_price,
                        tradesize_lots: table.tradesize_lots.toFixed(2),
                        commission: table.admin_commission.toFixed(2),
                        take_profit_status: isNull(table.take_profit_status),
                        stop_loss_status: isNull(table.stop_loss_status),
                        stop_loss_price: stoploss_price,
                        stop_loss: stoploss_val,
                        take_profit_price: takeprofit_price,
                        take_profit: takeprofit_val,
                        closed_by: isNull(table.closed_by),
                        // open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                        // closed_date_time: moment(table.closed_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                        open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('YYYY.MM.DD HH:mm:ss'),
                        closed_date_time: moment(table.closed_order_datetime).utcOffset("+05:30").format('YYYY.MM.DD HH:mm:ss')
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, show_order_type : show_order_type, total_count : count, total_profit: total_profit.toFixed(2), deposit : total_deposit.toFixed(2), withdrawal : total_withdrawal.toFixed(2), total_loss: total_loss.toFixed(2), net_profit_loss: net_profit_loss, profit_loss_type: profit_loss_type, date: top_date, message: 'Meta RG Closed order list API', data: data, });
            } else {
                return response.status(201).json({ status: false, show_order_type : show_order_type, total_count : 0, total_profit: "0.00", deposit: "0.00", withdrawal : "0.00", total_loss: "0.00", net_profit_loss: "0.00", message: 'Meta RG Order not found', data: [], })
            }
        })
    },


    closed_order_details_API: (request, response) => {

        const { tbl_user_id, login_id, order_id } = request.body;


        pool.query(`SELECT (SELECT currencypair_image FROM tbl_currencypair_logo where status = '1'
        AND currencypair = tbl_order.currency_pair), * FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_id = '${order_id}' AND order_status = 'closed'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;

            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {
                    if (table.currencypair_image == null) {
                        var currencypair_image = "";
                    } else {
                        var currencypair_image = base_img_url + '/currencypair_image/' + table.currencypair_image;
                    }
                    if (table.take_profit_status == 'yes') {
                        var takeprofit_val = table.take_profit.toFixed(2);
                        var takeprofit_price = table.take_profit_price.toString();
                    } else {
                        var takeprofit_val = "-";
                        var takeprofit_price = "-";
                    }
                    if (table.stop_loss_status == 'yes') {
                        var stoploss_val = table.stop_loss.toFixed(2);
                        var stoploss_price = table.stop_loss_price.toString();
                    } else {
                        var stoploss_val = "-";
                        var stoploss_price = "-";
                    }

                    let cat = {
                        tbl_order_id: isNull(table.tbl_order_id),
                        tbl_user_id: isNull(table.tbl_user_id),
                        login_id: isNull(table.login_id),
                        order_id: isNull(table.order_id),
                        type: isNull(table.type),
                        currencypair_image: currencypair_image,
                        currency_pair: isNull(table.currency_pair),
                        currency_type: isNull(table.currency_type),
                        margin: table.margin.toFixed(2),
                        leverage_ratio: table.leverage_ratio,
                        exchange_rate: table.exchange_rate,
                        open_price: table.open_price,
                        profit_type: isNull(table.profit_type),
                        commission: table.admin_commission.toFixed(2),
                        profit_loss_value: table.profit_loss_value,
                        closed_price: table.closed_price,
                        tradesize_lots: table.tradesize_lots.toFixed(2),
                        take_profit_status: isNull(table.take_profit_status),
                        stop_loss_status: isNull(table.stop_loss_status),
                        stop_loss_price: stoploss_price,
                        stop_loss: stoploss_val,
                        take_profit_price: takeprofit_price,
                        take_profit: takeprofit_val,
                        closed_by: isNull(table.closed_by),
                        open_date_time: moment(table.open_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a'),
                        closed_date_time: moment(table.closed_order_datetime).utcOffset("+05:30").format('D-MMMM-YYYY h:mm:ss a')
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, message: 'Closed order details API', data: data });
            } else {
                return response.status(201).json({ status: false, message: 'Order not found', data: [] })
            }
        })
    },

    delete_pending_order_API: (request, response) => {

        const { tbl_user_id, login_id, order_id } = request.body;

        pool.query(`SELECT * FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_id = '${order_id}' AND order_status = 'pending'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;
            if (count > 0) {
                pool.query(`DELETE from tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_id = '${order_id}' AND order_status = 'pending'`,
                    async (error, order_res) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }
                        if (order_res.rowCount > 0) {
                            return response.status(201).json({ status: true, message: 'Order successfully deleted.', });
                        } else {
                            return response.status(201).json({ status: false, message: 'Something Error', });
                        }
                    });
            } else {
                return response.status(201).json({ status: false, message: 'Order Id is wrong!' });
            }
        })
    },

    currencypair_image_list_api: async (request, response) => {

        const { tbl_user_id } = request.body;

        const img_query = await pool.query(`SELECT * FROM tbl_currencypair_logo where status = '1'`);

        if (img_query.rowCount > 0) {
            const res = img_query.rows;
            const data = [];
            res.forEach((table) => {
                let img_dat = {
                    tbl_currencypair_logo_id: isNull(table.tbl_currencypair_logo_id),
                    currencypair: isNull(table.currencypair),
                    currencypair_image: base_img_url + '/currencypair_image/' + table.currencypair_image,
                    status: table.status
                }
                data.push(img_dat);
            })
            return response.status(201).json({ status: true, message: 'Currencypair logo list', data: data })
        } else {
            return response.status(201).json({ status: false, message: 'data not found', data: [] })
        }
    },

    currencypair_list_api: async (request, response) => {

        const { tbl_user_id } = request.body;

        const img_query = await pool.query(`SELECT tbl_market_live_rate.*,(SELECT symbol FROM tbl_watch_list where tbl_user_id ='${tbl_user_id}' AND symbol = tbl_market_live_rate.currency_pair) AS symbol_added FROM tbl_market_live_rate where status = '1'`);

        if (img_query.rowCount > 0) {
            const res = img_query.rows;
            const data = [];
            res.forEach((table) => {
                

                if(table.symbol_added!=null)
                {
                    var alredy_added = 'yes';
                }else{
                    var alredy_added = 'no';
                }
                let img_dat = {
                    tbl_market_live_rate_id: isNull(table.tbl_market_live_rate_id),
                    currency_pair: isNull(table.currency_pair),
                    alredy_added: isNull(alredy_added),
                }
                data.push(img_dat);
            })
            return response.status(201).json({ status: true, message: 'Currencypair list', data: data })
        } else {
            return response.status(201).json({ status: false, message: 'data not found', data: [] })
        }
    },

    add_to_watchlist_api: (request, response) => {

        const { tbl_user_id, symbol } = request.body;

        pool.query(`SELECT * FROM tbl_watch_list WHERE tbl_user_id = '${tbl_user_id}' AND symbol = '${symbol}'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;
            if (count > 0) {

                return response.status(201).json({ status: false, message: 'Already Added', });

            } else {

                pool.query(`INSERT INTO tbl_watch_list(tbl_user_id,symbol)VALUES('${tbl_user_id}','${symbol}')`,
                    async (error, order_res) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }
                        if (order_res.rowCount > 0) {
                            return response.status(201).json({ status: true, message: 'Added successfully.', });
                        } else {
                            return response.status(201).json({ status: false, message: 'Something Error', });
                        }
                    });

            }
        })
    },

    remove_from_watchlist_api: (request, response) => {

        const { tbl_user_id, symbol } = request.body;

        pool.query(`SELECT * FROM tbl_watch_list WHERE tbl_user_id = '${tbl_user_id}' AND symbol = '${symbol}'`, async (error, result) => {

            if (error) { throw error }
            var count = result.rowCount;
            if (count > 0) {

                pool.query(`DELETE from tbl_watch_list WHERE tbl_user_id = '${tbl_user_id}' AND symbol = '${symbol}'`,
                    async (error, order_res) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }
                        if (order_res.rowCount > 0) {
                            return response.status(201).json({ status: true, message: 'Remove successfully.', });
                        } else {
                            return response.status(201).json({ status: false, message: 'Something Error', });
                        }
                    });

            } else {

                return response.status(201).json({ status: false, message: 'Already deleted', });

            }
        })
    },




};