"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const helpers_1 = require("./helpers");
const pool_1 = require("./pool");
class MT5WebClient extends pool_1.MTPool {
    constructor(config, maxPoolSize = 20) {
        super(config.host, config.port, config.login, config.password, maxPoolSize);
        this.getSymbolState = (mask = '*') => this.request('/api/tick/stat?symbol=' + mask);
        this.getHistoryCandlesInParallel = (symbol, _from, _to) => __awaiter(this, void 0, void 0, function* () {
            const minmax = [(0, helpers_1.floorToMultiple)(_from, 60), (0, helpers_1.cielToMultiple)(_to, 60)];
            const r = [];
            let i = _from;
            const step = 200 * 1000 * 60; // max 200,000 bar per request
            while (i < minmax[1]) {
                r.push([i, i + step]);
                i += step;
            }
            const lastR = r.pop();
            if (!lastR || lastR.length !== 2) {
                throw new Error('Invalid range');
            }
            r.push([lastR[0], Math.min(lastR[1], minmax[1])]);
            const tz = yield this.TZ;
            // I have chunks of from to.. lets call
            const chunks = yield Promise.all(r.map(([from, to]) => {
                return this.request(`/api/chart/get?symbol=${symbol}&from=${from + tz}&to=${to + tz}&data=dohlctv`).then(r => r.answer);
            }));
            return chunks.reduce((carry, chunk) => carry.concat(chunk), []);
        });
        this.getHistoryCandles = (symbol, _from, _to) => __awaiter(this, void 0, void 0, function* () {
            const now = _to || Math.ceil(Date.now() / 1000) + (yield this.TZ);
            const result = this.request(`/api/chart/get?symbol=${symbol}&from=${_from}&to=${now}&data=dohlctv`).then(r => {
                return r;
            });
            return result;
        });
        this.getGroup = (name) => this.request('/api/group/get?group=' + name).then(r => {
            let result = r.answer;
            if (!result || !result.Group) {
                throw new Error('Group not found');
            }
            return result;
        });
        this.getOrders = (logins, groupName) => {
            return this.request(`/api/order/get_batch?login=${logins.join(',')}&group=${groupName}`);
        };
        this.getLastTick = (symbol, group) => this.request(`/api/tick/last_group?symbol=${symbol}&group=` + group);
        this.getSymbol = (symbol, group) => __awaiter(this, void 0, void 0, function* () {
            const url = group
                ? `/api/symbol/get_group?symbol=${encodeURIComponent(symbol)}&group=` + encodeURIComponent(group)
                : `/api/symbol/get?symbol=${encodeURIComponent(symbol)}`;
            return this.request(url);
        });
        this.getPositions = (logins, groupName) => this.request(`/api/position/get_batch?login=${logins.join(',')}&group=${groupName}`).then(r => r.answer);
        this.getAccounts = (groupName) => this.request(`/api/user/account/get_batch?group=${groupName}`).then(r => r.answer);
        this.getAccountDeals = (account, from, to) => __awaiter(this, void 0, void 0, function* () {
            let result = [];
            const params = `from=${from}&to=${to}&login=${String(account)}`;
            const total = Number((yield this.request(`/api/deal/get_total?${params}`)).answer.total) || 0;
            let hasmore = total > result.length;
            let maxPages = 10;
            while (hasmore && maxPages-- > 0) {
                yield this.request(`/api/deal/get_page?offset=${result.length}&${params}`).then(data => {
                    if (!Array.isArray(data.answer))
                        throw new Error('no answer');
                    result = result.concat(data.answer);
                    hasmore = total > result.length;
                });
            }
            return result;
        });
    }
    getPositionsByLogin(login) {
        return this.request(`/api/position/get?login=${login}`).then(data => data.answer);
    }
    getOrdersByLogin(login) {
        return this.request(`/api/order/get?login=${login}`).then(data => data.answer);
    }
}
exports.default = MT5WebClient;
// const mt = new MT5WebClient({
//   login: '1086',
//   password: 'Forex1234#!',
//   host: 'amana-mt5-live.amanalabs.net', // "157.175.246.82", //
//   port: 443,
// });
// mt.request<MT.SymbolInfo[]>('/api/symbol/get?mask=*').then(console.log);
// const grp = Group.getInstance('Test\\MobileApp-Net-LIVE', mt);
