var express = require('express');
var app = express();
const path = require('path');
const pg = require('pg');
const cors = require("cors");

app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});

app.use(function(req, res, next) {
    res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
});

app.use(cors());

const dbconfig = require('../db');
const pool = new pg.Pool(dbconfig);

const checkauth = require('./api/auth/jwt_auth');
const validation = require('./api/middleware/validation');

app.use(cors());
app.use(express.static(path.join(__dirname, 'views')));



const base_img_url = 'http://35.154.239.62:8152/files/upload';
const Authorization_firbase_key = `key=AAAAfbDRXnM:APA91bGrXtxC2wBfpZ-50MUCuVjcPR_HwvRBu8_FtMU3PMLYsaVLRKL1P_Z63DP9p3i3mQliISiDP2gQWV4SbnBy4uQUbV_xFH94K22MHD5NGzE-W--tU0JXE5H4az9sr6UZzP8jnqgP`

//const notification_function = require('./api/notification_function');
/// new code for firebase notification
//notification_function.send_notification(147, 'wallet transfer', 'wallet_transfer', 'You have transferred an amount of 300 to 632838 in 246138');

/// new code for firebase notification


module.exports = {
    base_img_url : base_img_url,
    Authorization_firbase_key : Authorization_firbase_key,
}
 
var bodyParser = require('body-parser');
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
var port = process.env.PORT || 8152;
//const app = express.Router();

pool.connect((err, client, release) => {
    if (err) {
        return console.error('Error acquiring client', err.stack)
    }
    client.query('SELECT NOW()', (err, result) => {
        release()
        if (err) {
            return console.error('Error executing query', err.stack)
        }
        console.log("Connected to Database !")
    })
});

    app.get('/user_data',cors(), function(req, res) {
        console.log("Zerogravity user API is Online!") ;
        res.status(200).json({ message: 'Zerogravity User API is Online!' });
    });

   var updatemarket_rateAPI = require('./api/update_market_liverate');


   var usersAPI = require('./api/user_data');
   app.get('/user_data/check_version_API', cors(), usersAPI.check_version_API);
   app.post('/user_data/mlm_signup_API', validation.mlm_signup_API, cors(), usersAPI.mlm_signup_API);
   app.post('/user_data/mlm_userdetail_API', cors(), usersAPI.mlm_userdetail_API);
   app.post('/user_data/signup_API', cors(), validation.signup_API, usersAPI.signup_API);
   app.post('/user_data/IB_registration_API', cors(), usersAPI.IB_registration_API);
   app.post('/user_data/Manager_registration_API', cors(), usersAPI.Manager_registration_API);
   app.post('/user_data/otp_verify', cors(), validation.otp_verify, usersAPI.otp_verify);
   app.post('/user_data/Resend_email_otp_API', cors(), validation.email_validation, usersAPI.Resend_email_otp_API);
   app.post('/user_data/Login_API', cors(), validation.Login_API, usersAPI.Login_API);
   app.post('/user_data/IB_Login_API', cors(), validation.Login_API, usersAPI.IB_Login_API);
   app.post('/user_data/Manager_Login_API', cors(), validation.Login_API, usersAPI.Manager_Login_API);
   app.post('/user_data/myprofile_API', cors(), checkauth.checkauth, validation.user_id_validaion, usersAPI.myprofile_API);
   app.get('/user_data/document_type_API', cors(), usersAPI.document_type_API);
   app.post('/user_data/user_verification_API', cors(),  usersAPI.user_verification_API);
   app.post('/user_data/upload_user_image', cors(),  usersAPI.upload_user_image);
   app.post('/user_data/forgot_password_API', cors(),  usersAPI.forgot_password_API);
   app.post('/user_data/social_Login_signup_API', cors(), validation.social_Login_signup_API, usersAPI.social_Login_signup_API);
   app.post('/user_data/update_social_profile_API', cors(), validation.update_social_profile_API, usersAPI.update_social_profile_API);
   app.post('/user_data/Update_transfer_pin_API', cors(), validation.Update_transfer_pin_API, usersAPI.Update_transfer_pin_API);
   app.post('/user_data/Check_user_via_username_API', cors(), validation.Check_user_via_username_API, usersAPI.Check_user_via_username_API);
   app.post('/user_data/Check_user_via_account_id_API', cors(), validation.Check_user_via_account_id_API, usersAPI.Check_user_via_account_id_API);
   app.post('/user_data/amount_transfer_fee_api', cors(), validation.amount_transfer_fee_api, usersAPI.amount_transfer_fee_api);
   app.post('/user_data/requset_delete_account_API', cors(), validation.requset_delete_account_validaion, usersAPI.requset_delete_account_API);
   app.post('/user_data/trading_account_Login_API', cors(), validation.trading_account_Login_API, usersAPI.trading_account_Login_API);

   var walltAPI = require('./api/wallet_data');
   app.get('/wallet_data/deposit_address_API', cors(), walltAPI.deposit_address_API);
   app.post('/wallet_data/mlm_user_deposit', cors(), validation.mlm_deposit_amount_API, walltAPI.mlm_deposit_amount_API);
   app.post('/wallet_data/deposit_amount_API', cors(), checkauth.checkauth, validation.deposit_amount_API, walltAPI.deposit_amount_API);
   app.post('/wallet_data/withdrawal_amount_API', cors(), checkauth.checkauth, validation.withdrawal_amount_API, walltAPI.withdrawal_amount_API);
   app.post('/wallet_data/All_deposit_list_API', cors(), checkauth.checkauth, validation.user_id_validaion, walltAPI.All_deposit_list_API);
   app.post('/wallet_data/All_deposit_list_by_mt5_account_API', cors(), checkauth.checkauth, validation.All_deposit_list_by_mt5_account_API, walltAPI.All_deposit_list_by_mt5_account_API);

   app.post('/wallet_data/All_withdrawal_list_API', cors(), checkauth.checkauth, validation.user_id_validaion, walltAPI.All_withdrawal_list_API);

   app.post('/wallet_data/All_withdrawal_list_by_mt5_account_API', cors(), checkauth.checkauth, validation.All_withdrawal_list_by_mt5_account, walltAPI.All_withdrawal_list_by_mt5_account_API);
   app.post('/wallet_data/Wallet_to_wallet_amount_transfer_api', cors(), checkauth.checkauth, validation.Wallet_to_wallet_amount_transfer_api, walltAPI.Wallet_to_wallet_amount_transfer_api);
   app.post('/wallet_data/Wallet_to_wallet_transfer_history_api', cors(), validation.Wallet_to_wallet_history, walltAPI.Wallet_to_wallet_transfer_history_api);
   app.post('/wallet_data/Wallet_to_wallet_recived_history_api', cors(), validation.Wallet_to_wallet_history, walltAPI.Wallet_to_wallet_recived_history_api);
   app.post('/wallet_data/mlm_user_deposit', cors(), validation.mlm_deposit_amount_API, walltAPI.mlm_deposit_amount_API);
   app.post('/wallet_data/mlm_withdrawal_amount_API', cors(), walltAPI.mlm_withdrawal_amount_API);


   var firebaseAPI = require('./api/firebase_data');
   app.get('/firebase_data/push_data_in_firebsa_API', cors(), firebaseAPI.push_data_in_firebsa_API);

   var currency_convertedAPI = require('./api/currency_converted_data');
   app.get('/currency_converted_data/currency_convert_to_usd_api', cors(), currency_convertedAPI.currency_convert_to_usd_api);
   app.get('/currency_converted_data/currency_convert_to_usd_exchangerate_api', cors(), currency_convertedAPI.currency_convert_to_usd_exchangerate_api);



   var tradeAPI = require('./api/trading_data');

   //// this api for testing
   // app.post('/trading_data/calculate_test_sell_limit_stop_order_preview_API',  cors(), validation.calculate_sell_limit_stop_order_preview, tradeAPI.calculate_test_sell_limit_stop_order_preview_API);

   app.post('/trading_data/edit_test_calculate_sell_buy_market_order_preview_API',  cors(), validation.edit_calculate_sellbuy_market_order_preview, tradeAPI.edit_test_calculate_sell_buy_market_order_preview_API);

   app.post('/trading_data/calculate_test_buy_limit_stop_order_preview_API',  cors(), validation.calculate_buy_limit_stop_order_preview, tradeAPI.calculate_test_buy_limit_stop_order_preview_API);
   //// this api for testing

   app.post('/trading_data/currencypair_image_list_api',  cors(), validation.user_id_validaion, tradeAPI.currencypair_image_list_api);
   app.post('/trading_data/check_order_type_API',  cors(), validation.check_order_type, tradeAPI.check_order_type_API);
   app.post('/trading_data/claculate_order_preview_API',  cors(), validation.claculate_order_preview, tradeAPI.claculate_order_preview_API);
   app.post('/trading_data/user_account_details_by_loginid_API',  cors(), validation.user_account_details_by_loginid, tradeAPI.user_account_details_by_loginid_API);
   app.post('/trading_data/confirm_order_API',  cors(), validation.confirm_order, tradeAPI.confirm_order_API);
   app.post('/trading_data/order_list_by_type_API',  cors(), validation.order_list_by_type, tradeAPI.order_list_by_type_API);
   app.post('/trading_data/close_order_API',  cors(), validation.close_order, tradeAPI.close_order_API);
   app.post('/trading_data/closed_order_list_API',  cors(), validation.closed_order_list, tradeAPI.closed_order_list_API);
  
   app.post('/trading_data/closed_order_list_new_API',  cors(),  tradeAPI.closed_order_list_new_API);
   app.post('/trading_data/closed_order_details_API',  cors(), validation.closed_order_detail, tradeAPI.closed_order_details_API);
   app.post('/trading_data/delete_pending_order_API',  cors(), validation.closed_order_detail, tradeAPI.delete_pending_order_API);
   app.post('/trading_data/calculate_sell_buy_market_order_preview_API',  cors(), validation.calculate_sell_buy_market_order_preview, tradeAPI.calculate_sell_buy_market_order_preview_API);
   app.post('/trading_data/calculate_sell_buy_without_type_market_order_preview_API',  cors(), validation.calculate_sell_buy_without_type_market_order_preview, tradeAPI.calculate_sell_buy_without_type_market_order_preview_API);
   app.post('/trading_data/edit_calculate_sell_buy_market_order_preview_API',  cors(), validation.edit_calculate_sellbuy_market_order_preview, tradeAPI.edit_calculate_sell_buy_market_order_preview_API);
   app.post('/trading_data/edit_order_API',  cors(), validation.edit_order_API, tradeAPI.edit_order_API);
   app.post('/trading_data/metarg_closed_order_list_API',  cors(), validation.metarg_closed_order_list, tradeAPI.metarg_closed_order_list_API);
   app.post('/trading_data/calculate_sell_limit_stop_order_preview_API',  cors(), validation.calculate_sell_limit_stop_order_preview, tradeAPI.calculate_sell_limit_stop_order_preview_API);
   app.post('/trading_data/calculate_buy_limit_stop_order_preview_API',  cors(), validation.calculate_buy_limit_stop_order_preview, tradeAPI.calculate_buy_limit_stop_order_preview_API);
   app.post('/trading_data/currencypair_image_list_api',   cors(), validation.user_id_validaion, tradeAPI.currencypair_image_list_api);
   app.post('/trading_data/add_to_watchlist_api',   cors(),  validation.add_to_watchlist_api, tradeAPI.add_to_watchlist_api);
   app.post('/trading_data/remove_from_watchlist_api',   cors(),  validation.add_to_watchlist_api, tradeAPI.remove_from_watchlist_api);
   app.post('/trading_data/currencypair_list_api',   cors(), validation.user_id_validaion, tradeAPI.currencypair_list_api);



   var mt5_data = require('./api/mt5_data');
//    app.post('/mt5_data/mt5_add_user_API', cors(), validation.mt5_add_user_API, mt5_data.mt5_add_user_API);
   app.post('/mt5_data/mt5_new_add_user_API', cors(), validation.mt5_new_add_user_API, mt5_data.mt5_new_add_user_API);
   app.post('/mt5_data/mlm_update_amount_API', cors(), validation.mlm_update_amount_API, mt5_data.mlm_update_amount_API);
   app.get('/mt5_data/leverage_API', cors(),  mt5_data.leverage_API);   
   app.post('/mt5_data/mt5_account_list_API', cors(), validation.user_id_validaion, mt5_data.mt5_account_list_API);   
   app.get('/mt5_data/add_market_data_via_mt5_API', cors(), mt5_data.add_market_data_via_mt5_API);
   app.get('/mt5_data/Market_data_API', cors(), mt5_data.Market_data_API);
   app.post('/mt5_data/updated_wallet_balace_api', cors(), mt5_data.updated_wallet_balace_api);

   app.post('/mt5_data/info_account_details_API', cors(), validation.user_id_validaion, mt5_data.info_account_details_API);

   var bannerapi = require('./api/banner_data');
   app.post('/banner_data/banner_list_API', cors(), validation.user_id_validaion, bannerapi.banner_list_API);

   var notiapi = require('./api/notification_data');
   app.post('/notification_data/notification_list_api', cors(), validation.user_id_pagination_validaion, notiapi.notification_list);


   var couponapi = require('./api/coupon_data');
   app.post('/coupon_data/apply_coupon_API', cors(), validation.apply_coupon_API,  couponapi.apply_coupon_API);
   
   var atupdtordrapi = require('./api/auto_update_order_data');
   app.get('/auto_update_order_data/auto_update_pending_to_open_order_api', cors(),  atupdtordrapi.auto_update_pending_to_open_order_api);
   app.get('/auto_update_order_data/auto_update_tp_sl_order_api', cors(),  atupdtordrapi.auto_update_tp_sl_order_api);


  const tiingo_api = require('./api/tiingo_history_data');
  app.get('/tiingo_history_data/symbol_wise_history_data/:symbol/:startDate/:resampleFreq', cors(), tiingo_api.symbol_wise_history_data);

app.listen(port);
console.log('Listening on port ' + port);