const pg = require('pg');
const date = require('date-and-time');
const moment = require('moment');
const requests = require('request');

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}

const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

const { Authorization_key_for_firebase } = require('../zerogravity_admin_index');

function isNullNumber(item) {
    if (item) {
        return item.toString();
    } else {
        return "0";
    }
}


module.exports = {


    check_login_id_API: (request, response) => {

        const { tbl_admin_id, login_id } = request.body;

        console.log('check_user_name_API', request.body);

        pool.query(`SELECT * FROM tbl_mt5_user where login_id ='${login_id}' AND status = '1'`, async(error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }

            var count = result.rowCount;
            if (count > 0) {
                var res = result.rows;
                var data = [];

                res.forEach(function (table) {
                    let cat = {
                        tbl_mt5_user_id: isNull(table.tbl_mt5_user_id),
                        login_id: isNull(table.login_id),                       
                        name: isNull(table.name)
                    };
                    data.push(cat);
                });
                return response.status(201).json({ status: true, message: 'Check login Id api', data: data })
            } else {
                return response.status(201).json({ status: false, message: 'Invalid login Id', data: [] })
            }
        });
    },

    ////////////////////////////////////////////// add gold coin by admin/agency //////////////////////////////////////////////////////////////////

    add_balance_to_mt5_login_id_API: async (request, response) => {
        
        try {
            const { tbl_admin_id, login_id, amount  } = request.body;   
            
            console.log('add_balance_to_mt5_login_id_API', request.body);

            const user_datails = await pool.query(`SELECT tbl_user_id, balance FROM tbl_mt5_user where login_id ='${login_id}' AND status = '1'`);

            if (user_datails.rowCount > 0) {

                const user_id = user_datails.rows[0].tbl_user_id;
                const deposit_type = 'USDT-TRX';
                const currency_type = 'crypto';
                const user_transection_address = 'tmfsdfafsdfhfgsdfggdfgerwtetty';
                const joining_time = moment().utcOffset("+05:30").format('LT');

                const insert_update_payment_query = await pool.query(`INSERT INTO tbl_deposit(tbl_user_id,deposit_type,currency_type,amount,mt5_number, user_transection_address, status, created_date, created_time, updated_by) VALUES('${user_id}', '${deposit_type}', '${currency_type}','${amount}','${login_id}', '${user_transection_address}', '2', now(), '${joining_time}', 'add_balance_by_admin');
                UPDATE tbl_mt5_user SET balance = balance + ${amount} WHERE login_id ='${login_id}';
                UPDATE tbl_user SET wallet_amount = wallet_amount + ${amount} WHERE tbl_user_id ='${user_id}';
                `);

                if (insert_update_payment_query[0].rowCount > 0) {
                   return response.status(201).json({ status: true, message: `Amount of ${amount} has been added by admin to wallet Successfully.` });
                }
                else {
                    response.status(201).json({ status: false, message: 'Something Error to add amount in wallet' })
                }

            } else {
                return response.status(201).json({ status: false, message: 'login_id is not exit', data: [] });
            }

          
        } catch (error) {
            return response.status(500).json({ status: false, message: 'Something went wrong', error: error });
        }
    },


    agency_add_coin_to_user_wallet_API: async (request, response) => {

        try {
            const { tbl_user_id, tbl_agency_id, gold_coin } = request.body;

           const  ck_agency_wallet = await pool.query(`SELECT wallet_coin FROM tbl_agency where tbl_agency_id ='${tbl_agency_id}' AND wallet_coin > '${gold_coin}'`);

            if(ck_agency_wallet.rowCount > 0){            

                const user_datails = await pool.query(`SELECT tbl_user_id,firebase_token,wallet_coin FROM tbl_user where tbl_user_id ='${tbl_user_id}' AND status = '1'`);

                if (user_datails.rowCount > 0) {

                    const insert_update_payment_query = await pool.query(`INSERT INTO tbl_coin_add_history(sender_id,sender_type,tbl_user_id,gold_coin) VALUES('${tbl_agency_id}', 'agency', '${tbl_user_id}', '${gold_coin}');
                    UPDATE tbl_user SET wallet_coin = wallet_coin + ${gold_coin} WHERE tbl_user_id = '${tbl_user_id}';
                    UPDATE tbl_agency SET wallet_coin = wallet_coin - ${gold_coin} WHERE tbl_agency_id ='${tbl_agency_id}'`);

                    if (insert_update_payment_query[0].rowCount > 0) {

                        // notification code start from here 

                        const title = '💰💰 Coin Added Successfully!';
                        const notification_type = 'coin_added';
                        const notification_text = `Coin of ${gold_coin} has been added by agency to wallet Successfully.`;

                        // start notification code  for user

                        var options = {
                            'method': 'POST',
                            'url': 'https://fcm.googleapis.com/fcm/send',
                            'headers': {
                                'Content-Type': 'application/json',
                                'Authorization': Authorization_key
                            },
                            body: JSON.stringify({
                                "to": user_datails.rows[0].firebase_token,
                                "priority": "high",
                                "collapse_key": "type_a",
                                "notification": {

                                    "body": notification_text,
                                    "title": title,
                                    "notification_type": notification_type,
                                    "extra_params": ''
                                },
                                "data": {
                                    "body": notification_text,
                                    "title": title,
                                    "notification_type": notification_type,
                                    "extra_params": ''
                                }
                            })

                        };

                        requests(options, function (error, response2) {
                            if (error) {
                                res.json({ status: false, message: error })
                            }
                            console.log(response2.body);

                        });


                        const user_notification_query = await pool.query(`INSERT INTO tbl_notification (notification_type,tbl_user_id,notification_msg) VALUES ('${notification_type}','${tbl_user_id}',$$${notification_text}$$);`);

                        //  notification code end here 
                        response.status(201).json({ status: true, message: `Coin of ${gold_coin} has been added by agency to wallet Successfully.` });

                    }
                    else {
                        response.status(201).json({ status: false, message: 'Something Error to add coin in wallet' })
                    }

                } else {
                   return response.status(201).json({ status: false, message: 'tbl_user_id is not exit', data: [] });
                }

            } else {
                return response.status(201).json({ status: false, message: `You don't have enough coin to send in your wallet!`, data: [] });
            }
        } catch (error) {
            return response.status(500).json({ status: false, message: 'Something went wrong', error: error });
        }
    },

};