const pg = require('pg');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const formidable = require('formidable');
const AWS = require('aws-sdk');
const crypto = require("crypto");
const requests = require('request');
const moment = require('moment');
const now = new Date();

function isNull(item) {
  if (item) {
    return item;
  } else {
    return "";
  }
}

function isNullnumber(item) {
  if (item) {
    return item;
  } else {
    return "0";
  }
}

const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

const mailconfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailconfig);




module.exports = {

  add_banner_API: (request, response) => {

    const form = formidable({ multiples: true });

    form.parse(request, (err, fields, files) => {
      if (err) { 
        return response.status(403).json({ status: false, message: err, })
      }


      if (fields.title == '' || fields.title == null || fields.title == undefined) {
        return response.status(400).json({ status: false, message: 'title is required', })
      }

      if (fields.type == '' || fields.type == null || fields.type == undefined) {
        return response.status(400).json({ status: false, message: 'type is required', })
      }

      if (files.banner_image == '' || files.banner_image == null || files.banner_image == undefined) {
        return response.status(400).json({ status: false, message: 'banner_image is required', });
      }

      pool.query(`SELECT title FROM tbl_promotion_banner WHERE title = '${fields.title}'`, async (error, result) => {

        if (error) {
          return response.status(403).json({ status: false, message: error, });
        }
        var count = result.rowCount;
        if (count > 0) {
          return response.status(201).json({ status: false, message: 'Same baner title is already exist.' });
        } else {

         const fileName = files.banner_image.path;
         const typefile = files.banner_image.type
         const fileContent = fs.readFileSync(fileName)
         var type = typefile.split("/");
         var imagename = Math.floor(10000000 + Math.random() * 90000000);
         const filenames = imagename + '.' + type[1];

         fs.writeFile(`.././user/views/files/upload/banner_image/${filenames}`, fileContent, (err) => {
            if (err) {
              console.error(err);
            }
         });

         const add_ban_info = await pool.query(`INSERT INTO tbl_promotion_banner(title, type, banner)VALUES('${fields.title}',  '${fields.type}','${filenames}')`);

          if (add_ban_info.rowCount > 0) {
           response.status(201).json({ status: true, message: 'Banner is added successfully.' });
          } else {
           response.status(201).json({ status: false, message: 'Banner is not added.' });
          }
        }
      })
    });
  },



  update_banner_API: (request, response) => {

    const form = formidable({ multiples: true });

    form.parse(request, (err, fields, files) => {
      if (err) { 
        return response.status(403).json({ status: false, message: err, })
      }

      if (fields.tbl_promotion_banner_id == '' || fields.tbl_promotion_banner_id == null || fields.tbl_promotion_banner_id == undefined) {
        return response.status(400).json({ status: false, message: 'tbl_promotion_banner_id is required', })
      }

      if (fields.title == '' || fields.title == null || fields.title == undefined) {
        return response.status(400).json({ status: false, message: 'title is required', })
      }

      if (fields.type == '' || fields.type == null || fields.type == undefined) {
        return response.status(400).json({ status: false, message: 'type is required', })
      }

      if (fields.status == '' || fields.status == null || fields.status == undefined) {
        return response.status(400).json({ status: false, message: 'status is required', });
      }

      pool.query(`SELECT tbl_promotion_banner_id FROM tbl_promotion_banner WHERE tbl_promotion_banner_id = '${fields.tbl_promotion_banner_id}'`, async (error, result) => {

        if (error) {
          return response.status(403).json({ status: false, message: error, });
        }
        var count = result.rowCount;
        if (count > 0) {

          if (files.banner_image != undefined) {

            const fileName = files.banner_image.path;
            const typefile = files.banner_image.type
            const fileContent = fs.readFileSync(fileName)
            var type = typefile.split("/");
            var imagename = Math.floor(10000000 + Math.random() * 90000000);
            const filenames = imagename + '.' + type[1];

            fs.writeFile(`.././user/views/files/upload/banner_image/${filenames}`, fileContent, (err) => {
              if (err) {
                console.error(err);
              }
            });

            const Update_ban_info = await pool.query(`UPDATE tbl_promotion_banner SET title = '${fields.title}',  type = '${fields.type}', banner = '${filenames}', status = '${fields.status}' WHERE tbl_promotion_banner_id = '${fields.tbl_promotion_banner_id}'`);

            if (Update_ban_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Banner is updated successfully' });
            } else {
              response.status(201).json({ status: false, message: 'Banner is not updated' });
            }
          } else {
           
            const Update_ban_info = await pool.query(`UPDATE tbl_promotion_banner SET type = '${fields.type}', status = '${fields.status}' WHERE tbl_promotion_banner_id = '${fields.tbl_promotion_banner_id}'`);

            if (Update_ban_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Banner is updated successfully' });
            } else {
              response.status(201).json({ status: false, message: 'Banner is not updated' });
            }
          }
        } else {
          response.status(201).json({ status: false, message: 'Something went wrong!.' })
        }
      })
    });
  },

};