const pg = require('pg');
const multiparty = require('multiparty');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const formidable = require('formidable');

function isNull(item) {
  if (item) {
    return item;
  } else {
    return "";
  }
}

function isNullnumber(item) {
  if (item) {
    return item;
  } else {
    return "0";
  }
}

const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

const mailconfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailconfig);

module.exports = {

  add_currencypair_logo_API: (request, response) => {

    const form = formidable({ multiples: true });

    form.parse(request, (err, fields, files) => {
      if (err) { 
        return response.status(403).json({ status: false, message: err, })
      }
      if (fields.currency_pair == '' || fields.currency_pair == null || fields.currency_pair == undefined) {
        return response.status(400).json({ status: false, message: 'currency_pair is required', })
      }
      if (files.currency_pair_icon == '' || files.currency_pair_icon == null || files.currency_pair_icon == undefined) {
        return response.status(400).json({ status: false, message: 'currency_pair_icon is required', });
      }
      if (fields.currency_pair_icon_extention == '' || fields.currency_pair_icon_extention == null || fields.currency_pair_icon_extention == undefined) {
        return response.status(400).json({ status: false, message: 'currency_pair_icon_extention is required', });
      }

      const crncypair_name = fields.currency_pair.toUpperCase();

      pool.query(`SELECT currencypair FROM tbl_currencypair_logo WHERE currencypair = '${crncypair_name}'`, async (error, result) => {

        if (error) {
          return response.status(403).json({ status: false, message: error, });
        }
        var count = result.rowCount;
        if (count > 0) {
          return response.status(201).json({ status: false, message: 'Same currency_pair is already exist.'});
        } else {

         const fileName = files.currency_pair_icon.path;
         const typefile = files.currency_pair_icon.type
         const fileContent = fs.readFileSync(fileName)
         var type = typefile.split("/");
         var imagename = Math.floor(10000000 + Math.random() * 90000000);
         const filenames = imagename + '.' + fields.currency_pair_icon_extention;

         fs.writeFile(`.././user/views/files/upload/currencypair_image/${filenames}`, fileContent, (err) => {
            if (err) {
              console.error(err);
            }
         });

         const add_ban_info = await pool.query(`INSERT INTO tbl_currencypair_logo(currencypair, currencypair_image)VALUES('${crncypair_name}','${filenames}')`);

          if (add_ban_info.rowCount > 0) {
           response.status(201).json({ status: true, message: 'Currency pair icon is added successfully.' });
          } else {
           response.status(201).json({ status: false, message: 'Currency pair icon is not added.' });
          }
        }
      })
    });
  },


  update_currencypair_logo_API: (request, response) => {

    const form = formidable({ multiples: true });

    form.parse(request, (err, fields, files) => {
      if (err) { 
        return response.status(403).json({ status: false, message: err, })
      }

      if (fields.tbl_currencypair_logo_id == '' || fields.tbl_currencypair_logo_id == null || fields.tbl_currencypair_logo_id == undefined) {
        return response.status(400).json({ status: false, message: 'tbl_currencypair_logo_id is required', })
      }

      if (fields.currency_pair == '' || fields.currency_pair == null || fields.currency_pair == undefined) {
        return response.status(400).json({ status: false, message: 'currency_pair is required', })
      }
      

      const crncypair_name = fields.currency_pair.toUpperCase();

      if (fields.status == '' || fields.status == null || fields.status == undefined) {
        return response.status(400).json({ status: false, message: 'status is required', });
      }

      pool.query(`SELECT tbl_currencypair_logo_id FROM tbl_currencypair_logo WHERE currencypair = '${crncypair_name}' AND tbl_currencypair_logo_id != '${fields.tbl_currencypair_logo_id}'`, async (error, result) => {

        if (error) {
          return response.status(403).json({ status: false, message: error, });
        }
        var count = result.rowCount;
        if (count > 0) {
          return response.status(201).json({ status: false, message: 'Same currency_pair is already exist.'});
        } else {
          
          if (files.currency_pair_icon != undefined) {

            if (fields.currency_pair_icon_extention == '' || fields.currency_pair_icon_extention == null || fields.currency_pair_icon_extention == undefined) {
              return response.status(201).json({ status: false, message: 'currency_pair_icon_extention is required', });
            }

            const fileName = files.currency_pair_icon.path;
            const typefile = files.currency_pair_icon.type
            const fileContent = fs.readFileSync(fileName)
            var type = typefile.split("/");
            var imagename = Math.floor(10000000 + Math.random() * 90000000);
            const filenames = imagename + '.' + fields.currency_pair_icon_extention;

            fs.writeFile(`.././user/views/files/upload/currencypair_image/${filenames}`, fileContent, (err) => {
              if (err) {
                console.error(err);
              }
            });

            const Update_ban_info = await pool.query(`UPDATE tbl_currencypair_logo SET currencypair = '${crncypair_name}', currencypair_image = '${filenames}', status = '${fields.status}' WHERE tbl_currencypair_logo_id = '${fields.tbl_currencypair_logo_id}'`);

            if (Update_ban_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Currency pair icon is updated successfully' });
            } else {
              response.status(201).json({ status: false, message: 'Currency pair icon is not updated' });
            }
          } else {
            const Update_ban_info = await pool.query(`UPDATE tbl_currencypair_logo SET currencypair = '${crncypair_name}', status = '${fields.status}' WHERE tbl_currencypair_logo_id = '${fields.tbl_currencypair_logo_id}'`);

            if (Update_ban_info.rowCount > 0) {
              response.status(201).json({ status: true, message: 'Currency pair icon is updated successfully'});
            } else {
              response.status(201).json({ status: false, message: 'Currency pair icon is not updated' });
            }
          }
        }
      })
    });
  },
};