const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
const formidable = require('formidable');
const date = require('date-and-time');
const AWS = require('aws-sdk');
const crypto = require("crypto");





function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbConfig = require('../../db');
const pool = new pg.Pool(dbConfig);

module.exports = {

    document_type_list_API: (request, response) => {

        const { tbl_admin_id } = request.body;
    
        pool.query(`SELECT * FROM tbl_document_type ORDER BY tbl_document_type_id DESC `,(error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                var res = result.rows;
                var data = [];

                res.forEach((table)=> {

                    let lang = {
                        tbl_document_type_id: isNull(table.tbl_document_type_id),
                        document_name: isNull(table.document_name),
                        status: table.status
                    };
                    data.push(lang);

                });
                response.status(201).json({ status: true, message: 'Document Type List Data',  data: data });
            }else{
                response.status(201).json({ status: false, message: 'No reasul found', data: [] })
            }
        })
    },

    
    language_details_API: (request, response) => {

        const { tbl_language_id,tbl_admin_id } = request.body;
    
        pool.query(`SELECT * FROM tbl_language where tbl_language_id = $$${tbl_language_id}$$`,(error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {
    
                        let cat = {
                            tbl_language_id: isNull(table.tbl_language_id),
                            language_name: isNull(table.language_name),
                            status: table.status
                        };
                        data.push(cat);
    
                    });
    
                    response.status(201).json({ status: true, message: 'Language Details', data: data })
    
            }else{
                response.status(201).json({ status: false, message: 'No data', data: [] })
    
            }
    
        })
    },

    
    update_language_api: async(request, response) => {

        const { tbl_admin_id, tbl_language_id, language_name, status  } = request.body

        const ch_language = await pool.query(`SELECT tbl_language_id FROM tbl_language where language_name = $$${language_name}$$ and tbl_language_id != '${tbl_language_id}'`);

        if(ch_language.rowCount > 0){
            response.status(201).json({ status: false, message: 'Same language is already exist in your list.',  data: []  });
        }else{
            pool.query(`UPDATE tbl_language SET language_name = $$${language_name}$$,status = '${status}' WHERE tbl_language_id = '${tbl_language_id}'`, (error, result) => {

                if(result.rowCount > 0)
                {
                    response.status(201).json({ status: true, message: 'Language is updated succesfully.' })
                }else{
                    response.status(201).json({ status: false, message: 'something error' })
                }

            });
        }
    }, 
     
    add_language_api: async(request, response) => {

        const { tbl_admin_id, language_name  } = request.body

        const ch_language = await pool.query(`SELECT language_name FROM tbl_language where language_name = $$${language_name}$$`);

        if(ch_language.rowCount > 0){

            response.status(201).json({ status: false, message: 'Same language is already added in your list', });
            
        }else{
        
            pool.query(`INSERT INTO tbl_language(language_name)VALUES($$${language_name}$$)`, (error, result) => {

                if(result.rowCount > 0)
                {
                    response.status(201).json({ status: true, message: 'language is adeed succesfully.' })
                }else{
                    response.status(201).json({ status: false, message: 'something error' })
                }

            });
        }
    },


};