var express = require('express');
var app = express();
const path = require('path');
const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const cors=require("cors");
const nodeMailer = require('nodemailer');

app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});


// deposit address
// TVHEDuswbS9cLY1E5uovcBg28y8p9PUHQq //

app.use(function(req, res, next) {
    res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
});

const upload_pay_scr = multer({ dest: './views/files/upload/payment_screenshot' });
app.use(cors());
app.use(express.static(path.join(__dirname, 'views')));


const dbConfig = require('../db');
const pool = new pg.Pool(dbConfig);
const mailconfig = require('../mail');
const transporter = nodeMailer.createTransport(mailconfig);
const checkauth = require('./api/auth/jwt_auth');
const validation = require('./api/middleware/validation');

const all_user_notification = require('./api/all_user_notification_function'); 

// all_user_notification.send_notification_to_all_user('title', '50 USD to all users')

var bodyParser = require('body-parser');
app.use(bodyParser.urlencoded({ extended: true }));
app.use(bodyParser.json());
var port = process.env.PORT || 8159;
//const app = express.Router();

pool.connect((err, client, release) => {
    if (err) {
        return console.error(
            'Error acquiring client', err.stack)
    }
    client.query('SELECT NOW()', (err, result) => {
        release()
        if (err) {
            return console.error('Error executing query', err.stack)
        }
        console.log("Connected to Database !")
    })
});

const Authorization_key_for_firebase = 'key=AAAAfbDRXnM:APA91bGrXtxC2wBfpZ-50MUCuVjcPR_HwvRBu8_FtMU3PMLYsaVLRKL1P_Z63DP9p3i3mQliISiDP2gQWV4SbnBy4uQUbV_xFH94K22MHD5NGzE-W--tU0JXE5H4az9sr6UZzP8jnqgP';

module.exports = {
    Authorization_key_for_firebase :  Authorization_key_for_firebase
};


app.get('/admin',cors(), function(req, res) {
    console.log("FXTRADE Admin API is Online!") ;
    res.status(200).json({ message: 'FXTRADE Admin API is Online!' });
});

var Admin_dataAPI = require('./api/Admin_data');
app.post('/Admin_data/Admin_login_API', cors(), validation.Admin_login_API, Admin_dataAPI.Admin_login_API);

var usr_dataAPI = require('./api/user_data');
app.post('/user_data/total_trasaction_by_user_account_id_API', cors(), validation.total_trasaction_by_user_account_id, usr_dataAPI.total_trasaction_by_user_account_id_API);

var addbln_dataAPI = require('./api/add_balance_by_admin_data');
app.post('/add_balance_by_admin_data/check_login_id_API', cors(), validation.check_login_id_val, addbln_dataAPI.check_login_id_API);
app.post('/add_balance_by_admin_data/add_balance_to_mt5_login_id_API', cors(), validation.add_balance_to_mt5_login_id_val, addbln_dataAPI.add_balance_to_mt5_login_id_API);


var deposit_address_qr_dataAPI = require('./api/deposit_address_qr_data');
app.post('/admin_deposit_address/update_deposit_address', cors(), deposit_address_qr_dataAPI.update_deposit_address_API);


var banner_dataAPI = require('./api/banner_data');
app.post('/banner_data/update_banner_API', cors(), banner_dataAPI.update_banner_API);
app.post('/banner_data/add_banner_API', cors(), banner_dataAPI.add_banner_API);

var crncyicon_dataAPI = require('./api/currencypair_icon_data');
app.post('/currencypair_icon_data/add_currencypair_logo_API', cors(), crncyicon_dataAPI.add_currencypair_logo_API);
app.post('/currencypair_icon_data/update_currencypair_logo_API', cors(), crncyicon_dataAPI.update_currencypair_logo_API);

var doctypeAPI = require('./api/document_type');
app.post('/admin_document_type/document_type_list_API', cors(), checkauth.checkauth,  validation.tbl_admin_id_validation, doctypeAPI.document_type_list_API);

var adminnotifyAPI = require('./api/admin_push_notification_data');
app.post('/admin_push_notification_data/admin_send_notification_to_user_api', cors(),  validation.tbl_admin_id_validation, adminnotifyAPI.admin_send_notification_to_user_api);
app.post('/admin_push_notification_data/admin_notification_list_api', cors(),  validation.tbl_admin_id_validation, adminnotifyAPI.admin_notification_list_api);


app.listen(port);
console.log('Listening on port ' + port);