const express = require('express');
const pg = require('pg');
const app = module.exports = express();
const path = require('path');
const session = require('express-session')
const port = process.env.PORT || 8160;
const axios = require('axios');
const bodyParser = require('body-parser');
const expressLayout = require('express-ejs-layouts');
const { header } = require('express/lib/request');
const dbConfig = require('../db');
const pool = new pg.Pool(dbConfig);
const nodeMailer = require('nodemailer');
const user_apiurl = 'http://zerogravity.ojpasoftware.com:8152';
const apiurl = 'http://zerogravity.ojpasoftware.com:8159';
const base_image_url = 'http://zerogravity.ojpasoftware.com:8152/files/upload';

var formidable = require('formidable');
const moment = require('moment');
const cors = require('cors');

const mailConfig = require('../mail');
const transporter = nodeMailer.createTransport(mailConfig);

// const notification_function = require('../user/api/notification_function');

/// new code for firebase notification
//notification_function.send_notification(tbl_user_id, title, notification_type, notification_message);
//notification_function.send_notification(147, 'wallet transfer', 'wallet_transfer', 'You have transferred an amount of 300 to 632838 in 246138');

/// new code for firebase notification

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}
// for pandit agrement
app.use(function (req, res, next) {
    res.setHeader('Access-Control-Allow-Origin', '*');
    res.setHeader('Access-Control-Allow-Methods', 'GET, POST, OPTIONS, PUT, PATCH, DELETE');
    res.setHeader('Access-Control-Allow-Headers', 'X-Requested-With,content-type');
    res.setHeader('Access-Control-Allow-Credentials', true);
    next();
});

app.use(function (req, res, next) {
    res.header("Access-Control-Allow-Origin", "*"); // update to match the domain you will make the request from
    res.header("Access-Control-Allow-Headers", "Origin, X-Requested-With, Content-Type, Accept");
    next();
});
app.use(cors());

console.log('admin web server started');
// for pandit agrement

app.use(bodyParser.urlencoded({ limit: "150mb", extended: false }));
app.use(bodyParser.json({ limit: "150mb" }));
app.use('/', express.static(path.join(__dirname, '/public')));
app.use('/:a', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b/:c', express.static(path.join(__dirname, '/public')));

app.use(expressLayout)
app.set('views', path.join(__dirname, 'templates/views'));
app.set('view engine', 'ejs');


app.use(session({
    secret: 'FXTRADE',
    resave: true,
    saveUninitialized: false,
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 7 }
}));

const auth = (req, res, next) => {
    if (req.session.userid) {
        next()
    } else {
        res.redirect('/login');
    }
}

app.use((req, res, next) => {
    var err = req.session.error;
    delete req.session.error;
    res.locals.user_id = req.session.userid;
    res.locals.token = req.session.token;
    res.locals.user_email = req.session.useremail;
    res.locals.user_name = req.session.username;
    res.locals.depo_qr_err = req.session.depo_qr_err;
    res.locals.depo_qr_succ = req.session.depo_qr_succ;
    res.locals.moment = moment;
    res.locals.isNull = isNull;
    res.locals.base_image_url = base_image_url;

    res.locals.error = err;
    res.locals.pagetitle = "";
    next();
});

app.get('/logout', (req, res) => {
    req.session.destroy(() => {
        res.redirect('/login');
    })
});
app.get('/login', (req, res) => {
    res.render('login', { layout: false })
});

app.post('/login_form', (req, res) => {
    const { user_name, admin_pwd } = req.body;
    var data = JSON.stringify({
        "user_name": user_name,
        "password": admin_pwd
    });

    var headers = {
        'Content-Type': 'application/json'
    }

    axios.all([axios.post(apiurl + '/Admin_data/Admin_login_API', data, { "headers": headers })])
        .then(axios.spread((response) => {
            var sts = response.data.status;
            
            if (sts == true) {
                req.session.userid = response.data.data[0].tbl_admin_id;
                req.session.username = response.data.data[0].user_name;
                req.session.useremail = response.data.data[0].email;
                req.session.token = response.data.data[0].jwt_token;

                res.redirect('dashboard');
            } else {
                res.locals.error = 'You have entered an invalid  credential.';
                res.render('login', { layout: false });
            }
        }))
        .catch((err) => {
            console.log(err);
        })
});

// app.get('/dashboard', auth, async (req, res) => {

//     const dashResult = await pool.query(`SELECT 
//     (SELECT count(tbl_user_id) AS total_user from tbl_user),
//     (SELECT count(tbl_mt5_user_id) AS total_mt5_user from tbl_mt5_user),
//     (SELECT count(tbl_admin_notification_id) AS total_admin_notification from tbl_admin_notification),
//     (SELECT count(tbl_deposit_id) AS total_deposit from tbl_deposit where updated_by != 'add_balance_by_admin' OR updated_by IS NULL),
//     (SELECT count(tbl_wallet_to_wallet_transection_id) AS total_wallet_to_wallet from tbl_wallet_to_wallet_transection),
//     (SELECT count(tbl_deposit_id) AS deposit_pending from tbl_deposit where status = '1'),
//     (SELECT count(tbl_user_verification_id) AS total_user_verification from tbl_user_verification),
//     (SELECT count(tbl_withdrawal_amount_id) AS total_user_withdrawal from tbl_withdrawal_amount),
//     (SELECT count(tbl_document_type_id) AS total_document_type from tbl_document_type)`);
    
//     const dash_data = dashResult.rows;

//     const result = await pool.query(`SELECT 
//         (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair), tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
//         tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.order_status = '${order_type}' order by tbl_order_id DESC`);

//     const ordr_data = result.rows;




//     res.render('index', {
//         layout: true,
//         dash_data: dash_data,
//         pagetitle: 'dashboard_page'
//     });
// });





///////////////////////////////////////////////////// firebase code start here //////////////////////////////////////////////////////////////////

// setInterval(() => {
//     axios.all([axios.get('http://trandmunda.ojpasoftware.com:9111/firebase_data/push_data_in_firebsa_API')])
//         .then(axios.spread((firebse_res_sts) => {
//             // console.log(JSON.stringify(user_res_sts.data));
//             console.log('push_data_in_firebsa_API', firebse_res_sts.data);
//         })).catch((err) => {
//             console.log(err);
//         });
// }, 10000);


///////////////////////////////////////////////////// firebase code end here //////////////////////////////////////////////////////////////////


//////////////////////////////////////////// Auto update pending to open order api code start here ///////////////////////////////////


app.get('/dashboard', auth, async (req, res) => {
    try {
        // 1. Dashboard Count Query
        const dashResult = await pool.query(`
            SELECT 
                (SELECT COUNT(tbl_user_id) FROM tbl_user) AS total_user,
                (SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user) AS total_mt5_user,
                (SELECT COUNT(tbl_admin_notification_id) FROM tbl_admin_notification) AS total_admin_notification,
                (SELECT COUNT(tbl_deposit_id) FROM tbl_deposit WHERE updated_by != 'add_balance_by_admin' OR updated_by IS NULL) AS total_deposit,
                (SELECT COUNT(tbl_wallet_to_wallet_transection_id) FROM tbl_wallet_to_wallet_transection) AS total_wallet_to_wallet,
                (SELECT COUNT(tbl_deposit_id) FROM tbl_deposit WHERE status = '1') AS deposit_pending,
                (SELECT COUNT(tbl_user_verification_id) FROM tbl_user_verification) AS total_user_verification,
                (SELECT COUNT(tbl_withdrawal_amount_id) FROM tbl_withdrawal_amount) AS total_user_withdrawal,
                (SELECT COUNT(tbl_document_type_id) FROM tbl_document_type) AS total_document_type
        `);

        const dash_data = dashResult.rows;

        // 2. Order List Query
        const order_type = 'open'; // or 'closed' – set accordingly
        // const trade_type = 'normal_trade';
        const orderQuery = `
            SELECT 
                (SELECT currencypair_image 
                 FROM tbl_currencypair_logo 
                 WHERE status = '1' 
                   AND currencypair = tbl_order.currency_pair
                 ) AS currencypair_image,
                tbl_market_live_rate.currency_pair AS marker_pair, 
                tbl_market_live_rate.sell_bidprice, 
                tbl_market_live_rate.buy_askprice,
                tbl_market_live_rate.market_status, 
                tbl_order.* 
            FROM tbl_order  
            INNER JOIN tbl_market_live_rate  
                ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
            WHERE tbl_order.order_status = $1
            ORDER BY tbl_order_id DESC
        `;
         
       
        const result = await pool.query(orderQuery, [order_type]);
        const ordr_data = result.rows;

        // 3. Render the page
        res.render('index', {
            layout: true,
            dash_data: dash_data,
            ordr_data: ordr_data,
            
            order_type: order_type,
            base_image_url: 'http://zerogravity.ojpasoftware.com:8152/files/upload', // replace with your actual base URL
            moment: moment,
            pagetitle: 'dashboard_page'
        });

    } catch (err) {
        console.error("Dashboard Error:", err);
        res.status(500).send("Internal Server Error");
    }
});



setInterval(() => {
    axios.all([axios.get('http://zerogravity.ojpasoftware.com:8152/auto_update_order_data/auto_update_pending_to_open_order_api')])
    .then(axios.spread((pending_to_open_res) => {
        // console.log(JSON.stringify(user_res_sts.data));
    //    console.log('auto_update_pending_to_open_order_api', pending_to_open_res.data);
    })).catch((err) => {
       // console.log(err);
    });
}, 2000);


//////////////////////////////////////////// Auto update pending to open order api code start here ///////////////////////////////////
//////////////////////////////////////////// Auto update pending to open order api code start here ///////////////////////////////////

setInterval(() => {
    axios.all([axios.get('http://zerogravity.ojpasoftware.com:8152/auto_update_order_data/auto_update_tp_sl_order_api')])
    .then(axios.spread((auto_update_tp_sl_res) => {
        // console.log(JSON.stringify(user_res_sts.data));
        // console.log('auto_update_tp_sl_res', auto_update_tp_sl_res.data);
    })).catch((err) => {
        //console.log(err);
    });
}, 1000);


//////////////////////////////////////////// Auto update pending to open order api code start here ///////////////////////////////////



///////////////////////////////////// Document Code start from here //////////////////////
app.get('/document', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_document_type order by tbl_document_type_id ASC`);
        const doc_data = result.rows;

        res.render('document', {
            layout: true,
            docu_data: doc_data,
            pagetitle: 'doc_type_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/document_details/:doc_id', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_document_type where  tbl_document_type_id = '${req.params.doc_id}'`);
        const doc_data = result.rows;

        res.render('document_details', {
            layout: true,
            docu_data: doc_data,
            pagetitle: 'doc_type_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/document_update', auth, async (req, res) => {

    const { doc_id, doc_name, status_id } = req.body;

    try {
        pool.query(`SELECT tbl_document_type_id FROM tbl_document_type where tbl_document_type_id = '${doc_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                const result = await pool.query(`UPDATE tbl_document_type SET document_name = '${doc_name}', status = '${status_id}' WHERE tbl_document_type_id = '${doc_id}'`);

                if (result.rowCount > 0) {
                    res.json({ status: true, message: `Document Updated successfully.` });
                } else {
                    res.json({ status: false, message: 'Something wrong' });
                }
            } else {
                res.json({ status: false, message: 'Something went wrong!' });
            }
        })

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/add_document', auth, async (req, res) => {
    try {
        res.render('add_document', {
            layout: true,
            pagetitle: 'doc_type_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/document_add', auth, async (req, res) => {

    const { doc_name } = req.body;

    const doc_lower = doc_name.toLowerCase();

    try {
        pool.query(`SELECT document_name FROM tbl_document_type where document_name = '${doc_lower}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {
                res.json({ status: false, message: 'Same document already exist.' });
            } else {
                const result = await pool.query(`INSERT INTO tbl_document_type(document_name)VALUES('${doc_name}')`);
                if (result.rowCount > 0) {
                    res.json({ status: true, message: `Document added successfully.` });
                } else {
                    res.json({ status: false, message: 'Something wrong' });
                }
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});
///////////////////////////////////// Document Code start from here //////////////////////


/////////////////////////////////////   user Code start from here //////////////////////
app.get('/user_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_user order by tbl_user_id DESC`);
        const user_data = result.rows;
        res.render('all_user', {
            layout: true,
            user_data: user_data,
            pagetitle: 'user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/ib_user_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_ib_user order by tbl_ib_user_id DESC`);
        const user_data = result.rows;
        res.render('ib_user_list', {
            layout: true,
            user_data: user_data,
            pagetitle: 'ib_user_list'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_details/:tbl_user_id', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_user where  tbl_user_id = '${req.params.tbl_user_id}'`);
        const user_data = result.rows;

        const mt5tbl_user = await pool.query(`select * from tbl_mt5_user where tbl_user_id = '${req.params.tbl_user_id}'`);
        const mt5_user_data = mt5tbl_user.rows;

        res.render('user_detail', {
            layout: true,
            user_data: user_data,
            mt5_user_data: mt5_user_data,
            pagetitle: 'user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.get('/ib_user_detail/:tbl_ib_user', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_ib_user where  username = '${req.params.tbl_ib_user}'`);
        const user_data = result.rows;

        const mt5tbl_user = await pool.query(`SELECT * from tbl_mt5_user where tbl_user_id IN(SELECT tbl_user_id from tbl_user where used_login_id ='${req.params.tbl_ib_user}')`);
        const mt5_user_data = mt5tbl_user.rows;

        res.render('ib_user_detail', {
            layout: true,
            user_data: user_data,
            mt5_user_data: mt5_user_data,
            pagetitle: 'ib_user_detail'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


/////////////// /////////////////////////////////////  Mt5 user Code start from here //////////////////////

app.get('/user_multi_account_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_mt5_user order by tbl_mt5_user_id DESC`);
        const user_mt5_data = result.rows;
        res.render('mt5_user_list', {
            layout: true,
            user_mt5_data: user_mt5_data,
            pagetitle: 'mt5user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

/////////////// /////////////////////////////////////  Mt5 user Code end here //////////////////////


///////////////////////////////// open , close, pending  order list api code start from here  //////////////////////////////////////   

app.get('/user_multi_account_details/:login_id', auth, async (req, res) => {
    const { login_id } = req.params;

    try {
        var data = { "tbl_admin_id": "1",  "account_id" :  login_id }
        var headers = {
            // 'Authorization': 'Bearer ' + req.session.token,
            'Content-Type': 'application/json'
        }
        const result = await pool.query(`SELECT (SELECT SUM(profit_loss_value) as total_pl FROM tbl_order where login_id = '${login_id}'), mt5u.balance, mt5u.leverage, mt5u.joining_date, mt5u.joining_time, u.* FROM tbl_user u INNER JOIN  tbl_mt5_user mt5u ON u.tbl_user_id = mt5u.tbl_user_id where mt5u.login_id = '${login_id}'`);
        const user_data = result.rows;

        const ordr_result = await pool.query(`SELECT 
            (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair), tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
            tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.login_id = '${login_id}' order by tbl_order_id DESC`);
        const ordr_data = ordr_result.rows;

        axios.all([axios.post(apiurl + '/user_data/total_trasaction_by_user_account_id_API', data, { 'headers': headers })])
        .then(axios.spread((total_transaction_res) => {

       
    
            res.render('mt5_user_account_detail', {
                layout: true,
                login_id: login_id,
                user_data: user_data,
                total_transaction_data : total_transaction_res.data,
                order_data: ordr_data,
                pagetitle: 'mt5user_page'
            });
    
        })).catch((err) => {
            console.log(err);
        });
        
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

///////////////////////////////// open , close, pending  order list api code end here  //////////////////////////////////////

/////////////// /////////////////////////////////////  Mt5 user Code start from here //////////////////////


app.get('/order/:order_type', auth, async (req, res) => {

    const { order_type } = req.params;
    try {
       
        //// remove this line after closed_order_done_by_admin
       // const static_tbl_user_id = `AND tbl_order.tbl_user_id IN ('218', '147') AND trade_type = 'normal_trade'`;


        const result = await pool.query(`SELECT 
            (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair), tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
            tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.order_status = '${order_type}' AND tbl_order.trade_type = 'normal_trade' order by tbl_order_id DESC`);

        const ordr_data = result.rows;
        res.render('order_list', {
            layout: true,
            order_type: order_type,
            ordr_data: ordr_data,
            pagetitle: `${order_type}_ordr_page`
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/order_details/:tbl_order_id', auth, async (req, res) => {

    const { tbl_order_id } = req.params;
    var order_type = 'open';

    //// remove this line after closed_order_done_by_admin
    //const static_tbl_user_id = `AND tbl_user_id IN ('218', '147')`;
   
    const trade_type ="normal_trade"
    try {
        
        const result = await pool.query(`SELECT 
            (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair), tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
            tbl_market_live_rate.market_status, tbl_order.*, tbl_mt5_user.name FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair LEFT JOIN tbl_mt5_user ON tbl_order.login_id = tbl_mt5_user.login_id::varchar WHERE tbl_order.tbl_order_id = '${tbl_order_id}' `);

        const all_users_query = await pool.query(`SELECT * FROM public.tbl_mt5_user where balance >= 500 AND login_id !='${result.rows[0].login_id}'  order by tbl_mt5_user_id desc`); 

        //${static_tbl_user_id}

        const ordr_data = result.rows;
        const all_users = all_users_query.rows;

        const all_order_user = await pool.query(`SELECT * FROM tbl_order WHERE currency_pair = '${result.rows[0].currency_pair}' ORDER BY tbl_order_id DESC` )
        
        user_fetch = all_order_user.rows;
      

        const user_data_query = await pool.query(`SELECT * FROM tbl_user ORDER BY tbl_user_id DESC`);
        const user_data = user_data_query.rows;

        //// remove this line after closed_order_done_by_admin
       // const static_details_tbl_user_id = `AND tbl_order.tbl_user_id IN ('218', '147')`;
        
        const all_order_users = await pool.query(`SELECT tbl_order.*, tbl_user.*
            FROM tbl_order 
            INNER JOIN tbl_user ON tbl_order.tbl_user_id = tbl_user.tbl_user_id
            WHERE tbl_order.trade_type = 'copy_trade' AND tbl_order.order_status = '${order_type}' AND login_id !='${result.rows[0].login_id}' AND tbl_order.currency_pair = '${result.rows[0].currency_pair}' ORDER BY tbl_order.tbl_order_id desc`,
        );

        const fetch_data = all_order_users.rows;
                                  
        res.render('open_order_details', {
            layout: true,
            order_type: order_type,
            ordr_data: ordr_data,
            all_users: all_users,
            user_data: fetch_data , 
            user_fetch:user_fetch,
            // fetch_data :fetch_data ,
            pagetitle: `${order_type}_ordr_page`
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/close_orders', auth, async (req, res) => {
    const { tbl_order_id, closed_price, profit_loss_value, profit_type, closed_by } = req.body;

    console.log('close_orders', req.body);

    if (!Array.isArray(tbl_order_id) || tbl_order_id.length === 0) {
        return res.status(400).json({ success: false, message: "Missing or invalid tbl_order_id array" });
    }

    const client = await pool.connect();
    try {
        await client.query('BEGIN');

        // Fetch order details for all tbl_order_ids
        const checkQuery = `
            SELECT tbl_order_id, tbl_user_id, login_id, tradesize_lots
            FROM tbl_order
            WHERE tbl_order_id = ANY($1::bigint[])
        `;
        const checkResult = await client.query(checkQuery, [tbl_order_id]);

        if (checkResult.rowCount === 0) {
            await client.query('ROLLBACK');
            return res.status(404).json({ success: false, message: "No matching orders found" });
        }

        const orderMap = new Map();
        checkResult.rows.forEach(row => {
            orderMap.set(String(row.tbl_order_id), row); // Use String keys
        });

        for (const id of tbl_order_id) {
            const orderData = orderMap.get(String(id)); // Use String lookup

            if (!orderData) {
                console.log(`Order ID ${id} not found in fetched data, skipping.`);
                continue;
            }

            const price = closed_price[id];
            const pl_value = profit_loss_value[id];
            const type = profit_type[id] || 'profit';
            const user = closed_by || 'admin';

            // Calculate commission and prepare balance updates
            const tradesize_lots = Number(orderData.tradesize_lots);
            const admin_commission = tradesize_lots * 16;
            const final_pl_value = Number(pl_value);
            const balance_delta = final_pl_value - admin_commission;

            // Update tbl_order
            await client.query(
                `UPDATE tbl_order SET
                    order_status = $1,
                    closed_price = $2,
                    profit_loss_value = $3,
                    profit_type = $4,
                    closed_by = $5,
                    admin_commission = $6,
                    closed_order_datetime = NOW()
                 WHERE tbl_order_id = $7`,
                ['closed', price, pl_value, type, user, admin_commission, id]
            );

            // Update tbl_mt5_user
            const mt5Res = await client.query(
                `UPDATE tbl_mt5_user SET balance = balance + $1
                 WHERE login_id = $2 AND tbl_user_id = $3
                 RETURNING balance`,
                [balance_delta, orderData.login_id, orderData.tbl_user_id]
            );
            if (mt5Res.rowCount === 0) {
                throw new Error(`tbl_mt5_user not found for login_id=${orderData.login_id}, tbl_user_id=${orderData.tbl_user_id}`);
            }

            // Update tbl_user
            const userRes = await client.query(
                `UPDATE tbl_user SET wallet_amount = wallet_amount + $1
                 WHERE tbl_user_id = $2
                 RETURNING wallet_amount`,
                [balance_delta, orderData.tbl_user_id]
            );
            if (userRes.rowCount === 0) {
                throw new Error(`tbl_user not found for tbl_user_id=${orderData.tbl_user_id}`);
            }

            console.log(`✅ Order ID ${id} closed: admin_commission=${admin_commission}, balance_delta=${balance_delta}, new_balance=${mt5Res.rows[0].balance}, new_wallet=${userRes.rows[0].wallet_amount} where login_id=${orderData.login_id}, tbl_user_id=${orderData.tbl_user_id}`);
        }

        await client.query('COMMIT');

        return res.status(200).json({
            success: true,
            message: `${tbl_order_id.length} order(s) closed successfully with wallet and balance updated.`
        });
    } catch (error) {
        await client.query('ROLLBACK');
        console.error("❌ Internal error during closing orders:", error);
        return res.status(500).json({ success: false, message: "Internal server error", error: error.message });
    } finally {
        client.release();
    }
});




// app.post('/bck_close_orders', async (req, res) => {

//     const { tbl_order_id, closed_price, profit_loss_value, profit_type, closed_by } = req.body;

//     console.log('close_orders', req.body);
    

//     if (!Array.isArray(tbl_order_id) || tbl_order_id.length === 0) {
//       return res.status(400).json({ success: false, message: "Missing or invalid tbl_order_id array" });
//     }
//     try {
//       const checkQuery = `SELECT tbl_order_id, tbl_user_id, login_id, tradesize_lots  FROM tbl_order WHERE tbl_order_id = ANY($1::bigint[])`;

//       const checkResult = await pool.query(checkQuery, [tbl_order_id]);
//       if (checkResult.rowCount === 0) {
//         return res.status(404).json({ success: false, message: "No matching orders found" });
//       }
//       console.log('checkResult.rowCount', checkResult.rows[0]);
      
//         const updatePromises = tbl_order_id.map(async (id) => {
//             const price = closed_price[id];
//             const pl = profit_loss_value[id];
//             const type = profit_type[id];
//             const user = closed_by || 'admin';

//             return pool.query(`UPDATE tbl_order SET order_status = $1, closed_price = $2, profit_loss_value = $3, 
//             profit_type = $4, closed_by = $5, closed_order_datetime = now() WHERE tbl_order_id = $6`, 
//             ['closed', price, pl, type, user, id]);
//         });

//         await Promise.all(updatePromises);
//         return res.status(200).json({
//             success: true, 
//             message: `${tbl_order_id.length} order(s) closed successfully`
//         });
//     } catch (error) {
//       console.error("Internal error:", error);
//       return res.status(500).json({ success: false, message: "Internal server error" });
//     }
// });





app.get('/closed_order', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT (SELECT currencypair_image from  tbl_currencypair_logo where currencypair = tbl_order.currency_pair), 
tbl_order.* FROM tbl_order where order_status = 'closed' order by tbl_order_id DESC`);
        const closed_ordr_data = result.rows;

        res.render('closed_order_list', {
            layout: true,
            closed_ordr_data: closed_ordr_data,
            pagetitle: 'clos_ordr_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});



/////////////// /////////////////////////////////////  Mt5 user Code end here //////////////////////


/////////////// /////////////////////////////////////  Wallet to wallet  Code start from here //////////////////////

app.get('/wallet_to_wallet_transfer_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_wallet_to_wallet_transection order by tbl_wallet_to_wallet_transection_id DESC`);

        const user_wlttowlt_data = result.rows;

        res.render('wallet_to_wallet_transfer_list', {
            layout: true,
            user_wlttowlt_data: user_wlttowlt_data,
            pagetitle: 'mt5user_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

/////////////// /////////////////////////////////////  Mt5 user Code end here //////////////////////


  

/////////////////////////////////////   user  Code start from here //////////////////////


/////////////////////////////////////   user deposit Code start from here //////////////////////

// app.get('/user_deposit_list', auth, async (req, res) => {
//     try {

//         const result = await pool.query(`SELECT tbl_deposit.*, (SELECT fname || ' ' || lname FROM tbl_user WHERE tbl_user_id = tbl_deposit.tbl_user_id) AS user_name FROM  tbl_deposit where updated_by != 'add_balance_by_admin' OR updated_by IS NULL ORDER BY tbl_deposit_id DESC;`);

//         const user_depo_data = result.rows;
//         res.render('user_deposit', {
//             layout: true,
//             user_depo_data: user_depo_data,
//             pagetitle: 'deposit_page'
//         });
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });

// app.get('/user_deposit_details/:deposit_id', auth,  async (req, res) => {
//     try {

//         const result = await pool.query(`SELECT tbl_deposit.*, (SELECT fname || ' ' || lname FROM tbl_user WHERE tbl_user_id = tbl_deposit.tbl_user_id) AS user_name FROM tbl_deposit where tbl_deposit_id = '${req.params.deposit_id}'`);

//         const user_depo_data = result.rows;
//         res.render('user_deposit_details', {
//             layout: true,
//             user_depo_data: user_depo_data,
//             pagetitle: 'deposit_page'
//         });
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });

app.get('/user_deposit_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`
            SELECT 
                tbl_deposit.*, 
                (
                    SELECT COALESCE(fname, '') || ' ' || COALESCE(lname, '') 
                    FROM tbl_user 
                    WHERE tbl_user.tbl_user_id = tbl_deposit.tbl_user_id
                ) AS user_name 
            FROM tbl_deposit 
            WHERE updated_by != 'add_balance_by_admin' OR updated_by IS NULL 
            ORDER BY tbl_deposit_id DESC;
        `);

        const user_depo_data = result.rows;
        res.render('user_deposit', {
            layout: true,
            user_depo_data: user_depo_data,
            pagetitle: 'deposit_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});
app.get('/user_deposit_details/:deposit_id', auth, async (req, res) => {
    try {
        const result = await pool.query(`
            SELECT 
                tbl_deposit.*, 
                (
                    SELECT COALESCE(fname, '') || ' ' || COALESCE(lname, '') 
                    FROM tbl_user 
                    WHERE tbl_user.tbl_user_id = tbl_deposit.tbl_user_id
                ) AS user_name 
            FROM tbl_deposit 
            WHERE tbl_deposit_id = $1
        `, [req.params.deposit_id]);

        const user_depo_data = result.rows;
        res.render('user_deposit_details', {
            layout: true,
            user_depo_data: user_depo_data,
            pagetitle: 'deposit_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});




app.post('/deposit_acep_reject', auth,  async (req, res) => {

    const { deposit_id, login_id, deposit_amount, reason, status_id } = req.body;

    console.log('req.body', req.body);

    try {
        pool.query(`SELECT tbl_deposit_id, tbl_user_id, status FROM tbl_deposit where tbl_deposit_id = '${deposit_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                var check_sts_already_updated = result_res.rows[0].status;
                const user_id = result_res.rows[0].tbl_user_id;

                if (check_sts_already_updated == '2') {
                    var ck_msg = 'Approved';
                } else if (check_sts_already_updated == '3') {
                    var ck_msg = 'Rejected';
                } else {
                    var ck_msg = 'Pending';
                }

                if (check_sts_already_updated == '1') {

                    if (status_id == '2') {   ////// approved

                        // const axios = require('axios');
                        // const FormData = require('form-data');
                        // let data = new FormData();
                        // data.append('login_id', login_id);
                        // data.append('amount', deposit_amount);
                        // let config = {
                        //     method: 'post',
                        //     maxBodyLength: Infinity,
                        //     url: 'https://aiboxstudios.com/mt5_api/add_found_in_account.php',
                        //     headers: {
                        //         ...data.getHeaders()
                        //     },
                        //     data: data
                        // };
                        // axios.request(config)
                        // .then(async (response) => {

                        //     console.log(response.data);
                        //     var ck_res_sts = response.data.retcode;

                            // if (ck_res_sts == '0 Done') {
                            //     var ticket = response.data.answer.ticket;
                              // ticket = '${ticket}',

                                const result = await pool.query(`UPDATE tbl_deposit SET status = '${status_id}',  updated_by = 'admin', updated_date = now() WHERE tbl_deposit_id = '${deposit_id}';
                                 UPDATE tbl_mt5_user SET balance = balance + '${deposit_amount}' WHERE login_id = '${login_id}';
                                 UPDATE tbl_user SET wallet_amount = wallet_amount + '${deposit_amount}' WHERE tbl_user_id = '${user_id}';
                                `);

                                if (result[0].rowCount > 0) {

                                    const title = `Deposit request`;
                                    const notification_type = `deposit_request`;
                                    const notification_message = `Amount of ${deposit_amount} deposit requests approved successfully.`;
                                    notification_function.send_notification(user_id, title, notification_type, notification_message);

                                    return res.json({ status: true, message: `Amount deposit request approved successfully.` });
                                } else {
                                    return res.json({ status: false, message: 'Something wrong' });
                                }
                            // } else {
                            //     return res.json({ status: false, message: 'Something went wrong!' });
                            // }

                        // })
                        // .catch((error) => {
                        //     console.log(error);
                        // });

                    } else {

                        const result = await pool.query(`UPDATE tbl_deposit SET status = '${status_id}', updated_by = 'admin', updated_date = now(), reason = $$${reason}$$  WHERE tbl_deposit_id = '${deposit_id}'`);

                        if (result.rowCount > 0) {

                            const title = `Deposit request`;
                            const notification_type = `deposit_request`;
                            const notification_message = `Amount of ${deposit_amount} deposit requests is rejected.`;
                            notification_function.send_notification(user_id, title, notification_type, notification_message);
                            return res.json({ status: true, message: `Amount deposit request rejected.` });
                        } else {
                            return res.json({ status: false, message: 'Something wrong' });
                        }
                    }
                } else {
                    return res.json({ status: false, message: `This request has been already ${ck_msg}.` });
                }

            } else {
                return res.json({ status: false, message: 'tbl_deposit_id is wrong!' });
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

/////////////////////////////////////   user deposit Code start from here //////////////////////



app.get('/withdrawal_amount_list', auth, async (req, res) => {
    try {

        const result = await pool.query(`SELECT tbl_withdrawal_amount.*, (SELECT fname || ' ' || lname FROM tbl_user WHERE tbl_user_id = tbl_withdrawal_amount.tbl_user_id) AS user_name FROM tbl_withdrawal_amount ORDER BY tbl_withdrawal_amount_id DESC;`);

        const user_wdr_amt_data = result.rows;

        res.render('withdrawal_amount_list', {
            layout: true,
            user_wdr_amt_data: user_wdr_amt_data,
            pagetitle: 'withdra_amt_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_verification_list', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT tbl_user_verification.*, (SELECT document_name FROM tbl_document_type WHERE tbl_document_type_id::varchar = tbl_user_verification.id_type) FROM tbl_user_verification ORDER BY tbl_user_verification_id DESC`);

        const user_verfy_data = result.rows;

        res.render('user_verification_list', {
            layout: true,
            user_verfy_data: user_verfy_data,
            pagetitle: 'user_verify_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/user_verification_details/:user_verfication_id', auth, async (req, res) => {
    try {
        const { user_verfication_id } = req.params;
        const result = await pool.query(`SELECT tbl_user_verification.*, (SELECT document_name FROM tbl_document_type WHERE tbl_document_type_id::varchar = tbl_user_verification.id_type) FROM tbl_user_verification WHERE tbl_user_verification_id = '${user_verfication_id}'`);
        const verify_data = result.rows;

        res.render(`user_verification_details`, {
            layout: true,
            verify_data: verify_data,
            pagetitle: 'user_verify_page'
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/user_update_kyc', auth, async (req, res) => {

    const { verification_id, status_id } = req.body;

    try {
        pool.query(`SELECT tbl_user_verification_id FROM tbl_user_verification where tbl_user_verification_id = '${verification_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                const result = await pool.query(`UPDATE tbl_user_verification SET status = '${status_id}' WHERE tbl_user_verification_id = '${verification_id}'`);

                if (result.rowCount > 0) {
                    res.json({ status: true, message: `Kyc Updated successfully.` });
                } else {
                    res.json({ status: false, message: 'Something wrong' });
                }
            } else {
                res.json({ status: false, message: 'Something went wrong!' });
            }
        })
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

/////////////////////////////////////   user deposit Code end here //////////////////////
app.get('/update_deposit_address', auth, async (req, res) => {
    delete req.session.depo_qr_err;
    delete req.session.depo_qr_succ;
    try {
        const result = await pool.query(`SELECT * FROM tbl_deposit_address where  tbl_deposit_address_id = '1'`);
        const depo_adr_data = result.rows;

        res.render('update_deposit_address', {
            layout: true,
            depo_adr_data: depo_adr_data,
            pagetitle: 'updt_depo_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/deposite_address_update', auth, function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {


        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

        data.append('tbl_deposit_address_id', fields.depo_adr_id);
        data.append('deposit_address', fields.depo_address);
        data.append('status', fields.status);


        if (files.qr_code.size > 0) {
            data.append('deposit_qr', fs.createReadStream(files.qr_code.filepath));
        } else {
            console.log('qr code nhi hai');
        }

        var config = {
            method: 'post',
            url: apiurl + '/admin_deposit_address/update_deposit_address',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
            .then((update_qr_res) => {

                var sts = update_qr_res.data.status;
                var msg = update_qr_res.data.message;

                if (sts == false) {
                    req.session.depo_qr_err = msg;
                    res.redirect('/update_deposit_address');
                } else {
                    req.session.depo_qr_succ = msg;
                    res.redirect('/update_deposit_address');
                }
            })
            .catch(function (error) {
                console.log(error);
            });
    });
});
/////////////////////////////////////   banner  code start from here //////////////////////

app.get('/banner_list', auth, async(req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_promotion_banner order by tbl_promotion_banner_id DESC`);
        const ban_data = result.rows;

        res.render('banner_list', {
            layout: true,
            banr_data: ban_data,
            pagetitle: 'baner_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/banner_details/:baner_id', auth, async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_promotion_banner where tbl_promotion_banner_id = '${req.params.baner_id}'`);
        const ban_data = result.rows;

        res.render('update_banner', {
            layout: true,
            banr_data: ban_data,
            pagetitle: 'baner_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/banner_update', auth, function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

        data.append('tbl_promotion_banner_id', fields.prom_banr_id);
        data.append('title', fields.title);
        data.append('type', fields.ban_type);
        data.append('status', fields.status);

        if (files.banr_img.size > 0) {
            data.append('banner_image', fs.createReadStream(files.banr_img.filepath));
        } else {
            console.log('banr_img nhi hai');
        }

        var config = {
            method: 'post',
            url: apiurl + '/banner_data/update_banner_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
        .then((update_bnr_res) => {

            var sts = update_bnr_res.data.status;
            var msg = update_bnr_res.data.message;

            if (sts == false) {
                req.session.error = msg;
                res.redirect('/banner_details/'+ fields.prom_banr_id);
            } else {
                res.redirect('/banner_list');
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});

app.get('/add_banner', auth, async (req, res) => {
    try {
        res.render('add_banner', {
            layout: true,
            pagetitle: 'baner_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.post('/banner_add', auth, function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

        data.append('title', fields.title);
        data.append('type', fields.ban_type);
        data.append('banner_image', fs.createReadStream(files.banr_img.filepath));

        var config = {
            method: 'post',
            url: apiurl + '/banner_data/add_banner_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
        .then((add_bnr_res) => {

            var sts = add_bnr_res.data.status;
            var msg = add_bnr_res.data.message;

            if (sts == false) {
                req.session.error = msg;
                res.redirect('/add_banner');
            } else {
                res.redirect('/banner_list');
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});

/////////////////////////////////////   banner  code end here //////////////////////
/////////////////////////////////////   currency_pair_icon_list  code start from here //////////////////////

app.get('/currency_pair_icon_list', async(req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_currencypair_logo order by currencypair ASC`);
        const crncy_data = result.rows;

        res.render('currency_pair_icon_list', {
            layout: true,
            crncy_data: crncy_data,
            pagetitle: 'curencypair_icon_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/currencypair_icon_details/:crncypair_id',  async (req, res) => {
    try {
        const result = await pool.query(`SELECT * FROM tbl_currencypair_logo where tbl_currencypair_logo_id = '${req.params.crncypair_id}'`);
        const crncy_data = result.rows;

        res.render('edit_currencypair_icon', {
            layout: true,
            crncy_data: crncy_data,
            pagetitle: 'curencypair_icon_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/currencypair_icon_update', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

        data.append('tbl_currencypair_logo_id', fields.currencypair_id);
        data.append('currency_pair', fields.currency_pair);
        data.append('status', fields.status);

        if (files.currencypair_icon.size > 0) {
            //get_extention           
                const typefile = files.currencypair_icon.mimetype;       
                var type = typefile.split("/");
                const img_type = type[1];
                data.append('currency_pair_icon_extention', img_type);
            //get_extention
            data.append('currency_pair_icon', fs.createReadStream(files.currencypair_icon.filepath));
        } else {
            console.log('currency_pair_icon is not selected.');
        }

        var config = {
            method: 'post',
            url: apiurl + '/currencypair_icon_data/update_currencypair_logo_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
        .then((update_bnr_res) => {

            var sts = update_bnr_res.data.status;
            var msg = update_bnr_res.data.message;

            if (sts == false) {
                req.session.error = msg;
                res.redirect('/currencypair_icon_details/'+ fields.currencypair_id);
                } else {
             
                res.redirect('/currency_pair_icon_list');
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});

app.get('/add_currency_pair_icon',  async (req, res) => {
    try {
        res.render('add_currencypair_icon', {
            layout: true,           
            pagetitle: 'curencypair_icon_page'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/currencypair_icon_add', function (req, res) {

    var form = new formidable.IncomingForm();
    form.keepExtensions = true;
    form.parse(req, function (err, fields, files) {

        var FormData = require('form-data');
        var fs = require('fs');
        var data = new FormData();

        data.append('currency_pair', fields.currency_pair);
        //get_extention           
            const typefile = files.currencypair_icon.mimetype;       
            var type = typefile.split("/");
            const img_type = type[1];
            data.append('currency_pair_icon_extention', img_type);
        //get_extention
        data.append('currency_pair_icon', fs.createReadStream(files.currencypair_icon.filepath));
        

        var config = {
            method: 'post',
            url: apiurl + '/currencypair_icon_data/add_currencypair_logo_API',
            headers: {
                // 'Authorization': 'Bearer ' + req.session.token,
                ...data.getHeaders()
            },
            data: data
        };

        axios(config)
        .then((update_bnr_res) => {

            var sts = update_bnr_res.data.status;
            var msg = update_bnr_res.data.message;

            if (sts == false) {
                req.session.error = msg;
                res.redirect('/add_currency_pair_icon');
            } else {
                // res.redirect('/currencypair_icon_details/'+ fields.currencypair_id);
                res.redirect('/currency_pair_icon_list');
            }
        })
        .catch(function (error) {
            console.log(error);
        });
    });
});


app.post('/update_user_status', auth, async (req, res) => {

    const { user_id, user_sts_type } = req.body;

    try {
        pool.query(`SELECT tbl_user_id FROM tbl_user where tbl_user_id = '${user_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                const result = await pool.query(`UPDATE tbl_user SET status = '${user_sts_type}' WHERE tbl_user_id = '${user_id}'`);

                if (result.rowCount > 0) {
                    return res.json({ status: true, message: `User status is updated successfully.` });
                } else {
                    return res.json({ status: false, message: 'Something went wrong!' });
                }
            } else {
                return res.json({ status: false, message: 'tbl_user_id is not exist!' });
            }
        })

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.post('/update_ibuser_status', auth, async (req, res) => {

    const { user_id, user_sts_type } = req.body;

    try {
        pool.query(`SELECT * FROM tbl_ib_user where tbl_ib_user_id = '${user_id}'`, async (error, result_res) => {

            if (error) { res.status(403).json({ status: false, message: error }) }

            if (result_res.rowCount > 0) {

                const result = await pool.query(`UPDATE tbl_ib_user SET status = '${user_sts_type}' WHERE tbl_ib_user_id = '${user_id}'`);

                if (result.rowCount > 0) {

                   var email =  result_res.rows[0].email;
                   var password =  result_res.rows[0].password;

                     // email code start here

                     let mailOptions = {
                        from: '"XtremeFX" <info@fxtrade.app>', // sender address
                        to: email, // list of receivers
                        subject: "IB Account Active", // Subject line
                        //text: verification_token, // plain text body
                        // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                        html: `<html>
                                <body>
                                    <p>
                                        Hi, <br><br>
                                        Your XtremeFXIB account has been successfully Active. Here are your login details: <br>
                                        <strong>Email:</strong> ${email} <br>
                                        <strong>Password:</strong> '${password}' <br><br>
                                        Please keep this information secure and do not share it with anyone.
                                    </p>                  
                                    <p>
                                        Best regards, <br>
                                        Customer Support <br>
                                        XtremeFX
                                    </p>
                                </body>
                            </html>`

                    };
                    transporter.sendMail(mailOptions, (error, info) => {
                        if (error) {
                            return console.log(error);
                        } else {
                            return //console.log(info);
                        }
                        // console.log('Message %s sent: %s', info.messageId, info.response);
                    });

                    // email code end here


                    return res.json({ status: true, message: `User status is updated successfully.` });
                } else {
                    return res.json({ status: false, message: 'Something went wrong!' });
                }
            } else {
                return res.json({ status: false, message: 'tbl_ib_user_id is not exist!' });
            }
        })

    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});


app.get('/get_latest_order_data/:tbl_order_id', auth, async (req, res) => {
	const { tbl_order_id } = req.params;
    
	try {
		const result = await pool.query(`SELECT 
            tbl_market_live_rate.sell_bidprice, 
            tbl_market_live_rate.buy_askprice, 
            tbl_order.exchange_rate, 
            tbl_order.type,
            tbl_order.lotsize_in_lak, 
            tbl_order.tradesize_lots
            FROM tbl_order  
            INNER JOIN tbl_market_live_rate  
            ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
            WHERE tbl_order.tbl_order_id = '${tbl_order_id}'`);
		
		res.json(result.rows[0]);
	} catch (error) {
		console.error('Error fetching live data:', error);
		res.status(500).json({ error: 'Unable to fetch live data' });
	}
});

// app.get('/order_details/:tbl_order_id',  auth, async (req, res) => {

//     const { tbl_order_id } = req.params;
//     var order_type ='open'
//     try {
        
//         const result = await pool.query(`SELECT 
//             (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair), tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice,
//             tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order  INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair WHERE tbl_order.tbl_order_id = '${tbl_order_id}' order by tbl_order_id DESC`);

//             const all_users_query = await pool.query(`SELECT * FROM public.tbl_mt5_user where balance > 500 AND login_id !='${result.rows[0].login_id}' order by tbl_mt5_user_id desc`);

//         const ordr_data = result.rows;
//         const all_users = all_users_query.rows;
//         res.render('open_order_details', {
//             layout: true,
//             order_type: order_type,
//             ordr_data: ordr_data,
//             all_users: all_users,
//             pagetitle: `${order_type}_ordr_page`
//         });
//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });

 
      

// app.get('/order_details/:tbl_order_id', auth, async (req, res) => {
//     const { tbl_order_id } = req.params;
//     const order_type = 'open';
//     const trade_type = 'normal_trade';

//     try {
//         // Try with trade_type first
//         let result = await pool.query(`
//             SELECT 
//                 (SELECT currencypair_image 
//                  FROM tbl_currencypair_logo 
//                  WHERE status = '1' 
//                    AND currencypair = tbl_order.currency_pair
//                 ) AS currencypair_image,
//                 tbl_market_live_rate.currency_pair AS marker_pair,
//                 tbl_market_live_rate.sell_bidprice,
//                 tbl_market_live_rate.buy_askprice,
//                 tbl_market_live_rate.market_status,
//                 tbl_order.*,
//                 tbl_mt5_user.name 
//             FROM tbl_order  
//             INNER JOIN tbl_market_live_rate  
//                 ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
//             LEFT JOIN tbl_mt5_user 
//                 ON tbl_order.login_id = tbl_mt5_user.login_id::varchar 
//             WHERE tbl_order.tbl_order_id = $1 
//               AND tbl_order.trade_type = $2
//             ORDER BY tbl_order_id DESC
//         `, [tbl_order_id, trade_type]);

//         // Retry without trade_type if needed
//         if (result.rows.length === 0) {
//             console.warn(`Order ID ${tbl_order_id} not found with trade_type = '${trade_type}', retrying without trade_type...`);
//             result = await pool.query(`
//                 SELECT 
//                     (SELECT currencypair_image 
//                      FROM tbl_currencypair_logo 
//                      WHERE status = '1' 
//                        AND currencypair = tbl_order.currency_pair
//                     ) AS currencypair_image,
//                     tbl_market_live_rate.currency_pair AS marker_pair,
//                     tbl_market_live_rate.sell_bidprice,
//                     tbl_market_live_rate.buy_askprice,
//                     tbl_market_live_rate.market_status,
//                     tbl_order.*,
//                     tbl_mt5_user.name 
//                 FROM tbl_order  
//                 INNER JOIN tbl_market_live_rate  
//                     ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
//                 LEFT JOIN tbl_mt5_user 
//                     ON tbl_order.login_id = tbl_mt5_user.login_id::varchar 
//                 WHERE tbl_order.tbl_order_id = $1
//                 ORDER BY tbl_order_id DESC
//             `, [tbl_order_id]);
//         }

//         if (result.rows.length === 0) {
//             return res.status(404).send('Order not found');
//         }

//         const order = result.rows[0];

//         // Get other users with balance > 500
//         const all_users_query = await pool.query(`
//             SELECT * 
//             FROM public.tbl_mt5_user 
//             WHERE balance > 500 
//               AND login_id != $1 
//             ORDER BY tbl_mt5_user_id DESC
//         `, [order.login_id]);

//         // ✅ Fetch user_data for EJS template
//         const user_data_query = await pool.query(`SELECT * FROM tbl_user ORDER BY tbl_user_id DESC`);
//         const user_data = user_data_query.rows;

//         const ordr_data = result.rows;
//         const all_users = all_users_query.rows;

//         res.render('open_order_details', {
//             layout: true,
//             order_type: order_type,
//             ordr_data: ordr_data,
//             all_users: all_users,
//             user_data: user_data, // ✅ THIS LINE FIXES THE ERROR
//             pagetitle: `${order_type}_ordr_page`
//         });

//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });


// app.get('/order_details/:tbl_order_id', auth, async (req, res) => {
//     const { tbl_order_id } = req.params;
//     const order_type = 'open';
//     const trade_type ="normal trade"
//     try {
//         const result = await pool.query(`
//             SELECT 
//                 (SELECT currencypair_image FROM tbl_currencypair_logo 
//                     WHERE status = '1' 
//                     AND currencypair = tbl_order.currency_pair), 
//                 tbl_market_live_rate.currency_pair AS marker_pair, 
//                 tbl_market_live_rate.sell_bidprice, 
//                 tbl_market_live_rate.buy_askprice,
//                 tbl_market_live_rate.market_status, 
//                 tbl_order.*, 
//                 tbl_mt5_user.name 
//             FROM tbl_order  
//             INNER JOIN tbl_market_live_rate  
//                 ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
//             LEFT JOIN tbl_mt5_user 
//                 ON tbl_order.login_id = tbl_mt5_user.login_id::varchar 
//             WHERE tbl_order.tbl_order_id = $1 AND tbl_order.trade_type = $2
//             ORDER BY tbl_order_id DESC
//         `, [tbl_order_id,trade_type]);

//         const all_users_query = await pool.query(`
//             SELECT * FROM public.tbl_mt5_user 
//             WHERE balance > 500 
//                 AND login_id != $1 
//             ORDER BY tbl_mt5_user_id DESC
//         `, [order.login_id]);

//         const userDataQuery = await pool.query(`SELECT * FROM tbl_user ORDER BY tbl_user_id DESC`);
//         const user_data = userDataQuery.rows;

//         const ordr_data = result.rows;
//         const all_users = all_users_query.rows;

//         res.render('open_order_details', {
//             layout: true,
//             order_type: order_type,
//             ordr_data: ordr_data,
//             all_users: all_users,
//             user_data: user_data,
//             pagetitle: `${order_type}_ordr_page`
//         });

//     } catch (error) {
//         console.error('Error fetching data:', error);
//         res.status(500).send('Error fetching data');
//     }
// });




app.post('/copy_open_trade',  auth, async (req, res) => {
   

    const { tradesize_lots, lotsize_in_lak, leverage_ratio, live_rate, tbl_order_id } = req.body;

    let selectedUsers = req.body['selected_user[]'];

    // Ensure selectedUsers is always an array
    if (!Array.isArray(selectedUsers)) {
        selectedUsers = selectedUsers ? [selectedUsers] : [];
    }

    if (selectedUsers.length === 0) {
        return res.status(400).send('No users selected');
    }

    const lots_in_lac = tradesize_lots * lotsize_in_lak;

    const userIds = selectedUsers.map(id => `'${id}'`).join(',');


    const query = `
        SELECT balance, leverage, tbl_user_id, login_id,
        ((${lots_in_lac} / tbl_mt5_user.leverage) * ${live_rate}) AS margin
        FROM tbl_mt5_user
        WHERE login_id IN (${userIds})
        AND balance > ((${lots_in_lac} / tbl_mt5_user.leverage) * ${live_rate})
    `;


    try {
        const result = await pool.query(query);

        if (result.rowCount > 0) {
            let inserted = null; // initialize outside the loop

            for (let i = 0; i < result.rowCount; i++) {
                const { tbl_user_id, login_id, margin, leverage } = result.rows[i];

                // Generate 8-digit order ID
                const random = Math.floor(100000 + Math.random() * 900000);
                const random_with_id = login_id + random.toString();
                const order_id = String(random_with_id).slice(-8).padStart(8, '0');
                const copy_trade ="copy_trade";
                

                const copy_order_query = `
                    INSERT INTO tbl_order (
                        order_id, tbl_user_id, login_id, type, tradesize_lots,
                        exchange_rate, margin, leverage_ratio, currency_pair,
                        currency_type, order_setting, market_order_type, market_order_price,
                        stop_loss, take_profit, stop_loss_price, take_profit_price,
                        open_price, order_status, take_profit_status, stop_loss_status, lotsize_in_lak,trade_type
                    )
                    SELECT 
                        '${order_id}', '${tbl_user_id}', '${login_id}', type, tradesize_lots,
                        '${live_rate}', '${margin}', '${leverage}', currency_pair,
                        currency_type, order_setting, market_order_type, market_order_price,
                        stop_loss, take_profit, stop_loss_price, take_profit_price,
                        '${live_rate}', order_status, take_profit_status, stop_loss_status, lotsize_in_lak,'${copy_trade}'
                    FROM tbl_order
                    WHERE tbl_order_id = '${tbl_order_id}'
                `;

               // console.log(copy_order_query);

                inserted = await pool.query(copy_order_query);
            }

            // ✅ Success Response
            if (inserted && inserted.rowCount > 0) {


                //return res.json({ status: true, message: `Trade copied successfully.` });
                req.session.error = 'Trade copied successfully';

                res.redirect('/order_details/'+tbl_order_id);

            } else {
                req.session.error = 'No trades were inserted';

                res.redirect('/order_details/'+tbl_order_id);
            }
        } else {
            //return res.json({ status: false, message: 'No eligible users with sufficient balance.' });
            req.session.error = 'No eligible users with sufficient balance.';

            res.redirect('/order_details/'+tbl_order_id);
        }
    } catch (error) {
        console.error('Error in copy_open_trade:', error);
        return res.status(500).json({ status: false, message: 'Internal server error.' });
    }
});




app.get('/admin_notification_page', auth, (req, res) => {

    var data = JSON.stringify({
        "tbl_admin_id": "1"
    });

    var headers = {
        'Authorization': 'Bearer ' + req.session.token,
        'Content-Type': 'application/json'
    }

    axios.all([axios.post(apiurl + '/admin_push_notification_data/admin_notification_list_api', data, { "headers": headers })])
        .then(axios.spread((noti_list_res) => {

            res.render('notification_send_admin', {
                noti_list_data: noti_list_res.data,
                layout: true,
                pagetitle: 'noti_msg_page'
            })
        }))

});


app.post('/send_notification', auth, (req, res) => {

    var data = JSON.stringify({
        "tbl_admin_id": "1",
        "title": req.body.title,
        "message_txt": req.body.msg_text

    });

    var headers = {
        'Authorization': 'Bearer ' + req.session.token,
        'Content-Type': 'application/json'
    }

    axios.all([axios.post(apiurl + '/admin_push_notification_data/admin_send_notification_to_user_api/', data, { "headers": headers })])
        .then(axios.spread((noti_res) => {
            res.json({ noti_resulst_res: noti_res.data });
        }))
});


// //////////////////////////////////////   Add balance to user wallet code start from here   //////////////////////////


app.get('/amount_add_to_user_login_account_list_by_admin', auth, async (req, res) => {
    try {

        const result = await pool.query(`SELECT tbl_deposit.*, (SELECT fname || ' ' || lname FROM tbl_user WHERE tbl_user_id = tbl_deposit.tbl_user_id) AS user_name FROM tbl_deposit where updated_by = 'add_balance_by_admin' ORDER BY tbl_deposit_id DESC;`);

        const user_depo_data = result.rows;
        res.render('amount_add_to_user_login_account_list_by_admin', {
            layout: true,
            user_depo_data: user_depo_data,
            pagetitle: 'add_amt_login_coin'
        });
    } catch (error) {
        console.error('Error fetching data:', error);
        res.status(500).send('Error fetching data');
    }
});

app.get('/add_amount_to_user_login_account', auth,  async (req, res) => {
    try{
        res.render('add_amount_to_user_wallet', {
            layout: true,
            pagetitle: 'add_amt_login_coin'
        })
    } catch (error) {
        console.log(error);
    }
});

app.post('/check_login_id',  auth, (req, res) => {

    const { log_id } = req.body;

    var data = JSON.stringify({

        "tbl_admin_id" : "1",
        "login_id": log_id
    })

    var headers = {
        'Authorization': 'Bearer ' + req.session.token,
        'Content-Type': 'application/json'
    }

    axios.all([axios.post(apiurl + '/add_balance_by_admin_data/check_login_id_API', data, { 'headers': headers })])
        .then(axios.spread((ck_res) => {
            res.json({ ckuser_res: ck_res.data });
        })).catch((err) => {
            console.log(err);
        });
})

app.post('/amount_add',  auth, (req, res) => {

    var data = JSON.stringify({
        "tbl_admin_id" : "1",
        "login_id": req.body.loginid,
        "amount": req.body.amount,
    });

    var headers = {
        'Authorization': 'Bearer ' + req.session.token,
        'Content-Type': 'application/json'
    }

    axios.all([axios.post(apiurl + '/add_balance_by_admin_data/add_balance_to_mt5_login_id_API', data, { 'headers': headers })])
    .then(axios.spread((addamt_res) => {
        res.json({ add_amt_res: addamt_res.data });
    })).catch((err) => {
        console.log(err);
    });
});



// //////////////////////////////////////   Add balance to user wallet code start from here   //////////////////////////



/////////////////////////////////////  Support details start from here //////////////////////

app.get('/request_account_delete',  (req, res) => {
    res.render('app_user_request_account_delete', {
       layout: false,
       // vendor_data: ven_res.data,
       // pagetitle: 'vendor_page'
    });    
});


app.post('/admin/user_req_account_delete',  (req, res)=>{
    const { fullname, email, mobile, reason } = req.body;

 
    var data = {
        "full_name" : fullname,
        "email"     : email,
        "mobile"    : mobile,
        "reason"    : reason,  
    }

    var headers = {
        // 'Authorization': 'Bearer ' + req.session.token,
        'Content-Type': 'application/json'
    }
 
    axios.all([axios.post(user_apiurl + '/user_data/requset_delete_account_API', data, { 'headers' : headers }) ])
    .then(axios.spread((user_res_cont) => {
        res.json({ user_res_cont : user_res_cont.data});
    })).catch((err) => {
        console.log(err);
    });
});


app.get('/err_page', (req, res) => {
    res.status(404).render("invoice_page_404.ejs", {
        layout: false,
    })
})

app.get('*', (req, res) => {
    res.status(404).render("page_404.ejs")
})

app.listen(port, () => console.log(`Listening on port ${port}`));