const http = require('http');
const WebSocket = require('ws');
const pg = require('pg');
const dbconfig = require('../db'); // Adjust path as necessary
const moment = require('moment');

const pool = new pg.Pool(dbconfig);
const server = http.createServer();
const wss = new WebSocket.Server({ server, path: '/balance_update_by_account_id_api' });

const clientsData = new Map(); // To store parameters for each client

async function fetchAndSendData() {
  for (const [client, params] of clientsData.entries()) {
    if (params && params.tbl_user_id && params.login_id) {
      const { tbl_user_id, login_id } = params;

   

      try {
        const select_Query = await pool.query(
          `SELECT 
            (SELECT sum(margin) as total_used_margin FROM tbl_order WHERE tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}' AND order_status = 'open'),
            tbl_mt5_user.balance as account_balance, tbl_mt5_user.leverage, tbl_mt5_user.joining_date, tbl_mt5_user.joining_time, tbl_market_live_rate.currency_pair AS marker_pair, tbl_market_live_rate.sell_bidprice, tbl_market_live_rate.buy_askprice, tbl_market_live_rate.market_status, tbl_order.* FROM tbl_order
            INNER JOIN tbl_market_live_rate ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair INNER JOIN  
            tbl_mt5_user ON tbl_mt5_user.login_id = '${login_id}' WHERE tbl_order.order_status = 'open' AND tbl_order.tbl_user_id = '${tbl_user_id}' AND tbl_order.login_id = '${login_id}'`
        );
        const count = select_Query.rowCount;

        if (count > 0) {

          const resdata = select_Query.rows;
          const sell_bidprice = resdata[0].sell_bidprice;
          const buy_askprice = resdata[0].buy_askprice;
          const account_balance = resdata[0].account_balance;
          const leverage = resdata[0].leverage;
          const currency_pair = resdata[0].currency_pair;
          console.log('login_id', login_id);
          console.log('currency_pair', currency_pair);
          

          //////  new 
          if(resdata[0].total_used_margin == null) {
            var total_used_margin = 0;
          }else {
            var total_used_margin = resdata[0].total_used_margin;
          }
          
          //////  new  

          var total_profitloss_value = 0; // Initialize total profit/loss value for this client
          var total_tradesize_lots = 0; // Initialize total profit/loss value for this client

          const data  = []

          resdata.forEach((table) => {
            let profitloss;
            if (table.type === 'sell') {
              profitloss = table.exchange_rate - table.sell_bidprice;
            } else {
              profitloss = table.buy_askprice - table.exchange_rate;
            }
            // const profitloss_value = (profitloss.toFixed(5)) * table.lotsize_in_lak;
            const profitloss_value = Number(((profitloss.toFixed(5)) * table.lotsize_in_lak * table.tradesize_lots.toFixed(2)).toFixed(2));
            
            const profitloss_type = profitloss_value >= 0 ? 'profit' : 'loss';

            total_profitloss_value += profitloss_value; // Accumulate profitloss_value
            total_tradesize_lots += table.tradesize_lots; // Accumulate profitloss_value
          
          });
          // Push total_profitloss_value after the loop
          // data.push(total_profitloss_value);

          const total_profitloss_type = total_profitloss_value >= 0 ? 'profit' : 'loss';
          const updated_account_balance = account_balance + total_profitloss_value;
          const free_mrgn = account_balance - total_used_margin + total_profitloss_value;

          console.log('total_profitloss_value', total_profitloss_value);
          console.log('total_profitloss_type', total_profitloss_type);
          console.log('updated_account_balance', updated_account_balance);
          console.log('free_mrgn', free_mrgn);
          
          
        
          if (client.readyState === WebSocket.OPEN) {
            client.send(JSON.stringify({ status : true, event: `User account details by loginid`, tbl_user_id : tbl_user_id, login_id : login_id,   balance : account_balance.toFixed(2), equity : updated_account_balance.toFixed(2), total_order_count : count, total_tradesize_lots : total_tradesize_lots.toFixed(2), total_pl : total_profitloss_value.toFixed(2), free_mrgn : free_mrgn.toFixed(2), margin : total_used_margin.toFixed(2), total_profitloss_type : total_profitloss_type, leverage : leverage, joining_date : resdata[0].joining_date, joining_time : resdata[0].joining_time}));
          }
        } else {

          

          const else_Query = await pool.query(`SELECT balance as account_balance, leverage, joining_date, joining_time FROM tbl_mt5_user where login_id = '${login_id}' AND tbl_user_id = '${tbl_user_id}'`);
          
          if(else_Query.rowCount > 0){

            const elsresdata = else_Query.rows;
        
          
            const elsaccount_balance = elsresdata[0].account_balance;
            const leverage = elsresdata[0].leverage;

            if (client.readyState === WebSocket.OPEN) {
              client.send(JSON.stringify({ status : true, event: `No order found in user account details by loginid`, tbl_user_id : tbl_user_id, login_id : login_id, balance : elsaccount_balance.toFixed(2), equity : elsaccount_balance.toFixed(2), total_order_count : 0, total_tradesize_lots : "0.00", total_pl : "0.00", free_mrgn : elsaccount_balance.toFixed(2), margin : "0.00", total_profitloss_type : "normal", leverage : leverage, joining_date : elsresdata[0].joining_date, joining_time : elsresdata[0].joining_time }));
            }

          }else{

            if (client.readyState === WebSocket.OPEN) {
              client.send(JSON.stringify({ status : false, event: `Account not found`}));
            }

          }
          
        }
      } catch (err) {
        console.error('Error updating tbl_order:', err);
      }
    }
  }
}

wss.on('connection', function connection(ws) {
  ws.on('message', function incoming(message) {
    try {
      const receivedData = JSON.parse(message);
      const { tbl_user_id, login_id } = receivedData;

      if (tbl_user_id && login_id) {
        // Check if a client with the same user ID already exists
        let existingClient = null;
        for (const [client, params] of clientsData.entries()) {
          if (params && params.tbl_user_id === tbl_user_id && params.login_id === login_id) {
            existingClient = client;
            break;
          }
        }

        if (existingClient) {
          existingClient.close(); // Close the existing connection
          clientsData.delete(existingClient); // Remove the old client's data
        }

        // Store the new connection
        clientsData.set(ws, { tbl_user_id, login_id });

        // console.log('Updated client data:', clientsData);
      }
    } catch (error) {
      console.error('Error parsing JSON message:', error);
    }
  });

  ws.on('close', function close() {
    // Remove client data on disconnect
    clientsData.delete(ws);
    // console.log('Client disconnected, updated client data:', clientsData);
  });

  console.log('Client connected');
});

// Periodically fetch and send data to all clients every 3 seconds
setInterval(fetchAndSendData, 3000);

server.listen(8153, function listening() {
  console.log('Server is listening on port 8153');
});
