const http = require('http');
const WebSocket = require('ws');
const pg = require('pg');
const dbconfig = require('../db'); // Adjust path as necessary
const moment = require('moment');

const pool = new pg.Pool(dbconfig);
const server = http.createServer();
const wss = new WebSocket.Server({ server, path: '/total_currencywise_open_order_api' });

const clientsData = new Map(); // To store parameters for each client

async function fetchAndSendData() {
  for (const [client, params] of clientsData.entries()) {
    const { tbl_user_id, login_id, currency_pair } = params;

    try {
      const select_Query = await pool.query(
        `SELECT 
          (SELECT currencypair_image FROM tbl_currencypair_logo WHERE status = '1' AND currencypair = tbl_order.currency_pair),
          tbl_market_live_rate.currency_pair AS marker_pair, 
          tbl_market_live_rate.sell_bidprice, 
          tbl_market_live_rate.buy_askprice,
          tbl_market_live_rate.market_status,
          tbl_order.*
         FROM tbl_order 
         INNER JOIN tbl_market_live_rate  ON tbl_order.currency_pair = tbl_market_live_rate.currency_pair 
         WHERE tbl_order.order_status = 'open' 
         AND tbl_order.currency_pair = '${currency_pair}' 
         AND tbl_order.tbl_user_id = '${tbl_user_id}' 
         AND tbl_order.login_id = '${login_id}'`
      );
      const count = select_Query.rowCount;

  
      if (count > 0) {
        const resdata = select_Query.rows;
        const sell_bidprice = resdata[0].sell_bidprice;
        const buy_askprice = resdata[0].buy_askprice;

        var total_profitloss_value = 0; // Initialize total profit/loss value for this client
        var total_tradesize_lots = 0; // Initialize total profit/loss value for this client

        const data  = []

        resdata.forEach((table) => {
          let profitloss;
          if (table.type === 'sell') {
            profitloss = table.exchange_rate - table.sell_bidprice;
          } else {
            profitloss = table.buy_askprice - table.exchange_rate;
          }
          const profitloss_value = Number(((profitloss.toFixed(5)) * table.lotsize_in_lak * table.tradesize_lots.toFixed(2)).toFixed(2));
          const profitloss_type = profitloss_value >= 0 ? 'profit' : 'loss';

          total_profitloss_value += profitloss_value; // Accumulate profitloss_value
          total_tradesize_lots += table.tradesize_lots; // Accumulate profitloss_value
        
          // console.log('table.tbl_order_id', table.tbl_order_id);
          // console.log('table.tradesize_lots', table.tradesize_lots);
          // console.log('profitloss_type', profitloss_type);
          // console.log('profitloss_value', profitloss_value);
        });
        // Push total_profitloss_value after the loop
        // data.push(total_profitloss_value);

        const total_profitloss_type = total_profitloss_value >= 0 ? 'profit' : 'loss';

        // console.log('Final total_profitloss_value', total_profitloss_value);
        // console.log('total_tradesize_lots', total_tradesize_lots);
       
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify({ status : true, event: `Total ${currency_pair} Open order data`, total_order_count : count,  total_tradesize_lots : total_tradesize_lots.toFixed(2), total_profitloss_value: total_profitloss_value.toFixed(2), 
          total_profitloss_type : total_profitloss_type, sell_bidprice : sell_bidprice.toFixed(5), buy_askprice : buy_askprice.toFixed(5), }));
        }
      } else {
        if (client.readyState === WebSocket.OPEN) {
          client.send(JSON.stringify({ status : false, event: `No ${currency_pair} open orders found`,}));
        }
      }
    } catch (err) {
      console.error('Error updating tbl_order:', err);
    }
  }
}

wss.on('connection', function connection(ws) {
  ws.on('message', function incoming(message) {
    console.log('received: %s', message);
    try {
      const receivedData = JSON.parse(message);
      if (receivedData.tbl_user_id && receivedData.login_id && receivedData.currency_pair) {
        // Store client parameters
        clientsData.set(ws, {
          tbl_user_id: receivedData.tbl_user_id,
          login_id: receivedData.login_id,
          currency_pair: receivedData.currency_pair,
        });
        console.log('Updated client data:', clientsData);
      }
    } catch (error) {
      console.error('Error parsing JSON message:', error);
    }
  });

  ws.on('close', function close() {
    clientsData.delete(ws); // Remove client data on disconnect
    console.log('Client disconnected, updated client data:', clientsData);
  });
});

// Periodically fetch and send data to all clients every 3 seconds
setInterval(fetchAndSendData, 3000);

server.listen(8156, function listening() {
  console.log('Server is listening on port 8156');
});
