const pg = require('pg');
const path = require('path');
const moment = require('moment');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');


function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);


const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

module.exports = {

    apply_coupon_API: (request, response) => {

        const { tbl_user_id,promo_code,amount } = request.body;
    
        pool.query(`SELECT * FROM tbl_promo_code WHERE promo_code = '${promo_code}' AND status='1'`, async (error, result) => {
    
            if (error) {
                throw error
            }
            var count = result.rowCount;
    
            if (count > 0) {

                const current_date = moment(date).format("YYYY MMM  DD");
                const coupon_expiry_date = moment(result.rows[0].expiry_date).format("YYYY MMM  DD");
                

                if(current_date <= coupon_expiry_date)
                {

                    if(amount >= result.rows[0].minumum_amount)
                    {
                        

                        if(result.rows[0].code_type=='Flat')
                        {

                            response.status(201).json({ status: true, message: 'Coupon successfully applied', coupon_code : result.rows[0].promo_code , coupon_type : result.rows[0].code_type,main_amount:amount, coupon_amount : result.rows[0].upto_amount, total_amount : +amount+ +result.rows[0].upto_amount});

                        }else{
                            var percentage = ((amount/100)*result.rows[0].percentage_value).toFixed(2)
                            if(percentage > result.rows[0].upto_amount)
                            {
                                var new_added_amount = result.rows[0].upto_amount;
                            }else{
                                var new_added_amount = percentage;
                            }
                            response.status(201).json({ status: true, message: 'Coupon successfully applied', coupon_code : result.rows[0].promo_code , coupon_type : result.rows[0].code_type,main_amount:amount, coupon_amount :new_added_amount, total_amount : +amount+ +new_added_amount});

                        }
                        
                    }else{
                        response.status(201).json({ status: false, message: 'This promo code is valid for a minimum amount of '+result.rows[0].minumum_amount, data: [] })
                    }
                    
                }else{
                    response.status(201).json({ status: false, message: 'This promo code has expired', data: [] })
                }
    
                // var res = result.rows;
                // var data = [];
                // res.forEach(function (table) {

                //     let cat = {
                //         tbl_promotion_banner_id: isNull(table.tbl_promotion_banner_id),
                //         title: isNull(table.title),                     
                //         banner_image: isNull(base_img_url + "/banner_image/" + table.banner),
                     
                //     };
                //     data.push(cat);

                // });
                // response.status(201).json({ status: true, message: 'Banner list API', data: data });
    
            } else {
                response.status(201).json({ status: false, message: 'This promo code is invalid', data: [] })
            }
        })
    
    },

};

