const pg = require('pg');
const moment = require('moment');
const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);
const axios = require('axios');

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


module.exports = {


    currency_convert_to_usd_exchangerate_api: async (request, response) => {
        try {
            const result = await pool.query(`SELECT currency_pair, quote_currency FROM tbl_lots_size ORDER BY tbl_lots_size_id DESC`);
    
            if (result.rowCount > 0) {
                const resdat = result.rows;
                const quote = 'USD'; // we are converting TO USD
                const amount = 1;
    
                // Get the exchange rate data from the API
                const exchangeApiRes = await axios.get(`https://v6.exchangerate-api.com/v6/84d916741bedebf252c436bc/latest/${quote}`);
                const rateData = exchangeApiRes.data;
                const apires_status = rateData.result;
    
                if (apires_status === 'success') {
                    const rateDate = new Date(rateData.time_last_update_utc).toISOString().split('T')[0]; // Format: YYYY-MM-DD
                    const rates = rateData.conversion_rates;
    
                    for (const row of resdat) {
                        const quote_currency = row.quote_currency;
                        //console.log('quote_currency', quote_currency);
                        
    
                        if (rates[quote_currency]) {
                            const rate_in_point = Number(amount / rates[quote_currency]);
                            const rate = rate_in_point.toFixed(6);

                           // console.log('rate', rate);
                            
    
                            await pool.query(`UPDATE tbl_lots_size SET quote_currency_amount = $1, quote_currency_amount_in_usd = $2, 
                                     quote_currency_rate_date = $3, api_response_status = $4 WHERE quote_currency = $5`,
                                [amount, rate, rateDate, apires_status, quote_currency]
                            );
    
                            console.log(`Updated ${quote_currency} with rate ${rate}`);
                        } else {
                            console.warn(`Rate not found for ${quote_currency}`);
                        }
                    }
    
                    return response.status(200).json({ status: true, message: 'Currency conversions updated.' });
                } else {
                    return response.status(500).json({ status: false, message: 'Exchange API did not return success.' });
                }
            } else {
                return response.status(404).json({ status: false, message: 'No currency pairs found in database.' });
            }
        } catch (err) {
            return response.status(500).json({ status: false, message: 'Something went wrong', error: err.message });
        }
    },

    
    currency_convert_to_usd_api: async (request, response) => {
        try {
            const result = await pool.query(`SELECT currency_pair FROM tbl_lots_size ORDER BY tbl_lots_size_id DESC`);
            const resdat = result.rows;
    
            if (resdat.length === 0) {
                return response.status(201).json({ status: false, message: 'Currency data not found.' });
            }
    
            const amount = 1;
            const to = 'USD';
    
            const updateTasks = resdat
                .filter(row => row.currency_pair.length === 6)
                .map(async (row) => {
                    const currency_pair = row.currency_pair;
                    const base = currency_pair.substring(0, 3);
                    const quote = currency_pair.substring(3, 6);
                    const from = quote;
    
                    // If quote currency is already USD, no need for API call
                    if (from === 'USD') {
                        const rate = 1;
                        const rateDate = new Date().toISOString().split('T')[0]; // Format as YYYY-MM-DD
                        const apiMsg = 'Success';
    
                        await pool.query(`
                            UPDATE tbl_lots_size 
                            SET quote_currency = $1, 
                                quote_currency_amount = $2, 
                                quote_currency_amount_in_usd = $3,
                                quote_currency_rate_date = $4,
                                api_response_message = $5
                            WHERE currency_pair = $6
                        `, [from, amount, rate, rateDate, apiMsg, currency_pair]);
                    } else {
                        // Call the API for non-USD currencies
                        const apiUrl = `https://api.frankfurter.app/latest?amount=${amount}&from=${from}&to=${to}`;
    
                        try {
                            const apiResponse = await axios.get(apiUrl);
    
                            if (apiResponse.status === 200 && apiResponse.data?.rates?.[to]) {
                                const rate = apiResponse.data.rates[to];
                                const rateDate = apiResponse.data.date;
                                const apiMsg = 'Success';
    
                                await pool.query(`
                                    UPDATE tbl_lots_size 
                                    SET quote_currency = $1, 
                                        quote_currency_amount = $2, 
                                        quote_currency_amount_in_usd = $3,
                                        quote_currency_rate_date = $4,
                                        api_response_message = $5
                                    WHERE currency_pair = $6
                                `, [from, amount, rate, rateDate, apiMsg, currency_pair]);
                            } else {
                                const failMsg = 'Invalid API response structure';
                                await pool.query(`
                                    UPDATE tbl_lots_size 
                                    SET quote_currency = $1, 
                                        quote_currency_amount = $2, 
                                        quote_currency_amount_in_usd = NULL,
                                        quote_currency_rate_date = NULL,
                                        api_response_message = $3
                                    WHERE currency_pair = $4
                                `, [from, amount, failMsg, currency_pair]);
                            }
                        } catch (apiError) {
                            const failMsg = apiError.response?.data?.message || apiError.message;
    
                            await pool.query(`
                                UPDATE tbl_lots_size 
                                SET quote_currency = $1, 
                                    quote_currency_amount = $2, 
                                    quote_currency_amount_in_usd = NULL,
                                    quote_currency_rate_date = NULL,
                                    api_response_message = $3
                                WHERE currency_pair = $4
                            `, [from, amount, failMsg, currency_pair]);
                        }
                    }
                });
    
            await Promise.allSettled(updateTasks);
    
            return response.status(201).json({ status: true, message: 'Currency conversion update complete.' });
        } catch (err) {
            return response.status(500).json({ status: false, message: 'Something went wrong', error: err.message });
        }
    },

    bck_currency_convert_to_usd_exchangerate_api: async (request, response) => {
        try {
            const result = await pool.query(`SELECT currency_pair FROM tbl_lots_size ORDER BY tbl_lots_size_id DESC`);
            // const result = await pool.query(`SELECT currency_pair FROM tbl_lots_size where currency_pair = 'USDCNH' ORDER BY tbl_lots_size_id DESC`);
            const resdat = result.rows;
    
            if (resdat.length === 0) {
                return response.status(201).json({ status: false, message: 'Currency data not found.' });
            }
    
            const amount = 1;
            const updateTasks = resdat.filter(row => row.currency_pair.length === 6).map(async (row) => {
                

                const currency_pair = row.currency_pair;
                const quote = currency_pair.substring(3, 6); // quote currency is what we're converting to USD
              
                // Fetch once from exchangerate API
                
                const exchangeApiRes = await axios.get(`https://v6.exchangerate-api.com/v6/84d916741bedebf252c436bc/latest/${quote}`);
                // console.log('exchangeApiRes', exchangeApiRes);
                
                const rateData = exchangeApiRes.data;

                // console.log('rateData', rateData);
                
                const apires_status = rateData.result;
                // console.log('apires_status', apires_status);
                
                
                if (apires_status == 'success') {

                    const rateDate = new Date(rateData.time_last_update_utc).toISOString().split('T')[0]; // Format: YYYY-MM-DD
                    const rates = rateData.conversion_rates;
                    let quoteusd = 'USD';
                    let rate = rates[quoteusd];
                    await pool.query(`UPDATE tbl_lots_size SET quote_currency = $1, quote_currency_amount = $2, quote_currency_amount_in_usd = $3, quote_currency_rate_date = $4, api_response_status = $5 WHERE currency_pair = $6`, [quote, amount, rate, rate ? rateDate : null, apires_status, currency_pair]);

                    console.log(`Currency conversion update complete of currency_pair ${currency_pair}.`);

                }else{
                    
                    await pool.query(`UPDATE tbl_lots_size SET quote_currency = $1, quote_currency_amount = $2, api_response_status = $3 WHERE currency_pair = $6`, [quote, amount, apires_status, currency_pair]);
                    console.log(`else Currency conversion is not updated of currency_pair ${currency_pair}.`);
                }
            });
    
            await Promise.allSettled(updateTasks);
    
            return response.status(201).json({ status: true, message: 'Currency conversion update complete.' });
        } catch (err) {
            return response.status(500).json({ status: false, message: 'Something went wrong', error: err.message });
        }
    },

};

