var {
    failure_callback,
    checkVar,
    isValidEmail
} = require('../middleware/common');


module.exports = {

    mlm_withdrawl_amount_API: function (req, res, next) {
    try {
        const { mlm_login_id, amount, wallet_address } = req.body;

        if (checkVar(mlm_login_id)) {
            return failure_callback(res, ['mlm_login_id is required', 400]);
        }
        if (checkVar(amount)) {
            return failure_callback(res, ['amount is required', 400]);
        }
        if (!amount || isNaN(amount) || parseFloat(amount) <= 0) {
            return failure_callback(res, ['amount greater than 0 is required', 400]);
        }
        if (!wallet_address || checkVar(wallet_address)) {
            return failure_callback(res, ['wallet_address is required', 400]);
        }
        return next();
    } catch (e) {
        return failure_callback(res, [e.message, 500]);
    }
    },
    mlm_signup_API: function (req, res, next) {

        try {
            const {full_name, email, mlm_login_id, mobile, country} = req.body

            if (checkVar(full_name)) {
                return failure_callback(res, ['full_name is required', 400])
            }
            if (checkVar(mlm_login_id)) {
                return failure_callback(res, ['mlm_login_id is required', 400])
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }

            if (checkVar(country)) {
                return failure_callback(res, ['country is required', 400])
            }
           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    user_id_pagination_validaion: function (req, res, next) {

        try {
            const {tbl_user_id, pagesize, pagenumber } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(pagesize)) {
                return failure_callback(res, ['pagesize is required', 400])
            }
            if (checkVar(pagenumber)) {
                return failure_callback(res, ['pagenumber is required', 400])
            }
            
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    trading_account_Login_API: function (req, res, next) {

        try {
            const {login_id, password, broker_name,tbl_user_id } = req.body;

            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            if (checkVar(broker_name)) {
                return failure_callback(res, ['broker_name is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    signup_API: function (req, res, next) {

        try {
            const {fname,lname,firebase_token,email,password,dob,mobile } = req.body

            if (checkVar(fname)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(lname)) {
                return failure_callback(res, ['lname is required', 400])
            }
            if (checkVar(firebase_token)) {
                return failure_callback(res, ['firebase_token is required', 400])
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            if (checkVar(dob)) {
                return failure_callback(res, ['dob is required', 400])
            }
            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    social_Login_signup_API: function (req, res, next) {

        try {
            const {email, login_type, social_type, social_id, firebase_token} = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(login_type)) {
                return failure_callback(res, ['login_type is required', 400])
            }
            if (checkVar(social_type)) {
                return failure_callback(res, ['social_type is required', 400])
            }
            if (checkVar(social_id)) {
                return failure_callback(res, ['social_id is required', 400])
            }
            if (checkVar(firebase_token)) {
                return failure_callback(res, ['firebase_token is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    update_social_profile_API: function (req, res, next) {

        try {
            const {tbl_user_id, fname, lname, firebase_token, email, password, dob, mobile} = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(fname)) {
                return failure_callback(res, ['fname is required', 400])
            }
            if (checkVar(lname)) {
                return failure_callback(res, ['lname is required', 400])
            }
            if (checkVar(firebase_token)) {
                return failure_callback(res, ['firebase_token is required', 400])
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            if (checkVar(dob)) {
                return failure_callback(res, ['dob is required', 400])
            }
            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    otp_verify: function (req, res, next) {

        try {
            const { email,email_otp } = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(email_otp)) {
                return failure_callback(res, ['email_otp is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    Update_transfer_pin_API: function (req, res, next) {

        try {
            const { tbl_user_id, transfer_pin } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(transfer_pin)) {
                return failure_callback(res, ['transfer_pin is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    Check_user_via_username_API: function (req, res, next) {

        try {
            const { user_name } = req.body

            if (checkVar(user_name)) {
                return failure_callback(res, ['user_name is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Check_user_via_account_id_API: function (req, res, next) {

        try {
            const { account_id } = req.body

            if (checkVar(account_id)) {
                return failure_callback(res, ['account_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    amount_transfer_fee_api: function (req, res, next) {

        try {
            const { amount } = req.body

            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    user_name_validation: function (req, res, next) {

        try {
            const { user_name } = req.body

            if (checkVar(user_name)) {
                return failure_callback(res, ['user_name is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Wallet_to_wallet_history: function (req, res, next) {

        try {
            const { user_name, user_account_id } = req.body;

            if (checkVar(user_name)) {
                return failure_callback(res, ['user_name is required', 400])
            }
            if (checkVar(user_account_id)) {
                return failure_callback(res, ['user_account_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    Wallet_to_wallet_amount_transfer_api: function (req, res, next) {

        try {
            const { tbl_user_id, from_user_name, from_user_account_id, to_user_name,  to_user_account_id, amount, deduction_percentage,fee,main_amount,transfer_pin } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(from_user_name)) {
                return failure_callback(res, ['from_user_name is required', 400])
            }
            if (checkVar(from_user_account_id)) {
                return failure_callback(res, ['from_user_account_id is required', 400])
            }
            if (checkVar(to_user_name)) {
                return failure_callback(res, ['to_user_name is required', 400])
            }
            if (checkVar(to_user_account_id)) {
                return failure_callback(res, ['to_user_account_id is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(deduction_percentage)) {
                return failure_callback(res, ['deduction_percentage is required', 400])
            }
            if (checkVar(fee)) {
                return failure_callback(res, ['fee is required', 400])
            }
            if (checkVar(main_amount)) {
                return failure_callback(res, ['main_amount is required', 400])
            }
            if (checkVar(transfer_pin)) {
                return failure_callback(res, ['transfer_pin is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    email_validation: function (req, res, next) {

        try {
            const { email } = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    Login_API: function (req, res, next) {

        try {
            const { email,password,firebase_token } = req.body

            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password)) {
                return failure_callback(res, ['password is required', 400])
            }
            if (checkVar(firebase_token)) {
                return failure_callback(res, ['firebase_token is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    mlm_deposit_amount_API: function (req, res, next) {

        try {
            const {mlm_login_id, deposit_type, amount, user_transection_address } = req.body

            if (checkVar(mlm_login_id)) {
                return failure_callback(res, ['mlm_login_id is required', 400])
            }
            if (checkVar(deposit_type)) {
                return failure_callback(res, ['deposit_type is required', 400])
            }
           
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            
            if (checkVar(user_transection_address)) {
                return failure_callback(res, ['user_transection_address is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    deposit_amount_API: function (req, res, next) {

        try {
            const {tbl_user_id, deposit_type, currency_type, amount, mt5_number, user_transection_address } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(deposit_type)) {
                return failure_callback(res, ['deposit_type is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(mt5_number)) {
                return failure_callback(res, ['mt5_number is required', 400])
            }
            if (checkVar(user_transection_address)) {
                return failure_callback(res, ['user_transection_address is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    withdrawal_amount_API: function (req, res, next) {

        try {
            const {tbl_user_id, account_id, withdrawal_type, currency_type, amount, mt5_number, wallet_address, name } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(account_id)) {
                return failure_callback(res, ['account_id is required', 400])
            }
            if (checkVar(withdrawal_type)) {
                return failure_callback(res, ['withdrawal_type is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(amount)) {
                return failure_callback(res, ['amount is required', 400])
            }
            if (checkVar(mt5_number)) {
                return failure_callback(res, ['mt5_number is required', 400])
            }
            if (checkVar(wallet_address)) {
                return failure_callback(res, ['wallet_address is required', 400])
            }
            if (checkVar(name)) {
                return failure_callback(res, ['name is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    Update_location_API: function (req, res, next) {

        try {
            const {latitude, longitude,tbl_user_id } = req.body

            if (checkVar(latitude)) {
                return failure_callback(res, ['latitude is required', 400])
            }
            if (checkVar(longitude)) {
                return failure_callback(res, ['longitude is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    Location_wise_valet_user_list: function (req, res, next) {

        try {
            const {latitude, longitude,tbl_user_id } = req.body

            if (checkVar(latitude)) {
                return failure_callback(res, ['latitude is required', 400])
            }
            if (checkVar(longitude)) {
                return failure_callback(res, ['longitude is required', 400])
            }
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    

    user_id_validaion: function (req, res, next) {

        try {
            const {tbl_user_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    mt5_add_user_API: function (req, res, next) {

        try {
            const {tbl_user_id, name, leverage, email, password_main, phone, agent, country } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(name)) {
                return failure_callback(res, ['name is required', 400])
            }
            if (checkVar(leverage)) {
                return failure_callback(res, ['leverage is required', 400])
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password_main)) {
                return failure_callback(res, ['password_main is required', 400])
            }
            if (checkVar(phone)) {
                return failure_callback(res, ['phone is required', 400])
            }
            if (checkVar(agent)) {
                return failure_callback(res, ['agent is required', 400])
            }
            if (checkVar(country)) {
                return failure_callback(res, ['country is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },




    All_deposit_list_by_mt5_account_API: function (req, res, next) {

        try {
            const {tbl_user_id,login_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    All_withdrawal_list_by_mt5_account : function(req, res, next){

        try {
            const { tbl_user_id, login_id } = req.body;

            if(checkVar(tbl_user_id)){
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if(checkVar(login_id)){
                return failure_callback(res, ['login_id is required', 400])
            }
            return next();
        } catch (error) {
            return failure_callback(res, [error.message, 500]);
        }
    } ,




    apply_coupon_API : function(req, res, next){

        try {
            const { tbl_user_id,promo_code,amount  } = req.body;

            if(checkVar(tbl_user_id)){
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if(checkVar(promo_code)){
                return failure_callback(res, ['promo_code is required', 400])
            }
            if(checkVar(amount)){
                return failure_callback(res, ['amount is required', 400])
            }
            return next();
        } catch (error) {
            return failure_callback(res, [error.message, 500]);
        }
    },

    requset_delete_account_validaion : function (req, res, next){

        try {
            const {full_name, mobile, email, reason } = req.body;

            if (checkVar(full_name)) {
                return failure_callback(res, ['full_name is required', 400]);
            }
            if (checkVar(mobile)) {
                return failure_callback(res, ['mobile is required', 400]);
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400]);
            }
            if (checkVar(reason)) {
                return failure_callback(res, ['reason is required', 400]);
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },


    mt5_new_add_user_API: function (req, res, next) {

        try {
            const {tbl_user_id, name, leverage, email, password_main, phone, agent, country, group_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(name)) {
                return failure_callback(res, ['name is required', 400])
            }
            if (checkVar(leverage)) {
                return failure_callback(res, ['leverage is required', 400])
            }
            if (checkVar(email)) {
                return failure_callback(res, ['email is required', 400])
            }
            if (checkVar(password_main)) {
                return failure_callback(res, ['password_main is required', 400])
            }
            if (checkVar(phone)) {
                return failure_callback(res, ['phone is required', 400])
            }
            if (checkVar(agent)) {
                return failure_callback(res, ['agent is required', 400])
            }
            if (checkVar(country)) {
                return failure_callback(res, ['country is required', 400])
            }
            if (checkVar(group_id)) {
                return failure_callback(res, ['group_id is required', 400])
            }
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    mlm_update_amount_API: function (req, res, next) {

        try {
            const {mlm_login_id, updated_bal } = req.body

            if (checkVar(mlm_login_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(updated_bal)) {
                return failure_callback(res, ['updated_bal is required', 400])
            }           
            return next();

        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    check_order_type: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, exchange_rate, currency_pair, take_profit_price, stop_loss_price,
            take_profit_status, stop_loss_status } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }            
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(take_profit_price)) {
                return failure_callback(res, ['take_profit_price is required', 400])
            }
            if (checkVar(stop_loss_price)) {
                return failure_callback(res, ['stop_loss_price is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    claculate_order_preview: function (req, res, next) {

        try {
            const {tbl_user_id, login_id, tradesize, exchange_rate, currency_pair, leverage_ratio, currency_type } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    user_account_details_by_loginid: function (req, res, next) {

        try {
            const {tbl_user_id, login_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
           
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    confirm_order: function (req, res, next) {

        try {
            const {tbl_user_id, login_id, type, tradesize, exchange_rate, margin, free_margin, leverage_ratio, currency_pair, currency_type, order_setting, market_order_type, take_profit_status, stop_loss_status } = req.body;

           
            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(margin)) {
                return failure_callback(res, ['margin is required', 400])
            }
            if (checkVar(free_margin)) {
                return failure_callback(res, ['free_margin is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(order_setting)) {
                return failure_callback(res, ['order_setting is required', 400])
            }
            if (checkVar(market_order_type)) {
                return failure_callback(res, ['market_order_type is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },



    order_list_by_type: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, order_status } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(order_status)) {
                return failure_callback(res, ['order_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    close_order: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, order_id, closed_price, profitloss_type, profit_loss_value, closed_by } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(order_id)) {
                return failure_callback(res, ['order_id is required', 400])
            }
            if (checkVar(closed_price)) {
                return failure_callback(res, ['closed_price is required', 400])
            }
            if (checkVar(profitloss_type)) {
                return failure_callback(res, ['profitloss_type is required', 400])
            }
            if (checkVar(profit_loss_value)) {
                return failure_callback(res, ['profit_loss_value is required', 400])
            }
            if (checkVar(closed_by)) {
                return failure_callback(res, ['closed_by is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    closed_order_detail: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, order_id } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(order_id)){
                return failure_callback(res, ['order_id is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    closed_order_list: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, date } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(date)) {
                return failure_callback(res, ['date is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }


    },

    metarg_closed_order_list: function (req, res, next) {

        try {
            const {tbl_user_id, login_id, from_date, to_date,  show_order_type } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(from_date)) {
                return failure_callback(res, ['from_date is required', 400])
            }
            if (checkVar(to_date)) {
                return failure_callback(res, ['to_date is required', 400])
            }
            if (checkVar(show_order_type)) {
                return failure_callback(res, ['show_order_type is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },


    calculate_sell_buy_market_order_preview: function (req, res, next) {
        try {
            const { tbl_user_id, login_id, type, tradesize, exchange_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(take_profit)) {
                return failure_callback(res, ['take_profit is required', 400])
            }
            if (checkVar(stop_loss)) {
                return failure_callback(res, ['stop_loss is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    calculate_sell_buy_without_type_market_order_preview: function (req, res, next) {

        try {
            const { tbl_user_id, login_id, tradesize, exchange_rate, leverage_ratio,
            currency_pair, currency_type, take_profit, stop_loss,
            take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(take_profit)) {
                return failure_callback(res, ['take_profit is required', 400])
            }
            if (checkVar(stop_loss)) {
                return failure_callback(res, ['stop_loss is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },

    edit_calculate_sellbuy_market_order_preview: function (req, res, next) {
        try {
            const {  tbl_user_id, tbl_order_id, login_id, ordr_profit_loss_val, take_profit, stop_loss, take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_order_id)) {
                return failure_callback(res, ['tbl_order_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(ordr_profit_loss_val)) {
                return failure_callback(res, ['ordr_profit_loss_val is required', 400])
            }
            if (checkVar(take_profit)) {
                return failure_callback(res, ['take_profit is required', 400])
            }
            if (checkVar(stop_loss)) {
                return failure_callback(res, ['stop_loss is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },
    edit_order_API: function (req, res, next) {
        try {
            const { tbl_user_id, login_id, tbl_order_id,  take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(tbl_order_id)) {
                return failure_callback(res, ['tbl_order_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            // if (checkVar(take_profit)) {
            //     return failure_callback(res, ['take_profit is required', 400])
            // }
            // if (checkVar(stop_loss)) {
            //     return failure_callback(res, ['stop_loss is required', 400])
            // }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },
    
    calculate_sell_limit_stop_order_preview: function (req, res, next) {
        try {
            const { tbl_user_id, login_id, type, limit_stop_type, tradesize, exchange_rate, order_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            if (checkVar(limit_stop_type)) {
                return failure_callback(res, ['limit_stop_type is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(order_rate)) {
                return failure_callback(res, ['order_rate is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(take_profit)) {
                return failure_callback(res, ['take_profit is required', 400])
            }
            if (checkVar(stop_loss)) {
                return failure_callback(res, ['stop_loss is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }
    },

    calculate_buy_limit_stop_order_preview: function (req, res, next) {
        try {
            const { tbl_user_id, login_id, type, limit_stop_type, tradesize, exchange_rate, order_rate, leverage_ratio, currency_pair, currency_type, take_profit, stop_loss, take_profit_status, stop_loss_status } = req.body;

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(login_id)) {
                return failure_callback(res, ['login_id is required', 400])
            }
            if (checkVar(type)) {
                return failure_callback(res, ['type is required', 400])
            }
            if (checkVar(limit_stop_type)) {
                return failure_callback(res, ['limit_stop_type is required', 400])
            }
            if (checkVar(tradesize)) {
                return failure_callback(res, ['tradesize is required', 400])
            }
            if (checkVar(exchange_rate)) {
                return failure_callback(res, ['exchange_rate is required', 400])
            }
            if (checkVar(order_rate)) {
                return failure_callback(res, ['order_rate is required', 400])
            }
            if (checkVar(leverage_ratio)) {
                return failure_callback(res, ['leverage_ratio is required', 400])
            }
            if (checkVar(currency_pair)) {
                return failure_callback(res, ['currency_pair is required', 400])
            }
            if (checkVar(currency_type)) {
                return failure_callback(res, ['currency_type is required', 400])
            }
            if (checkVar(take_profit)) {
                return failure_callback(res, ['take_profit is required', 400])
            }
            if (checkVar(stop_loss)) {
                return failure_callback(res, ['stop_loss is required', 400])
            }
            if (checkVar(take_profit_status)) {
                return failure_callback(res, ['take_profit_status is required', 400])
            }
            if (checkVar(stop_loss_status)) {
                return failure_callback(res, ['stop_loss_status is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }

    },






    add_to_watchlist_api: function (req, res, next) {

        try {
            const { tbl_user_id, symbol } = req.body

            if (checkVar(tbl_user_id)) {
                return failure_callback(res, ['tbl_user_id is required', 400])
            }
            if (checkVar(symbol)) {
                return failure_callback(res, ['symbol is required', 400])
            }
            return next();
        } catch (e) {
            return failure_callback(res, [e.message, 500]);
        }


    },

}