const http = require('http');
const WebSocket = require('ws');
const pg = require('pg');
const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);
const server = http.createServer();
const urln = "wss://api.tiingo.com/fx";
//let currentTickers = ['EURUSD', 'XAUUSD', 'GBPUSD', 'AUDUSD', 'NZDUSD', 'XAGUSD', 'XPDUSD', 'XPTUSD','AUDCAD','AUDCHF','AUDJPY', 'AUDNZD','AUDUSD','CADCHF',]; // Initial tickers

let currentTickers = [
  'EURUSD', 'XAUUSD', 'GBPUSD', 'AUDUSD', 'NZDUSD', 'XAGUSD', 'XPDUSD', 'XPTUSD',
  'AUDCAD', 'AUDCHF', 'AUDJPY', 'AUDNZD', 'CADCHF', 'CADJPY', 'CHFJPY',
  'EURAUD', 'EURCAD', 'EURCHF', 'EURGBP', 'EURJPY', 'EURNZD',
  'GBPAUD', 'GBPCAD', 'GBPCHF', 'GBPJPY', 'GBPNZD',
  'USDCNH', 'USDCZK', 'USDHUF', 'USDILS', 'USDMXN',
  'USDTWD', 'USDTRY', 'USDINR', 'USDKRW', 'USDCLP', 
  'USDQAR', 'USDPHP', 'USDAED', 'USDKWD', 'USDOMR', 
  'USDPKR', 'USDNPR', 'USDLKR', 'USDMMK', 'USDLAK', 'USDKHR'
]

// let currentTickers = [
//   'EURUSD', 'XAUUSD', 'GBPUSD', 'AUDUSD', 'NZDUSD', 'XAGUSD', 'XPDUSD', 'XPTUSD',
//   'AUDCAD', 'AUDCHF', 'AUDJPY', 'AUDNZD', 'CADCHF', 'CADJPY', 'CHFJPY',
//   'EURAUD', 'EURCAD', 'EURCHF', 'EURGBP', 'EURJPY', 'EURNZD',
//   'GBPAUD', 'GBPCAD', 'GBPCHF', 'GBPJPY', 'GBPNZD',
//   'NZDCAD', 'NZDCHF', 'NZDJPY',
//   'USDCAD', 'USDCHF', 'USDJPY', 'USDHKD', 'USDNOK', 'USDSEK', 'USDSGD', 'USDZAR',
//   'EURSEK', 'EURDKK', 'EURHKD', 'EURNOK', 'EURPLN', 'EURSGD', 'EURZAR', 'EURTRY',
//   'GBPSGD', 'GBPZAR', 'CHFSGD', 'JPYSGD',
//   'AUDHKD', 'AUDSGD', 'AUDCNH', 'AUDMXN', 'AUDPLN', 'AUDSEK', 'AUDTRY', 'AUDZAR',
//   'CADHKD', 'CADSGD',
//   'CHFCNH', 'CHFPLN', 'CHFSEK', 'CHFZAR',
//   'EURAOA', 'EURCNH', 'EURCZK', 'EURHUF', 'EURILS', 'EURMXN', 'EURRUB', 'EURTWD',
//   'GBPCNH', 'GBPDKK', 'GBPHKD', 'GBPNOK', 'GBPPLN', 'GBPRUB', 'GBPSAR', 'GBPSEK', 'GBPTWD', 'GBPTRY',
//   'NZDCNH', 'NZDHKD', 'NZDSGD', 'NZDTRY',
//   'USDCNH', 'USDCZK', 'USDHUF', 'USDILS', 'USDMXN', 'USDPLN', 'USDRUB', 'USDSAR', 'USDSZL', 'USDTHB',
//   'USDTWD', 'USDTRY', 'USDINR', 'USDKRW', 'USDCLP', 'USDARS', 'USDBRL', 'USDIDR', 'USDVND', 'USDMYR',
//   'USDQAR', 'USDPHP', 'USDAED', 'USDKWD', 'USDOMR', 'USDJOD', 'USDLBP', 'USDNGN', 'USDGHS', 'USDZMW',
//   'USDPKR', 'USDNPR', 'USDLKR', 'USDMMK', 'USDLAK', 'USDKHR'
// ];// update on 16-04-2025 
// let currentTickers = ['EURUSD', 'XAUUSD', 'GBPUSD', 'AUDUSD', 'NZDUSD', 'XAGUSD', 'XPDUSD', 'XPTUSD', 'USDJPY', 'GBPJPY', 'EURJPY' ]; // Initial tickers
// "tickers":  ["EURUSD", "XAUUSD", "GBPUSD", "AUDUSD", "AUDUSD", "NZDUSD", "XAGUSD", "XPDUSD", "XPTUSD", "USDJPY", "USDJPY", 'EURJPY']
let tiingoSocket;

const subscribeMessage = () => ({
  eventName: 'subscribe',
  authorization: '477981dda9e9b6a10894f92f2a1be152660e5b3e', // This key is purchased by xtreamfx account    
  eventData: {
    thresholdLevel: 5,
    tickers: currentTickers
  }
});

function connectToTiingo() {
  tiingoSocket = new WebSocket(urln); 

  tiingoSocket.on('open', function open() {
    // console.log('Connected to Tiingo WebSocket API');
    tiingoSocket.send(JSON.stringify(subscribeMessage()));
  });

  tiingoSocket.on('message', async function incoming(data) {
    const message = JSON.parse(data);

    // console.log('message', message);


    if (message.messageType === 'A'){
      try {
        // const currency_pair = message.data[1].toUpperCase();
        // const market_datetime = message.data[2];
        // const sell_bidPrice = message.data[4].toFixed(5);
        // const buy_askPrice = message.data[7].toFixed(5);
        // const midvalue = message.data[5].toFixed(5);

        const currency_pair = message.data[1].toUpperCase();
        const market_datetime = message.data[2];
        const sell_bidPrice = parseFloat(message.data[4]).toFixed(5);
        const buy_askPrice = parseFloat(message.data[7]).toFixed(5);
        const midvalue = parseFloat(message.data[5]).toFixed(5);

        const highPrice = Math.max(midvalue, sell_bidPrice, buy_askPrice);    
        const lowPrice = Math.min(midvalue, sell_bidPrice, buy_askPrice);


        const selectQuery = await pool.query('SELECT currency_pair,highprice,lowprice,buy_askprice,sell_bidprice FROM tbl_market_live_rate WHERE currency_pair = $1', [currency_pair]);

        if (selectQuery.rowCount > 0) {     
          
          const existingHighPrice = parseFloat(selectQuery.rows[0].highprice);
          const existingLowPrice = parseFloat(selectQuery.rows[0].lowprice);
          const privious_sell_bidprice = selectQuery.rows[0].sell_bidprice;
          const privious_buy_askprice = selectQuery.rows[0].buy_askprice;

          if(existingHighPrice < highPrice)
          {
             var newhigh = highPrice
          }else{
            var newhigh = existingHighPrice
          }

          if(existingLowPrice > lowPrice)
            {
               var newlowPrice = lowPrice
            }else{
               var newlowPrice = existingLowPrice
            }
        
          const updateQuery = await pool.query(
            `UPDATE tbl_market_live_rate 
             SET sell_bidprice = $1, 
                 buy_askprice = $2, 
                 market_date_time = $3, 
                 market_status = 'open', 
                 highPrice = $4, 
                 lowPrice = $5,
                 privious_sell_bidprice = $7,
                 privious_buy_askprice = $8
             WHERE currency_pair = $6`,
            [sell_bidPrice, buy_askPrice, market_datetime, newhigh, newlowPrice, currency_pair,privious_sell_bidprice,privious_buy_askprice]
          );



          // const updateQuery = await pool.query(
          //   `UPDATE tbl_market_live_rate SET sell_bidprice = '${sell_bidPrice}', buy_askprice = '${buy_askPrice}', market_date_time = '${market_datetime}', market_status = 'open'  WHERE currency_pair = '${currency_pair}'`,
          // );

          // console.log(updateQuery.rowCount > 0 ? 'currency_pair updated successfully' : 'currency_pair not updated successfully');
        } else {
          const insertQuery = await pool.query(
            'INSERT INTO tbl_market_live_rate(currency_pair, sell_bidprice, buy_askprice, market_date_time) VALUES($1, $2, $3, $4)',
            [currency_pair, sell_bidPrice, buy_askPrice, market_datetime]
          );

          console.log(insertQuery.rowCount > 0 ? 'New currency_pair added successfully' : 'Currency not added successfully');
        }
      } catch (err) {
        console.error('Error updating tbl_market_live_rate:', err);
      }
    }else{
      const update_market_close_Query = await pool.query(
        `UPDATE tbl_market_live_rate SET market_status = 'open'`,
        // `UPDATE tbl_market_live_rate SET market_status = 'closed'`,
      );

      console.log(update_market_close_Query.rowCount > 0 ? 'market closed status updated successfully' : 'market closed status not updated successfully');
    }


  });

  tiingoSocket.on('error', function error(err) {
    console.error('WebSocket error:', err);
  });

  tiingoSocket.on('close', function close() {
    //console.log('Disconnected from Tiingo WebSocket API');
    setTimeout(connectToTiingo, 800); // Reconnect after 5 seconds
  });
}

connectToTiingo();