const pg = require('pg');
const multer = require('multer');
const fs = require('fs');
const nodeMailer = require('nodemailer');
const jwt = require('jsonwebtoken');
const formidable = require('formidable');
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const crypto = require("crypto");
const moment = require('moment');
const upload = multer({ dest: '../views/files/upload/user_image/' });

function isNull(item) {
    if (item) {
        return item;
    } else {
        return "";
    }
}


const dbconfig = require('../../db');
const pool = new pg.Pool(dbconfig);

const { base_img_url, Authorization_firbase_key } = require('../zerogravity_user_index');

const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}


// function encrypt(password) {
//     var key = "123|a123123123123123@&";
//     var cipher = crypto.createCipher('aes-256-cbc', key);
//     var crypted = cipher.update(password, 'utf-8', 'hex');
//     crypted += cipher.final('hex');
//     return crypted;
// }

// function decrypt(password) {
//     var key = "123|a123123123123123@&";
//     var decipher = crypto.createDecipher('aes-256-cbc', key);
//     var decrypted = decipher.update(password, 'hex', 'utf-8');
//     decrypted += decipher.final('utf-8');
//     return decrypted;
// }


const mailConfig = require('../../mail');
const transporter = nodeMailer.createTransport(mailConfig);

module.exports = {

    check_version_API: (request, response) => {
       
        pool.query(`SELECT * FROM tbl_build_version WHERE  status='1'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var build_version = result.rows[0].build_version;
                
                response.status(201).json({ status: true, message: 'Build Version', build_version: build_version })
            } else {
                response.status(201).json({ status: false, message: 'No account not found', data: [] })
            }
        })
    },

    // mlm_signup_API: async (request, response) => {
    //     const client = await pool.connect();
    //     try {
    //       const { full_name: fname, email, password,
    //         mlm_login_id,
    //         mobile,
    //         country: full_address,
    //       } = request.body;

    //        console.log("mlm_signup_API", request.body);
    //        const lowercase_email = email.toLowerCase();
    //        const mlm_login_id_number = ((mlm_login_id || '').toString().match(/\d+/g) || []).join('') || '123456';
    //        const numeric_mlm_login_id = parseInt(mlm_login_id_number, 10);

    //       await client.query('BEGIN');
    //       const [existingUser, existingMlmId, existingMobile] = await Promise.all([
    //         client.query(`SELECT 1 FROM tbl_user WHERE email = $1 LIMIT 1`, [lowercase_email]),
    //         client.query(`SELECT 1 FROM tbl_user WHERE mlm_login_id = $1 LIMIT 1`, [mlm_login_id]),
    //         client.query(`SELECT 1 FROM tbl_user WHERE mobile = $1 LIMIT 1`, [mobile]),
    //       ]);
    //       if (existingUser.rowCount > 0 || existingMlmId.rowCount > 0 || existingMobile.rowCount > 0) {
    //         await client.query('ROLLBACK');
    //         let message = existingUser.rowCount > 0
    //           ? "This email is already registered with us"
    //           : existingMlmId.rowCount > 0
    //             ? "This MLM ID is already used. Please use a different one."
    //             : "This mobile is already used. Please use a different one.";
    //         return response.status(201).json({
    //           status: false,
    //           message,
    //           data: [],
    //         });
    //       }
    //       const joining_time = moment().utcOffset("+05:30").format("LT");
    //       const joing_date = moment().format("DD MMM YYYY");
    //       const insertUser = await client.query(
    //         `INSERT INTO tbl_user (
    //           fname, email, password, mlm_login_id, mobile, full_address,
    //           joining_time, joing_date, email_verify, mobile_verify,mlm_wallet
    //         ) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, 1, 1, 0)
    //         RETURNING tbl_user_id`,
    //         [fname, lowercase_email, password, mlm_login_id, mobile, full_address, joining_time, joing_date]
    //       );
    //       const newuser_id = insertUser.rows[0].tbl_user_id;
    //       const my_login_id = mlm_login_id;
    //       const user_name = mlm_login_id;
    //       const token = createToken(newuser_id);
    //       await client.query(
    //         `UPDATE tbl_user SET my_login_id = $1, user_name = $2, jwt_token = $3 WHERE tbl_user_id = $4`,
    //         [my_login_id, user_name, token, newuser_id]
    //       );
    //       const newUser = {
    //         tbl_user_id: newuser_id,
    //         fname,
    //         email: lowercase_email,
    //         my_login_id,
    //         mlm_login_id,
    //         mobile,
    //         full_address,
    //         user_name,
    //       };
    //       await client.query(
    //         `INSERT INTO tbl_mt5_user (
    //           tbl_user_id, login_id, registration,
    //           name, leverage, email, password_main, phone, agent,
    //           country, joining_time, joining_date, group_id, balance, mlm_login_id,mlm_wallet
    //         ) VALUES (
    //           $1, $2, $3, $4, $5,
    //           $6, $7, $8, $9, $10, $11, $12, 23, 0, $13, $14
    //         )`,
    //         [
    //           newUser.tbl_user_id,
    //           numeric_mlm_login_id,
    //           0,
    //           newUser.fname,
    //           0,
    //           lowercase_email,
    //           password,
    //           mobile,
    //           0,
    //           full_address,
    //           joining_time,
    //           joing_date,
    //           mlm_login_id,
    //           0
    //         ]
    //       );
    //       const mt5UserResult = await client.query(
    //         `SELECT * FROM tbl_mt5_user WHERE tbl_user_id = $1`,
    //         [newUser.tbl_user_id]
    //       );
    //       const mt5User = mt5UserResult.rows[0];
    //       const data = [{
    //         tbl_user_id: newUser.tbl_user_id,
    //         fullName: newUser.fname,
    //         email: newUser.email,
    //         my_login_id: newUser.my_login_id,
    //         user_name: newUser.user_name,
    //         mlm_login_id: newUser.mlm_login_id,
    //         mobile: newUser.mobile,
    //         full_address: newUser.full_address,
    //         token,
    //         mt5_details: mt5User
    //       }];
    //       await client.query('COMMIT');
    //       return response.status(201).json({
    //         status: true,
    //         message: "Your account has been successfully registered.",
    //         data,
    //       });
    //     } catch (error) {
    //       await client.query('ROLLBACK');
    //       console.error("Signup Error:", error);
    //       return response.status(500).json({
    //         status: false,
    //         message: "Internal server error",
    //         error: error.message,
    //       });
    //     } finally {
    //       client.release();
    //     }
    // },

mlm_signup_API: async (request, response) => {
  const client = await pool.connect();
  try {
    const {
      full_name: fname,
      email,
      mlm_login_id,
      mobile,
      country: full_address,
    } = request.body;

    console.log("mlm_signup_API", request.body);
    const lowercase_email = email.toLowerCase();

    const mlm_login_id_number = ((mlm_login_id || '').toString().match(/\d+/g) || []).join('') || '123456';
    const numeric_mlm_login_id = parseInt(mlm_login_id_number, 10);

    const generatePassword = () => {
      const chars = 'abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789';
      let pass = '';
      for (let i = 0; i < 6; i++) {
        pass += chars.charAt(Math.floor(Math.random() * chars.length));
      }
      return pass;
    };
    const password = generatePassword(); 

    await client.query('BEGIN');

    const [existingUser, existingMlmId, existingMobile] = await Promise.all([
      client.query(`SELECT 1 FROM tbl_user WHERE email = $1 LIMIT 1`, [lowercase_email]),
      client.query(`SELECT 1 FROM tbl_user WHERE mlm_login_id = $1 LIMIT 1`, [mlm_login_id]),
      client.query(`SELECT 1 FROM tbl_user WHERE mobile = $1 LIMIT 1`, [mobile]),
    ]);

    if (existingUser.rowCount > 0 || existingMlmId.rowCount > 0 || existingMobile.rowCount > 0) {
      await client.query('ROLLBACK');
      let message = existingUser.rowCount > 0
        ? "This email is already registered with us"
        : existingMlmId.rowCount > 0
          ? "This MLM ID is already used. Please use a different one."
          : "This mobile is already used. Please use a different one.";
      return response.status(201).json({
        status: false,
        message,
        data: [],
      });
    }

    const joining_time = moment().utcOffset("+05:30").format("LT");
    const joing_date = moment().format("DD MMM YYYY");

    const insertUser = await client.query(
      `INSERT INTO tbl_user (
        fname, email, password, mlm_login_id, mobile, full_address,
        joining_time, joing_date, email_verify, mobile_verify, mlm_wallet
      ) VALUES ($1, $2, $3, $4, $5, $6, $7, $8, 1, 1, 0)
      RETURNING tbl_user_id`,
      [fname, lowercase_email, password, mlm_login_id, mobile, full_address, joining_time, joing_date]
    );

    const newuser_id = insertUser.rows[0].tbl_user_id;

    const my_login_id = mlm_login_id;
    const user_name = mlm_login_id_number; 

    const token = createToken(newuser_id);

    await client.query(
      `UPDATE tbl_user SET my_login_id = $1, user_name = $2, jwt_token = $3 WHERE tbl_user_id = $4`,
      [my_login_id, user_name, token, newuser_id]
    );

    const newUser = {
      tbl_user_id: newuser_id,
      fname,
      email: lowercase_email,
      my_login_id,
      mlm_login_id,
      mobile,
      full_address,
      user_name,
    };

    await client.query(
      `INSERT INTO tbl_mt5_user (
        tbl_user_id, login_id, registration,
        name, leverage, email, password_main, phone, agent,
        country, joining_time, joining_date, group_id, balance, mlm_login_id, mlm_wallet
      ) VALUES (
        $1, $2, $3, $4, $5,
        $6, $7, $8, $9, $10, $11, $12, 23, 0, $13, $14
      )`,
      [
        newUser.tbl_user_id,
        numeric_mlm_login_id,
        0,
        newUser.fname,
        100,
        lowercase_email,
        password,
        mobile,
        0,
        full_address,
        joining_time,
        joing_date,
        mlm_login_id,
        0
      ]
    );

    const mt5UserResult = await client.query(
      `SELECT * FROM tbl_mt5_user WHERE tbl_user_id = $1`,
      [newUser.tbl_user_id]
    );
    const mt5User = mt5UserResult.rows[0];

    const data = [{
      tbl_user_id: newUser.tbl_user_id,
      fullName: newUser.fname,
      email: newUser.email,
      my_login_id: newUser.my_login_id,
      user_name: newUser.user_name,
      mlm_login_id: newUser.mlm_login_id,
      mobile: newUser.mobile,
      full_address: newUser.full_address,
      token,
      mt5_details: mt5User
    }];

    await client.query('COMMIT');
    return response.status(201).json({
      status: true,
      message: "Your account has been successfully registered.",
      data,
    });
  } catch (error) {
    await client.query('ROLLBACK');
    console.error("Signup Error:", error);
    return response.status(500).json({
      status: false,
      message: "Internal server error",
      error: error.message,
    });
  } finally {
    client.release();
  }
    },

    mlm_userdetail_API: async (request, response) => {
  const client = await pool.connect();
  try {
    const { mlm_login_id } = request.body; 

    if (!mlm_login_id) {
      return response.status(400).json({
        status: false,
        message: "mlm_login_id is required",
        data: [],
      });
    }

    const result = await client.query(
      `SELECT * FROM tbl_user WHERE mlm_login_id = $1 LIMIT 1`,
      [mlm_login_id]
    );

    if (result.rowCount === 0) {
      return response.status(404).json({
        status: false,
        message: "No user found with the provided mlm_login_id",
        data: [],
      });
    }

    const row = result.rows[0];

    const filteredData = {
      tbl_user_id: row.tbl_user_id,
      user_name: row.user_name,
      fname: row.fname,
      email: row.email,
      mobile: row.mobile,
      wallet_amount: row.wallet_amount,
      status: row.status,
      joining_time: row.joining_time,
      created_date: row.created_date,
      password: row.password,
      user_image: row.user_image,
      my_login_id: row.my_login_id,
      joing_date: row.joing_date,
      mlm_login_id: row.mlm_login_id,
      mlm_wallet: row.mlm_wallet
    };

    return response.status(200).json({
      status: true,
      message: "User details fetched successfully",
      data: filteredData,
    });

  } catch (error) {
    console.error("mlm_userdetail_API Error:", error);
    return response.status(500).json({
      status: false,
      message: "Internal server error",
      error: error.message,
    });
  } finally {
    client.release();
  }
    },
    
    signup_API: (request, response) => {

        const { fname, lname, firebase_token, email, password, dob, mobile, login_id } = request.body;

        console.log('signup_API', request.body);

        if(login_id == null  || login_id == undefined || login_id == '') {
            var used_login_id1 = '' ;
        }else{
            var used_login_id1 = login_id;
        }
        

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT * FROM tbl_user WHERE  email = '${lowercase_email}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

           
            if (count > 0) {

                response.status(201).json({ status: false, message: 'This email is already registered with us', data: [] })

            } else {

                var otpp = Math.floor(100000 + Math.random() * 900000);
                var ot = Math.floor(100 + Math.random() * 999);

                // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");


                pool.query(`INSERT INTO tbl_user (lname,fname,email,email_otp,joing_date,joining_time,password,firebase_token,dob,mobile,used_login_id) VALUES ('${lname}','${fname}','${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${dob}','${mobile}','${used_login_id1}') RETURNING tbl_user_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }

                        var newuser_id = result_user.rows[0].tbl_user_id;
                        const token = createToken(result_user.rows[0].tbl_user_id);
                        var my_login_id = 'FXT' + ot + newuser_id;


                        const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET my_login_id = '${my_login_id}', user_name = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_user_id = '${newuser_id}'`);
                        
                        console.log(`add_to_watchlist, INSERT INTO tbl_watch_list(tbl_user_id,symbol)VALUES('${newuser_id}','EURUSD')`);
                        const add_to_watchlist = await pool.query(`INSERT INTO tbl_watch_list(tbl_user_id,symbol)VALUES('${newuser_id}','EURUSD')`);
                        
                        // email code start here

                        let mailOptions = {
                            from: '"XtremeFX" <info@fxtrade.app>', // sender address
                            to: lowercase_email, // list of receivers
                            subject: "Account Login Details", // Subject line
                            //text: verification_token, // plain text body
                            // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                            html: `<html>
                                    <body>
                                        <p>
                                            Hi, <br><br>
                                            Your XtremeFX account has been successfully created. Here are your login OTP: <br>
                                            <strong>OTP:</strong> '${otpp}' <br><br>
                                            Please keep this information secure and do not share it with anyone.
                                        </p>                  
                                        <p>
                                            Best regards, <br>
                                            Customer Support <br>
                                            XtremeFX
                                        </p>
                                    </body>
                                </html>`

                        };
                        transporter.sendMail(mailOptions, (error, info) => {
                            if (error) {
                                return console.log(error);
                            } else {
                                return //console.log(info);
                            }
                            // console.log('Message %s sent: %s', info.messageId, info.response);
                        });

                        // email code end here


                        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${newuser_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_user_id: isNull(table.tbl_user_id),
                                    user_name: isNull(table.user_name),
                                    fname: isNull(table.fname),
                                    lname: isNull(table.lname),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    gender: isNull(table.gender),
                                    user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                                    email_otp: table.email_otp,
                                    email_verify: table.email_verify,
                                    dob: table.dob,
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);
                            });
                            response.status(201).json({ status: true, message: 'Your user account has been successfully created, and the login details have been sent to the provided email ID.', data: data })
                        })
                    },
                )
            }
        })
    },

    otp_verify: (request, response) => {

        const { email, email_otp } = request.body;

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT * FROM tbl_user WHERE email = '${lowercase_email}' AND email_otp = '${email_otp}'`, async (error, result) => {

            if (error) {
                throw error
            }
            var count = result.rowCount;

            if (count > 0) {

                pool.query(`SELECT * FROM tbl_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
                    if (error) {
                        return response.status(403).json({ status: false, message: error })
                    }
                    var count = result.rowCount;
                    var res = result.rows;
                    var data = [];

                

                    const Update_otpverify = await pool.query(`UPDATE tbl_user SET email_verify = 1, profile_status = 1 WHERE email = '${lowercase_email}'`);

                    // email code start here

                        let mailOptions = {
                            from: '"MetaFxPro" <info@fxtrade.app>', // sender address
                            to: lowercase_email, // list of receivers
                            subject: "Welcome to MetaFxPro", // Subject line
                            //text: verification_token, // plain text body
                            // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                            html: `<!DOCTYPE html>
                            <html lang="en">
                            <head>
                                <meta charset="UTF-8">
                                <meta name="viewport" content="width=device-width, initial-scale=1.0">
                                <title>Welcome Email MetaFxPro!</title>
                            </head>
                            <body style="font-family: Arial, sans-serif; margin: 0; padding: 0;">
                                <div style="width: 100%; background-color: #0182bb; padding: 20px 0;">
                                    <div style="width: 100%; max-width: 600px; margin: 0 auto; background-color: #ffffff; box-shadow: 0 0 10px rgba(0, 0, 0, 0.1); padding: 20px; border-radius: 8px;">
                                        <!-- <img class="main__logo--img " src="https://trandmunda.ojpasoftware.com/assets/img/logo.png" alt="logo-img" width="200" style="justify-content: center; align-items: center; display: flex; margin: auto; margin-bottom: 20px;"> -->
                                        <img src="https://img.freepik.com/free-vector/welcome-word-flat-cartoon-people-characters_81522-4207.jpg?t=st=1716965017~exp=1716968617~hmac=ef82f492e9aa7e5acebc6e19044f4bf82698e92c6332bf33c2ec74e561220c68&w=740" alt="logo-img" width="300" style="display: block; margin: 0 auto 20px;">
                                        
                                        <div style="text-align: center; font-size: 30px; color: #333333; font-family: emoji;">
                                            Welcome to MetaFxPro!
                                        </div>
                                
                                        <div style="font-size: 16px; color: #666666; line-height: 1.6;">
                                            <p>Dear ${result.rows[0].user_name},</p>
                                            <p>We are thrilled to have you on board. Here are your login details:</p>
                                            <div style="margin: 20px 0;">
                                                <p style="margin-bottom: 10px;"><strong>Username:</strong> ${result.rows[0].user_name}</p>
                                                 <p><strong>Email :</strong> ${result.rows[0].email}</p>
                                                 <p><strong>Mobile No :</strong> ${result.rows[0].mobile}</p>
                                            </div>
                                            <p>As a member, you will enjoy the following benefits:</p>
                                            <ul style="padding-right: 30px; letter-spacing: 1px; line-height: 2;">
                                                <li>With high leverage, traders can take on large positions by depositing a small amount of money as a margin. This can significantly increase profits.</li>
                                                <li>The forex market is one of the most liquid in the world, with billions of dollars traded every minute. This allows for quick and easy transactions, which can result in low transaction costs.</li>
                                                <li>Traders have access to technology that can help them apply indicators like pivot points, which can be used to create support and resistance levels for market entry and exit.</li>
                                                <li>Traders can develop personalized trading strategies that answer questions about what, when, why, and how much to trade.</li>
                                            </ul>
                                            <p>If you have any questions, feel free to reach out to our support team.</p>
                                            <p>Welcome aboard!</p>
                                            <p>Best regards,</p>
                                            <p>The MetaFxPro Team</p>
                                        </div>
                                    </div>
                                </div>
                            </body>
                            </html>`
                        };
                        transporter.sendMail(mailOptions, (error, info) => {
                            if (error) {
                                return console.log(error);
                            } else {
                                return console.log(info);
                            }
                            // console.log('Message %s sent: %s', info.messageId, info.response);
                        });

                    // email code end here

                   
                    res.forEach(function (table) {

                        let cat = {
                            tbl_user_id: isNull(table.tbl_user_id),
                            user_name: isNull(table.user_name),
                            fname: isNull(table.fname),
                            lname: isNull(table.lname),
                            mobile: isNull(table.mobile),
                            email: isNull(table.email),
                            gender: isNull(table.gender),
                            user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                            email_otp: table.email_otp,
                            email_verify: table.email_verify,
                            dob: isNull(table.dob),
                            wallet_amount: table.wallet_amount,
                            jwt_token: isNull(table.jwt_token),
                            profile_status: table.profile_status,
                            firebase_token: isNull(table.firebase_token),
                        };
                        data.push(cat);

                    });
                    response.status(201).json({ status: true, message: 'Welcome To MetaFxPro', data: data })
                })

            } else {
                response.status(201).json({ status: false, message: 'You entered wrong otp', data: [] })
            }
        })

    },

    Resend_email_otp_API: (request, response) => {

        const { email } = request.body;


        //console.log('Resend_email_otp_API', request.body);

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT email_otp FROM tbl_user WHERE  email = '${lowercase_email}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;


            if (count > 0) {

                // email code start here

                let mailOptions = {
                    from: '"MetaFxPro" <info@fxtrade.app>', // sender address
                    to: lowercase_email, // list of receivers
                    subject: "Email Verification OTP", // Subject line
                    
                    html: `<html>
                                <body>                             
                                    <p>
                                    Hi, <br>
                                    Your MetaFxPro account email verify OTP is ${result.rows[0].email_otp}. Please do not share this with anyone.
                                    </p>                   
                                    <p>
                                    Thanks <br/>
                                    Customer Support
                                    MetaFxPro 
                                    </p>
                                
                                </body>
                        </html>`

                };
                transporter.sendMail(mailOptions, (error, info) => {
                    if (error) {
                        return console.log(error);
                    } else {
                        return console.log(info);
                    }
                    console.log('Message %s sent: %s', info.messageId, info.response);
                });


                // email code end here

                response.status(201).json({ status: true, message: 'An OTP has been sent to your email' })

            } else {

                response.status(201).json({ status: false, message: 'This email is not registered with us' })



            }

        })
    },

    Login_API: (request, response) => {

        const { email, password, firebase_token } = request.body;

        console.log('Login_API', request.body);

        const lowercase_email = email.toLowerCase();
        

        pool.query(`SELECT * FROM tbl_user WHERE email = '${lowercase_email}' OR LOWER(user_name) = '${lowercase_email}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;


            if (count > 0) {

                if (result.rows[0].password == password) {

                    var otpp = Math.floor(100000 + Math.random() * 900000);

                 

                    const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET firebase_token = '${firebase_token}', email_otp = '${otpp}'  WHERE email = '${lowercase_email}'`);


                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {

                        const mlm_login_id = table.mlm_login_id != null ? table.mlm_login_id : '';

                        let cat = {
                            tbl_user_id: isNull(table.tbl_user_id),
                            user_name: isNull(table.user_name),
                            mlm_login_id: isNull(mlm_login_id),
                            fname: isNull(table.fname),
                            lname: isNull(table.lname),
                            mobile: isNull(table.mobile),
                            dob: isNull(table.dob),
                            email: isNull(table.email),
                            gender: isNull(table.gender),
                            user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                            email_otp: table.email_otp,
                            email_verify: table.email_verify,
                            wallet_amount: table.wallet_amount,
                            profile_status: table.profile_status,
                            kyc_step_1: table.kyc_step_1,
                            kyc_step_2: table.kyc_step_2,
                            jwt_token: isNull(table.jwt_token),
                            firebase_token: isNull(firebase_token),
                        };
                        data.push(cat);
                    });
                    response.status(201).json({ status: true, message: 'Welcome To MetaFxPro', data: data })
                } else {
                    response.status(201).json({ status: false, message: 'You entered the wrong password', data: [] })
                }
            } else {
                response.status(201).json({ status: false, message: 'The email/Username is not registered with us', data: [] })
            }

        })
    },


    trading_account_Login_API: (request, response) => {

        const { login_id, password, broker_name,tbl_user_id } = request.body;

        console.log('trading_account_Login_API', request.body);      

        pool.query(`SELECT * FROM tbl_mt5_user WHERE  login_id = '${login_id}' AND tbl_user_id ='${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;


            if (count > 0) {

                if (result.rows[0].password_main == password) {

                    var otpp = Math.floor(100000 + Math.random() * 900000);


                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {

                        let cat = {
                            tbl_mt5_user_id: isNull(table.tbl_mt5_user_id),
                            tbl_user_id: isNull(table.tbl_user_id),
                            login_id: isNull(table.login_id),
                            balance: table.balance,
                            name: isNull(table.name),
                            email: isNull(table.email),
                        };
                        data.push(cat);
                    });
                    response.status(201).json({ status: true, message: 'Welcome To Xoniccapitals', data: data })
                } else {
                    response.status(201).json({ status: false, message: 'You entered the wrong password', data: [] })
                }
            } else {
                response.status(201).json({ status: false, message: 'The login ID is not registered with us', data: [] })
            }

        })
    },

    myprofile_API: (request, response) => {

        const { tbl_user_id } = request.body

       
        pool.query(`SELECT (SELECT status as user_id_varify from tbl_user_verification where tbl_user_id = '${tbl_user_id}' order by tbl_user_verification_id DESC limit 1),  tbl_user.* FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];

                const markt_query = await pool.query(`SELECT market_status FROM tbl_market_live_rate where market_status = 'closed'`);
                if(markt_query.rowCount > 0){
                    market_status = 'closed';
                }else{
                    market_status = 'open';
                }

                res.forEach(function (table) {

                    if(table.user_id_varify == undefined || table.user_id_varify == null) {
                        user_id_varify = "Not upload";
                    }else if(table.user_id_varify == '0'){
                        user_id_varify = "Pending";
                    }else if(table.user_id_varify == '1'){
                        user_id_varify = "Approved";
                    }else{
                        user_id_varify = "Rejected";
                    }

                    const mlm_login_id = table.mlm_login_id != null ? table.mlm_login_id : '';

                    let cat = {
                        tbl_user_id: isNull(table.tbl_user_id),
                        user_name: isNull(table.user_name),
                        mlm_login_id: isNull(mlm_login_id),
                        fname: isNull(table.fname),
                        lname: isNull(table.lname),
                        mobile: isNull(table.mobile),
                        email: isNull(table.email),
                        dob: isNull(table.dob),
                        email_verify: table.email_verify,
                        otp_verify: table.otp_verify,
                        image: isNull(base_img_url + "/user_image/" + table.user_image),
                        wallet_amount: table.wallet_amount.toFixed(2),
                        profile_status: table.profile_status,
                        user_id_varify: user_id_varify,
                        jwt_token: isNull(table.jwt_token),
                        password: isNull(table.password),
                        transfer_pin: isNull(table.transfer_pin),
                        firebase_token: isNull(table.firebase_token),
                        market_status: isNull(market_status),
                    };
                    data.push(cat);
                });
                response.status(201).json({ status: true, message: 'Profile Details', data: data })
            } else {
                response.status(201).json({ status: false, message: 'Profile Details not found', data: [] })
            }
        })
    },

    document_type_API: (request, response) => {

        /// const {tbl_user_id } = request.body;

        pool.query(`select * FROM tbl_document_type where status = '1' order by tbl_document_type_id ASC`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_document_type_id: isNull(table.tbl_document_type_id),
                        document_name: isNull(table.document_name)
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Document Type List', data: data })
            } else {
                response.status(201).json({ status: false, message: 'Document not added', data: [] })
            }

        })
    },

    user_verification_API: (request, response) => {

        const form = formidable({ multiples: true });
        form.parse(request, (err, fields, files) => {
            if (err) {
                next(err);
                return;
            }

            if(fields.tbl_user_id == null  || fields.tbl_user_id == undefined || fields.tbl_user_id == '') {
                return response.status(201).json({ status: false, message: 'tbl_user_id is required!' }); 
            }
            if(fields.id_type == null  || fields.id_type == undefined || fields.id_type == '') {
                return response.status(201).json({ status: false, message: 'id_type is required!' }); 
            }
            
           
            if(fields.user_name == null  || fields.user_name == undefined || fields.user_name == '') {
                return response.status(201).json({ status: false, message: 'user_name is required!' }); 
            }
            if(fields.id_number == null  || fields.id_number == undefined || fields.id_number == '') {
                return response.status(201).json({ status: false, message: 'id_number is required!' }); 
            }
            if(fields.dob == null  || fields.dob == undefined || fields.dob == '') {
                return response.status(201).json({ status: false, message: 'dob is required!' }); 
            }
            if(fields.address == null  || fields.address == undefined || fields.address == '') {
                return response.status(201).json({ status: false, message: 'address is required!' }); 
            }

            if(fields.document_type == null  || fields.document_type == undefined || fields.document_type == '') {
                return response.status(201).json({ status: false, message: 'document_type is required!' }); 
            }
            if(files.user_image == null  || files.user_image == undefined || files.user_image == '') {
                return response.status(201).json({ status: false, message: 'user_image is required!' }); 
            }
            
            pool.query('SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = $1', [fields.tbl_user_id], (error, result) => {

                if (error) {
                    return response.status(403).json({ status: false, message: error })
                }

                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");

                

                if (count = result.rowCount > 0) {
                    if (fields.document_type == 'photo') {

                        const usrfileName = files.user_image.path;
                        const usrtypefile = files.user_image.type
                        const usrfileContent = fs.readFileSync(usrfileName)
                        const usrtype = usrtypefile.split("/");
                        const usrimagename = Math.floor(10000000 + Math.random() * 90000000);
                        const user_imagename = 'user_img_' + usrimagename + '.' + usrtype[1];

                        fs.writeFile(`./views/files/upload/verification_document/${user_imagename}`, usrfileContent, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });

                        const fileName = files.front_image.path;
                        const typefile = files.front_image.type
                        const fileContent = fs.readFileSync(fileName)
                        var type = typefile.split("/");
                        var imagename = Math.floor(10000000 + Math.random() * 90000000);
                        const front_imagename = imagename + '.' + type[1];

                        fs.writeFile(`./views/files/upload/verification_document/${front_imagename}`, fileContent, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });

                        const fileName1 = files.back_image.path;
                        const typefile1 = files.back_image.type
                        const fileContent1 = fs.readFileSync(fileName1)
                        var type = typefile1.split("/");
                        var imagename = Math.floor(10000000 + Math.random() * 90000000);
                        const back_imagename = imagename + '.' + type[1];

                        fs.writeFile(`./views/files/upload/verification_document/${back_imagename}`, fileContent1, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });

                        pool.query(`INSERT INTO tbl_user_verification(tbl_user_id,id_type,document_type,front_image,back_image,upload_date,upload_time, user_image, user_name, id_number, dob, address) VALUES('${fields.tbl_user_id}','${fields.id_type}','${fields.document_type}','${front_imagename}','${back_imagename}','${joining_date}','${joining_time}', '${user_imagename}','${fields.user_name}','${fields.id_number}','${fields.dob}','${fields.address}')`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            if (result.rowCount > 0) {
                                response.status(201).json({ status: true, message: 'Verification request successfully submitted.' })
                            }
                        });

                    } else {
                        
                        const usrfileName = files.user_image.path;
                        const usrtypefile = files.user_image.type
                        const usrfileContent = fs.readFileSync(usrfileName)
                        const usrtype = usrtypefile.split("/");
                        const usrimagename = Math.floor(10000000 + Math.random() * 90000000);
                        const user_imagename = 'user_img_' + usrimagename + '.' + usrtype[1];

                        fs.writeFile(`./views/files/upload/verification_document/${user_imagename}`, usrfileContent, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });


                        const fileName = files.document_file.path;
                        const typefile = files.document_file.type
                        const fileContent = fs.readFileSync(fileName)
                        var type = typefile.split("/");
                        var imagename = Math.floor(10000000 + Math.random() * 90000000);
                        const document_filename = imagename + '.' + type[1];

                        fs.writeFile(`./views/files/upload/verification_document/${document_filename}`, fileContent, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });

                        

                        pool.query(`INSERT INTO tbl_user_verification(tbl_user_id,id_type,document_type,document_file,upload_date,upload_time,user_image, user_name, id_number, dob, address) VALUES('${fields.tbl_user_id}','${fields.id_type}','${fields.document_type}','${document_filename}','${joining_date}','${joining_time}', '${user_imagename}','${fields.user_name}','${fields.id_number}','${fields.dob}','${fields.address}')`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            if (result.rowCount > 0) {
                                response.status(201).json({ status: true, message: 'Verification request successfully submitted.' })
                            }
                        });

                    }


                } else {
                    response.status(201).json({ status: false, message: 'userid is wrong.', })
                }

            })

        });

    },

    upload_user_image: (request, response) => {
        const form = formidable({ multiples: true });
        form.parse(request, (err, fields, files) => {
            if (err) {
                next(err);
                return;
            }
            pool.query(`SELECT tbl_user_id FROM tbl_user WHERE tbl_user_id = '${fields.tbl_user_id}'`, (error, result) => {
                if (error) {
                    return response.status(403).json({ status: false, message: error })
                }
                if (count = result.rowCount > 0) {

                    if (files.user_image != undefined) {
                        const fileName = files.user_image.path;
                        const typefile = files.user_image.type
                        const fileContent = fs.readFileSync(fileName)
                        var type = typefile.split("/");
                        var imagename = Math.floor(10000000 + Math.random() * 90000000);
                        const imagefilename = imagename + '.' + type[1];

                        fs.writeFile(`./views/files/upload/user_image/${imagefilename}`, fileContent, (err) => {
                            if (err) {
                                console.error(err);
                            }
                        });

                        // const params = {
                        //     Bucket: 'drivify',
                        //     Key: `user_image/${imagefilename}`,
                        //     'ContentType': 'image/png',
                        //     Body: fileContent
                        // }
                        // s3.upload(params, (err, data) => {
                        //     if (err) {
                        //         //reject(err)
                        //         console.log(err)
                        //     }
                        // })
                        // s3 bucket code end here imagefilename
                        pool.query(`UPDATE tbl_user SET user_image = '${imagefilename}' WHERE tbl_user_id = '${fields.tbl_user_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            if (result.rowCount > 0) {
                                response.status(201).json({ status: true, message: 'Profile Image uploaded successfully.', user_image: base_img_url + "/user_image/" + isNull(imagefilename) })
                            }
                        },
                        )
                    } else {
                        response.status(201).json({ status: false, message: 'Select Image.', })
                    }
                } else {
                    response.status(201).json({ status: false, message: 'userid is wrong.', })
                }

            })

        });

    },

    forgot_password_API: (request, response) => {

        const { email } = request.body;

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT email,password FROM tbl_user WHERE email = '${lowercase_email}'`, (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                /* Email send code start here */

                let mailOptions = {
                    from: '"MetaFxPro" <info@fxtrade.app>', // sender address, // sender address
                    to: lowercase_email, // list of receivers
                    subject: "Login Password", // Subject line
                    //text: verification_token, // plain text body
                    // You can also change your password by going into the profile settings of your account.
                    // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                    html: `<html>
                            <body>                             
                                <p>
                                 Hi, <br>
                                 Your MetaFxPro account password is ${result.rows[0].password}. Please do not share this with anyone.
                                </p>                   
                                <p>
                                  Thanks <br/> 
                                  Customer Support
                                  MetaFxPro 
                                </p>                               
                            </body>
                    </html>`
                };
                transporter.sendMail(mailOptions, (error, info) => {
                    if (error) {
                        return console.log(error);
                    } else {
                        return console.log(info);
                    }
                    // console.log('Message %s sent: %s', info.messageId, info.response);
                });

                response.status(201).json({ status: true, message: 'We have sent password to your email address. Please visit the inbox.' });
                /* Email send code End here height_type */
            } else {
                response.status(201).json({ status: false, message: 'This email address is not registered with us.' })
            }
        })
    },

    social_Login_signup_API: (request, response) => {

        const { email, login_type, social_type, social_id, firebase_token } = request.body;

        console.log('Login_signup_API', request.body);

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT tbl_user_id, user_name, dob, email_otp, fname,lname, mobile,email,gender,user_image,email_verify,wallet_amount,jwt_token,firebase_token,  login_type, scoial_type, social_id_pass, profile_status FROM tbl_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                
                var res = result.rows;
                var data = [];
                res.forEach((table) => {

                    let cat = {

                        tbl_user_id: isNull(table.tbl_user_id),
                        user_name: isNull(table.user_name),
                        fname: isNull(table.fname),
                        lname: isNull(table.lname),
                        mobile: isNull(table.mobile),
                        email: isNull(table.email),
                        gender: isNull(table.gender),
                        user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                        email_otp: table.email_otp,
                        email_verify: table.email_verify,                                  
                        dob: isNull(table.dob),
                        wallet_amount: table.wallet_amount,
                        jwt_token: isNull(table.jwt_token),
                        login_type: isNull(table.login_type),
                        scoial_type: isNull(table.scoial_type),
                        social_id: isNull(table.social_id_pass),
                        profile_status: table.profile_status,
                        firebase_token: isNull(firebase_token),

                    };
                    data.push(cat);
                });

                response.status(201).json({ status: true, message: 'Welcome To MetaFxPro', data: data })

            } else {

                var otpp = Math.floor(100000 + Math.random() * 900000);
                var ot = Math.floor(100 + Math.random() * 999);

                // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");


                pool.query(`INSERT INTO tbl_user (email,email_otp,joing_date,joining_time,social_id_pass,firebase_token,login_type,scoial_type) VALUES ('${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${social_id}','${firebase_token}','${login_type}','${social_type}') RETURNING tbl_user_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error })
                        }

                        var newuser_id = result_user.rows[0].tbl_user_id;
                        const token = createToken(result_user.rows[0].tbl_user_id);
                        var my_login_id = 'FXT' + ot + newuser_id;


                        const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET my_login_id = '${my_login_id}', user_name = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_user_id = '${newuser_id}'`);

                        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${newuser_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_user_id: isNull(table.tbl_user_id),
                                    user_name: isNull(table.user_name),
                                    fname: isNull(table.fname),
                                    lname: isNull(table.lname),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    gender: isNull(table.gender),
                                    user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                                    email_otp: table.email_otp,
                                    email_verify: table.email_verify,                                  
                                    dob: isNull(table.dob),
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),
                                    login_type: isNull(table.login_type),
                                    scoial_type: isNull(table.scoial_type),
                                    social_id: isNull(table.social_id_pass),
                                    profile_status: table.profile_status,
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);
                            });
                            response.status(201).json({ status: true, message: 'Your account has been successfully registered. Now, please verify your email by checking your inbox.', data: data })
                        })
                    },
                )
            }
        })
    },

    update_social_profile_API: (request, response) => {

        const { tbl_user_id, fname, lname, firebase_token, email, password, dob, mobile } = request.body;

        console.log('update_social_profile_API', request.body);

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT * FROM tbl_user WHERE tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

           
            if (count > 0) {

                var otpp = Math.floor(100000 + Math.random() * 900000);
                //var ot = Math.floor(100 + Math.random() * 999);
                // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                //const joining_time = moment().utcOffset("+05:30").format('LT');
                // const joining_date = moment(date).format("DD MMM YYYY");
                // pool.query(`INSERT INTO tbl_user (lname,fname,email,email_otp,joing_date,joining_time,password,firebase_token,dob,mobile) VALUES ('${lname}','${fname}','${email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${dob}','${mobile}') RETURNING tbl_user_id`,

                pool.query(`UPDATE tbl_user SET fname = '${fname}', lname = '${lname}', firebase_token = '${firebase_token}', password = '${password}', dob = '${dob}', email_otp = '${otpp}', mobile = '${mobile}' WHERE tbl_user_id = '${tbl_user_id}'`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error })
                        }

                       // var newuser_id = result_user.rows[0].tbl_user_id;
                       // const token = createToken(result_user.rows[0].tbl_user_id);
                       //  var my_login_id = 'TM' + ot + newuser_id;


                      //  const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET my_login_id = '${my_login_id}', user_name = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_user_id = '${newuser_id}'`);


                        // email code start here

                        let mailOptions = {
                            from: '"MetaFxPro" <info@fxtrade.app>', // sender address
                            to: lowercase_email, // list of receivers
                            subject: "Email Verification OTP", // Subject line
                            //text: verification_token, // plain text body
                            // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                            html: `<html>
                                        <body>                             
                                            <p>
                                                Hi, <br>
                                                Your MetaFxPro account email verify OTP is ${otpp}. Please do not share this with anyone.
                                            </p>                   
                                            <p>
                                                Thanks <br/>
                                                Customer Support
                                                MetaFxPro 
                                            </p>
                                            
                                        </body>
                                    </html>`

                        };
                        transporter.sendMail(mailOptions, (error, info) => {
                            if (error) {
                                return console.log(error);
                            } else {
                                return console.log(info);
                            }
                            // console.log('Message %s sent: %s', info.messageId, info.response);
                        });
                        // email code end here

                        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_user_id: isNull(table.tbl_user_id),
                                    user_name: isNull(table.user_name),
                                    fname: isNull(table.fname),
                                    lname: isNull(table.lname),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    gender: isNull(table.gender),
                                    user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                                    email_otp: table.email_otp,
                                    email_verify: table.email_verify,
                                    dob: table.dob,
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),                              
                                    login_type: isNull(table.login_type),
                                    scoial_type: isNull(table.scoial_type),
                                    social_pass: isNull(table.social_id_pass),
                                    profile_status: table.profile_status,
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);
                            });
                            response.status(201).json({ status: true, message: 'Your account has been successfully registered. Now, please verify your email by checking your inbox.', data: data })
                        })
                    },
                )
            } else {
                response.status(201).json({ status: false, message: 'This tbl_user_id is not exist', data: [] })
            }
        })
    },






    Update_transfer_pin_API: (request, response) => {

        const { tbl_user_id, transfer_pin } = request.body;

        pool.query(`SELECT count(tbl_user_id) AS totalcount FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'; 
        UPDATE tbl_user SET transfer_pin = '${transfer_pin}' WHERE tbl_user_id = '${tbl_user_id}' `, (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result[0].rowCount;
            if (count > 0) {
                if (result[1].rowCount) {
                    response.status(201).json({ status: true, message: 'Transfer PIN updated successully' })
                } else {
                    response.status(201).json({ status: true, message: 'Something error' })
                }

            } else {
                response.status(201).json({ status: false, message: 'User Not found' })
            }
        })
    },



    ////
    Check_user_via_username_API: (request, response) => {

        const { user_name } = request.body;

        pool.query(`SELECT user_name,fname,lname,email FROM tbl_user WHERE  user_name = '${user_name}'`, (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                response.status(201).json({ status: true, message: 'User Details', user_name : result.rows[0].user_name, name : result.rows[0].fname+" "+result.rows[0].lname, email : result.rows[0].email  });
            } else {
                response.status(201).json({ status: false, message: 'Check your username OR user not register with us' })
            }
        })
    },

    Check_user_via_account_id_API: async(request, response) => {

        const { account_id } = request.body;

      
        const acnt_query = await pool.query(`SELECT tbl_user_id, login_id FROM tbl_mt5_user WHERE login_id = '${account_id}'`);

        if(acnt_query.rowCount > 0){

            const res =  acnt_query.rows[0];

            pool.query(`SELECT user_name,fname,lname,email FROM tbl_user WHERE tbl_user_id = '${res.tbl_user_id}'`, (error, result) => {
                if (error) {
                    return response.status(403).json({ status: false, message: error })
                }
                var count = result.rowCount;
                if (count > 0) {
                    response.status(201).json({ status: true, message: 'User Details', account_id : res.login_id, user_name : result.rows[0].user_name, name : result.rows[0].fname+" "+result.rows[0].lname, email : result.rows[0].email  });
                } else {
                    response.status(201).json({ status: false, message: 'Check your username OR user not register with us' })
                }
            })
        }else {
            response.status(201).json({ status: false, message: 'Account id is not valid! Please enter valid account id' })
        }
    },


    amount_transfer_fee_api: (request, response) => {

        const { amount } = request.body;

        pool.query(`SELECT * FROM tbl_wallet_to_wallet_trasection_charges WHERE  tbl_wallet_to_wallet_trasection_charges_id = '1'`, (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {
                
                var percentage = result.rows[0].deduction_percentage;

                var fee_data = ((amount * percentage) / 100).toFixed(2);
                
          
                response.status(201).json({ status: true, message: 'Amount_deduction_fee', amount : amount, percentage:percentage, Fee : fee_data  })
                

            } else {
                response.status(201).json({ status: false, message: 'Something Error' })
            }
        })
    },





    



    







    











    Login_signup_API: (request, response) => {

        const { mobile, otp_verify, firebase_token } = request.body;

        console.log('Login_signup_API', request.body);

        pool.query(`SELECT tbl_user_id,full_name,mobile,email,gender,image,otp_verify,wallet_amount,jwt_token,firebase_token FROM tbl_user WHERE  mobile = '${mobile}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var axios = require('axios');
                if (mobile == '8604111232') {
                    var otpp = '123456';
                } else {
                    var otpp = Math.floor(100000 + Math.random() * 900000);
                }


                const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET firebase_token = '${firebase_token}', otp = '${otpp}'  WHERE mobile = '${mobile}'`);

                // sms code start here 



                var sms = `Dear Customers, Your one time Login OTP is ${otpp}Thank you GLSMS`;

                var config = {
                    method: 'get',
                    url: 'http://mobicomm.dove-sms.com//submitsms.jsp?user=GLAMTONE&key=252827e795XX&mobile=+91' + mobile + '&message=' + sms + '&senderid=GLMSMS&accusage=1&entityid=1701159161018733493&tempid=1707164084993414094',
                    headers: {
                        'Cookie': 'JSESSIONID=4E0E2F71CA44AD4C9277AE1FDF27572F'
                    }
                };

                axios(config)
                    .then(function (response) {
                        //console.log(JSON.stringify(response.data));
                    })
                    .catch(function (error) {
                        //console.log(error);
                    });


                // sms code end here 

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_user_id: isNull(table.tbl_user_id),
                        full_name: isNull(table.full_name),
                        mobile: isNull(table.mobile),
                        email: isNull(table.email),
                        gender: isNull(table.gender),
                        my_referal_code: isNull(table.my_referal_code),
                        otp_verify: table.otp_verify,
                        image: isNull(base_img_url + "/user_image/" + table.image),
                        wallet_amount: table.wallet_amount,
                        jwt_token: isNull(table.jwt_token),
                        firebase_token: isNull(firebase_token),
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Welcome To Drivify', data: data })

            } else {

                var axios = require('axios');
                var otpp = Math.floor(100000 + Math.random() * 900000);

                // sms code start here 

                var sms = `Dear Customers, Your one time Login OTP is ${otpp}Thank you GLSMS`;

                var config = {
                    method: 'get',
                    url: 'http://mobicomm.dove-sms.com//submitsms.jsp?user=GLAMTONE&key=252827e795XX&mobile=+91' + mobile + '&message=' + sms + '&senderid=GLMSMS&accusage=1&entityid=1701159161018733493&tempid=1707164084993414094',
                    headers: {
                        'Cookie': 'JSESSIONID=4E0E2F71CA44AD4C9277AE1FDF27572F'
                    }
                };

                axios(config)
                    .then(function (response) {
                        //console.log(JSON.stringify(response.data));
                    })
                    .catch(function (error) {
                        //console.log(error);
                    });


                // sms code end here 

                pool.query(`INSERT INTO tbl_user (mobile,otp_verify,status,created_date,wallet_amount,firebase_token,image,otp) VALUES ('${mobile}','${otp_verify}','0',now(),'0','${firebase_token}','defaultimage.jpg','${otpp}') RETURNING tbl_user_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error })
                        }

                        var newuser_id = result_user.rows[0].tbl_user_id;
                        const token = createToken(result_user.rows[0].tbl_user_id);
                        var my_sponsor_id = 'DVU' + '000' + newuser_id;

                        const Update_my_sponsor_id = await pool.query(`UPDATE tbl_user SET my_referal_code = '${my_sponsor_id}', full_name = '${my_sponsor_id}', jwt_token ='${token}'  WHERE tbl_user_id = '${newuser_id}'`);


                        pool.query(`SELECT tbl_user_id,full_name,mobile,email,gender,image,otp_verify,wallet_amount,jwt_token,firebase_token FROM tbl_user WHERE  mobile = '${mobile}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_user_id: isNull(table.tbl_user_id),
                                    full_name: isNull(table.full_name),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    gender: isNull(table.gender),
                                    image: isNull(base_img_url + "/user_image/" + table.image),
                                    otp_verify: table.otp_verify,
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);

                            });
                            response.status(201).json({ status: true, message: 'Welcome To Drivify', data: data })

                        })

                    },
                )

            }

        })
    },

    Update_profile_API: (request, response) => {

        const { tbl_user_id, full_name, email, gender } = request.body;

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT count(tbl_user_id) AS totalcount FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'; 
        UPDATE tbl_user SET full_name = '${full_name}', email ='${lowercase_email}', gender = '${gender}' WHERE tbl_user_id = '${tbl_user_id}'`, (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result[0].rowCount;
            if (count > 0) {
                if (result[1].rowCount) {
                    response.status(201).json({ status: true, message: 'Profile updated successully' })
                } else {
                    response.status(201).json({ status: true, message: 'Something error' })
                }

            } else {
                response.status(201).json({ status: false, message: 'Profile not found' })
            }
        })
    },

    Add_vehicle_API: (request, response) => {

        const { tbl_user_id, vehicle_number, gear_type } = request.body

        pool.query(`SELECT * FROM tbl_vehicle WHERE  vehicle_number = '${vehicle_number}' AND gear_type = '${gear_type}' AND tbl_user_id = '${tbl_user_id}'`, (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            if (count > 0) {

                response.status(201).json({ status: false, message: 'This vehicle is already added in your list' })

            } else {

                pool.query(`INSERT INTO tbl_vehicle (gear_type,vehicle_number,tbl_user_id) VALUES('${gear_type}','${vehicle_number}','${tbl_user_id}')`, (error, result_vehicle) => {
                    if (error) {
                        return response.status(403).json({ status: false, message: error })
                    }

                    if (result_vehicle.rowCount > 0) {
                        response.status(201).json({ status: true, message: 'Vehicle added successfully' })
                    } else {
                        response.status(201).json({ status: false, message: 'something error' })
                    }

                })
            }

        })
    },

    added_vehicle_list: (request, response) => {

        const { tbl_user_id } = request.body;

        pool.query(`select *  FROM tbl_vehicle where tbl_user_id = '${tbl_user_id}' order by tbl_vehicle_id DESC`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_vehicle_id: isNull(table.tbl_vehicle_id),
                        vehicle_number: isNull(table.vehicle_number),
                        gear_type: isNull(table.gear_type)
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Vehicle List', data: data })
            } else {
                response.status(201).json({ status: true, message: 'Vehicle not added', data: [] })
            }

        })
    },

    delete_vehicle: (request, response) => {

        const { tbl_user_id, tbl_vehicle_id } = request.body;

        pool.query(`DELETE FROM tbl_vehicle where tbl_user_id = '${tbl_user_id}' AND tbl_vehicle_id = '${tbl_vehicle_id}'`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            if (result.rowCount > 0) {

                response.status(201).json({ status: true, message: 'Deleted Successfully' })
            } else {
                response.status(201).json({ status: true, message: 'Something error' })
            }

        })
    },

    Location_wise_valet_user_list: (request, response) => {

        const { latitude, longitude, tbl_user_id } = request.body;

        pool.query(`select * from ( SELECT  *,( 3959 * acos( cos( radians(${latitude}) ) * cos( radians( latitude ) ) * cos( radians( longitude ) - radians(${longitude}) ) + sin( radians(${latitude}) ) * sin( radians( latitude ) ) ) ) AS distance FROM tbl_valet_user ) al where distance < 3 AND status = 1 AND duty_status = 'ON' ORDER BY distance`, (error, result) => {

            if (error) {
                response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;
            if (count > 0) {

                var res = result.rows;
                var data = [];
                res.forEach(function (table) {

                    let cat = {
                        tbl_valet_user_id: isNull(table.tbl_valet_user_id),
                        user_name: isNull(table.user_name),
                        latitude: isNull(table.latitude),
                        longitude: isNull(table.longitude),
                    };
                    data.push(cat);

                });

                response.status(201).json({ status: true, message: 'Valet List', data: data })
            } else {
                response.status(201).json({ status: true, message: 'Valet List Not Found', data: [] })
            }

        })
    },

    Add_user_new_address_API: (request, response) => {

        console.log('Add_user_new_address_API');

        const { tbl_user_id, first_address, second_address, state, city, pincode, address_type, latitude, longitude } = request.body;

        if (second_address == '' || second_address == null || second_address == undefined) {
            var secondaddress = '';
        } else {
            var secondaddress = second_address;
        }

        pool.query(`SELECT address_type FROM tbl_user_add_address WHERE address_type = '${address_type}' AND tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            if (count > 0) {

                const Update_user_add = await pool.query(`UPDATE tbl_user_add_address SET address_1 = $$${first_address}$$, address_2 =$$${secondaddress}$$, state = '${state}', city = '${city}', pincode = '${pincode}', address_type = '${address_type}', latitude = '${latitude}', longitude = '${longitude}' WHERE address_type = '${address_type}' AND tbl_user_id = '${tbl_user_id}'`);
                if (Update_user_add.rowCount > 0) {
                    response.status(201).json({ status: true, message: 'Your Address updated successfully' })
                } else {
                    response.status(201).json({ status: false, message: 'Something wrong ', })
                }

            } else {

                pool.query(`INSERT INTO tbl_user_add_address (tbl_user_id, address_1, address_2, state, city, pincode, address_type, latitude, longitude)VALUES('${tbl_user_id}',$$${first_address}$$,$$${secondaddress}$$, '${state}', '${city}', '${pincode}', '${address_type}', '${latitude}', '${longitude}')`, (error, result_add) => {
                    if (error) {
                        return response.status(403).json({ status: false, message: error })
                    }

                    if (result_add.rowCount > 0) {
                        response.status(201).json({ status: true, message: 'Your New Address added successfully' })
                    } else {
                        response.status(201).json({ status: false, message: 'something error' })
                    }

                })
            }

        })
    },


    requset_delete_account_API: (request, response) => {

        const {full_name, mobile, email, reason } = request.body;

        const lowercase_email = email.toLowerCase();
    
        console.log('request.body', request.body);
    
        pool.query(`SELECT email FROM tbl_user WHERE email = '${lowercase_email}'`, async(error, result) => {
    
            if (error) {
                return response.status(403).json({ status: false, message: error, msg : "SELECT email FROM" })
            }
            var count = result.rowCount;
    
            if(count > 0){
    
                const ck_delreq_query = await pool.query(`SELECT email FROM tbl_requset_delete_account WHERE email = '${lowercase_email}'`);
    
                if(ck_delreq_query.rowCount > 0)
                {
                    return response.status(201).json({ status: false, message: 'Your request is already under process.'});
                }else{
    
                    pool.query(`INSERT INTO tbl_requset_delete_account(full_name, mobile, email, reason)VALUES($$${full_name}$$, '${mobile}', '${lowercase_email}',  $$${reason}$$)`,(error, result_add) => {
                        if (error) {
                            return response.status(403).json({ status: false, message: error.message, msg : "INSERT"});
                        }
                        if(result_add.rowCount > 0)
                        {
                            return response.status(201).json({ status: true, message: 'Your request have been sent successfully'})
                        }else{
                            return response.status(201).json({ status: false, message: 'Something went wrong, Please try again.' })
                        }
                    })
                }
            }else{
                response.status(201).json({ status: false, message: 'This email is not registered with us.' })
            }
        })
    },


    IB_registration_API: (request, response) => {

        const { name, firebase_token, email, password, mobile, login_id } = request.body;

        console.log('IB_registration_API', request.body);

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT * FROM tbl_ib_user WHERE  email = '${lowercase_email}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

            
            if (count > 0) {

                response.status(201).json({ status: false, message: 'This email is already registered with us', data: [] })

            } else {

                var otpp = Math.floor(100000 + Math.random() * 900000);
                var ot = Math.floor(100 + Math.random() * 999);

                // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");


                pool.query(`INSERT INTO tbl_ib_user (name,email,email_otp,joining_date,joining_time,password,firebase_token,mobile,sponsor_id) VALUES ('${name}','${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${mobile}','${login_id}') RETURNING tbl_ib_user_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }

                        var newuser_id = result_user.rows[0].tbl_ib_user_id;
                        const token = createToken(result_user.rows[0].tbl_ib_user_id);
                        var my_login_id = 'XTRIB' + ot + newuser_id;


                        const Update_my_sponsor_id = await pool.query(`UPDATE tbl_ib_user SET login_id = '${my_login_id}', username = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_ib_user_id = '${newuser_id}'`);


                        // email code start here

                        let mailOptions = {
                            from: '"XtremeFX" <info@fxtrade.app>', // sender address
                            to: lowercase_email, // list of receivers
                            subject: "Account Login Details", // Subject line
                            //text: verification_token, // plain text body
                            // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                            html: `<html>
                                                    <body>                             
                                                        <p>
                                                         Hi, <br>
                                                         Your XtremeFx account login details are email: ${email} AND password is ${password}. Please do not share this with anyone.
                                                        </p>                   
                                                        <p>
                                                          Thanks <br/>
                                                          Customer Support
                                                          XtremeFX 
                                                        </p>
                                                       
                                                    </body>
                                            </html>`

                        };
                        transporter.sendMail(mailOptions, (error, info) => {
                            if (error) {
                                return console.log(error);
                            } else {
                                return console.log(info);
                            }
                            // console.log('Message %s sent: %s', info.messageId, info.response);
                        });

                        // email code end here


                        pool.query(`SELECT * FROM tbl_ib_user WHERE  tbl_ib_user_id = '${newuser_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_ib_user_id: isNull(table.tbl_ib_user_id),
                                    username: isNull(table.username),
                                    name: isNull(table.name),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);
                            });
                            response.status(201).json({ status: true, message: 'Your have successfully created user account login details have send to mention email . Now, please verify your email by checking your inbox.', data: data })
                        })
                    },
                )
            }
        })
    },


    Manager_registration_API: (request, response) => {

        const { name, firebase_token, email, password, mobile } = request.body;

        console.log('Manager_registration_API', request.body);

        const lowercase_email = email.toLowerCase();

        pool.query(`SELECT * FROM tbl_manager WHERE  email = '${lowercase_email}'`, async (error, result) => {

            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;

           
            if (count > 0) {

                response.status(201).json({ status: false, message: 'This email is already registered with us', data: [] })

            } else {

                var otpp = Math.floor(100000 + Math.random() * 900000);
                var ot = Math.floor(100 + Math.random() * 999);

                // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");


                pool.query(`INSERT INTO tbl_manager (name,email,email_otp,joining_date,joining_time,password,firebase_token,mobile) VALUES ('${name}','${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${mobile}') RETURNING tbl_manager_id`,
                    async (error, result_user) => {

                        if (error) {
                            return response.status(403).json({ status: false, message: error });
                        }

                        var newuser_id = result_user.rows[0].tbl_manager_id;
                        const token = createToken(result_user.rows[0].tbl_manager_id);
                        var my_login_id = 'XTRMN' + ot + newuser_id;


                        const Update_my_sponsor_id = await pool.query(`UPDATE tbl_manager SET login_id = '${my_login_id}', username = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_manager_id = '${newuser_id}'`);


                        // email code start here

                        let mailOptions = {
                            from: '"XtremeFX" <info@fxtrade.app>', // sender address
                            to: lowercase_email, // list of receivers
                            subject: "Account Login Details", // Subject line
                            //text: verification_token, // plain text body
                            // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                            html: `<html>
                                                    <body>                             
                                                        <p>
                                                         Hi, <br>
                                                         Your XtremeFx account login details are email: ${email} AND password is ${password}. Please do not share this with anyone.
                                                        </p>                   
                                                        <p>
                                                          Thanks <br/>
                                                          Customer Support
                                                          XtremeFX 
                                                        </p>
                                                       
                                                    </body>
                                            </html>`

                        };
                        transporter.sendMail(mailOptions, (error, info) => {
                            if (error) {
                                return console.log(error);
                            } else {
                                return console.log(info);
                            }
                            // console.log('Message %s sent: %s', info.messageId, info.response);
                        });

                        // email code end here


                        pool.query(`SELECT * FROM tbl_manager WHERE  tbl_manager_id = '${newuser_id}'`, (error, result) => {
                            if (error) {
                                return response.status(403).json({ status: false, message: error })
                            }
                            var count = result.rowCount;

                            var res = result.rows;
                            var data = [];
                            res.forEach(function (table) {

                                let cat = {
                                    tbl_manager_id: isNull(table.tbl_manager_id),
                                    username: isNull(table.username),
                                    name: isNull(table.name),
                                    mobile: isNull(table.mobile),
                                    email: isNull(table.email),
                                    user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                                    wallet_amount: table.wallet_amount,
                                    jwt_token: isNull(table.jwt_token),
                                    firebase_token: isNull(firebase_token),
                                };
                                data.push(cat);
                            });
                            response.status(201).json({ status: true, message: 'Your have successfully created user account login details have send to mention email . Now, please verify your email by checking your inbox.', data: data })
                        })
                    },
                )
            }
        })
    },




    IB_Login_API: (request, response) => {

        const { email, password, firebase_token } = request.body;

        console.log('IB_Login_API', request.body);

        const lowercase_email = email.toLowerCase();
        

        pool.query(`SELECT * FROM tbl_ib_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;


            if (count > 0) {

                if (result.rows[0].password == password) {

                    var otpp = Math.floor(100000 + Math.random() * 900000);

                 

                    const Update_my_sponsor_id = await pool.query(`UPDATE tbl_ib_user SET firebase_token = '${firebase_token}', email_otp = '${otpp}'  WHERE email = '${lowercase_email}'`);


                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {

                        let cat = {
                            tbl_ib_user_id: isNull(table.tbl_ib_user_id),
                            username: isNull(table.username),
                            login_id: isNull(table.login_id),
                            name: isNull(table.name),
                            mobile: isNull(table.mobile),
                            email: isNull(table.email),
                            user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                            email_otp: table.email_otp,
                            email_verify: table.email_verify,
                            wallet_amount: table.wallet_amount,
                            profile_status: table.profile_status,
                            kyc_step_1: table.kyc_step_1,
                            kyc_step_2: table.kyc_step_2,
                            jwt_token: isNull(table.jwt_token),
                            firebase_token: isNull(firebase_token),
                            status: table.status,
                        };
                        data.push(cat);
                    });
                    response.status(201).json({ status: true, message: 'Welcome To XtremeFX', data: data })
                } else {
                    response.status(201).json({ status: false, message: 'You entered the wrong password', data: [] })
                }
            } else {
                response.status(201).json({ status: false, message: 'The email is not registered with us', data: [] })
            }

        })
    },




    Manager_Login_API: (request, response) => {

        const { email, password, firebase_token } = request.body;

        console.log('Manager_Login_API', request.body);

        const lowercase_email = email.toLowerCase();
        

        pool.query(`SELECT * FROM tbl_manager WHERE  email = '${lowercase_email}'`, async (error, result) => {
            if (error) {
                return response.status(403).json({ status: false, message: error })
            }
            var count = result.rowCount;


            if (count > 0) {

                if (result.rows[0].password == password) {

                    var otpp = Math.floor(100000 + Math.random() * 900000);

                 

                    const Update_my_sponsor_id = await pool.query(`UPDATE tbl_manager SET firebase_token = '${firebase_token}', email_otp = '${otpp}'  WHERE email = '${lowercase_email}'`);


                    var res = result.rows;
                    var data = [];
                    res.forEach(function (table) {

                        let cat = {
                            tbl_manager_id: isNull(table.tbl_manager_id),
                            username: isNull(table.username),
                            login_id: isNull(table.login_id),
                            name: isNull(table.name),
                            mobile: isNull(table.mobile),
                            email: isNull(table.email),
                            user_image: isNull(base_img_url + "/user_image/" + table.user_image),
                            email_otp: table.email_otp,
                            email_verify: table.email_verify,
                            wallet_amount: table.wallet_amount,
                            profile_status: table.profile_status,
                            kyc_step_1: table.kyc_step_1,
                            kyc_step_2: table.kyc_step_2,
                            jwt_token: isNull(table.jwt_token),
                            firebase_token: isNull(firebase_token),
                        };
                        data.push(cat);
                    });
                    response.status(201).json({ status: true, message: 'Welcome To XtremeFX', data: data })
                } else {
                    response.status(201).json({ status: false, message: 'You entered the wrong password', data: [] })
                }
            } else {
                response.status(201).json({ status: false, message: 'The email is not registered with us', data: [] })
            }

        })
    },














};