# MT5 Web API Client ( Manager Interface )

MT5 Web API Client can be used for MetaTrader 5 Web Manager Interface (Rest API)

[for more information](https://support.metaquotes.net/en/docs/mt5/api/webapi_main)

This library expose 2 main methods:

## Request:

Promise Based response

## Stream:

Return Text Stream that contain response from MT Rest Api

example usage:

```
import MT5WebClient from '@centroid/mt5-webapi-client';

const mt = new MT5WebClient({
  password:process.env.MT_PASS,
  host: process.env.MT_HOST,
  login: process.env.MT_LOGIN,
  port: process.env.MT_PORT,
});

// print array of all symbols on server
mt.request('/api/symbol/list').then(console.log);

// will all deals of account 12345
mt.request('/api/deal/get?login=12345').then(console.log);


mt.stream('/api/chart/get?symbol=BTCUSD&from=1688645379&to=1658645379&data=dohlctv').then(stream=>{
  // nodejs text stream contain response
  // this is more memory effient since response will not be parsed as json, nore allocated on memory
});

```

feel free to extend `MT5WebClient` class to create you own Client interface.

@TODO:

- create a client api for all avaliable MT5 urls
- include Type Declaration for all data structures

- [] Configuration Databases
- [] Trading
- [] Users
- [] Clients
- [] Mail
- [] News
- [] Prices
- [] Daily Reports
- [] Settings Files
- [] Subscriptions
