"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.MTAgent = void 0;
/* eslint-disable camelcase */
const buffer = require("buffer");
const crypto = require("crypto");
const https_1 = require("https");
const FAKE_ORIGIN_HOST = 'mzalabany.centroidsol.net';
class MTAgent extends https_1.Agent {
    constructor(config, login, password) {
        super(config);
        this.login = login;
        this.password = password;
        this.cli_random_buf = crypto.randomBytes(16);
        this.sendPassword = (rand) => {
            const pass_md5 = crypto.createHash('md5');
            const buf = buffer.transcode(Buffer.from(this.password, 'utf8'), 'utf8', 'utf16le');
            pass_md5.update(buf);
            const pass_md5_digest = pass_md5.digest();
            // ---
            const md5 = crypto.createHash('md5');
            md5.update(pass_md5_digest);
            md5.update('WebAPI', 'ascii');
            const md5_digest = md5.digest();
            // ---
            const answer_md5 = crypto.createHash('md5');
            answer_md5.update(md5_digest);
            const buf2 = Buffer.from(rand, 'hex');
            answer_md5.update(buf2);
            // ---
            const digest = answer_md5.digest('hex');
            const cli_random_buf_hex = this.cli_random_buf.toString('hex');
            return '/api/auth/answer?srv_rand_answer=' + digest + '&cli_rand=' + cli_random_buf_hex;
        };
        this.validatePassword = (cli_rand_answer) => {
            const pass_md5 = crypto.createHash('md5');
            const buf = buffer.transcode(Buffer.from(this.password, 'utf8'), 'utf8', 'utf16le');
            pass_md5.update(buf);
            const pass_md5_digest = pass_md5.digest();
            // ---
            const md5 = crypto.createHash('md5');
            md5.update(pass_md5_digest);
            md5.update('WebAPI', 'ascii');
            const md5_digest = md5.digest();
            // ---
            const answer_md5 = crypto.createHash('md5');
            answer_md5.update(md5_digest);
            answer_md5.update(this.cli_random_buf);
            return `${cli_rand_answer}` === answer_md5.digest('hex');
        };
        this.createSocket = (req, options, cb) => {
            // @ts-ignore
            super.createSocket(req, options, (err, client) => {
                if (err) {
                    cb(err, client);
                    return;
                }
                // ---- Step1: send login
                client.once('connect', () => client.write(`GET /api/auth/start?version=1985&agent=WebManager&login=${this.login}&type=manager HTTP/1.1\r\n
                    Connection: keep-alive\r\n
                    Host: ${FAKE_ORIGIN_HOST}\r\n\r\n`));
                // ---- Step2: send password
                client.once('data', (data) => {
                    const rand = String(data).match(/srv_rand"[^"]*"([a-z0-9]*)"/) || ['', ''];
                    const hex = this.sendPassword(rand[1]);
                    if (Array.isArray(rand)) {
                        client.write(`GET ${hex} HTTP/1.1\r\n
                        Connection: keep-alive\r\n
                        Host: ${FAKE_ORIGIN_HOST}\r\n\r\n`);
                        client.once('data', (data) => {
                            const rand = String(data).match(/cli_rand_answer"[^"]*"([a-z0-9]*)"/) || [];
                            if (this.validatePassword(rand[1])) {
                                cb(null, client);
                            }
                            else {
                                cb(new Error('Failed to authenticate mt5 socket'));
                            }
                        });
                    }
                });
            });
        };
    }
}
exports.MTAgent = MTAgent;
