"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __classPrivateFieldSet = (this && this.__classPrivateFieldSet) || function (receiver, state, value, kind, f) {
    if (kind === "m") throw new TypeError("Private method is not writable");
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a setter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot write private member to an object whose class did not declare it");
    return (kind === "a" ? f.call(receiver, value) : f ? f.value = value : state.set(receiver, value)), value;
};
var __classPrivateFieldGet = (this && this.__classPrivateFieldGet) || function (receiver, state, kind, f) {
    if (kind === "a" && !f) throw new TypeError("Private accessor was defined without a getter");
    if (typeof state === "function" ? receiver !== state || !f : !state.has(receiver)) throw new TypeError("Cannot read private member from an object whose class did not declare it");
    return kind === "m" ? f : kind === "a" ? f.call(receiver) : f ? f.value : state.get(receiver);
};
var __rest = (this && this.__rest) || function (s, e) {
    var t = {};
    for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0)
        t[p] = s[p];
    if (s != null && typeof Object.getOwnPropertySymbols === "function")
        for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
            if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i]))
                t[p[i]] = s[p[i]];
        }
    return t;
};
var _GroupService_pool, _GroupService_info;
Object.defineProperty(exports, "__esModule", { value: true });
exports.GroupService = void 0;
const helpers_1 = require("./helpers");
class GroupService {
    constructor(name, pool) {
        this.Symbols = {};
        this.Prices = {};
        this.getSymbol = (symbol) => {
            return __classPrivateFieldGet(this, _GroupService_pool, "f").getSymbol(symbol, this.Group).catch(console.error);
        };
        _GroupService_pool.set(this, void 0);
        _GroupService_info.set(this, null);
        this.bootstrap = () => __awaiter(this, void 0, void 0, function* () {
            const info = yield this.getInfo();
            const overides = getconfigOverides(info.Symbols);
            const promises = info.Symbols.map(({ Path }) => __awaiter(this, void 0, void 0, function* () {
                const i = yield __classPrivateFieldGet(this, _GroupService_pool, "f").request(encodeURI(`/api/tick/stat?symbol=` + Path + '&group=' + this.Group));
                yield Promise.all(i.answer.map(row => {
                    this.Prices[row.Symbol] = row;
                    return __classPrivateFieldGet(this, _GroupService_pool, "f").getSymbol(row.Symbol, this.Group).then(r => {
                        this.Symbols[row.Symbol] = Object.assign(Object.create(null), r.answer, overides[r.answer.Symbol]);
                    });
                }));
            }));
            console.time('Getting Group Symbols');
            yield Promise.all(promises);
            console.timeEnd('Getting Group Symbols');
            return this;
        });
        this.Group = name;
        __classPrivateFieldSet(this, _GroupService_pool, pool, "f");
        this.bootstrap = (0, helpers_1.throttlePromise)(this.bootstrap, this, true);
        this.getInfo = (0, helpers_1.throttlePromise)(this.getInfo, this, true);
        setImmediate(() => this.bootstrap());
    }
    static getInstance(name, pool) {
        if (!GroupService.instances[name]) {
            GroupService.instances[name] = new GroupService(name, pool);
        }
        return GroupService.instances[name];
    }
    getInfo() {
        return __awaiter(this, void 0, void 0, function* () {
            if (!__classPrivateFieldGet(this, _GroupService_info, "f"))
                __classPrivateFieldSet(this, _GroupService_info, yield __classPrivateFieldGet(this, _GroupService_pool, "f").getGroup(this.Group), "f");
            return __classPrivateFieldGet(this, _GroupService_info, "f");
        });
    }
}
exports.GroupService = GroupService;
_GroupService_pool = new WeakMap(), _GroupService_info = new WeakMap();
GroupService.instances = {};
const getconfigOverides = (grpSymbol) => {
    return grpSymbol.reduce((carry, item) => {
        const { Path } = item, symbolGroupSettings = __rest(item, ["Path"]);
        const needOveride = Object.values(symbolGroupSettings).some(row => row !== 'default');
        const overRide = needOveride
            ? Object.keys(symbolGroupSettings).reduce((c, item) => {
                let i = item;
                if (symbolGroupSettings[i] === 'default')
                    return c;
                c[i] = symbolGroupSettings[i];
                return c;
            }, {})
            : {};
        if (overRide) {
            carry[Path] = overRide;
        }
        return carry;
    }, {});
};
