"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.throttlePromise = exports.cielToMultiple = exports.floorToMultiple = void 0;
function floorToMultiple(num, multiple) {
    return Math.floor(num / multiple) * multiple;
}
exports.floorToMultiple = floorToMultiple;
function cielToMultiple(num, multiple) {
    return Math.ceil(num / multiple) * multiple;
}
exports.cielToMultiple = cielToMultiple;
// Prevent Promise from being called while still loading.
// return loading promise if it is not loaded yet
const throttlePromise = (fn, context, persist = false) => {
    let lastFn = {};
    function ReturnFn() {
        const args = arguments;
        const dependencies = Array.from(args).join('-') || '~';
        lastFn[dependencies] =
            lastFn[dependencies] ||
                fn.apply(context, args).finally(() => {
                    if (persist === false)
                        lastFn[dependencies] = null;
                });
        return lastFn[dependencies];
    }
    return ReturnFn;
};
exports.throttlePromise = throttlePromise;
