import { MTPool } from './pool';
import { MT } from './types';
export default class MT5WebClient extends MTPool {
    constructor(config: {
        host: string;
        port: number;
        login: string;
        password: string;
    }, maxPoolSize?: number);
    getSymbolState: (mask?: string) => Promise<{
        answer: MT.SymbolStat[];
        trans_id?: string;
        retcode: string;
    }>;
    getHistoryCandlesInParallel: (symbol: string, _from: number, _to: number) => Promise<MT.HistoryBar[]>;
    getHistoryCandles: (symbol: string, _from: number, _to?: number) => Promise<{
        answer: MT.HistoryBar[];
        trans_id?: string;
        retcode: string;
    }>;
    getGroup: (name: string) => Promise<MT.Group>;
    getOrders: (logins: string[], groupName: string) => Promise<{
        answer: MT.Order[];
        trans_id?: string;
        retcode: string;
    }>;
    getLastTick: (symbol: string, group: string) => Promise<{
        answer: MT.Tick[];
        trans_id?: string;
        retcode: string;
    }>;
    getSymbol: (symbol: string, group?: string) => Promise<{
        answer: MT.SymbolInfo;
        trans_id?: string;
        retcode: string;
    }>;
    getPositionsByLogin(login: string): Promise<MT.Postion[]>;
    getOrdersByLogin(login: string): Promise<MT.Order[]>;
    getPositions: (logins: string[], groupName: string) => Promise<MT.Postion[]>;
    getAccounts: (groupName: string) => Promise<MT.Account[]>;
    getAccountDeals: (account: string, from: number, to: number) => Promise<MT.Deal[]>;
}
