"use strict";
// <refrence path="./.index.d.ts" />
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.MTPool = void 0;
const https = require("https");
const agent_1 = require("./agent");
const helpers_1 = require("./helpers");
class MTPool {
    constructor(host, port, login, password, maxPoolSize = 20) {
        this.host = host;
        this.port = port;
        this.login = login;
        this.password = password;
        this.maxPoolSize = maxPoolSize;
        this.agentFactory = () => {
            const liveagent = new agent_1.MTAgent({
                maxSockets: this.maxPoolSize,
                maxFreeSockets: this.maxPoolSize,
                keepAliveMsecs: 12 * 1000,
                timeout: 180 * 1000,
                keepAlive: true,
                scheduling: 'lifo', // Fifo | lifo
            }, this.login, this.password);
            return liveagent;
        };
        this.setTz = () => this.request('/api/time/server').then(r => {
            let to = Number(r.answer.time.split(' ')[0]) - Math.floor(Date.now() / 1000);
            return (0, helpers_1.floorToMultiple)(to, 3600);
        });
        this.stream = (path, body, agent) => __awaiter(this, void 0, void 0, function* () {
            const liveagent = agent || this.Agent;
            return new Promise((resolve, reject) => {
                // Console.log('starting: ' + path)
                const options = this.reqConfig(path, liveagent, body);
                const r = https
                    .request(options, res => {
                    if (res.statusCode !== 200) {
                        res.socket.destroy();
                        console.error('MT5 connection failed: ' + res.statusCode);
                        return reject(res.statusCode);
                    }
                    res.setEncoding('utf8');
                    resolve(res);
                })
                    .on('error', reject);
                if (body) {
                    r.write(body);
                }
                r.end();
            });
        });
        this.request = (path, body, agent) => __awaiter(this, void 0, void 0, function* () {
            const liveagent = agent || this.Agent;
            return new Promise((resolve, reject) => {
                const options = this.reqConfig(path, liveagent, body);
                // Console.log('requesting: ', options)
                const r = https
                    .request(options, res => {
                    if (res.statusCode !== 200) {
                        res.socket.destroy();
                        console.error('MT5 connection failed: ' + res.statusCode);
                        return reject(res.statusCode);
                    }
                    res.setEncoding('utf8');
                    let chunks = '';
                    res.on('data', chunk => {
                        chunks += chunk;
                    });
                    res.once('end', () => {
                        resolve(JSON.parse(chunks));
                    });
                })
                    .once('error', reject);
                if (body) {
                    r.write(body);
                }
                r.end();
            });
        });
        // validate date is UTC
        if (new Date().getTimezoneOffset() !== 0) {
            throw new Error("MT5 pool require server to be running in UTC timezone. try set process.env.TZ='UTC'");
        }
        this.Agent = this.agentFactory();
        this.TZ = this.setTz();
    }
    reqConfig(path, agent, body) {
        const r = {
            host: this.host,
            port: this.port,
            path,
            method: 'GET',
            headers: { Connection: 'keep-alive' },
            agent,
            rejectUnauthorized: false, // Comment out this line if you use self-signed certificates
        };
        if (body || body === null) {
            r.method = 'POST';
            r.headers = {
                Connection: 'keep-alive',
                'Content-Type': 'application/x-www-form-urlencoded',
                'Content-Length': body === null ? 0 : body.length,
            };
        }
        return r;
    }
    dispose() {
        this.Agent.destroy();
    }
}
exports.MTPool = MTPool;
