// load the things we need
var express = require('express');
var cookieParser = require('cookie-parser');
var session = require('express-session');
var app = express();
var bodyParser = require('body-parser');
var axios = require('axios');
const expressLayout = require('express-ejs-layouts');
const moment = require('moment');
const path = require('path');
const fs = require('fs');
const pg = require('pg');
const formidable = require('formidable');
const dbConfig = require('./db');
const pool = new pg.Pool(dbConfig);
var user_apiurl = "https://api.xprimetrade.live";
const  img_base_url = "https://api.xprimetrade.live/files/upload";
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const multer = require("multer");
const nodeMailer = require('nodemailer')

const PORT = 3004;

///////////////////////////// create token function  ///////////////////////

const jwt = require('jsonwebtoken');
const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}
//  const token = createToken(tbl_store_id);               
//  const Update_my_sponsor_id = await pool.query(`UPDATE tbl_store SET  jwt_token ='${token}' WHERE tbl_store_id = '${tbl_store_id}'`);

/////////////////////////////// create token function  ///////////////////////////////

//////////////////////////upload image code ///////////////////////////////////////

const createFolder = (folder) => {
    if (!fs.existsSync(folder)) {
        fs.mkdirSync(folder, { recursive: true });
    }
};

const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        let folderPath = "";
        if (file.fieldname === "aadhar_image") {
            folderPath = "uploads/aadhar_image/";
        } else if (file.fieldname === "pan_image") {
            folderPath = "uploads/pan_image/";
        }

        createFolder(folderPath);
        cb(null, folderPath);
    },
    filename: function (req, file, cb) {
        cb(null, file.fieldname + "_" + Date.now() + path.extname(file.originalname));
    },
});

// Initialize upload middleware
const upload = multer({ storage: storage });

//////////////////////////upload image code ///////////////////////////////////////

// use res.render to load up an ejs view file
app.use(express.static("views"));
app.use('/', express.static(path.join(__dirname, '/public')));
app.use('/:a', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b/:c', express.static(path.join(__dirname, '/public')));

app.use(expressLayout)
app.set('views', path.join(__dirname, 'templates/views'));
app.set("views", path.join(__dirname, "templates", "views"));
app.set('view engine', 'ejs');

// Latest version - v3.0.0
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json({ limit: "150mb" }))

app.use(cookieParser());
app.use(session({ 
    secret: "CRM",
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 7 },
    resave: true,
    saveUninitialized: true
}));

// Mock database for demonstration purposes
let userSessions = {}; // { userId: sessionId }



// Middleware to check if the user is not authenticated
const unauth = function (req, res, next) {
    if (req.session.tbl_user_id && userSessions[req.session.tbl_user_id] === req.session.id) {
        // If the user is authenticated, redirect them to another page (e.g., dashboard)
        res.redirect('/dashboard'); // Change '/dashboard' to whatever page you want to redirect to
    } else {
        // If not authenticated, allow access to the login page
        next();
    }
};


const transporter = nodeMailer.createTransport({
    host: 'smtp.gmail.com',
    port: 587,
    secure: false,
    auth: {
        user: 'xprimetradeofficial@gmail.com',
        pass: 'zkrwdjrjlytjehty'
    }
});


app.use(function (req, res, next) {
    var err = req.session.error;
    delete req.session.error;
    res.locals.imgbaseurl = img_base_url;
    res.locals.moment = moment;
    res.locals.super_admin_id = req.session.supadminid;
    res.locals.tbl_user_id = req.session.tbl_user_id;
    res.locals.ticket_number = req.session.ticket_number;
    res.locals.user_name = req.session.username;
    res.locals.user_email = req.session.email;
    res.locals.email = req.session.email;
    res.locals.password = req.session.password;
    res.locals.used_login_id = req.session.used_login_id;
    res.locals.user_pageno = req.session.user_list_page_no;
    res.locals.jwt_token = req.session.jwt_token;
    res.locals.fname = req.session.fname;
    res.locals.lname = req.session.lname;
    res.locals.mobile = req.session.mobile;
    res.locals.user_image = req.session.user_image;
    res.locals.user_name = req.session.user_name;
    res.locals.error = err;
    res.locals.bearer = res.locals.jwt_token;
    res.locals.kyc_step_1 = req.session.kyc_step_1;
    res.locals.kyc_step_2 = req.session.kyc_step_2;
    res.locals.check_ib_login = req.session.check_ib_login;
    res.locals.ib_email = req.session.ib_email;
    res.locals.ib_password = req.session.ib_password;

    
    next();

   // console.log("req.session",res.locals);

});



const auth = function (req, res, next) {
    //console.log(req);
    //console.log("req.session.tbl_user_id",req.session.tbl_user_id);
    
    if (req.session.tbl_user_id) {
        if(req.session.tbl_user_id){
          next();
        }else{
            // Session ID does not match, log the user out
            req.session.destroy(() => {
                res.redirect('/');
            });
        }
    } else {
        res.redirect('/');
    }
}



app.get('/logout', function (req, res) {
    console.log("logout");
    
    req.session.destroy(function () {
       res.redirect('/');
    });
})

app.get('/',  function (req, res) {
    res.render('login', {
        layout : false,
    });
});

app.get('/login', function (req, res) {
    res.setHeader('Cache-Control', 'no-store');     // Prevent caching of the login page
     res.setHeader('Pragma', 'no-cache');        // HTTP 1.0
    //res.setHeader('Expires', '0');              // Proxies
    res.render('login', {
        layout : false,
    });
});


app.get('/forgot_password', unauth, function (req, res) {

    res.render('forgot_password', {
        layout : false,
    });
});

app.get('/index', auth, async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id; 

    const wallet_amount =  await pool.query(`SELECT wallet_amount,profit_amount FROM tbl_user where  tbl_user_id = '${tbl_user_id}' `);
    const wallet_amount_data = wallet_amount.rows;

    res.render('index', {
        layout : true,
        wallet_amount_data: wallet_amount_data,
    });
});




app.get('/user_account_list', auth, async (req, res) => {
    try {
        var tbl_user_id = req.session.tbl_user_id; 

        if (!tbl_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const mt5_account = await pool.query(
            `SELECT * FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
            [tbl_user_id]
        );

        res.render('account_section/user_account_list', {
            layout: false, // Ensures only the partial is sent
            mt5_account_data1: mt5_account.rows,
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/user_ticket_list', auth, async (req, res) => {
    try {
        var tbl_user_id = req.session.tbl_user_id; 

        if (!tbl_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const ticket_list = await pool.query(
            `SELECT * FROM tbl_user_ticket WHERE tbl_user_id = $1 ORDER BY tbl_user_ticket_id DESC`,
            [tbl_user_id]
        );

        res.render('account_section/user_ticket_list', {
            layout: false, // Ensures only the partial is sent
            ticket_list_data: ticket_list.rows,
        });

    } catch (error) {
        console.error("Error fetching Ticket data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/chat/:ticket_number', auth, async (req, res) => {
    const { ticket_number } = req.params;
    try {
        var tbl_user_id = req.session.tbl_user_id; 

        req.session.ticket_number  = ticket_number;

        if (!tbl_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const ticket_msg = await pool.query(
            `SELECT * FROM tbl_user_ticket_msg WHERE tbl_user_id = $1 AND ticket_number =$2 ORDER BY tbl_user_ticket_msg_id ASC`,
            [tbl_user_id,ticket_number]
        );

        res.render('chat', {
            layout: true, // Ensures only the partial is sent
            ticket_msg: ticket_msg.rows,
        });

    } catch (error) {
        console.error("Error fetching Ticket data:", error);
        res.status(500).send("Error loading account data");
    }
});


app.get('/chat_msg', auth, (req, res) => {
    var tbl_user_id = req.session.tbl_user_id;
    let ticket_number = req.query.ticket_number.replace(/\/$/, ""); // Remove trailing slash if exists
    //console.log("ticket_number",ticket_number);
    

    // Now query the database with sanitized ticket_number
    pool.query('SELECT * FROM tbl_user_ticket_msg WHERE ticket_number = $1 order by tbl_user_ticket_msg_id ASC', [ticket_number], (err, result) => {
        if (err) {
            console.error("Database error:", err);
            return res.status(500).send("Error fetching messages.");
        }
        res.render('chat_section/ticket_msg', {
            layout: false,
            ticket_msg: result.rows,
        });
    });
});


app.get('/deposit', auth,  function (req, res) {
    
    res.render('deposit', {
        layout : true,
    });
});


app.post("/deposit_amount", auth, async (req, res) => {
    const { login_id, remark, deposit_type, currency_type, amount, user_transection_address } = req.body;
    const tbl_user_id = req.session.tbl_user_id;
   

    //console.log("deposit_amount",req.body);
    
    if (!login_id || !deposit_type || !currency_type || !amount || !user_transection_address) {
        return res.json({ success: false, message: "All fields are required." });
    }

    const mt5_number = login_id;
    // new code start here
    pool.query(`SELECT tbl_mt5_user_id,tbl_user_id,login_id FROM tbl_mt5_user WHERE  login_id = '${login_id}' AND tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

                // const check_already_deposite_query = await pool.query(`SELECT tbl_user_id, wallet_amount FROM tbl_user where wallet_amount > 0 AND tbl_user_id ='${tbl_user_id}'`);

                // if(check_already_deposite_query.rowCount > 0){
                //     console.log('Deposit failed. Initial deposit already made.');
                //     return res.json({ success: false, message: "Deposit failed. Initial deposit already made." });
                // }

                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");

                // if(currency_type=='INR')
                // {
                //     var amount_range = '90000'
                //     var new_amount = '1000';
                // }else{
                //     var amount_range = '1000'
                //     var new_amount = '1000';
                // }


            // if(amount==amount_range)
            // {
            
                pool.query(`INSERT INTO tbl_deposit (tbl_user_id,deposit_type,currency_type,amount,mt5_number,user_transection_address,created_date,created_time,remark,inr_amount) VALUES ('${tbl_user_id}','${deposit_type}','${currency_type}','${new_amount}','${mt5_number}','${user_transection_address}','${joining_date}','${joining_time}',$$${remark}$$,'${amount}') RETURNING tbl_deposit_id`,
                    async (error, result_user) => {

                        if (error) {
                            return res.status(403).json({ status: false, message: error })
                        }

                        if(result_user.rowCount > 0)
                        {

                            return res.json({ success: true, message: 'Deposit Successfully' });
                        }else{
                        
                            return res.json({ success: false, message:  "Deposit failed." });
                        }
                    },
                )

            // }else{
            //    return res.json({ success: false, message:  "Deposit failed. Amount should be 1000 USD" });
            // }
        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});


app.get('/deposit_new', auth,   async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    
    res.render('deposit_new', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});

app.get('/deposit_trc20', auth,   async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    
    res.render('deposit_trc20', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});



app.get('/bank_deposit', auth,   async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    
    res.render('bank_deposit', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});

// app.get('/PayoutRequest', auth,  async (req, res) => {

//     var tbl_user_id = req.session.tbl_user_id;
//     const mt5_account = await pool.query(
//         `SELECT (SELECT wallet_amount FROM tbl_user where  tbl_user_id = '${tbl_user_id}' ) AS wallet_amount, tbl_mt5_user.login_id,tbl_mt5_user.balance FROM tbl_mt5_user WHERE tbl_mt5_user.status = '1' AND tbl_mt5_user.tbl_user_id = $1 ORDER BY tbl_mt5_user.tbl_mt5_user_id DESC`,
//         [tbl_user_id]
//     );
    
//     res.render('PayoutRequest', {
//         layout : true, 
//         mt5_account_data: mt5_account.rows,
//     });
// });



app.get('/PayoutRequest', auth,  async (req, res) => {
    var tbl_user_id = req.session.tbl_user_id;
    // var tbl_user_id = '150';
    const mt5_account = await pool.query(
        `SELECT (SELECT wallet_amount FROM tbl_user WHERE tbl_user_id = $1) AS wallet_amount, 
        (SELECT profit_amount FROM tbl_user WHERE tbl_user_id = $1) AS profit_amount,
        tbl_mt5_user.login_id, tbl_mt5_user.tbl_user_id, tbl_mt5_user.balance 
        FROM tbl_mt5_user 
        WHERE tbl_mt5_user.status = '1' AND tbl_mt5_user.tbl_user_id = $1 
        ORDER BY tbl_mt5_user.tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    // Default values if no records are found
    let mt5_account_data = mt5_account.rows.length > 0 ? mt5_account.rows : [{ wallet_amount: 0, login_id: null, balance: 0 }];   
    res.render('PayoutRequest', {
        layout: true,
        mt5_account_data
    });
});




// app.post("/bck_withdraw_amount",  async (req, res) => {
//     const { login_id, amount, user_wallet_address } = req.body;

//     const tbl_user_id = req.session.tbl_user_id;

//     console.log("withdraw_amount",req.body);
    
//     if (!login_id || !user_wallet_address || !amount) {
//         return res.json({ success: false, message: "All fields are required." });
//     }

//     const mt5_number = login_id;

//     // new code start here
//     pool.query(`SELECT tbl_mt5_user_id,tbl_user_id,login_id,balance FROM tbl_mt5_user WHERE  login_id = '${login_id}' AND tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

//         if (error) {
//             return res.status(403).json({ status: false, message: error })
//         }
//         var count = result.rowCount;

//         if (count > 0) {
//             var wallet_amount = result.rows[0].balance;

//             if(wallet_amount<=amount)
//             {
//                 return res.json({ success: false, message: 'Your wallet amount is low for this account you should be withdraw '+wallet_amount });
//             }


//                         const joining_time = moment().utcOffset("+05:30").format('LT');
//                         const joining_date = moment(date).format("DD MMM YYYY");
    
//                         pool.query(`INSERT INTO tbl_withdrawal_amount (tbl_user_id,account_id,amount,mt5_number,wallet_address,created_date,created_time) VALUES ('${tbl_user_id}','${login_id}','${amount}','${login_id}','${user_wallet_address}','${joining_date}','${joining_time}'); 
//                         UPDATE tbl_user SET wallet_amount = wallet_amount - '${amount}' where tbl_user_id = '${tbl_user_id}';
//                         UPDATE tbl_mt5_user SET balance = balance - '${amount}' where tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}';
//                         `,
//                         async (error, result_user) => {
//                             if (error) {
//                                 return res.status(403).json({ success: false, message: error })
//                             }
//                             if(result_user[0].rowCount > 0)
//                             {
//                                 res.json({ success: true, message: 'Your withdrawal request has been submitted successfully.' })
//                             }else{
                            
//                                 return res.json({ success: false, message: 'Something error.' });
//                             }
//                         })
                    

//         } else {
//             response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
//         }
//     }) 
//     // new code end here 
// });


app.post("/withdraw_amount",  auth, async (req, res) => {
    const { withdraw_wallet_type, amount, user_wallet_address } = req.body;

    // const tbl_user_id = '150';
    const tbl_user_id = req.session.tbl_user_id;

    // ✅ 1-5 date validation
    const today = new Date();
    const dayOfMonth = today.getDate();

    if (dayOfMonth < 1 || dayOfMonth > 5) {
        return res.json({
            success: false,
            message: "Withdrawal is allowed only from 1st to 5th of each month."
        });
    }

    // console.log("withdraw_amount",req.body);
    
    if (!withdraw_wallet_type || !user_wallet_address || !amount) {
        return res.json({ success: false, message: "All fields are required." });
    }
    // new code start here
    pool.query(`SELECT tbl_user_id, profit_amount, wallet_amount FROM tbl_user WHERE tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

            if(withdraw_wallet_type == 'profit'){
               
              var wallet_amount = result.rows[0].profit_amount;
              var update_wallet = `profit_amount = profit_amount - '${amount}'`;
              var update_mt5_wallet = ``;
            }else{
                var wallet_amount = result.rows[0].wallet_amount;
                var update_wallet = `wallet_amount = '0'`;
                var update_mt5_wallet = `UPDATE tbl_mt5_user SET balance ='0' where tbl_user_id = '${tbl_user_id}'`;
                
                if (wallet_amount != amount) {
                    return res.json({
                        success: false,
                        message: 'Withdrawal amount must be exactly equal to your wallet balance. You should withdraw ' + wallet_amount
                    });
                }
            }


            // console.log('wallet_amount', wallet_amount);
            // console.log('amount', amount);
            
            if(Number(wallet_amount) < Number(amount))
            {
                return res.json({ success: false, message: 'Your wallet amount is low for this account you should be withdraw '+wallet_amount });
            }


            const joining_time = moment().utcOffset("+05:30").format('LT');
            const joining_date = moment(date).format("DD MMM YYYY");

            pool.query(`INSERT INTO tbl_withdrawal_amount (tbl_user_id,withdraw_wallet_type,amount,wallet_address,created_date,created_time) VALUES ('${tbl_user_id}','${withdraw_wallet_type}','${amount}','${user_wallet_address}','${joining_date}','${joining_time}'); 
            UPDATE tbl_user SET ${update_wallet} where tbl_user_id = '${tbl_user_id}';${update_mt5_wallet}
            `,
            // pool.query(`INSERT INTO tbl_withdrawal_amount (tbl_user_id,account_id,amount,mt5_number,wallet_address,created_date,created_time) VALUES ('${tbl_user_id}','${login_id}','${amount}','${login_id}','${user_wallet_address}','${joining_date}','${joining_time}'); 
            // UPDATE tbl_user SET wallet_amount = wallet_amount - '${amount}' where tbl_user_id = '${tbl_user_id}';
            // UPDATE tbl_mt5_user SET balance = balance - '${amount}' where tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}';
            // `,

            async (error, result_user) => {
                if (error) {
                    return res.status(403).json({ success: false, message: error })
                }
                if(result_user[0].rowCount > 0)
                {

                   return res.json({ success: true, message: 'Your withdrawal request has been submitted successfully.' })
                }else{
                
                    return res.json({ success: false, message: 'Something error.' });
                }
            })
                    

        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});

app.get('/all_account',   function (req, res) {
    
    res.render('all_account', {
        layout : true,
    });
});

app.get('/withdrawal', auth, function (req, res) {
    
    res.render('withdrawal', {
        layout : true,
    });
});


app.get('/orderSummary', auth, async (req, res)=> {
    var tbl_user_id = req.session.tbl_user_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    
    res.render('orderSummary', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});


app.post("/update_password", auth, async (req, res) => {
    const { old_password, newPassword, confirmPassword } = req.body;

    const tbl_user_id = req.session.tbl_user_id;

    console.log("update_password",req.body);
    
    if (!old_password || !newPassword || !confirmPassword) {
        return res.json({ success: false, message: "All fields are required." });
    }

    // new code start here
    pool.query(`SELECT tbl_user_id,password FROM tbl_user WHERE tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

            if(result.rows[0].password == old_password)
            {   

                        pool.query(`UPDATE tbl_user SET password = $1 where tbl_user_id = $2`,[newPassword,tbl_user_id],
                        async (error, result_user) => {
                            if (error) {
                                return res.status(403).json({ success: false, message: error })
                            }
                            if(result_user.rowCount > 0)
                            {
                                res.json({ success: true, message: 'Password updated successfully.' })
                            }else{
                            
                                return res.json({ success: false, message: 'Something error.' });
                            }
                        })
                    }else{
                        return res.json({ status: false, message: 'You have entered an incorrect old password. Please enter the correct password.'})
                    }

        } else {
            return res.json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});


app.post('/filter_orderSummary', auth, async (req, res) => {
    const { login_id, day_period } = req.body;
    const tbl_user_id = req.session.tbl_user_id;

    // Initialize query and parameters array
    let query = `
        SELECT 
            COUNT(tbl_order_id) AS total_order,
            (SELECT COUNT(tbl_order_id) FROM tbl_order WHERE tbl_user_id = $1 AND login_id = $2 AND order_status = 'closed' {dayfilter}) AS total_closed_order,
            (SELECT COALESCE(SUM(profit_loss_value), 0)  FROM tbl_order WHERE tbl_user_id = $1 AND login_id = $2 AND order_status = 'closed' {dayfilter}) AS net_profit,    
            (SELECT COALESCE(SUM(margin), 0) FROM tbl_order WHERE tbl_user_id = $1 AND login_id = $2 AND order_status = 'closed' {dayfilter}) AS total_trading_amount,   
            (SELECT COALESCE(balance, 0) AS total_equity FROM tbl_mt5_user WHERE tbl_user_id = $1::INTEGER AND login_id = $2::INTEGER)     
        FROM tbl_order 
        WHERE tbl_user_id = $1 
        AND login_id = $2 {dayfilter}`;

    // Parameters array
    let params = [tbl_user_id, login_id];

    // Apply date filter dynamically
    let dayfilter = "";
    if (day_period && day_period !== "") {
        dayfilter = `AND creted_date >= NOW() - INTERVAL '${day_period} days'`;
    }

    // Replace `{dayfilter}` placeholders in the query
    query = query.replace(/{dayfilter}/g, dayfilter);

    try {
        const filter_account_order_data = await pool.query(query, params);
        res.json({ success: true, data: filter_account_order_data.rows });
    } catch (error) {
        console.error("Error fetching filtered data:", error);
        res.status(500).json({ success: false, message: "Database query error" });
    }
});




app.get('/ordersHistory', auth, async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id;
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_order WHERE tbl_user_id = $1`,
        [tbl_user_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const order_list = await pool.query(
        `SELECT * FROM tbl_order WHERE tbl_user_id = $1 ORDER BY tbl_order_id DESC LIMIT $2 OFFSET $3`,
        [tbl_user_id, limit, offset]
    );

    res.render('ordersHistory', {
        layout: true,
        order_list: order_list.rows,
        currentPage: page,
        totalPages: totalPages
    });
});



app.get('/depositHistory', auth, async (req, res) => {
    
    var tbl_user_id = req.session.tbl_user_id;
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_deposit WHERE tbl_user_id = $1`,
        [tbl_user_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const deposit_list = await pool.query(
        `SELECT * FROM tbl_deposit WHERE tbl_user_id = $1 ORDER BY tbl_deposit_id DESC LIMIT $2 OFFSET $3`,
        [tbl_user_id, limit, offset]
    );

    res.render('depositHistory', {
        layout: true,
        deposit_list: deposit_list.rows,
        currentPage: page,
        totalPages: totalPages
    });
});




app.get('/withdrawHistory', auth, async (req, res) => {
    
    var tbl_user_id = req.session.tbl_user_id;
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_withdrawal_amount WHERE tbl_user_id = $1`,
        [tbl_user_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const withdraw_list = await pool.query(
        `SELECT * FROM tbl_withdrawal_amount WHERE tbl_user_id = $1 ORDER BY tbl_withdrawal_amount_id DESC LIMIT $2 OFFSET $3`,
        [tbl_user_id, limit, offset]
    );

    res.render('withdrawHistory', {
        layout: true,
        withdraw_list: withdraw_list.rows,
        currentPage: page,
        totalPages: totalPages
    });
});

app.get('/tradebenifit',  function (req, res) {
    
    res.render('tradebenifit', {
        layout : true,
    });
});


app.get('/help_center', auth, function (req, res) {
    
    res.render('help_center', {
        layout : true,
    });
});

app.get('/profile', auth, async (req, res) => {
    var tbl_user_id = req.session.tbl_user_id;
    const user_details = await pool.query(
        `SELECT * FROM tbl_user WHERE tbl_user_id = $1 AND status ='1'`,
        [tbl_user_id]
    );
    
    res.render('profile', {
        layout : true,
        user_details: user_details.rows,
    });
});



app.post("/update_kyc_step_1", auth, async (req, res) => {
    const { fname, lname, mobile,gender,dob,full_address } = req.body;

    const tbl_user_id = req.session.tbl_user_id;

    console.log("update_kyc_step_1",req.body);
    
    if (!fname || !lname || !mobile || !gender || !dob || !full_address) {
        return res.json({ success: false, message: "All fields are required." });
    }

    // new code start here
    pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

            var update_kyc_step_1 = await pool.query(`UPDATE tbl_user SET fname = $1,lname=$2,mobile=$3,gender=$4,dob=$5,full_address=$6, kyc_step_1 = '1' where tbl_user_id = $7`, [fname,lname,mobile,gender,dob,full_address,tbl_user_id])

            if(update_kyc_step_1.rowCount > 0)
            {
                res.json({ success: true, message: 'submitted successfully.' })
            }else{
                return res.json({ success: false, message: 'Something error.' });
            }
           
                        //const joining_time = moment().utcOffset("+05:30").format('LT');
                        //const joining_date = moment(date).format("DD MMM YYYY");
    
        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});



app.post("/update_kyc_step_2", auth, upload.fields([{ name: "aadhar_image", maxCount: 1 }, { name: "pan_image", maxCount: 1 }]), async (req, res) => {
    const { aadhar_number, pan_number } = req.body;
    const tbl_user_id = req.session.tbl_user_id;

    if (!aadhar_number || !pan_number || !req.files["aadhar_image"] || !req.files["pan_image"]) {
        return res.json({ success: false, message: "All fields are required." });
    }

    let aadhar_image = req.files["aadhar_image"][0].filename;
    let pan_image = req.files["pan_image"][0].filename;

    try {
        const result = await pool.query(`SELECT * FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]);

        if (result.rowCount > 0) {
            const update_kyc_step_2 = await pool.query(
                `UPDATE tbl_user SET aadhar_number = $1, aadhar_image = $2, pan_number = $3, pan_image = $4, kyc_step_2 = '1' WHERE tbl_user_id = $5`,
                [aadhar_number, aadhar_image, pan_number, pan_image, tbl_user_id]
            );

            if (update_kyc_step_2.rowCount > 0) {

                req.session.kyc_step_2 = '1';
                req.session.kyc_step_1 = '1';
                return res.json({ success: true, message: "Submitted successfully." });
            } else {
                return res.json({ success: false, message: "Something went wrong." });
            }
        } else {
            return res.status(201).json({ success: false, message: "This user is not registered. Please log in again." });
        }
    } catch (error) {
        return res.status(403).json({ success: false, message: error.message });
    }
});


app.get('/security', auth, function (req, res) {
    
    res.render('security', {
        layout : true,
    });
});

app.get('/swapfree',  function (req, res) {
    
    res.render('swapfree', {
        layout : true,
    });
});

app.get('/vps',  function (req, res) {
    
    res.render('vps', {
        layout : true,
    });
});

app.get('/emailservices',  function (req, res) {
    
    res.render('email', {
        layout : true,
    });
});

app.get('/new_account',  function (req, res) {
    
    res.render('new_account', {
        layout : true,
    });
});



app.get('/history',  function (req, res) {
  
    res.render('history', {
        layout : true,
    });
});


app.get('/register/:ib_reffral?',  function (req, res) {
    const { ib_reffral } = req.params;
    if(ib_reffral !=undefined)
    {
        var ibreffral = ib_reffral
    }else{
         var ibreffral = 'XTRIB4682'
    }
    res.render('register', {
        layout : false,
        ibreffral : ibreffral
    });
});

app.get('/otp_verify',  function (req, res) {
    res.render('otp_verify', {
        layout : false,
    });
});


app.post("/signup", async (req, res) => {
    const { fname, lname, email, password, firebase_token, dob, mobile,ib_referral } = req.body;

    if (!fname || !lname || !email || !password || !dob || !mobile) {
        return res.json({ success: false, message: "All fields are required." });
    }

    if (ib_referral=='') {
        var login_id = '';
    }else{
        var login_id = ib_referral;
    }

    
    

    try {
        let response = await axios.post(user_apiurl+"/user_data/signup_API", {
            fname,
            lname,
            email,
            password,
            firebase_token,
            dob,
            mobile,
            login_id,
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            req.session.error = response.data.message;
            req.session.email = email;
            res.json({ success: true, message: response.data.message });
           

        } else {
            res.json({ success: false, message: response.data.message || "Registration failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});



app.post("/otp_verify", async (req, res) => {
    const { email_otp } = req.body;
    var email = req.session.email; 
    if (!email_otp) {
        return res.json({ success: false, message: "OTP is required." });
    }

    console.log("email_otp",email_otp);
    console.log("email",email);
    


    try {
        let response = await axios.post(user_apiurl+"/user_data/otp_verify", {
            email_otp,
            email,
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            req.session.error = response.data.message;
            req.session.email = response.data.data[0].email;
            req.session.password = response.data.data[0].password;
            req.session.used_login_id = response.data.data[0].used_login_id;
            req.session.jwt_token = response.data.data[0].jwt_token;
            req.session.tbl_user_id = response.data.data[0].tbl_user_id;
            req.session.fname = response.data.data[0].fname;
            req.session.lname = response.data.data[0].lname;
            req.session.mobile = response.data.data[0].mobile;
            req.session.user_image = response.data.data[0].user_image;
            req.session.user_name = response.data.data[0].user_name;
            res.json({ success: true, message: response.data.message });
           

        } else {
            res.json({ success: false, message: response.data.message || "OTP Verify failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});




app.post("/forgot_password_verify", async (req, res) => {
    const { email } = req.body;

    console.log("forgot_password_verify",req.body);
    
    var tbl_user_id = req.session.tbl_user_id; 
    
        const lowercase_email = email.toLowerCase();
        
                pool.query(`SELECT * FROM tbl_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
        
                    if (error) {
                        
                        return res.json({ status: false, message: error });
                    }
                    var count = result.rowCount;
        
                    console.log("count", count);
                    if (count <= 0) {
        
                        
                        return res.json({ status: false, message: 'This email is not registered with us' });
        
                    } else {

                      var password = result.rows[0].password


        
        
                                // email code start here
        
                                let mailOptions = {
                                    from: '"Xprimetrade"', // sender address
                                    to: lowercase_email, // list of receivers
                                    subject: "Password Details", // Subject line
                                    //text: verification_token, // plain text body
                                    // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                                    html: `<html>
                                                <body>                             
                                                    <p>
                                                        Hi, <br>
                                                        Your CRM account login details are <br> Email: ${email} <br> Password ${password}. <br> Please do not share this with anyone.
                                                    </p>                   
                                                    <p>
                                                        Thanks <br/>
                                                        Customer Support
                                                        Xprimetrade 
                                                    </p>
                                                </body>
                                            </html>`
        
                                };
                                transporter.sendMail(mailOptions, (error, info) => {
                                    if (error) {
                                        return console.log(error);
                                        
                                    } else {
                                         //console.log(info);
                                         res.json({ success: true, message: 'Your password has been sent to your email. ' });
                                    }
                                    // console.log('Message %s sent: %s', info.messageId, info.response);
                                });
        
                                // email code end here
  
        
                           
                    }
                })

});




app.post("/login_verify", async (req, res) => {
    const { email,password } = req.body;
 
    //console.log("login_verify",req.body);
    
    if (!email) {
        return res.json({ success: false, message: "email is required." });
    }

    if (!password) {
        return res.json({ success: false, message: "password is required." });
    }

    var firebase_token ='firebase_token';
    


    try {
        let response = await axios.post(user_apiurl+"/user_data/Login_API", {
            email,
            password,
            firebase_token
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            var check_ib_login = 0;
            var ib_email = 0;
            var ib_password = 0;

            const check_IB_user = await pool.query(
                `SELECT email,password FROM tbl_ib_user where status ='1' AND email =$1`,
                [response.data.data[0].email]
            );

            if(check_IB_user.rowCount > 0)
            {
                check_ib_login = '1';
                ib_email = check_IB_user.rows[0].email;
                ib_password = check_IB_user.rows[0].password;
            }

            req.session.error = response.data.message;
            req.session.email = response.data.data[0].email;
            req.session.password = response.data.data[0].password;
            req.session.used_login_id = response.data.data[0].used_login_id;
            req.session.jwt_token = response.data.data[0].jwt_token;
            req.session.tbl_user_id = response.data.data[0].tbl_user_id;
            req.session.fname = response.data.data[0].fname;
            req.session.lname = response.data.data[0].lname;
            req.session.mobile = response.data.data[0].mobile;
            req.session.user_image = response.data.data[0].user_image;
            req.session.user_name = response.data.data[0].user_name;
            req.session.kyc_step_2 = response.data.data[0].kyc_step_2;
            req.session.kyc_step_1 = response.data.data[0].kyc_step_1;
            req.session.check_ib_login = check_ib_login;
            req.session.ib_email = ib_email;
            req.session.ib_password = ib_password;
            res.json({ success: true, message: response.data.message });
           

        } else {
            res.json({ success: false, message: response.data.message || "Login failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});




app.post("/add_mt5_user", auth, async (req, res) => {
    const { lots, Commission, Leverage, Currency } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 
    

    if (!Leverage) {
        return res.json({ success: false, message: "Leverage are required." });
    }


   // console.log('add_mt5_user', req.body);
    
        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            
            if (count > 0) {
                // Add API code here

                /// generate 6 digit random login id for user

                    var name = result.rows[0].fname + " " +result.rows[0].lname;
                    var email = result.rows[0].email;
                    var password_main = result.rows[0].password;
                    var mobile = result.rows[0].mobile;
                
                    const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                    const random_with_id = random.toString() + tbl_user_id; // Combine random number and user ID
                    const sixDigitRandomWithId = random_with_id.slice(-6); // Take the last 6 digits
                    const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                    const Login_id = zeroPad(sixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                
                /// generate 6 digit random login id for user
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");
                
                pool.query(`INSERT INTO tbl_mt5_user (tbl_user_id,login_id,group_id,balance,registration,name,leverage,email,password_main,phone,agent,country,joining_time,joining_date) VALUES ('${tbl_user_id}','${Login_id}','23','0','0','${name}','${Leverage}','${email}','${password_main}','${mobile}','','India','${joining_time}','${joining_date}')`,
                    async (error, mt5user_user) => {
                    if (error) {
                        return res.json(403).json({ status: false, message: error });
                    }

                    if (mt5user_user.rowCount > 0) {

                        //Email code start Here


                                let mailOptions = {
                                    from: '"Xprimetrade"', // sender address
                                    to: email, // list of receivers
                                    subject: "Trading Account Details", // Subject line
                                    //text: verification_token, // plain text body
                                    html: `<b>Your Trading Accounts Details Are :</b><br/>
                                            <b>Login ID :  ${Login_id} </b><br/>
                                            <b>Login Password :  ${password_main} </b><br/>`
                                };

                                transporter.sendMail(mailOptions, (error, info) => {
                                    if (error) {
                                        return console.log(error);
                                    }
                                 //console.log('Message %s sent: %s', info.messageId, info.response);
                                });

                    /* Email End Here */ 

                        res.json({ success: true, message: 'Your account has been successfully created. The details have been sent to your email address.' });
                    } else {
                        
                        res.json({ success: false, message: 'Something Error' });
                    }
                });    
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});




app.post("/add_IB_user", auth, async (req, res) => {
    const { name, firebase_token, email, password, mobile, login_id } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 


    console.log('add_mt5_user', req.body);
    
        const lowercase_email = email.toLowerCase();
        
                pool.query(`SELECT * FROM tbl_ib_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
        
                    if (error) {
                        
                        return res.json({ status: false, message: error });
                    }
                    var count = result.rowCount;
        
                    console.log("count", count);
                    if (count > 0) {
        
                        return res.json({ status: false, message: 'This email is already registered with us' });
        
                    } else {
        
                        var otpp = Math.floor(100000 + Math.random() * 900000);
                        var ot = Math.floor(100 + Math.random() * 999);
        
                        // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                        const joining_time = moment().utcOffset("+05:30").format('LT');
                        const joining_date = moment(date).format("DD MMM YYYY");
        
        
                        pool.query(`INSERT INTO tbl_ib_user (name,email,email_otp,joining_date,joining_time,password,firebase_token,mobile,sponsor_id) VALUES ('${name}','${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${mobile}','${login_id}') RETURNING tbl_ib_user_id`,
                            async (error, result_user) => {
        
                                if (error) {
                                    return res.json({ status: false, message: error });
                                }
        
                                var newuser_id = result_user.rows[0].tbl_ib_user_id;
                                const token = createToken(result_user.rows[0].tbl_ib_user_id);
                                var my_login_id = 'XTRIB' + ot + newuser_id;
        
        
                                // const Update_my_sponsor_id = await pool.query(`UPDATE tbl_ib_user SET login_id = '${my_login_id}', username = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_ib_user_id = '${newuser_id}';SELECT tbl_ib_user_id,sponsor_id FROM tbl_ib_user where login_id ='${login_id}'`);

                                // new code start here
                                // Step 1: Update new user details
                                const Update_my_sponsor_id = await pool.query(`
                                    UPDATE tbl_ib_user 
                                    SET login_id = '${my_login_id}', 
                                        username = '${my_login_id}', 
                                        jwt_token = '${token}'  
                                    WHERE tbl_ib_user_id = '${newuser_id}';
                                
                                    SELECT tbl_ib_user_id, sponsor_id FROM tbl_ib_user WHERE login_id = '${login_id}';
                                `);
                                
                                let currentSponsorLoginId = my_login_id;
                                let level = 1;

                                // Loop to handle team hierarchy up to 8 levels
                                while (level <= 8 && currentSponsorLoginId) {
                                    
                                    const result = await pool.query(`
                                        SELECT tbl_ib_user_id, sponsor_id 
                                        FROM tbl_ib_user 
                                        WHERE login_id = '${currentSponsorLoginId}'
                                    `);

                                    if (result.rowCount === 0) break;

                                    const { tbl_ib_user_id, sponsor_id } = result.rows[0];

                                    // Insert the new user into the team of each sponsor in the hierarchy

                                    
                                    await pool.query(`
                                        INSERT INTO tbl_ib_team (
                                            tbl_ib_user_id, sponsor_id, team_level, login_id, team_ib_user_id
                                        ) VALUES (
                                            '${tbl_ib_user_id}', '${sponsor_id}', '${level}', '${my_login_id}', '${newuser_id}'
                                        )
                                    `);

                                    currentSponsorLoginId = sponsor_id;
                                    level++;
                                }
                                
                                // Loop to handle team hierarchy up to 5 levels
                                // while (level <= 8 && currentSponsorLoginId) {
                                //     const result = await pool.query(`
                                //     SELECT tbl_ib_user_id, sponsor_id 
                                //     FROM tbl_ib_user 
                                //     WHERE login_id = '${currentSponsorLoginId}'
                                //     `);

                                
                                //     if (result.rowCount === 0) break;
                                
                                //     const { tbl_ib_user_id, sponsor_id } = result.rows[0];
                                
                                //     await pool.query(`
                                //     INSERT INTO tbl_ib_team (
                                //         tbl_ib_user_id, sponsor_id, team_level, login_id, team_ib_user_id
                                //     ) VALUES (
                                //         '${tbl_ib_user_id}', '${sponsor_id}', '${level}', '${my_login_id}', '${newuser_id}'
                                //     )
                                //     `);

                                
                                //     // Set up for next level
                                //     currentSponsorLoginId = sponsor_id;
                                //     level++;
                                // }
  
                                // new code start here
                                
        
        
                                // email code start here
        
                                let mailOptions = {
                                    from: '"Xprimetrade"', // sender address
                                    to: lowercase_email, // list of receivers
                                    subject: "Account Login Details", // Subject line
                                    //text: verification_token, // plain text body
                                    // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                                    html: `<html>
                                                <body>                             
                                                    <p>
                                                        Hi, <br>
                                                        Your IB account login details are <br>Login URL : https://ib.xprimetrade.live/ <br> Email: ${email} <br> Password ${password}. <br> Please do not share this with anyone.
                                                    </p>                   
                                                    <p>
                                                        Thanks <br/>
                                                        Customer Support
                                                        Xprimetrade 
                                                    </p>
                                                </body>
                                            </html>`
        
                                };
                                transporter.sendMail(mailOptions, (error, info) => {
                                    if (error) {
                                        return console.log(error);
                                    } else {
                                         //console.log(info);
                                    }
                                    // console.log('Message %s sent: %s', info.messageId, info.response);
                                });
        
                                // email code end here

                                if(Update_my_sponsor_id[0].rowCount > 0)
                                {
                                    res.json({ success: true, message: 'Your account has been successfully created. The details have been sent to your email address.' });
                                }else{
                                    res.json({ success: false, message: 'Something Error Check Again or login again' });
                                }
        
                            },
                        )
                    }
                })

});



app.get("/add_team_by_login_id", async (req, res) => {
   // const { login_id } = req.body;

    console.log('add_team_by_login_id', req.body);
        
                                let currentSponsorLoginId = '';
                                let my_login_id = '';
                                let newuser_id = '';
                                // for exapmle value 
                                // let currentSponsorLoginId = 'XTRIB96719';
                                // let my_login_id = 'XTRIB72875';
                                // let newuser_id = '75';

                                let level = 1;
                                
                                // Loop to handle team hierarchy up to 5 levels
                                while (level <= 8 && currentSponsorLoginId) {
                                    const result = await pool.query(`
                                    SELECT tbl_ib_user_id, sponsor_id 
                                    FROM tbl_ib_user 
                                    WHERE login_id = '${currentSponsorLoginId}'
                                    `);
                                
                                    if (result.rowCount === 0) break;
                                
                                    const { tbl_ib_user_id, sponsor_id } = result.rows[0];
                                
                                    await pool.query(`
                                    INSERT INTO tbl_ib_team (
                                        tbl_ib_user_id, sponsor_id, team_level, login_id, team_ib_user_id
                                    ) VALUES (
                                        '${tbl_ib_user_id}', '${sponsor_id}', '${level}', '${my_login_id}', '${newuser_id}'
                                    )
                                    `);
                                
                                    // Set up for next level
                                    currentSponsorLoginId = sponsor_id;
                                    level++;
                                }
  
                                // new code start here
                                
                                    res.json({ success: true, message: 'Your account has been successfully created. The details have been sent to your email address.' });         

});



app.post("/create_ticket", auth, async (req, res) => {
    const { title, message } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 
    

    if (!title) {
        return res.json({ success: false, message: "title are required." });
    }

    if (!message) {
        return res.json({ success: false, message: "message are required." });
    }

        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            
            if (count > 0) {
                
                    const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                    const random_with_id = random.toString() + tbl_user_id; // Combine random number and user ID
                    const sixDigitRandomWithId = random_with_id.slice(-8); // Take the last 6 digits
                    const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                    const ticket_number = zeroPad(sixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                
                /// generate 6 digit random login id for user
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");
                
                pool.query(`INSERT INTO tbl_user_ticket (tbl_user_id,ticket_number,title,created_date,created_time) VALUES ('${tbl_user_id}','${ticket_number}',$$${title}$$,'${joining_date}','${joining_time}')`,
                    async (error, ticket_data) => {
                    if (error) {
                        return res.json(403).json({ status: false, message: error });
                    }

                    if (ticket_data.rowCount > 0) {

                      var msg =   'Your ticket has been successfully created! Our team will reach out to you shortly. Your Ticket number is : '+ticket_number

                        const insert_msg_query =  await pool.query(`INSERT INTO tbl_user_ticket_msg(tbl_user_id,ticket_number,message,send_date,send_time,msg_from) VALUES ('${tbl_user_id}','${ticket_number}',$$${message}$$,'${joining_date}','${joining_time}','user'); INSERT INTO tbl_user_notification(notification_type,tbl_user_id,notification_msg,created_date,created_time,title) VALUES('Ticket','${tbl_user_id}','${msg}','${joining_date}','${joining_time}','Your ticket has been successfully created!')`);

                        if(insert_msg_query[0].rowCount > 0)
                        {
                            res.json({ success: true, message: 'Your ticket has been successfully created! Our team will reach out to you shortly. Your Ticket number is : '+ticket_number });
                        }else{
                            res.json({ success: false, message: 'Something wrong try again' });
                        }
                       
                    } else {
                        
                        res.json({ success: false, message: 'Something Error' });
                    }
                });    
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});





app.post("/send_chat", auth, async (req, res) => {
    const { msg, ticketnumber } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 
    

    if (!ticketnumber) {
        return res.json({ success: false, message: "ticketnumber are required." });
    }

    if (!msg) {
        return res.json({ success: false, message: "msg are required." });
    }

        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            if (count > 0) {
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");

                        const insert_msg_query =  await pool.query(`INSERT INTO tbl_user_ticket_msg(tbl_user_id,ticket_number,message,send_date,send_time,msg_from) VALUES ('${tbl_user_id}','${ticketnumber}',$$${msg}$$,'${joining_date}','${joining_time}','user')`);

                        if(insert_msg_query.rowCount > 0)
                        {
                            res.json({ success: true, message: 'Message Send' });
                        }else{
                            res.json({ success: false, message: 'Something wrong try again' });
                        }
                  
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});


app.get("/admin_login/:email/:password", async (req, res) => {
    const { email, password } = req.params;
 
    // console.log("admin_login",req.params);
    
    if (!email) {
        return res.json({ success: false, message: "email is required." });
    }

    if (!password) {
        return res.json({ success: false, message: "password is required." });
    }

    var firebase_token ='firebase_token';
    


    try {
        let response = await axios.post(user_apiurl+"/user_data/Login_API", {
            email,
            password,
            firebase_token
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            var check_ib_login = 0;
            var ib_email = 0;
            var ib_password = 0;

            const check_IB_user = await pool.query(
                `SELECT email,password FROM tbl_ib_user where status ='1' AND email =$1`,
                [response.data.data[0].email]
            );

            if(check_IB_user.rowCount > 0)
            {
                check_ib_login = '1';
                ib_email = check_IB_user.rows[0].email;
                ib_password = check_IB_user.rows[0].password;
            }

            req.session.error = response.data.message;
            req.session.email = response.data.data[0].email;
            req.session.jwt_token = response.data.data[0].jwt_token;
            req.session.tbl_user_id = response.data.data[0].tbl_user_id;
            req.session.fname = response.data.data[0].fname;
            req.session.lname = response.data.data[0].lname;
            req.session.mobile = response.data.data[0].mobile;
            req.session.user_image = response.data.data[0].user_image;
            req.session.user_name = response.data.data[0].user_name;
            req.session.kyc_step_2 = response.data.data[0].kyc_step_2;
            req.session.kyc_step_1 = response.data.data[0].kyc_step_1;
            req.session.check_ib_login = check_ib_login;
            req.session.ib_email = ib_email;
            req.session.ib_password = ib_password;

            res.redirect("/index");

        } else {
           return res.json({ success: false, message: response.data.message || "Login failed." });
        }
    } catch (error) {
       return res.json({ success: false, message: "Error connecting to API." });
    }
});


//  All old code will be deleted after created 


/////////////////////////////////////  👍👍👍👌👌👍👌👌👌👌👌👌👍👌👌👌 /////////////////////////

// app.get('*',  function (req, res) {
//     res.status(404).render('404_page', {
//         pagetitle: ''
//     })
// })

app.listen(PORT);
console.log(`app listening on port ${PORT}`);

