// load the things we need
var express = require('express');
var cookieParser = require('cookie-parser');
var session = require('express-session');
var app = express();
var bodyParser = require('body-parser');
var axios = require('axios');
const expressLayout = require('express-ejs-layouts');
const moment = require('moment');
const path = require('path');
const fs = require('fs');
const pg = require('pg');
const formidable = require('formidable');
const dbConfig = require('./db');
const pool = new pg.Pool(dbConfig);
var user_apiurl = "https://api.xprimetrade.live";
const  img_base_url = "https://api.xprimetrade.live/files/upload";
process.env.TZ = "Asia/Calcutta";
const date = require('date-and-time');
const multer = require("multer");
const nodeMailer = require('nodemailer')

const PORT = 3005;

///////////////////////////// create token function  ///////////////////////

const jwt = require('jsonwebtoken');
const createToken = (id) => {
    return jwt.sign({ id }, 'f954428e07782c67f42d9bb3fa655078', {
        expiresIn: 1000 * 60 * 60 * 24
    })
}
//  const token = createToken(tbl_store_id);               
//  const Update_my_sponsor_id = await pool.query(`UPDATE tbl_store SET  jwt_token ='${token}' WHERE tbl_store_id = '${tbl_store_id}'`);

/////////////////////////////// create token function  ///////////////////////////////

//////////////////////////upload image code ///////////////////////////////////////

const createFolder = (folder) => {
    if (!fs.existsSync(folder)) {
        fs.mkdirSync(folder, { recursive: true });
    }
};

const storage = multer.diskStorage({
    destination: function (req, file, cb) {
        let folderPath = "";
        if (file.fieldname === "aadhar_image") {
            folderPath = "uploads/aadhar_image/";
        } else if (file.fieldname === "pan_image") {
            folderPath = "uploads/pan_image/";
        }

        createFolder(folderPath);
        cb(null, folderPath);
    },
    filename: function (req, file, cb) {
        cb(null, file.fieldname + "_" + Date.now() + path.extname(file.originalname));
    },
});

// Initialize upload middleware
const upload = multer({ storage: storage });

//////////////////////////upload image code ///////////////////////////////////////

// use res.render to load up an ejs view file
app.use(express.static("views"));
app.use('/', express.static(path.join(__dirname, '/public')));
app.use('/:a', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b', express.static(path.join(__dirname, '/public')));
app.use('/:a/:b/:c', express.static(path.join(__dirname, '/public')));

app.use(expressLayout)
app.set('views', path.join(__dirname, 'templates/views'));
app.set("views", path.join(__dirname, "templates", "views"));
app.set('view engine', 'ejs');

// Latest version - v3.0.0
app.use(bodyParser.urlencoded({ extended: false }));
app.use(bodyParser.json({ limit: "150mb" }))

app.use(cookieParser());
app.use(session({ 
    secret: "CRM",
    cookie: { maxAge: 1000 * 60 * 60 * 24 * 7 },
    resave: true,
    saveUninitialized: true
}));

// Mock database for demonstration purposes
let userSessions = {}; // { userId: sessionId }



// Middleware to check if the user is not authenticated
const unauth = function (req, res, next) {
    if (req.session.tbl_user_id && userSessions[req.session.tbl_user_id] === req.session.id) {
        // If the user is authenticated, redirect them to another page (e.g., dashboard)
        res.redirect('/dashboard'); // Change '/dashboard' to whatever page you want to redirect to
    } else {
        // If not authenticated, allow access to the login page
        next();
    }
};


const transporter = nodeMailer.createTransport({
    host: 'smtp.gmail.com',
    port: 587,
    secure: false,
    auth: {
        user: 'aws.addcrypto@gmail.com',
        pass: 'tnafkiklxtbdsopq'
    }
});


app.use(function (req, res, next) {
    var err = req.session.error;
    delete req.session.error;
    res.locals.imgbaseurl = img_base_url;
    res.locals.moment = moment;
    res.locals.super_admin_id = req.session.supadminid;
    res.locals.tbl_ib_user_id = req.session.tbl_ib_user_id;
    res.locals.login_id = req.session.login_id;
    res.locals.ticket_number = req.session.ticket_number;
    res.locals.user_name = req.session.username;
    res.locals.user_email = req.session.email;
    res.locals.user_pageno = req.session.user_list_page_no;
    res.locals.jwt_token = req.session.jwt_token;
    res.locals.fname = req.session.fname;
    res.locals.lname = req.session.lname;
    res.locals.mobile = req.session.mobile;
    res.locals.user_image = req.session.user_image;
    res.locals.user_name = req.session.user_name;
    res.locals.error = err;
    res.locals.bearer = res.locals.jwt_token;
    res.locals.kyc_step_1 = req.session.kyc_step_1;
    res.locals.kyc_step_2 = req.session.kyc_step_2;

    
    next();

   // console.log("req.session",res.locals);

});



const auth = function (req, res, next) {
    //console.log(req);
    //console.log("req.session.tbl_user_id",req.session.tbl_user_id);
    
    if (req.session.tbl_ib_user_id) {
        if(req.session.tbl_ib_user_id){
          next();
        }else{
            // Session ID does not match, log the user out
            req.session.destroy(() => {
                res.redirect('/');
            });
        }
    } else {
        res.redirect('/');
    }
}



app.get('/logout', function (req, res) {
    console.log("logout");
    
    req.session.destroy(function () {
       res.redirect('/');
    });
})


app.get('/',  function (req, res) {
    res.render('login', {
        layout : false,
    });
});

app.get('/login/:email?/:password?', function (req, res) {
    var email = req.params.email || ''; 
    var password = req.params.password || '';

    res.setHeader('Cache-Control', 'no-store');  // Prevent caching
    res.setHeader('Pragma', 'no-cache');         // HTTP 1.0

    res.render('login', {
        layout: false,
        email: email,
        password: password
    });
});


app.get('/forgot_password', unauth, function (req, res) {

    res.render('forgot_password', {
        layout : false,
    });
});

app.get('/index', auth, async (req, res) => {

    var tbl_ib_user_id = req.session.tbl_ib_user_id; 
    var login_id = req.session.login_id; 

    console.log("login_id",login_id);
    

    const wallet_amount =  await pool.query(`SELECT wallet_amount FROM tbl_ib_user where  tbl_ib_user_id = '${tbl_ib_user_id}' `);

    const total_details_query = await pool.query(
        `SELECT count(tbl_user_id) AS total_account,
        (SELECT count(tbl_user_id) FROM tbl_user WHERE wallet_amount > 0 AND used_login_id = $1) AS total_active_account,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_withdrawal_amount 
        FROM tbl_user WHERE status = '1' AND used_login_id = $1`,
        [login_id]
    );


    const wallet_amount_data = wallet_amount.rows;

    res.render('index', {
        layout : true,
        wallet_amount_data: wallet_amount_data,
        total_details_query: total_details_query.rows,
    });
});




app.post("/add_IB_user", auth, async (req, res) => {
    const { name, firebase_token, email, password, mobile, login_id } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 


    console.log('add_IB_user', req.body);
    
        const lowercase_email = email.toLowerCase();
        
                pool.query(`SELECT * FROM tbl_ib_user WHERE  email = '${lowercase_email}'`, async (error, result) => {
        
                    if (error) {
                        
                        return res.json({ status: false, message: error });
                    }
                    var count = result.rowCount;
        
                    console.log("count", count);
                    if (count > 0) {
        
                        return res.json({ status: false, message: 'This email is already registered with us' });
        
                    } else {
        
                        var otpp = Math.floor(100000 + Math.random() * 900000);
                        var ot = Math.floor(100 + Math.random() * 999);
        
                        // var email_otp = `Dear Customers, Your one time Emil Verify OTP is ${otpp}`;
                        const joining_time = moment().utcOffset("+05:30").format('LT');
                        const joining_date = moment(date).format("DD MMM YYYY");
        
        
                        pool.query(`INSERT INTO tbl_ib_user (name,email,email_otp,joining_date,joining_time,password,firebase_token,mobile,sponsor_id) VALUES ('${name}','${lowercase_email}','${otpp}','${joining_date}','${joining_time}','${password}','${firebase_token}','${mobile}','${login_id}') RETURNING tbl_ib_user_id`,
                            async (error, result_user) => {
        
                                if (error) {
                                    return res.json({ status: false, message: error });
                                }
        
                                var newuser_id = result_user.rows[0].tbl_ib_user_id;
                                const token = createToken(result_user.rows[0].tbl_ib_user_id);
                                var my_login_id = 'XTRIB' + ot + newuser_id;
        
        
                                // const Update_my_sponsor_id = await pool.query(`UPDATE tbl_ib_user SET login_id = '${my_login_id}', username = '${my_login_id}', jwt_token ='${token}'  WHERE tbl_ib_user_id = '${newuser_id}';SELECT tbl_ib_user_id,sponsor_id FROM tbl_ib_user where login_id ='${login_id}'`);

                                // new code start here
                                // Step 1: Update new user details
                                const Update_my_sponsor_id = await pool.query(`
                                    UPDATE tbl_ib_user 
                                    SET login_id = '${my_login_id}', 
                                        username = '${my_login_id}', 
                                        jwt_token = '${token}'  
                                    WHERE tbl_ib_user_id = '${newuser_id}';
                                
                                    SELECT tbl_ib_user_id, sponsor_id FROM tbl_ib_user WHERE login_id = '${login_id}';
                                `);
                                
                                let currentSponsorLoginId = login_id;
                                let level = 1;
                                
                                // Loop to handle team hierarchy up to 5 levels
                                while (level <= 5 && currentSponsorLoginId) {
                                    
                                    const result = await pool.query(`
                                    SELECT tbl_ib_user_id, sponsor_id,login_id 
                                    FROM tbl_ib_user 
                                    WHERE login_id = '${currentSponsorLoginId}'
                                    `);
                                
                                    if (result.rowCount === 0) break;
                                
                                    const { tbl_ib_user_id, sponsor_id,login_id } = result.rows[0];
                                
                                    await pool.query(`
                                    INSERT INTO tbl_ib_team (
                                        tbl_ib_user_id, sponsor_id, team_level, login_id, team_ib_user_id
                                    ) VALUES (
                                        '${tbl_ib_user_id}', '${login_id}', '${level}', '${my_login_id}', '${newuser_id}'
                                    )
                                    `);

                                    // Set up for next level
                                    currentSponsorLoginId = sponsor_id;
                                    level++;
                                }
  
                                // new code start here
                                
        
        
                                // email code start here
        
                                let mailOptions = {
                                    from: '"Xprimetrade"', // sender address
                                    to: lowercase_email, // list of receivers
                                    subject: "Account Login Details", // Subject line
                                    //text: verification_token, // plain text body
                                    // html: '<b>Your Login Password is ' + result.rows[0].password + ' </b>'
                                    html: `<html>
                                                <body>
                                                    <p>
                                                        Hi, <br>
                                                        Your IB account login details are <br>Login URL : https://ib.xprimetrade.live/login/ <br> Email: ${email} <br> Password ${password}. <br> Please do not share this with anyone.
                                                    </p>
                                                    <p>
                                                        Thanks <br/>
                                                        Customer Support
                                                        Xprimetrade
                                                    </p> 
                                                </body>
                                            </html>`
        
                                };
                                transporter.sendMail(mailOptions, (error, info) => {
                                    if (error) {
                                        return console.log(error);
                                    } else {
                                         //console.log(info);
                                    }
                                    // console.log('Message %s sent: %s', info.messageId, info.response);
                                });
        
                                // email code end here

                                if(Update_my_sponsor_id[0].rowCount > 0)
                                {
                                    res.json({ success: true, message: 'Your account has been successfully created. The details have been sent to your email address.' });
                                }else{
                                    res.json({ success: false, message: 'Something Error Check Again or login again' });
                                }
        
                            },
                        )
                    }
                })

});





app.get('/new_user_account_list', auth, async (req, res) => {

    console.log("new_user_account_list");
    
    try {
        var tbl_ib_user_id = req.session.tbl_ib_user_id; 
        var login_id = req.session.login_id;

        if (!tbl_ib_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const mt5_account = await pool.query(
            `SELECT tbl_user.*,(SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user where tbl_user_id = tbl_user.tbl_user_id) AS total_trading_account, (SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user where tbl_user_id = tbl_user.tbl_user_id AND balance > 0) AS total_active_account FROM tbl_user WHERE used_login_id = $1 ORDER BY tbl_user_id DESC`,
            [login_id]
        );
        
        res.render('account_section/user_account_list', {
            layout: false, // Ensures only the partial is sent
            mt5_account_data1: mt5_account.rows,
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/user_ticket_list', auth, async (req, res) => {
    try {
        var tbl_ib_user_id = req.session.tbl_ib_user_id; 

        if (!tbl_ib_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        console.log("user_ticket_list",tbl_ib_user_id);
        
        const ticket_list = await pool.query(
            `SELECT * FROM tbl_user_ticket WHERE tbl_user_id = $1 AND user_type ='IB_user' ORDER BY tbl_user_ticket_id DESC`,
            [tbl_ib_user_id]
        );

        res.render('account_section/user_ticket_list', {
            layout: false, // Ensures only the partial is sent
            ticket_list_data: ticket_list.rows,
        });

    } catch (error) {
        console.error("Error fetching Ticket data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/chat/:ticket_number', auth, async (req, res) => {
    const { ticket_number } = req.params;
    try {
        var tbl_ib_user_id = req.session.tbl_ib_user_id; 

        req.session.ticket_number  = ticket_number;

        if (!tbl_ib_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const ticket_msg = await pool.query(
            `SELECT * FROM tbl_user_ticket_msg WHERE tbl_user_id = $1 AND ticket_number =$2 ORDER BY tbl_user_ticket_msg_id ASC`,
            [tbl_ib_user_id,ticket_number]
        );

        res.render('chat', {
            layout: true, // Ensures only the partial is sent
            ticket_msg: ticket_msg.rows,
        });

    } catch (error) {
        console.error("Error fetching Ticket data:", error);
        res.status(500).send("Error loading account data");
    }
});


app.get('/chat_msg', auth, (req, res) => {
    var tbl_user_id = req.session.tbl_user_id;
    let ticket_number = req.query.ticket_number.replace(/\/$/, ""); // Remove trailing slash if exists
    //console.log("ticket_number",ticket_number);
    

    // Now query the database with sanitized ticket_number
    pool.query('SELECT * FROM tbl_user_ticket_msg WHERE ticket_number = $1 order by tbl_user_ticket_msg_id ASC', [ticket_number], (err, result) => {
        if (err) {
            console.error("Database error:", err);
            return res.status(500).send("Error fetching messages.");
        }
        res.render('chat_section/ticket_msg', {
            layout: false,
            ticket_msg: result.rows,
        });
    });
});


// app.get('/deposit', auth,  function (req, res) {
    
//     res.render('deposit', {
//         layout : true,
//     });
// });

app.get('/dashboard', auth,  async (req, res)=> {

    var tbl_ib_user_id = req.session.tbl_ib_user_id; 
    var login_id = req.session.login_id; 

    const dashboard_data = await pool.query(
        `SELECT 
    -- Total user accounts
    COUNT(DISTINCT u.tbl_user_id) AS total_account,

    -- Growth percentage for user accounts
    COALESCE(
        ROUND(
            (COUNT(DISTINCT CASE 
                WHEN DATE_TRUNC('month', u.created_date) = DATE_TRUNC('month', NOW()) 
                THEN u.tbl_user_id 
            END) - COUNT(DISTINCT CASE 
                WHEN DATE_TRUNC('month', u.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                THEN u.tbl_user_id 
            END))::DECIMAL 
            / NULLIF(COUNT(DISTINCT CASE 
                WHEN DATE_TRUNC('month', u.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                THEN u.tbl_user_id 
            END), 0) * 100, 2
        ), 0
    ) AS total_account_growth,

    -- Total trading accounts
    (SELECT COUNT(tbl_mt5_user_id) 
     FROM tbl_mt5_user 
     WHERE status = '1' 
     AND tbl_user_id IN (SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1)
    ) AS total_trading_account,

    -- Growth percentage for trading accounts
    COALESCE(
        ROUND(
            ((SELECT COUNT(tbl_mt5_user_id) 
              FROM tbl_mt5_user 
              WHERE status = '1' 
              AND tbl_user_id IN (SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1) 
              AND DATE_TRUNC('month', created_date) = DATE_TRUNC('month', NOW())
             ) - 
             (SELECT COUNT(tbl_mt5_user_id) 
              FROM tbl_mt5_user 
              WHERE status = '1' 
              AND tbl_user_id IN (SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1) 
              AND DATE_TRUNC('month', created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month')
             ))::DECIMAL
            / NULLIF((SELECT COUNT(tbl_mt5_user_id) 
                      FROM tbl_mt5_user 
                      WHERE status = '1' 
                      AND tbl_user_id IN (SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1) 
                      AND DATE_TRUNC('month', created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month')
                     ), 0) * 100, 2
        ), 0
    ) AS total_trading_account_growth

FROM tbl_user u
WHERE u.used_login_id = $1;
`,
        [login_id]
    );


    const dashboard_data1 = await pool.query(
        `
SELECT 
    -- Total deposit amount
    COALESCE(SUM(d.amount), 0) AS total_deposit_amount,

    -- Growth percentage for deposits
    COALESCE(
        ROUND(
            (
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW()) 
                    THEN d.amount 
                END) 
                - 
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.amount 
                END)
            )::NUMERIC 
            / NULLIF(
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.amount 
                END)::NUMERIC, 0
            ) * 100, 
            2  -- Rounding to 2 decimal places
        )::NUMERIC, 0
    ) AS total_deposit_growth

FROM tbl_deposit d
WHERE d.status = '2' 
AND d.tbl_user_id IN (
    SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1
);
`,
        [login_id]
    );


    const withdraw_amount_data = await pool.query(
        `SELECT 
    -- Total withdraw amount
    COALESCE(SUM(d.amount), 0) AS total_withdraw_amount,

    -- Growth percentage for deposits
    COALESCE(
        ROUND(
            (
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW()) 
                    THEN d.amount 
                END) 
                - 
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.amount 
                END)
            )::NUMERIC 
            / NULLIF(
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.created_date) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.amount 
                END)::NUMERIC, 0
            ) * 100, 
            2  -- Rounding to 2 decimal places
        )::NUMERIC, 0
    ) AS total_withdraw_growth

FROM tbl_withdrawal_amount d
WHERE d.status = '2' 
AND d.tbl_user_id IN (
    SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1)
`,
        [login_id]
    );


    const active_account_query = await pool.query(`select COALESCE(COUNT(tbl_mt5_user_id), 0)  AS total_active_account,(SELECT COALESCE(SUM(wallet_amount), 0)  FROM tbl_user where used_login_id = $1 ) AS total_outstanding_amount FROM tbl_mt5_user where balance > 0 AND tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id = $1) `,
        [login_id]
    );



    const profit_amount_data = await pool.query( `SELECT 
    -- Total withdraw amount
    COALESCE(SUM(d.profit_loss_value), 0) AS total_profit_amount,

    -- Growth percentage for deposits
    COALESCE(
        ROUND(
            (
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW()) 
                    THEN d.profit_loss_value 
                END) 
                - 
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.profit_loss_value 
                END)
            )::NUMERIC 
            / NULLIF(
                SUM(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.profit_loss_value 
                END)::NUMERIC, 0
            ) * 100, 
            2  -- Rounding to 2 decimal places
        )::NUMERIC, 0
    ) AS total_profit_growth

FROM tbl_order d
WHERE d.tbl_user_id IN (
    SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1)`,
        [login_id]
    );



    const trade_query = await pool.query( `SELECT 
    -- Total withdraw amount
    COALESCE(COUNT(d.tbl_order_id), 0) AS total_trade_count,

    -- Growth percentage for deposits
    COALESCE(
        ROUND(
            (
                COUNT(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW()) 
                    THEN d.tbl_order_id 
                END) 
                - 
                COUNT(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.tbl_order_id 
                END)
            )::NUMERIC 
            / NULLIF(
                COUNT(CASE 
                    WHEN DATE_TRUNC('month', d.open_order_datetime) = DATE_TRUNC('month', NOW() - INTERVAL '1 month') 
                    THEN d.tbl_order_id 
                END)::NUMERIC, 0
            ) * 100, 
            2  -- Rounding to 2 decimal places
        )::NUMERIC, 0
    ) AS total_trade_growth

FROM tbl_order d
WHERE d.tbl_user_id IN (
    SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1)`,
            [login_id]
        );


        const top_gainer_query = await pool.query( `SELECT   o.tbl_user_id, 
                            SUM(o.profit_loss_value) AS total_net_profit, 
                            (SELECT fname FROM tbl_user where tbl_user_id =o.tbl_user_id ) AS fname,
                            (SELECT lname FROM tbl_user where tbl_user_id =o.tbl_user_id ) AS lname,
                            (SELECT email FROM tbl_user where tbl_user_id =o.tbl_user_id ) AS email,
                            (SELECT wallet_amount FROM tbl_user where tbl_user_id =o.tbl_user_id ) AS wallet_amount,
                            (SELECT created_date FROM tbl_user where tbl_user_id =o.tbl_user_id ) AS created_date,
                            (SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user where tbl_user_id =o.tbl_user_id ) AS total_account
                        FROM tbl_order o
                        WHERE o.tbl_user_id IN (
                            SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1
                        )  
                        GROUP BY o.tbl_user_id
                        HAVING SUM(o.profit_loss_value) > 0  -- Exclude users with net losses
                        ORDER BY total_net_profit DESC  
                        LIMIT 10`, [login_id]);

                        const chart_order_list = await pool.query(
                            `SELECT 
    TO_CHAR(creted_date, 'Mon') AS month,
    COUNT(*) AS total_trades, 
    SUM(profit_loss_value) AS cumulative_profit_loss
FROM tbl_order 
WHERE tbl_user_id IN (SELECT tbl_user_id FROM tbl_user WHERE used_login_id = $1)
GROUP BY month
ORDER BY MIN(creted_date);
;`, 
                            [login_id]
                        );

  

    const all_dashboard_data = dashboard_data.rows;
    const all_dashboard_data1 = dashboard_data1.rows;
    const all_withdraw_amount_data = withdraw_amount_data.rows;
    const active_account_data = active_account_query.rows;
    const profit_amount_data1 = profit_amount_data.rows;
    const trade_data = trade_query.rows;
    const top_gainer_data = top_gainer_query.rows;
    const chart_order_data = chart_order_list.rows;
    


    res.render('dashboard', {
        layout : true,
        all_dashboard_data: all_dashboard_data,
        all_dashboard_data1: all_dashboard_data1,
        all_withdraw_amount_data: all_withdraw_amount_data,
        active_account_data: active_account_data,
        profit_amount_data: profit_amount_data1,
        trade_data: trade_data,
        top_gainer_data: top_gainer_data,
        chart_order_data: chart_order_data,
    });
});



app.post("/deposit_amount", auth, async (req, res) => {
    const { login_id, remark, deposit_type, currency_type, amount, user_transection_address } = req.body;
    const tbl_user_id = req.session.tbl_user_id;

    console.log("deposit_amount",req.body);
    
    if (!login_id || !deposit_type || !currency_type || !amount || !user_transection_address) {
        return res.json({ success: false, message: "All fields are required." });
    }

    const mt5_number = login_id;

    // new code start here
    pool.query(`SELECT tbl_mt5_user_id,tbl_user_id,login_id FROM tbl_mt5_user WHERE  login_id = '${login_id}' AND tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

                const joining_time = moment().utcOffset("+05:30").format('LT');
                const joining_date = moment(date).format("DD MMM YYYY");

               

                pool.query(`INSERT INTO tbl_deposit (tbl_user_id,deposit_type,currency_type,amount,mt5_number,user_transection_address,created_date,created_time,remark) VALUES ('${tbl_user_id}','${deposit_type}','${currency_type}','${amount}','${mt5_number}','${user_transection_address}','${joining_date}','${joining_time}',$$${remark}$$) RETURNING tbl_deposit_id`,
                async (error, result_user) => {

                    if (error) {
                        return res.status(403).json({ status: false, message: error })
                    }

                    if(result_user.rowCount > 0)
                    {

                        return res.json({ success: true, message: 'Deposit Successfully' });
                    }else{
                       
                        return res.json({ success: false, message:  "Deposit failed." });
                    }
                },
            )
        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});


app.get('/deposit_new', auth,   async (req, res) => {

    var tbl_user_id = req.session.tbl_user_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
        [tbl_user_id]
    );
    
    res.render('deposit_new', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});

// app.get('/PayoutRequest', auth,  async (req, res) => {

//     var tbl_user_id = req.session.tbl_user_id;
//     const mt5_account = await pool.query(
//         `SELECT (SELECT wallet_amount FROM tbl_user where  tbl_user_id = '${tbl_user_id}' ) AS wallet_amount, tbl_mt5_user.login_id,tbl_mt5_user.balance FROM tbl_mt5_user WHERE tbl_mt5_user.status = '1' AND tbl_mt5_user.tbl_user_id = $1 ORDER BY tbl_mt5_user.tbl_mt5_user_id DESC`,
//         [tbl_user_id]
//     );
    
//     res.render('PayoutRequest', {
//         layout : true,
//         mt5_account_data: mt5_account.rows,
//     });
// });



// app.get('/PayoutRequest', auth, async (req, res) => {
//     var tbl_user_id = req.session.tbl_user_id;
//     const mt5_account = await pool.query(
//         `SELECT (SELECT wallet_amount FROM tbl_user WHERE tbl_user_id = $1) AS wallet_amount, 
//         tbl_mt5_user.login_id, tbl_mt5_user.balance 
//         FROM tbl_mt5_user 
//         WHERE tbl_mt5_user.status = '1' AND tbl_mt5_user.tbl_user_id = $1 
//         ORDER BY tbl_mt5_user.tbl_mt5_user_id DESC`,
//         [tbl_user_id]
//     );

//     // Default values if no records are found
//     let mt5_account_data = mt5_account.rows.length > 0 ? mt5_account.rows : [{ wallet_amount: 0, login_id: null, balance: 0 }];

//     res.render('PayoutRequest', {
//         layout: true,
//         mt5_account_data
//     });
// });


app.post("/withdraw_amount", auth, async (req, res) => {
    const { login_id, amount, user_wallet_address } = req.body;

    const tbl_user_id = req.session.tbl_user_id;

    console.log("withdraw_amount",req.body);
    
    if (!login_id || !user_wallet_address || !amount) {
        return res.json({ success: false, message: "All fields are required." });
    }

    const mt5_number = login_id;

    // new code start here
    pool.query(`SELECT tbl_mt5_user_id,tbl_user_id,login_id,balance FROM tbl_mt5_user WHERE  login_id = '${login_id}' AND tbl_user_id ='${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {
            var wallet_amount = result.rows[0].balance;

            if(wallet_amount<=amount)
            {
                return res.json({ success: false, message: 'Your wallet amount is low for this account you should be withdraw '+wallet_amount });
            }


                        const joining_time = moment().utcOffset("+05:30").format('LT');
                        const joining_date = moment(date).format("DD MMM YYYY");
    
                        pool.query(`INSERT INTO tbl_withdrawal_amount (tbl_user_id,account_id,amount,mt5_number,wallet_address,created_date,created_time) VALUES ('${tbl_user_id}','${login_id}','${amount}','${login_id}','${user_wallet_address}','${joining_date}','${joining_time}'); 
                        UPDATE tbl_user SET wallet_amount = wallet_amount - '${amount}' where tbl_user_id = '${tbl_user_id}';
                        UPDATE tbl_mt5_user SET balance = balance - '${amount}' where tbl_user_id = '${tbl_user_id}' AND login_id = '${login_id}';
                        `,
                        async (error, result_user) => {
                            if (error) {
                                return res.status(403).json({ success: false, message: error })
                            }
                            if(result_user[0].rowCount > 0)
                            {
                                res.json({ success: true, message: 'Your withdrawal request has been submitted successfully.' })
                            }else{
                            
                                return res.json({ success: false, message: 'Something error.' });
                            }
                        })
                    

        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});

app.get('/user_account_list', auth, async (req, res) => {
    try {
        var tbl_user_id = req.session.tbl_user_id; 

        if (!tbl_user_id) {
            return res.status(400).send("User ID not found in session");
        }

        const mt5_account = await pool.query(
            `SELECT * FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
            [tbl_user_id]
        );

        res.render('account_section/user_account_list', {
            layout: false, // Ensures only the partial is sent
            mt5_account_data1: mt5_account.rows,
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }
});


app.get('/all_account/:login_id', auth,  async function (req, res) {

    console.log("all_account");
    

    const { login_id } = req.params;

    try {
        var tbl_user_id = req.session.tbl_user_id; 

        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        const mt5_account = await pool.query(
            `SELECT * FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
            [login_id]
        );

        const total_details_query = await pool.query(
            `SELECT count(tbl_mt5_user_id) AS total_account,(SELECT count(tbl_mt5_user_id) FROM tbl_mt5_user WHERE balance > 0 AND tbl_user_id = $1) AS total_active_account,(SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE  tbl_user_id = $1 AND status ='2') AS total_deposit_amount, (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id = $1 AND status ='2') AS total_withdrawal_amount,(SELECT email FROM tbl_user where tbl_user_id = $1) AS user_email FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1`,
            [login_id]
        );
        
        res.render('all_account', {
            layout: true, // Ensures only the partial is sent
            mt5_account_data1: mt5_account.rows,
            total_details_query: total_details_query.rows,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }

});


app.get('/user_all_active_account/:login_id', auth,  async function (req, res) {

    console.log("user_all_active_account");
    

    const { login_id } = req.params;

    try {
        var tbl_user_id = req.session.tbl_user_id; 

        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        const mt5_account = await pool.query(
            `SELECT * FROM tbl_mt5_user WHERE status = '1' AND balance > 0 AND tbl_user_id = $1 ORDER BY tbl_mt5_user_id DESC`,
            [login_id]
        );

        const total_details_query = await pool.query(
            `SELECT count(tbl_mt5_user_id) AS total_account,(SELECT count(tbl_mt5_user_id) FROM tbl_mt5_user WHERE balance > 0 AND tbl_user_id = $1) AS total_active_account,(SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE  tbl_user_id = $1 AND status ='2') AS total_deposit_amount, (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id = $1 AND status ='2') AS total_withdrawal_amount,(SELECT email FROM tbl_user where tbl_user_id = $1) AS user_email FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1`,
            [login_id]
        );
        
        res.render('user_all_active_account', {
            layout: true, // Ensures only the partial is sent
            mt5_account_data1: mt5_account.rows,
            total_details_query: total_details_query.rows,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }

});


app.get('/user_all_deposit_list/:login_id', auth,  async function (req, res) {

    console.log("user_all_deposit_list");
    

    const { login_id } = req.params;

    try {
        
        var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
        var limit = 10; // Number of records per page
        var offset = (page - 1) * limit;

        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        const totalCountResult = await pool.query(
            `
            SELECT COUNT(*) FROM tbl_deposit WHERE tbl_user_id =$1`,[login_id]
        );
        var totalCount = parseInt(totalCountResult.rows[0].count);
        var totalPages = Math.ceil(totalCount / limit);
    
        // Fetch paginated data
        const deposit_list = await pool.query(
            `SELECT * FROM tbl_deposit WHERE tbl_user_id =$1 ORDER BY tbl_deposit_id DESC LIMIT $2 OFFSET $3`,
            [login_id, limit, offset]
        );

        const total_details_query = await pool.query(
            `SELECT count(tbl_mt5_user_id) AS total_account,(SELECT count(tbl_mt5_user_id) FROM tbl_mt5_user WHERE balance > 0 AND tbl_user_id = $1) AS total_active_account,(SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE  tbl_user_id = $1 AND status ='2') AS total_deposit_amount, (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id = $1 AND status ='2') AS total_withdrawal_amount,(SELECT email FROM tbl_user where tbl_user_id = $1) AS user_email FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1`,
            [login_id]
        );
        
        res.render('user_all_deposit_list', {
            layout: true, // Ensures only the partial is sent
            total_details_query: total_details_query.rows,
            deposit_list: deposit_list.rows,
            currentPage: page,
            totalPages: totalPages,
            login_id:login_id
        });

    } catch (error) {
        console.error("Error fetching MT5 account data:", error);
        res.status(500).send("Error loading account data");
    }

});



app.get('/all_active_account', auth,  async function (req, res) {

    console.log("all_active_account");
    

    var tbl_ib_user_id = req.session.tbl_ib_user_id; 
    var login_id = req.session.login_id; 

    const mt5_account = await pool.query(
        `SELECT tbl_user.*,(SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user where tbl_user_id = tbl_user.tbl_user_id) AS total_trading_account,
(SELECT COUNT(tbl_mt5_user_id) FROM tbl_mt5_user where tbl_user_id = tbl_user.tbl_user_id AND balance > 0) AS total_active_account 
FROM tbl_user WHERE used_login_id = $1 AND wallet_amount > 0 ORDER BY tbl_user_id DESC`,
        [login_id]
    );

    const total_details_query = await pool.query(
        `SELECT count(tbl_user_id) AS total_account,
        (SELECT count(tbl_user_id) FROM tbl_user WHERE wallet_amount > 0 AND used_login_id = $1) AS total_active_account,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_withdrawal_amount 
        FROM tbl_user WHERE status = '1' AND used_login_id = $1`,
        [login_id]
    );
    
    res.render('all_active_account', {
        layout : true,
        mt5_account_data1: mt5_account.rows,
        total_details_query: total_details_query.rows,
    });

});



app.get('/all_deposit_list', auth,  async function (req, res) {

    console.log("all_deposit_list");
    

    var login_id = req.session.login_id; 
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    const totalCountResult = await pool.query(
        `
        SELECT COUNT(*) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1)
        `,
        [login_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const deposit_list = await pool.query(
        `SELECT * FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_deposit_id DESC LIMIT $2 OFFSET $3`,
        [login_id, limit, offset]
    );

    const total_details_query = await pool.query(
        `SELECT count(tbl_user_id) AS total_account,
        (SELECT count(tbl_user_id) FROM tbl_user WHERE wallet_amount > 0 AND used_login_id = $1) AS total_active_account,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_withdrawal_amount 
        FROM tbl_user WHERE status = '1' AND used_login_id = $1`,
        [login_id]
    );
    
    res.render('all_deposit_list', {
        layout : true,
        total_details_query: total_details_query.rows,
        deposit_list: deposit_list.rows,
        currentPage: page,
        totalPages: totalPages
    });

});



app.get('/all_withdraw_list', auth,  async function (req, res) {

    console.log("all_withdraw_list");
    

    var login_id = req.session.login_id; 
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_withdrawal_amount WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1)`,
        [login_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const withdraw_list = await pool.query(
        `SELECT * FROM tbl_withdrawal_amount WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_withdrawal_amount_id DESC LIMIT $2 OFFSET $3`,
        [login_id, limit, offset]
    );

    const total_details_query = await pool.query(
        `SELECT count(tbl_user_id) AS total_account,
        (SELECT count(tbl_user_id) FROM tbl_user WHERE wallet_amount > 0 AND used_login_id = $1) AS total_active_account,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id IN(SELECT tbl_user_id FROM tbl_user WHERE  used_login_id = $1) AND status ='2') AS total_withdrawal_amount 
        FROM tbl_user WHERE status = '1' AND used_login_id = $1`,
        [login_id]
    );
    
    res.render('all_withdraw_list', {
        layout : true,
        total_details_query: total_details_query.rows,
        withdraw_list: withdraw_list.rows,
        currentPage: page,
        totalPages: totalPages
    });

});


app.get('/account_wise_all_withdraw_list/:login_id', auth,  async function (req, res) {

    console.log("account_wise_all_withdraw_list");
    

    const { login_id } = req.params;
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_withdrawal_amount WHERE tbl_user_id =$1`,
        [login_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const withdraw_list = await pool.query(
        `SELECT * FROM tbl_withdrawal_amount WHERE tbl_user_id =$1 ORDER BY tbl_withdrawal_amount_id DESC LIMIT $2 OFFSET $3`,
        [login_id, limit, offset]
    );

    const total_details_query = await pool.query(
        `SELECT count(tbl_mt5_user_id) AS total_account,(SELECT count(tbl_mt5_user_id) FROM tbl_mt5_user WHERE balance > 0 AND tbl_user_id = $1) AS total_active_account,(SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE  tbl_user_id = $1 AND status ='2') AS total_deposit_amount, (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE  tbl_user_id = $1 AND status ='2') AS total_withdrawal_amount,(SELECT email FROM tbl_user where tbl_user_id = $1) AS user_email FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id = $1`,
        [login_id]
    );
    
    res.render('account_wise_all_withdraw_list', {
        layout : true,
        total_details_query: total_details_query.rows,
        withdraw_list: withdraw_list.rows,
        login_id:login_id,
        currentPage: page,
        totalPages: totalPages
    });

});



app.get('/total_trade_by_login_id/:user_login_id', auth,  async function (req, res) {

    console.log("total_trade_by_login_id");
    const { user_login_id } = req.params;
    const login_id = user_login_id;
    
    //var login_id = user_login_id; 
    console.log("login_id",login_id);
    
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_order WHERE login_id ='${login_id}'`
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const order_list = await pool.query(
        `SELECT * FROM tbl_order WHERE login_id ='${login_id}' ORDER BY tbl_order_id DESC LIMIT '${limit}' OFFSET '${offset}'`
    );

    
    const total_details_query = await pool.query(
        `SELECT count(tbl_order_id) AS total_trade,
        (SELECT count(tbl_order_id) FROM tbl_order WHERE login_id  = '${login_id}' AND order_status ='open') AS total_open_trade,
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order WHERE login_id =  '${login_id}') AS profit_loss_value,
        (SELECT COALESCE(SUM(balance), 0) FROM tbl_mt5_user WHERE login_id = '${login_id}') AS total_outstanding_balance,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE mt5_number = '${login_id}' AND status='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE mt5_number = '${login_id}' AND status='2') AS total_withdrawal_amount
        FROM tbl_order WHERE login_id = '${login_id}'`
    );
    
    res.render('total_trade_by_login_id', {
        layout : true,
        total_details_query: total_details_query.rows,
        order_list: order_list.rows,
        currentPage: page,
        totalPages: totalPages,
        login_id: login_id
    });

});


app.get('/total_open_trade_by_login_id/:user_login_id', auth,  async function (req, res) {

    console.log("total_trade_by_login_id");
    const { user_login_id } = req.params;
    const login_id = user_login_id;
    
    //var login_id = user_login_id; 
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_order WHERE login_id ='${login_id}' AND order_status ='open'`
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const order_list = await pool.query(
        `SELECT * FROM tbl_order WHERE login_id ='${login_id}' AND order_status ='open' ORDER BY tbl_order_id DESC LIMIT '${limit}' OFFSET '${offset}'`
    );

    
    const total_details_query = await pool.query(
        `SELECT count(tbl_order_id) AS total_trade,
        (SELECT count(tbl_order_id) FROM tbl_order WHERE login_id  = '${login_id}' AND order_status ='open') AS total_open_trade,
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order WHERE login_id =  '${login_id}') AS profit_loss_value,
        (SELECT COALESCE(SUM(balance), 0) FROM tbl_mt5_user WHERE login_id = '${login_id}') AS total_outstanding_balance,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE mt5_number = '${login_id}' AND status='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE mt5_number = '${login_id}' AND status='2') AS total_withdrawal_amount
        FROM tbl_order WHERE login_id = '${login_id}'`
    );
    
    res.render('total_open_trade_by_login_id', {
        layout : true,
        total_details_query: total_details_query.rows,
        order_list: order_list.rows,
        currentPage: page,
        totalPages: totalPages,
        login_id: login_id
    });

});


app.get('/deposit_by_login_id/:user_login_id', auth,  async function (req, res) {

    console.log("total_trade_by_login_id");
    const { user_login_id } = req.params;
    const login_id = user_login_id;
    
    
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    if (!login_id) {
        return res.status(400).send("User ID not found in session");
    }

    const totalCountResult = await pool.query(
        `
        SELECT COUNT(*) FROM tbl_deposit WHERE mt5_number ='${login_id}'`
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const deposit_list = await pool.query(
        `SELECT * FROM tbl_deposit WHERE mt5_number ='${login_id}' ORDER BY tbl_deposit_id DESC LIMIT '${limit}' OFFSET '${offset}'`
    );


    
    const total_details_query = await pool.query(
        `SELECT count(tbl_order_id) AS total_trade,
        (SELECT count(tbl_order_id) FROM tbl_order WHERE login_id  = '${login_id}' AND order_status ='open') AS total_open_trade,
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order WHERE login_id =  '${login_id}') AS profit_loss_value,
        (SELECT COALESCE(SUM(balance), 0) FROM tbl_mt5_user WHERE login_id = '${login_id}') AS total_outstanding_balance,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE mt5_number = '${login_id}' AND status='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE mt5_number = '${login_id}' AND status='2') AS total_withdrawal_amount
        FROM tbl_order WHERE login_id = '${login_id}'`
    );
    
    res.render('deposit_by_login_id', {
        layout : true,
        total_details_query: total_details_query.rows,
        deposit_list: deposit_list.rows,
        currentPage: page,
        totalPages: totalPages,
        login_id: login_id
    });

});



app.get('/withdraw_list_by_login_id/:user_login_id', auth,  async function (req, res) {

    console.log("withdraw_list_by_login_id");
    const { user_login_id } = req.params;
    const login_id = user_login_id;
    
    //var login_id = user_login_id; 
    console.log("login_id",login_id);
    
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_withdrawal_amount WHERE account_id = '${login_id}'`
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const withdraw_list = await pool.query(
        `SELECT * FROM tbl_withdrawal_amount WHERE account_id = '${login_id}' ORDER BY tbl_withdrawal_amount_id DESC LIMIT '${limit}' OFFSET '${offset}'`
    );

    
    const total_details_query = await pool.query(
        `SELECT count(tbl_order_id) AS total_trade,
        (SELECT count(tbl_order_id) FROM tbl_order WHERE login_id  = '${login_id}' AND order_status ='open') AS total_open_trade,
        (SELECT COALESCE(SUM(profit_loss_value), 0) FROM tbl_order WHERE login_id =  '${login_id}') AS profit_loss_value,
        (SELECT COALESCE(SUM(balance), 0) FROM tbl_mt5_user WHERE login_id = '${login_id}') AS total_outstanding_balance,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_deposit WHERE mt5_number = '${login_id}' AND status='2') AS total_deposit_amount,
        (SELECT COALESCE(SUM(amount), 0) FROM tbl_withdrawal_amount WHERE mt5_number = '${login_id}' AND status='2') AS total_withdrawal_amount
        FROM tbl_order WHERE login_id = '${login_id}'`
    );
    
    res.render('withdraw_list_by_login_id', {
        layout : true,
        total_details_query: total_details_query.rows,
        withdraw_list: withdraw_list.rows,
        currentPage: page,
        totalPages: totalPages,
        login_id: login_id
    });

});


app.get('/withdrawal', auth, function (req, res) {
    
    res.render('withdrawal', {
        layout : true,
    });
});


app.get('/orderSummary', auth, async (req, res)=> {
    var login_id = req.session.login_id;

    const mt5_account = await pool.query(
        `SELECT login_id FROM tbl_mt5_user WHERE status = '1' AND tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_mt5_user_id DESC`,
        [login_id]
    );
    
    res.render('orderSummary', {
        layout : true,
        mt5_account_data: mt5_account.rows,
    });
});


app.post("/update_password", auth, async (req, res) => {
    const { old_password, newPassword, confirmPassword } = req.body;

    const tbl_ib_user_id = req.session.tbl_ib_user_id;

    console.log("update_password",req.body);
    
    if (!old_password || !newPassword || !confirmPassword) {
        return res.json({ success: false, message: "All fields are required." });
    }

    // new code start here
    pool.query(`SELECT tbl_ib_user_id,password FROM tbl_ib_user WHERE tbl_ib_user_id ='${tbl_ib_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

            if(result.rows[0].password == old_password)
            {   

                        pool.query(`UPDATE tbl_ib_user SET password = $1 where tbl_ib_user_id = $2`,[newPassword,tbl_ib_user_id],
                        async (error, result_user) => {
                            if (error) {
                                return res.status(403).json({ success: false, message: error })
                            }
                            if(result_user.rowCount > 0)
                            {
                                res.json({ success: true, message: 'Password updated successfully.' })
                            }else{
                            
                                return res.json({ success: false, message: 'Something error.' });
                            }
                        })
                    }else{
                        return res.json({ status: false, message: 'You have entered an incorrect old password. Please enter the correct password.'})
                    }

        } else {
            return res.json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});


app.post('/filter_orderSummary', auth, async (req, res) => {
    const { login_id, day_period } = req.body;
    const tbl_user_id = req.session.tbl_user_id;

    // Initialize query and parameters array
    let query = `
        SELECT 
            COUNT(tbl_order_id) AS total_order,
            (SELECT COUNT(tbl_order_id) FROM tbl_order WHERE login_id = $1 AND order_status = 'closed' {dayfilter}) AS total_closed_order,
            (SELECT COALESCE(SUM(profit_loss_value), 0)  FROM tbl_order WHERE login_id = $1 AND order_status = 'closed' {dayfilter}) AS net_profit,    
            (SELECT COALESCE(SUM(margin), 0) FROM tbl_order WHERE login_id = $1 AND order_status = 'closed' {dayfilter}) AS total_trading_amount,   
            (SELECT COALESCE(balance, 0) AS total_equity FROM tbl_mt5_user WHERE  login_id = $1::INTEGER)     
        FROM tbl_order 
        WHERE login_id = $1 {dayfilter}`;
    
    // Parameters array
    let params = [login_id];

    // Apply date filter dynamically
    let dayfilter = "";
    if (day_period && day_period !== "") {
        dayfilter = `AND creted_date >= NOW() - INTERVAL '${day_period} days'`;
    }

    // Replace `{dayfilter}` placeholders in the query
    query = query.replace(/{dayfilter}/g, dayfilter);

    try {
        const filter_account_order_data = await pool.query(query, params);
        res.json({ success: true, data: filter_account_order_data.rows });
    } catch (error) {
        console.error("Error fetching filtered data:", error);
        res.status(500).json({ success: false, message: "Database query error" });
    }
});




app.get('/ordersHistory', auth, async (req, res) => {

    var login_id = req.session.login_id;
    var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
    var limit = 10; // Number of records per page
    var offset = (page - 1) * limit;

    // Fetch total count
    const totalCountResult = await pool.query(
        `SELECT COUNT(*) FROM tbl_order WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1)`,
        [login_id]
    );
    var totalCount = parseInt(totalCountResult.rows[0].count);
    var totalPages = Math.ceil(totalCount / limit);

    // Fetch paginated data
    const order_list = await pool.query(
        `SELECT * FROM tbl_order WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_order_id DESC LIMIT $2 OFFSET $3`,
        [login_id, limit, offset]
    );

    res.render('ordersHistory', {
        layout: true,
        order_list: order_list.rows,
        currentPage: page,
        totalPages: totalPages
    });
});



// app.get('/depositHistory', auth, async (req, res) => {
    
//     var login_id = req.session.login_id;
//     var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
//     var limit = 10; // Number of records per page
//     var offset = (page - 1) * limit;

//     // Fetch total count
//     const totalCountResult = await pool.query(
//         `
//         SELECT COUNT(*) FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1)
//         `,
//         [login_id]
//     );
//     var totalCount = parseInt(totalCountResult.rows[0].count);
//     var totalPages = Math.ceil(totalCount / limit);

//     // Fetch paginated data
//     const deposit_list = await pool.query(
//         `SELECT * FROM tbl_deposit WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_deposit_id DESC LIMIT $2 OFFSET $3`,
//         [login_id, limit, offset]
//     );

//     res.render('depositHistory', {
//         layout: true,
//         deposit_list: deposit_list.rows,
//         currentPage: page,
//         totalPages: totalPages
//     });
// });




// app.get('/withdrawHistory', auth, async (req, res) => {
    
//     var login_id = req.session.login_id;
//     var page = parseInt(req.query.page) || 1; // Get page number from query, default to 1
//     var limit = 10; // Number of records per page
//     var offset = (page - 1) * limit;

//     // Fetch total count
//     const totalCountResult = await pool.query(
//         `SELECT COUNT(*) FROM tbl_withdrawal_amount WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1)`,
//         [login_id]
//     );
//     var totalCount = parseInt(totalCountResult.rows[0].count);
//     var totalPages = Math.ceil(totalCount / limit);

//     // Fetch paginated data
//     const withdraw_list = await pool.query(
//         `SELECT * FROM tbl_withdrawal_amount WHERE tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =$1) ORDER BY tbl_withdrawal_amount_id DESC LIMIT $2 OFFSET $3`,
//         [login_id, limit, offset]
//     );

//     res.render('withdrawHistory', {
//         layout: true,
//         withdraw_list: withdraw_list.rows,
//         currentPage: page,
//         totalPages: totalPages
//     });
// });

app.get('/tradebenifit',  function (req, res) {
    
    res.render('tradebenifit', {
        layout : true,
    });
});


app.get('/help_center', auth, function (req, res) {
    
    res.render('help_center', {
        layout : true,
    });
});

app.get('/profile', auth, async (req, res) => {
    var tbl_ib_user_id = req.session.tbl_ib_user_id;
    const user_details = await pool.query(
        `SELECT * FROM tbl_ib_user WHERE tbl_ib_user_id = $1 AND status ='1'`,
        [tbl_ib_user_id]
    );
    
    res.render('profile', {
        layout : true,
        user_details: user_details.rows,
    });
});



app.get('/edit_profile', auth, async (req, res) => {
    var tbl_ib_user_id = req.session.tbl_ib_user_id;
    const user_details = await pool.query(
        `SELECT * FROM tbl_ib_user WHERE tbl_ib_user_id = $1 AND status ='1'`,
        [tbl_ib_user_id]
    );
    
    res.render('edit_profile', {
        layout : true,
        user_details: user_details.rows,
    });
});



app.get('/IBprofile', auth, async (req, res) => {
    var tbl_ib_user_id = req.session.tbl_ib_user_id;
    var login_id = req.session.login_id;
    
    const user_details = await pool.query(
        `SELECT tbl_ib_user.*,
(SELECT COUNT(tbl_user_id) FROM tbl_user where used_login_id =tbl_ib_user.login_id ) AS total_team, 
(SELECT count(tbl_mt5_user_id) FROM tbl_mt5_user WHERE 
tbl_user_id IN(SELECT tbl_user_id FROM tbl_user where used_login_id =tbl_ib_user.login_id)) AS total_trading_account
FROM tbl_ib_user WHERE tbl_ib_user.tbl_ib_user_id = $1 AND tbl_ib_user.status ='1'`,
        [tbl_ib_user_id]
    );

    const mt5_account = await pool.query(
        `SELECT * FROM tbl_user WHERE used_login_id = $1 ORDER BY tbl_user_id DESC`,
        [login_id]
    );
    
    res.render('IBprofile', {
        layout : true,
        user_details: user_details.rows,
        mt5_account_data1: mt5_account.rows,
    });
});



app.post("/update_kyc_step_1", auth, async (req, res) => {
    const { fname, lname, mobile,gender,dob,full_address } = req.body;

    const tbl_user_id = req.session.tbl_user_id;

    console.log("update_kyc_step_1",req.body);
    
    if (!fname || !lname || !mobile || !gender || !dob || !full_address) {
        return res.json({ success: false, message: "All fields are required." });
    }

    // new code start here
    pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {

        if (error) {
            return res.status(403).json({ status: false, message: error })
        }
        var count = result.rowCount;

        if (count > 0) {

            var update_kyc_step_1 = await pool.query(`UPDATE tbl_user SET fname = $1,lname=$2,mobile=$3,gender=$4,dob=$5,full_address=$6, kyc_step_1 = '1' where tbl_user_id = $7`, [fname,lname,mobile,gender,dob,full_address,tbl_user_id])

            if(update_kyc_step_1.rowCount > 0)
            {
                res.json({ success: true, message: 'submitted successfully.' })
            }else{
                return res.json({ success: false, message: 'Something error.' });
            }
           
                        //const joining_time = moment().utcOffset("+05:30").format('LT');
                        //const joining_date = moment(date).format("DD MMM YYYY");
    
        } else {
            response.status(201).json({ status: false, message: 'This user id is not register with us OR Login again.'})
        }
    }) 
    // new code end here 
});



app.post("/update_kyc_step_2", auth, upload.fields([{ name: "aadhar_image", maxCount: 1 }, { name: "pan_image", maxCount: 1 }]), async (req, res) => {
    const { aadhar_number, pan_number } = req.body;
    const tbl_user_id = req.session.tbl_user_id;

    if (!aadhar_number || !pan_number || !req.files["aadhar_image"] || !req.files["pan_image"]) {
        return res.json({ success: false, message: "All fields are required." });
    }

    let aadhar_image = req.files["aadhar_image"][0].filename;
    let pan_image = req.files["pan_image"][0].filename;

    try {
        const result = await pool.query(`SELECT * FROM tbl_user WHERE tbl_user_id = $1`, [tbl_user_id]);

        if (result.rowCount > 0) {
            const update_kyc_step_2 = await pool.query(
                `UPDATE tbl_user SET aadhar_number = $1, aadhar_image = $2, pan_number = $3, pan_image = $4, kyc_step_2 = '1' WHERE tbl_user_id = $5`,
                [aadhar_number, aadhar_image, pan_number, pan_image, tbl_user_id]
            );

            if (update_kyc_step_2.rowCount > 0) {
                return res.json({ success: true, message: "Submitted successfully." });
            } else {
                return res.json({ success: false, message: "Something went wrong." });
            }
        } else {
            return res.status(201).json({ success: false, message: "This user is not registered. Please log in again." });
        }
    } catch (error) {
        return res.status(403).json({ success: false, message: error.message });
    }
});


app.get('/security', auth, function (req, res) {
    
    res.render('security', {
        layout : true,
    });
});

app.get('/swapfree',  function (req, res) {
    
    res.render('swapfree', {
        layout : true,
    });
});

app.get('/vps',  function (req, res) {
    
    res.render('vps', {
        layout : true,
    });
});

app.get('/emailservices',  function (req, res) {
    
    res.render('email', {
        layout : true,
    });
});

app.get('/new_account',  function (req, res) {
    
    res.render('new_account', {
        layout : true,
    });
});



app.get('/history',  function (req, res) {
  
    res.render('history', {
        layout : true,
    });
});



app.get('/register/:ib_reffral?',  function (req, res) {
    const { ib_reffral } = req.params;
    

    if(ib_reffral !=undefined)
    {
        var ibreffral = ib_reffral
    }else{
         var ibreffral = 'XTRIB4682'
    }
    res.render('register', {
        layout : false,
        ibreffral : ibreffral
    });
});


app.get('/otp_verify',  function (req, res) {
    res.render('otp_verify', {
        layout : false,
    });
});


app.post("/signup", async (req, res) => {
    const { fname, lname, email, password, firebase_token, dob, mobile } = req.body;

    if (!fname || !lname || !email || !password || !dob || !mobile) {
        return res.json({ success: false, message: "All fields are required." });
    }

    var login_id = req.session.login_id; 

    try {
        let response = await axios.post(user_apiurl+"/user_data/signup_API", {
            fname,
            lname,
            email,
            password,
            firebase_token,
            dob,
            mobile,
            login_id
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            req.session.error = response.data.message;
            req.session.email = email;
            res.json({ success: true, message: response.data.message });
           

        } else {
            res.json({ success: false, message: response.data.message || "Registration failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});



app.post("/otp_verify", async (req, res) => {
    const { email_otp } = req.body;
    var email = req.session.email; 
    if (!email_otp) {
        return res.json({ success: false, message: "OTP is required." });
    }

    console.log("email_otp",email_otp);
    console.log("email",email);
    


    try {
        let response = await axios.post(user_apiurl+"/user_data/otp_verify", {
            email_otp,
            email,
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            req.session.error = response.data.message;
            req.session.email = response.data.data[0].email;
            req.session.jwt_token = response.data.data[0].jwt_token;
            req.session.tbl_user_id = response.data.data[0].tbl_user_id;
            req.session.fname = response.data.data[0].fname;
            req.session.lname = response.data.data[0].lname;
            req.session.mobile = response.data.data[0].mobile;
            req.session.user_image = response.data.data[0].user_image;
            req.session.user_name = response.data.data[0].user_name;
            res.json({ success: true, message: response.data.message });
           

        } else {
            res.json({ success: false, message: response.data.message || "OTP Verify failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});





app.post("/login_verify", async (req, res) => {
    const { email,password } = req.body;
 
    //console.log("login_verify",req.body);
    
    if (!email) {
        return res.json({ success: false, message: "email is required." });
    }

    if (!password) {
        return res.json({ success: false, message: "password is required." });
    }

    var firebase_token ='firebase_token';
    


    try {
        let response = await axios.post(user_apiurl+"/user_data/IB_Login_API", {
            email,
            password,
            firebase_token
        }, {
            headers: { "Content-Type": "application/json" }
        });

        if (response.data.status === true) {

            if(response.data.data[0].status =='1')
            {
            

            req.session.error = response.data.message;
            req.session.email = response.data.data[0].email;
            req.session.jwt_token = response.data.data[0].jwt_token;
            req.session.tbl_ib_user_id = response.data.data[0].tbl_ib_user_id;
            req.session.login_id = response.data.data[0].login_id;
            req.session.fname = response.data.data[0].name;
            req.session.lname = '';
            req.session.mobile = response.data.data[0].mobile;
            req.session.user_image = response.data.data[0].user_image;
            req.session.user_name = response.data.data[0].username;
            req.session.kyc_step_2 = response.data.data[0].kyc_step_2;
            req.session.kyc_step_1 = response.data.data[0].kyc_step_1;
            res.json({ success: true, message: response.data.message });

            }else{
                res.json({ success: false, message: 'Your IB request is under processing we will inform you on email when our team will approve' || "Login failed." });  
            }
           

        } else {
            res.json({ success: false, message: response.data.message || "Login failed." });
        }
    } catch (error) {
        res.json({ success: false, message: "Error connecting to API." });
    }
});




app.post("/add_mt5_user", auth, async (req, res) => {
    const { lots, Commission, Leverage, Currency } = req.body;

    var tbl_user_id = req.session.tbl_user_id; 
    

    if (!Leverage) {
        return res.json({ success: false, message: "Leverage are required." });
    }


    console.log('add_mt5_user', req.body);
    
        pool.query(`SELECT * FROM tbl_user WHERE  tbl_user_id = '${tbl_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            
            if (count > 0) {
                // Add API code here

                /// generate 6 digit random login id for user

                    var name = result.rows[0].fname + " " +result.rows[0].lname;
                    var email = result.rows[0].email;
                    var password_main = result.rows[0].password;
                    var mobile = result.rows[0].mobile;
                
                    const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                    const random_with_id = random.toString() + tbl_user_id; // Combine random number and user ID
                    const sixDigitRandomWithId = random_with_id.slice(-6); // Take the last 6 digits
                    const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                    const Login_id = zeroPad(sixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                
                /// generate 6 digit random login id for user
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");
                
                pool.query(`INSERT INTO tbl_mt5_user (tbl_user_id,login_id,group_id,balance,registration,name,leverage,email,password_main,phone,agent,country,joining_time,joining_date) VALUES ('${tbl_user_id}','${Login_id}','23','0','0','${name}','${Leverage}','${email}','${password_main}','${mobile}','','India','${joining_time}','${joining_date}')`,
                    async (error, mt5user_user) => {
                    if (error) {
                        return res.json(403).json({ status: false, message: error });
                    }

                    if (mt5user_user.rowCount > 0) {

                        res.json({ success: true, message: 'Your account has been successfully created.' });
                    } else {
                        
                        res.json({ success: false, message: 'Something Error' });
                    }
                });    
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});




app.post("/create_ticket", auth, async (req, res) => {
    const { title, message } = req.body;

    var tbl_ib_user_id = req.session.tbl_ib_user_id; 
    
    console.log("create_ticket",req.body);
    

    if (!title) {
        return res.json({ success: false, message: "title are required." });
    }

    if (!message) {
        return res.json({ success: false, message: "message are required." });
    }

        pool.query(`SELECT * FROM tbl_ib_user WHERE  tbl_ib_user_id = '${tbl_ib_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            
            if (count > 0) {
                
                    const random = Math.floor(100000 + Math.random() * 900000); // Generate a random 6-digit number
                    const random_with_id = random.toString() + tbl_ib_user_id; // Combine random number and user ID
                    const sixDigitRandomWithId = random_with_id.slice(-8); // Take the last 6 digits
                    const zeroPad = (num, places) => String(num).padStart(places, '0'); // Function to zero-pad the number
                    const ticket_number = zeroPad(sixDigitRandomWithId, 6); // Ensure the final ID is 6 digits                    
                
                /// generate 6 digit random login id for user
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");
                
                pool.query(`INSERT INTO tbl_user_ticket (tbl_user_id,ticket_number,title,created_date,created_time,user_type) VALUES ('${tbl_ib_user_id}','${ticket_number}',$$${title}$$,'${joining_date}','${joining_time}','IB_user')`,
                    async (error, ticket_data) => {
                    if (error) {
                        return res.json(403).json({ status: false, message: error });
                    }

                    if (ticket_data.rowCount > 0) {

                      var msg =   'Your ticket has been successfully created! Our team will reach out to you shortly. Your Ticket number is : '+ticket_number

                        const insert_msg_query =  await pool.query(`INSERT INTO tbl_user_ticket_msg(tbl_user_id,ticket_number,message,send_date,send_time,msg_from) VALUES ('${tbl_ib_user_id}','${ticket_number}',$$${message}$$,'${joining_date}','${joining_time}','user'); INSERT INTO tbl_user_notification(notification_type,tbl_user_id,notification_msg,created_date,created_time,title) VALUES('Ticket','${tbl_ib_user_id}','${msg}','${joining_date}','${joining_time}','Your ticket has been successfully created!')`);

                        if(insert_msg_query[0].rowCount > 0)
                        {
                            res.json({ success: true, message: 'Your ticket has been successfully created! Our team will reach out to you shortly. Your Ticket number is : '+ticket_number });
                        }else{
                            return res.json({ success: false, message: 'Something wrong try again' });
                        }
                       
                    } else {
                        
                       return res.json({ success: false, message: 'Something Error' });
                    }
                });    
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});





app.post("/send_chat", auth, async (req, res) => {
    const { msg, ticketnumber } = req.body;

    var tbl_ib_user_id = req.session.tbl_ib_user_id; 
    

    if (!ticketnumber) {
        return res.json({ success: false, message: "ticketnumber are required." });
    }

    if (!msg) {
        return res.json({ success: false, message: "msg are required." });
    }

        pool.query(`SELECT * FROM tbl_ib_user WHERE  tbl_ib_user_id = '${tbl_ib_user_id}'`, async (error, result) => {
            if (error) {
                return res.json(403).json({ status: false, message: error });
            }
            
            var count = result.rowCount;
            if (count > 0) {
                
                var joining_time = moment().utcOffset("+05:30").format('LT');
                var joining_date = moment(date).format("DD MMM YYYY");

                        const insert_msg_query =  await pool.query(`INSERT INTO tbl_user_ticket_msg(tbl_user_id,ticket_number,message,send_date,send_time,msg_from) VALUES ('${tbl_ib_user_id}','${ticketnumber}',$$${msg}$$,'${joining_date}','${joining_time}','user')`);

                        if(insert_msg_query.rowCount > 0)
                        {
                            res.json({ success: true, message: 'Message Send' });
                        }else{
                            res.json({ success: false, message: 'Something wrong try again' });
                        }
                  
            } else {
                res.json({ success: false, message: 'This user is not registered with us. Please check your user ID. OR logout and loing again' });
            }
        });

});

app.get('/level_one_team/:login_id', async function (req, res) {
    const { login_id } = req.params;
    console.log("login_id", login_id);

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Fetch User Data
        const userResult = await pool.query(
            `SELECT * FROM tbl_user WHERE used_login_id = $1`,
            [login_id]
        );

        // 2. Fetch Level Count Data
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || {};
        const countData = countResult.rows[0] || {};

        res.render('level_one_team', {
            layout: true,
            leval_one_team_data: userData,
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching level team data:", error);
        res.status(500).send("Error loading data");
    }
});



app.get('/level_two_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Fetch users at level 2 under the given login_id
        const userResult = await pool.query(`
            SELECT * FROM tbl_user 
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team 
                WHERE sponsor_id = $1 AND team_level = '1'
            )
        `, [login_id]);

        // 2. Fetch counts for all levels for this sponsor
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_two_team', {
            layout: true,
            leval_one_team_data: userData,
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching level two team data:", error);
        res.status(500).send("Error loading data");
    }
});



app.get('/level_three_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Fetch Level 3 team users (users directly under team_level 3)
        const userResult = await pool.query(`
            SELECT * FROM tbl_user 
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team 
                WHERE sponsor_id = $1 AND team_level = '2'
            )
        `, [login_id]);

        // 2. Fetch level count data (levels 1 to 8 under this sponsor)
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_three_team', {
            layout: true,
            leval_one_team_data: userData, // You may rename this to level_three_team_data for clarity
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching level three team data:", error);
        res.status(500).send("Error loading data");
    }
});



app.get('/level_four_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Get all users under team level 4 for this login_id
        const userResult = await pool.query(`
            SELECT * FROM tbl_user
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team
                WHERE sponsor_id = $1 AND team_level = '3'
            )
        `, [login_id]);

        // 2. Get all team level counts (1 to 8)
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_four_team', {
            layout: true,
            leval_one_team_data: userData, // consider renaming to level_four_team_data
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching level four team data:", error);
        res.status(500).send("Error loading data");
    }
});


app.get('/level_five_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Get team users of level 5 under the given login_id
        const userResult = await pool.query(`
            SELECT * FROM tbl_user
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team
                WHERE sponsor_id = $1 AND team_level = '4'
            )
        `, [login_id]);

        // 2. Get count for each team level (1 to 8)
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_five_team', {
            layout: true,
            leval_one_team_data: userData, // You may rename this to level_five_team_data for clarity
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id: login_id,
        });

    } catch (error) {
        console.error("Error fetching level five team data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/level_six_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Get users who are in level 6 under the given sponsor (login_id)
        const userResult = await pool.query(`
            SELECT * FROM tbl_user
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team
                WHERE sponsor_id = $1 AND team_level = '5'
            )
        `, [login_id]);

        // 2. Get total counts for all levels (1 to 8) under this login_id
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_six_team', {
            layout: true,
            leval_one_team_data: userData,
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id,
        });

    } catch (error) {
        console.error("Error fetching level six team data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/level_seven_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Get users in level 7 under the sponsor
        const userResult = await pool.query(`
            SELECT * FROM tbl_user
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team
                WHERE sponsor_id = $1 AND team_level = '6'
            )
        `, [login_id]);

        // 2. Get total user counts for all 8 levels
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_seven_team', {
            layout: true,
            leval_one_team_data: userData,
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id,
        });

    } catch (error) {
        console.error("Error fetching level seven team data:", error);
        res.status(500).send("Error loading account data");
    }
});



app.get('/level_eight_team/:login_id', async function (req, res) {
    const { login_id } = req.params;

    try {
        if (!login_id) {
            return res.status(400).send("User ID not found in session");
        }

        // 1. Get users under level 8
        const userResult = await pool.query(`
            SELECT * FROM tbl_user
            WHERE used_login_id IN (
                SELECT login_id FROM public.tbl_ib_team
                WHERE sponsor_id = $1 AND team_level = '7'
            )
        `, [login_id]);

        // 2. Get all level counts (1 to 8)
        const countResult = await pool.query(`
            WITH count_data AS (
                SELECT
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id = $1) AS total_count_level_1,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '1'
                    )) AS total_count_level_2,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '2'
                    )) AS total_count_level_3,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '3'
                    )) AS total_count_level_4,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '4'
                    )) AS total_count_level_5,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '5'
                    )) AS total_count_level_6,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '6'
                    )) AS total_count_level_7,
                    (SELECT COALESCE(COUNT(tbl_user_id), 0) FROM tbl_user WHERE used_login_id IN (
                        SELECT login_id FROM public.tbl_ib_team WHERE sponsor_id = $1 AND team_level = '7'
                    )) AS total_count_level_8
            )
            SELECT * FROM count_data
        `, [login_id]);

        const userData = userResult.rows || [];
        const countData = countResult.rows[0] || {};

        res.render('level_eight_team', {
            layout: true,
            leval_one_team_data: userData,
            total_count_level_1: countData.total_count_level_1 || 0,
            total_count_level_2: countData.total_count_level_2 || 0,
            total_count_level_3: countData.total_count_level_3 || 0,
            total_count_level_4: countData.total_count_level_4 || 0,
            total_count_level_5: countData.total_count_level_5 || 0,
            total_count_level_6: countData.total_count_level_6 || 0,
            total_count_level_7: countData.total_count_level_7 || 0,
            total_count_level_8: countData.total_count_level_8 || 0,
            login_id,
        });

    } catch (error) {
        console.error("Error fetching level eight team data:", error);
        res.status(500).send("Error loading account data");
    }
});





//  All old code will be deleted after created 


/////////////////////////////////////  👍👍👍👌👌👍👌👌👌👌👌👌👍👌👌👌 /////////////////////////

// app.get('*',  function (req, res) {
//     res.status(404).render('404_page', {
//         pagetitle: ''
//     })
// })

app.listen(PORT);
console.log(`app listening on port ${PORT}`);

